/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.model;

import java.util.Collection;
import java.util.Set;
import org.opensearch.timeseries.Name;

public enum ValidationAspect implements Name
{
    DETECTOR("detector"),
    MODEL("model"),
    FORECASTER("forecaster");

    private String name;

    private ValidationAspect(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static ValidationAspect getName(String name) {
        switch (name) {
            case "detector": {
                return DETECTOR;
            }
            case "model": {
                return MODEL;
            }
            case "forecaster": {
                return FORECASTER;
            }
        }
        throw new IllegalArgumentException("Unsupported validation aspects");
    }

    public static Set<ValidationAspect> getNames(Collection<String> names) {
        return Name.getNameFromCollection(names, ValidationAspect::getName);
    }
}

