/*
 * Decompiled with CFR 0.152.
 */
package org.passay.dictionary;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.passay.dictionary.WordList;

public abstract class AbstractWordList
implements WordList {
    protected Comparator<String> comparator;

    @Override
    public Comparator<String> getComparator() {
        return this.comparator;
    }

    @Override
    public Iterator<String> iterator() {
        return new WordListIterator(false);
    }

    @Override
    public Iterator<String> medianIterator() {
        return new WordListIterator(true);
    }

    protected void checkRange(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Supplied index (" + index + ") does not exist");
        }
    }

    @Deprecated
    protected void checkIsString(Object o) {
        if (!String.class.isInstance(o)) {
            throw new ClassCastException("Parameter must be of type String");
        }
    }

    private class WordListIterator
    implements Iterator<String> {
        protected final boolean medians;
        protected int index;

        protected WordListIterator(boolean useMedians) {
            this.medians = useMedians;
        }

        @Override
        public boolean hasNext() {
            return this.index < AbstractWordList.this.size();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported.");
        }

        @Override
        public String next() {
            int n;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.medians) {
                n = this.toMedianIndex(this.index++, AbstractWordList.this.size());
            } else {
                int n2 = this.index;
                n = n2;
                this.index = n2 + 1;
            }
            return AbstractWordList.this.get(n);
        }

        int toMedianIndex(int i, int size) {
            int powerOfTwo = Integer.highestOneBit(i + 1);
            long remainder = i + 1 - powerOfTwo;
            int leftovers = size - powerOfTwo;
            if (leftovers >= powerOfTwo || remainder == 0L) {
                return (int)((long)size * (2L * remainder + 1L) / (long)(2 * powerOfTwo));
            }
            return (int)(((long)size * remainder - 1L) / (long)leftovers);
        }
    }
}

