/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.datasources.transport;

import org.opensearch.action.ActionType;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.sql.datasource.DataSourceService;
import org.opensearch.sql.datasources.model.transport.PatchDataSourceActionRequest;
import org.opensearch.sql.datasources.model.transport.PatchDataSourceActionResponse;
import org.opensearch.sql.datasources.service.DataSourceServiceImpl;
import org.opensearch.sql.protocol.response.format.JsonResponseFormatter;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class TransportPatchDataSourceAction
extends HandledTransportAction<PatchDataSourceActionRequest, PatchDataSourceActionResponse> {
    public static final String NAME = "cluster:admin/opensearch/ql/datasources/patch";
    public static final ActionType<PatchDataSourceActionResponse> ACTION_TYPE = new ActionType("cluster:admin/opensearch/ql/datasources/patch", PatchDataSourceActionResponse::new);
    private DataSourceService dataSourceService;

    @Inject
    public TransportPatchDataSourceAction(TransportService transportService, ActionFilters actionFilters, DataSourceServiceImpl dataSourceService) {
        super(NAME, transportService, actionFilters, PatchDataSourceActionRequest::new);
        this.dataSourceService = dataSourceService;
    }

    protected void doExecute(Task task, PatchDataSourceActionRequest request, ActionListener<PatchDataSourceActionResponse> actionListener) {
        try {
            this.dataSourceService.patchDataSource(request.getDataSourceData());
            String responseContent = new JsonResponseFormatter<String>(JsonResponseFormatter.Style.PRETTY){

                protected Object buildJsonObject(String response) {
                    return response;
                }
            }.format((Object)("Updated DataSource with name " + String.valueOf(request.getDataSourceData().get("name"))));
            actionListener.onResponse((Object)new PatchDataSourceActionResponse(responseContent));
        }
        catch (Exception e) {
            actionListener.onFailure(e);
        }
    }
}

