/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.JobExecutionStatus;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkExecutorInfo;
import org.apache.spark.SparkExecutorInfoImpl;
import org.apache.spark.SparkJobInfo;
import org.apache.spark.SparkJobInfoImpl;
import org.apache.spark.SparkStageInfo;
import org.apache.spark.SparkStageInfoImpl;
import org.apache.spark.status.AppStatusStore;
import org.apache.spark.status.api.v1.JobData;
import org.apache.spark.status.api.v1.MemoryMetrics;
import org.apache.spark.status.api.v1.StageStatus;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005}3Aa\u0003\u0007\u0001'!A!\u0004\u0001B\u0001B\u0003%1\u0004\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u0011\u00191\u0003\u0001\"\u0001\rO!)1\u0006\u0001C\u0001Y!)\u0001\t\u0001C\u0001\u0003\")A\t\u0001C\u0001\u000b\")a\t\u0001C\u0001\u000b\")q\t\u0001C\u0001\u0011\")\u0011\u000b\u0001C\u0001%\")\u0011\f\u0001C\u00015\n\u00112\u000b]1sWN#\u0018\r^;t)J\f7m[3s\u0015\tia\"A\u0003ta\u0006\u00148N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011a!\u00118z%\u00164\u0017AA:d!\taR$D\u0001\r\u0013\tqBB\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH/A\u0003ti>\u0014X\r\u0005\u0002\"I5\t!E\u0003\u0002$\u0019\u000511\u000f^1ukNL!!\n\u0012\u0003\u001d\u0005\u0003\bo\u0015;biV\u001c8\u000b^8sK\u00061A(\u001b8jiz\"2\u0001K\u0015+!\ta\u0002\u0001C\u0003\u001b\u0007\u0001\u00071\u0004C\u0003 \u0007\u0001\u0007\u0001%A\thKRTuNY%eg\u001a{'o\u0012:pkB$\"!L\u001a\u0011\u0007Uq\u0003'\u0003\u00020-\t)\u0011I\u001d:bsB\u0011Q#M\u0005\u0003eY\u00111!\u00138u\u0011\u0015!D\u00011\u00016\u0003!QwNY$s_V\u0004\bC\u0001\u001c>\u001d\t94\b\u0005\u00029-5\t\u0011H\u0003\u0002;%\u00051AH]8pizJ!\u0001\u0010\f\u0002\rA\u0013X\rZ3g\u0013\tqtH\u0001\u0004TiJLgn\u001a\u0006\u0003yY\tqbZ3u\u0015>\u0014\u0017\nZ:G_J$\u0016m\u001a\u000b\u0003[\tCQaQ\u0003A\u0002U\naA[8c)\u0006<\u0017!E4fi\u0006\u001bG/\u001b<f'R\fw-Z%egR\tQ&A\bhKR\f5\r^5wK*{'-\u00133t\u0003)9W\r\u001e&pE&sgm\u001c\u000b\u0003\u0013>\u00032!\u0006&M\u0013\tYeC\u0001\u0004PaRLwN\u001c\t\u000395K!A\u0014\u0007\u0003\u0019M\u0003\u0018M]6K_\nLeNZ8\t\u000bAC\u0001\u0019\u0001\u0019\u0002\u000b)|'-\u00133\u0002\u0019\u001d,Go\u0015;bO\u0016LeNZ8\u0015\u0005M;\u0006cA\u000bK)B\u0011A$V\u0005\u0003-2\u0011ab\u00159be.\u001cF/Y4f\u0013:4w\u000eC\u0003Y\u0013\u0001\u0007\u0001'A\u0004ti\u0006<W-\u00133\u0002!\u001d,G/\u0012=fGV$xN]%oM>\u001cX#A.\u0011\u0007UqC\f\u0005\u0002\u001d;&\u0011a\f\u0004\u0002\u0012'B\f'o[#yK\u000e,Ho\u001c:J]\u001a|\u0007")
public class SparkStatusTracker {
    private final AppStatusStore store;

    public int[] getJobIdsForGroup(String jobGroup) {
        Option expected = Option$.MODULE$.apply((Object)jobGroup);
        return (int[])((IterableOnceOps)((IterableOps)this.store.jobsList(null).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SparkStatusTracker.$anonfun$getJobIdsForGroup$1(expected, x$1)))).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.jobId()))).toArray((ClassTag)ClassTag$.MODULE$.Int());
    }

    public int[] getJobIdsForTag(String jobTag) {
        return (int[])((IterableOnceOps)((IterableOps)this.store.jobsList(null).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SparkStatusTracker.$anonfun$getJobIdsForTag$1(jobTag, x$3)))).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.jobId()))).toArray((ClassTag)ClassTag$.MODULE$.Int());
    }

    public int[] getActiveStageIds() {
        return (int[])((IterableOnceOps)this.store.stageList(Arrays.asList((Object[])new StageStatus[]{StageStatus.ACTIVE}), this.store.stageList$default$2(), this.store.stageList$default$3(), this.store.stageList$default$4(), this.store.stageList$default$5()).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.stageId()))).toArray((ClassTag)ClassTag$.MODULE$.Int());
    }

    public int[] getActiveJobIds() {
        return (int[])((IterableOnceOps)this.store.jobsList(Arrays.asList((Object[])new JobExecutionStatus[]{JobExecutionStatus.RUNNING})).map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.jobId()))).toArray((ClassTag)ClassTag$.MODULE$.Int());
    }

    public Option<SparkJobInfo> getJobInfo(int jobId) {
        return this.store.asOption((Function0 & Serializable)() -> $this.store.job(jobId)).map((Function1 & Serializable)job -> new SparkJobInfoImpl(jobId, (int[])job.stageIds().toArray((ClassTag)ClassTag$.MODULE$.Int()), job.status()));
    }

    public Option<SparkStageInfo> getStageInfo(int stageId) {
        return this.store.asOption((Function0 & Serializable)() -> $this.store.lastStageAttempt(stageId)).map((Function1 & Serializable)stage -> new SparkStageInfoImpl(stageId, stage.attemptId(), BoxesRunTime.unboxToLong((Object)stage.submissionTime().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.getTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)), stage.name(), stage.numTasks(), stage.numActiveTasks(), stage.numCompleteTasks(), stage.numFailedTasks()));
    }

    public SparkExecutorInfo[] getExecutorInfos() {
        return (SparkExecutorInfo[])((IterableOnceOps)this.store.executorList(true).map((Function1 & Serializable)exec -> {
            Tuple2<String, Object> tuple2 = Utils$.MODULE$.parseHostPort(exec.hostPort());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String host = (String)tuple2._1();
            int port = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
            Tuple2 tuple23 = tuple22;
            String host2 = (String)tuple23._1();
            int port2 = tuple23._2$mcI$sp();
            long cachedMem = BoxesRunTime.unboxToLong((Object)exec.memoryMetrics().map((Function1 & Serializable)mem -> BoxesRunTime.boxToLong((long)SparkStatusTracker.$anonfun$getExecutorInfos$2(mem))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
            return new SparkExecutorInfoImpl(host2, port2, cachedMem, exec.activeTasks(), BoxesRunTime.unboxToLong((Object)exec.memoryMetrics().map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.usedOnHeapStorageMemory())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)), BoxesRunTime.unboxToLong((Object)exec.memoryMetrics().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.usedOffHeapStorageMemory())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)), BoxesRunTime.unboxToLong((Object)exec.memoryMetrics().map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.totalOnHeapStorageMemory())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)), BoxesRunTime.unboxToLong((Object)exec.memoryMetrics().map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.totalOffHeapStorageMemory())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        })).toArray(ClassTag$.MODULE$.apply(SparkExecutorInfo.class));
    }

    public static final /* synthetic */ boolean $anonfun$getJobIdsForGroup$1(Option expected$1, JobData x$1) {
        Option<String> option = x$1.jobGroup();
        Option option2 = expected$1;
        return !(option != null ? !option.equals((Object)option2) : option2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getJobIdsForTag$1(String jobTag$1, JobData x$3) {
        return x$3.jobTags().contains((Object)jobTag$1);
    }

    public static final /* synthetic */ long $anonfun$getExecutorInfos$2(MemoryMetrics mem) {
        return mem.usedOnHeapStorageMemory() + mem.usedOffHeapStorageMemory();
    }

    public SparkStatusTracker(SparkContext sc, AppStatusStore store) {
        this.store = store;
    }
}

