/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.rerank.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.ObjectPath;
import org.opensearch.neuralsearch.processor.rerank.context.ContextSourceFetcher;
import org.opensearch.neuralsearch.settings.NeuralSearchSettings;
import org.opensearch.search.SearchHit;

public class DocumentContextSourceFetcher
implements ContextSourceFetcher {
    @Generated
    private static final Logger log = LogManager.getLogger(DocumentContextSourceFetcher.class);
    public static final String NAME = "document_fields";
    public static final String DOCUMENT_CONTEXT_LIST_FIELD = "document_context_list";
    private final List<String> contextFields;

    @Override
    public void fetchContext(SearchRequest searchRequest, SearchResponse searchResponse, ActionListener<Map<String, Object>> listener) {
        ArrayList<String> contexts = new ArrayList<String>();
        for (SearchHit hit : searchResponse.getHits()) {
            StringBuilder ctx = new StringBuilder();
            for (String field : this.contextFields) {
                ctx.append(this.contextFromSearchHit(hit, field));
            }
            contexts.add(ctx.toString());
        }
        listener.onResponse(new HashMap(Map.of(DOCUMENT_CONTEXT_LIST_FIELD, contexts)));
    }

    private String contextFromSearchHit(SearchHit hit, String field) {
        if (hit.getFields().containsKey(field)) {
            Object fieldValue = hit.field(field).getValue();
            return String.valueOf(fieldValue);
        }
        if (hit.hasSource() && hit.getSourceAsMap().containsKey(field)) {
            Object sourceValue = ObjectPath.eval((String)field, (Object)hit.getSourceAsMap());
            return String.valueOf(sourceValue);
        }
        log.warn(String.format(Locale.ROOT, "Could not find field %s in document %s for reranking! Using the empty string instead.", field, hit.getId()));
        return "";
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static DocumentContextSourceFetcher create(Object config, ClusterService clusterService) {
        if (!(config instanceof List)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "%s must be a list of field names", NAME));
        }
        List fields = (List)config;
        if (fields.size() == 0) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "%s must be nonempty", NAME));
        }
        if (fields.size() > (Integer)NeuralSearchSettings.RERANKER_MAX_DOC_FIELDS.get(clusterService.getSettings())) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "%s must not contain more than %d fields. Configure by setting %s", NAME, NeuralSearchSettings.RERANKER_MAX_DOC_FIELDS.get(clusterService.getSettings()), NeuralSearchSettings.RERANKER_MAX_DOC_FIELDS.getKey()));
        }
        List<String> fieldsAsStrings = fields.stream().map(field -> (String)field).collect(Collectors.toList());
        return new DocumentContextSourceFetcher(fieldsAsStrings);
    }

    @Generated
    public DocumentContextSourceFetcher(List<String> contextFields) {
        this.contextFields = contextFields;
    }
}

