/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.util;

import com.android.tools.smali.dexlib2.AccessFlags;
import com.android.tools.smali.dexlib2.iface.ClassDef;
import com.android.tools.smali.dexlib2.iface.Method;
import com.android.tools.smali.dexlib2.iface.MethodImplementation;
import com.android.tools.smali.dexlib2.iface.instruction.Instruction;
import com.android.tools.smali.dexlib2.iface.instruction.ReferenceInstruction;
import com.android.tools.smali.dexlib2.iface.reference.MethodReference;
import com.android.tools.smali.dexlib2.iface.reference.Reference;
import com.android.tools.smali.dexlib2.util.SyntheticAccessorFSM;
import com.google.common.collect.ImmutableList;
import java.util.Map;

public class SyntheticAccessorResolver {
    private final SyntheticAccessorFSM syntheticAccessorFSM;
    private final Map<String, ClassDef> classDefMap;
    private final Map<MethodReference, AccessedMember> resolvedAccessors;

    public static boolean looksLikeSyntheticAccessor(String methodName) {
        return methodName.startsWith("access$");
    }

    public AccessedMember getAccessedMember(MethodReference methodReference) {
        AccessedMember accessedMember = this.resolvedAccessors.get(methodReference);
        if (accessedMember != null) {
            return accessedMember;
        }
        String type = methodReference.getDefiningClass();
        ClassDef classDef = this.classDefMap.get(type);
        if (classDef == null) {
            return null;
        }
        Method matchedMethod = null;
        MethodImplementation matchedMethodImpl = null;
        for (Method method : classDef.getMethods()) {
            MethodImplementation methodImpl = method.getImplementation();
            if (methodImpl == null || !SyntheticAccessorResolver.methodReferenceEquals(method, methodReference)) continue;
            matchedMethod = method;
            matchedMethodImpl = methodImpl;
            break;
        }
        if (matchedMethod == null) {
            return null;
        }
        if (!AccessFlags.SYNTHETIC.isSet(matchedMethod.getAccessFlags())) {
            return null;
        }
        ImmutableList<? extends Instruction> instructions = ImmutableList.copyOf(matchedMethodImpl.getInstructions());
        int n = this.syntheticAccessorFSM.test(instructions);
        if (n >= 0) {
            AccessedMember member = new AccessedMember(n, ((ReferenceInstruction)instructions.get(0)).getReference());
            this.resolvedAccessors.put(methodReference, member);
            return member;
        }
        return null;
    }

    private static boolean methodReferenceEquals(MethodReference ref1, MethodReference ref2) {
        return ref1.getName().equals(ref2.getName()) && ref1.getReturnType().equals(ref2.getReturnType()) && ref1.getParameterTypes().equals(ref2.getParameterTypes());
    }

    public static class AccessedMember {
        public final int accessedMemberType;
        public final Reference accessedMember;

        public AccessedMember(int accessedMemberType, Reference accessedMember) {
            this.accessedMemberType = accessedMemberType;
            this.accessedMember = accessedMember;
        }
    }
}

