/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.authentication;

import com.intellij.collaboration.auth.ui.login.LoginException;
import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.collaboration.ui.ExceptionUtil;
import com.intellij.collaboration.ui.codereview.list.error.ErrorStatusPresenter;
import com.intellij.collaboration.ui.util.ActionUtilKt;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import java.awt.event.ActionEvent;
import java.net.ConnectException;
import javax.swing.Action;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.authentication.ui.GitLabTokenLoginPanelModel;
import org.jetbrains.plugins.gitlab.util.GitLabBundle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0015\u0010\f\u001a\u00070\n\u00a2\u0006\u0002\b\r2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0012H\u0002J\u0014\u0010\u0013\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/gitlab/authentication/GitLabLoginErrorStatusPresenter;", "Lcom/intellij/collaboration/ui/codereview/list/error/ErrorStatusPresenter$HTML;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "model", "Lorg/jetbrains/plugins/gitlab/authentication/ui/GitLabTokenLoginPanelModel;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lorg/jetbrains/plugins/gitlab/authentication/ui/GitLabTokenLoginPanelModel;)V", "getErrorTitle", "", "error", "getHTMLBody", "Lcom/intellij/openapi/util/NlsSafe;", "getErrorAction", "Ljavax/swing/Action;", "customizeUnsupportedVersionError", "Lcom/intellij/openapi/util/text/HtmlBuilder;", "Lcom/intellij/collaboration/auth/ui/login/LoginException$UnsupportedServerVersion;", "customizeInvalidTokenOrUnsupportedServerVersionError", "Lcom/intellij/collaboration/auth/ui/login/LoginException$InvalidTokenOrUnsupportedServerVersion;", "intellij.vcs.gitlab"})
public final class GitLabLoginErrorStatusPresenter
implements ErrorStatusPresenter.HTML<Throwable> {
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final GitLabTokenLoginPanelModel model;

    public GitLabLoginErrorStatusPresenter(@NotNull CoroutineScope cs, @NotNull GitLabTokenLoginPanelModel model) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        this.cs = cs;
        this.model = model;
    }

    @NotNull
    public String getErrorTitle(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        return "";
    }

    @NotNull
    public String getHTMLBody(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        HtmlBuilder builder = new HtmlBuilder();
        Throwable throwable = error;
        if (throwable instanceof ConnectException) {
            v0 = builder.append(CollaborationToolsBundle.message((String)"clone.dialog.login.error.server", (Object[])new Object[0]));
        } else if (throwable instanceof LoginException.UnsupportedServerVersion) {
            v0 = this.customizeUnsupportedVersionError(builder, (LoginException.UnsupportedServerVersion)error);
        } else if (throwable instanceof LoginException.InvalidTokenOrUnsupportedServerVersion) {
            v0 = this.customizeInvalidTokenOrUnsupportedServerVersionError(builder, (LoginException.InvalidTokenOrUnsupportedServerVersion)error);
        } else if (throwable instanceof LoginException.AccountAlreadyExists) {
            Object[] objectArray = new Object[]{((LoginException.AccountAlreadyExists)error).getUsername()};
            v0 = builder.append(CollaborationToolsBundle.message((String)"login.dialog.error.account.already.exists", (Object[])objectArray));
        } else if (throwable instanceof LoginException.AccountUsernameMismatch) {
            Object[] objectArray = new Object[]{((LoginException.AccountUsernameMismatch)error).getRequiredUsername(), ((LoginException.AccountUsernameMismatch)error).getUsername()};
            v0 = builder.append(CollaborationToolsBundle.message((String)"login.dialog.error.account.username.mismatch", (Object[])objectArray));
        } else {
            v0 = builder.append(ExceptionUtil.INSTANCE.getPresentableMessage(error));
        }
        String string = builder.wrapWithHtmlBody().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Nullable
    public Action getErrorAction(@NotNull Throwable error) {
        Action action;
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Throwable throwable = error;
        if (throwable instanceof LoginException.UnsupportedServerVersion || throwable instanceof LoginException.InvalidTokenOrUnsupportedServerVersion) {
            String string = CollaborationToolsBundle.message((String)"login.via.git", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            action = ActionUtilKt.swingAction((String)string, arg_0 -> GitLabLoginErrorStatusPresenter.getErrorAction$lambda$0(this, arg_0));
        } else {
            action = null;
        }
        return action;
    }

    private final HtmlBuilder customizeUnsupportedVersionError(HtmlBuilder $this$customizeUnsupportedVersionError, LoginException.UnsupportedServerVersion error) {
        HtmlBuilder builder = $this$customizeUnsupportedVersionError;
        Object[] objectArray = new Object[]{error.getEarliestSupportedVersion()};
        String text2 = GitLabBundle.message("server.version.unsupported", objectArray);
        HtmlChunk.Element element = HtmlChunk.link((String)"ERROR_ACTION", (String)CollaborationToolsBundle.message((String)"login.via.git", (Object[])new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"link(...)");
        HtmlChunk.Element link = element;
        HtmlBuilder htmlBuilder = builder.append(text2).nbsp().append((HtmlChunk)link);
        Intrinsics.checkNotNullExpressionValue((Object)htmlBuilder, (String)"append(...)");
        return htmlBuilder;
    }

    private final HtmlBuilder customizeInvalidTokenOrUnsupportedServerVersionError(HtmlBuilder $this$customizeInvalidTokenOrUnsupportedServerVersionError, LoginException.InvalidTokenOrUnsupportedServerVersion error) {
        HtmlBuilder builder = $this$customizeInvalidTokenOrUnsupportedServerVersionError;
        Object[] objectArray = new Object[]{error.getEarliestSupportedVersion()};
        String text2 = GitLabBundle.message("invalid.token.or.server.version.unsupported", objectArray);
        HtmlChunk.Element element = HtmlChunk.link((String)"ERROR_ACTION", (String)CollaborationToolsBundle.message((String)"login.via.git", (Object[])new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"link(...)");
        HtmlChunk.Element linkAction = element;
        Object[] objectArray2 = new Object[]{error.getEarliestSupportedVersion()};
        String linkAdditionalText = GitLabBundle.message("invalid.token.or.server.version.unsupported.additional.text", objectArray2);
        HtmlBuilder linkBuilder = new HtmlBuilder().append((HtmlChunk)linkAction).nbsp().append(linkAdditionalText);
        HtmlBuilder htmlBuilder = builder.append(text2).append((HtmlChunk)HtmlChunk.p().attr("align", "left").child(linkBuilder.toFragment()));
        Intrinsics.checkNotNullExpressionValue((Object)htmlBuilder, (String)"append(...)");
        return htmlBuilder;
    }

    private static final Unit getErrorAction$lambda$0(GitLabLoginErrorStatusPresenter this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BuildersKt.launch$default((CoroutineScope)this$0.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            final /* synthetic */ GitLabLoginErrorStatusPresenter this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = GitLabLoginErrorStatusPresenter.access$getModel$p(this.this$0).tryGitAuthorization((Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ GitLabTokenLoginPanelModel access$getModel$p(GitLabLoginErrorStatusPresenter $this) {
        return $this.model;
    }
}

