/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.scheduling;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlinx.coroutines.scheduling.ParallelismCompensation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0002\u001a\u0002H\u0003\"\u0004\b\u0000\u0010\u00032\u000e\b\b\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0005H\u0080\b\u00a2\u0006\u0002\u0010\u0006\u001a%\u0010\u0002\u001a\u0002H\u0003\"\u0004\b\u0000\u0010\u0003*\u00020\u00072\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0005H\u0002\u00a2\u0006\u0002\u0010\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"parallelismCompensationEnabled", "", "withCompensatedParallelism", "T", "body", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Lkotlinx/coroutines/scheduling/ParallelismCompensation;", "(Lkotlinx/coroutines/scheduling/ParallelismCompensation;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "kotlinx-coroutines-core"})
public final class ParallelismCompensationKt {
    private static final boolean parallelismCompensationEnabled = Boolean.parseBoolean(System.getProperty("kotlinx.coroutines.parallelism.compensation", "true"));

    public static final <T> T withCompensatedParallelism(@NotNull Function0<? extends T> body) {
        boolean $i$f$withCompensatedParallelism = false;
        if (!ParallelismCompensationKt.parallelismCompensationEnabled) {
            return body.invoke();
        }
        Thread thread2 = Thread.currentThread();
        ParallelismCompensation parallelismCompensation = thread2 instanceof ParallelismCompensation ? (ParallelismCompensation)((Object)thread2) : null;
        if (parallelismCompensation == null) {
            return body.invoke();
        }
        ParallelismCompensation worker = parallelismCompensation;
        return (T)ParallelismCompensationKt.withCompensatedParallelism(worker, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <T> T withCompensatedParallelism(ParallelismCompensation $this$withCompensatedParallelism, Function0<? extends T> body) {
        $this$withCompensatedParallelism.increaseParallelismAndLimit();
        try {
            T t = body.invoke();
            return t;
        }
        finally {
            $this$withCompensatedParallelism.decreaseParallelismLimit();
        }
    }
}

