" Vim syntax file
" Language: Oblivion Language (obl)
" Original Creator: Ulthar Seramis
" Maintainer: Kat <katisntgood@gmail.com>
" Latest Revision: 13 November 2022

if exists("b:current_syntax")
  finish
endif

let s:cpo_save = &cpo
set cpo&vim

" obse is case insensitive
syntax case ignore

" Statements {{{
syn keyword obseStatement set let to skipwhite
" the second part needs to be separate as to not mess up the next group
syn match obseStatementTwo ":="
" }}}

" Regex matched objects {{{
" these are matched with regex and thus must be set first
syn match obseNames '\w\+'
syn match obseScriptNameRegion '\i\+' contained
syn match obseVariable '\w*\S' contained
syn match obseReference '\zs\w\+\>\ze\.'
" }}}

" Operators {{{
syn match obseOperator "\v\*"
syn match obseOperator "\v\-"
syn match obseOperator "\v\+"
syn match obseOperator "\v\/"
syn match obseOperator "\v\^"
syn match obseOperator "\v\="
syn match obseOperator "\v\>"
syn match obseOperator "\v\<"
syn match obseOperator "\v\!"
syn match obseOperator "\v\&"
syn match obseOperator "\v\|"
" }}}

" Numbers {{{
syn match obseInt '\d\+'
syn match obseInt '[-+]\d\+'
syn match obseFloat '\d\+\.\d*' 
syn match obseFloat '[-+]\d\+\.\d*'
" }}}

" Comments and strings {{{
syn region obseComment start=";" end="$" keepend fold contains=obseToDo
syn region obseString start=/"/ end=/"/ keepend fold contains=obseStringFormatting
syn match obseStringFormatting "%%" contained
syn match obseStringFormatting "%a" contained
syn match obseStringFormatting "%B" contained
syn match obseStringFormatting "%b" contained
syn match obseStringFormatting "%c" contained
syn match obseStringFormatting "%e" contained
syn match obseStringFormatting "%g" contained
syn match obseStringFormatting "%i" contained
syn match obseStringFormatting "%k" contained
syn match obseStringFormatting "%n" contained
syn match obseStringFormatting "%p" contained
syn match obseStringFormatting "%ps" contained
syn match obseStringFormatting "%pp" contained
syn match obseStringFormatting "%po" contained
syn match obseStringFormatting "%q" contained
syn match obseStringFormatting "%r" contained
syn match obseStringFormatting "%v" contained
syn match obseStringFormatting "%x" contained
syn match obseStringFormatting "%z" contained
syn match obseStringFormatting "%{" contained
syn match obseStringFormatting "%}" contained
syn match obseStringFormatting "%\d*.\d*f" contained
syn match obseStringFormatting "% \d*.\d*f" contained
syn match obseStringFormatting "%-\d*.\d*f" contained
syn match obseStringFormatting "%+\d*.\d*f" contained
syn match obseStringFormatting "%\d*.\d*e" contained
syn match obseStringFormatting "%-\d*.\d*e" contained
syn match obseStringFormatting "% \d*.\d*e" contained
syn match obseStringFormatting "%+\d*.\d*e" contained
syn keyword obseToDo contained TODO todo Todo ToDo FIXME fixme NOTE note
" }}}


" Conditionals {{{
syn match obseCondition "If"
syn match obseCondition "Eval"
syn match obseCondition "Return"
syn match obseCondition "EndIf"
syn match obseCondition "ElseIf"
syn match obseCondition "Else"
" }}}

" Repeat loops {{{
syn match obseRepeat "Label" 
syn match obseRepeat "GoTo"
syn match obseRepeat "While"
syn match obseRepeat "Loop"
syn match obseRepeat "ForEach"
syn match obseRepeat "Break"
syn match obseRepeat "Continue"
" }}}

" Basic Types {{{
syn keyword obseTypes array_var float int long ref reference short string_var nextgroup=obseNames skipwhite
syn keyword obseOtherKey Player player playerRef playerREF PlayerRef PlayerREF
syn keyword obseScriptName ScriptName scriptname Scriptname scn nextgroup=obseScriptNameRegion skipwhite
syn keyword obseBlock Begin End
" }}}

" Fold {{{
setlocal foldmethod=syntax
syn cluster obseNoFold contains=obseComment,obseString
syn region obseFoldIfContainer
      \ start="^\s*\<if\>"
      \ end="^\s*\<endif\>"
      \ keepend extend
      \ containedin=ALLBUT,@obseNoFold
      \ contains=ALLBUT,obseScriptName,obseScriptNameRegion
syn region obseFoldIf
      \ start="^\s*\<if\>"
      \ end="^\s*\<endif\>"
      \ fold
      \ keepend
      \ contained containedin=obseFoldIfContainer
      \ nextgroup=obseFoldElseIf,obseFoldElse
      \ contains=TOP,NONE
syn region obseFoldElseIf
      \ start="^\s*\<elseif\>"
      \ end="^\s*\<endif\>"
      \ fold
      \ keepend
      \ contained containedin=obseFoldIfContainer
      \ nextgroup=obseFoldElseIf,obseFoldElse
      \ contains=TOP
syn region obseFoldElse
      \ start="^\s*\<else\>"
      \ end="^\s*\<endif\>"
      \ fold
      \ keepend
      \ contained containedin=obseFoldIfContainer
      \ contains=TOP
syn region obseFoldWhile
      \ start="^\s*\<while\>"
      \ end="^\s*\<loop\>"
      \ fold
      \ keepend extend
      \ contains=TOP
      \ containedin=ALLBUT,@obseNoFold
" fold for loops
syn region obseFoldFor
      \ start="^\s*\<foreach\>"
      \ end="^\s*\<loop\>"
      \ fold
      \ keepend extend
      \ contains=TOP
      \ containedin=ALLBUT,@obseNoFold
      \ nextgroup=obseVariable
" }}}

" Skills and Attributes {{{
syn keyword skillAttribute
      \ Strength
      \ Willpower
      \ Speed
      \ Personality
      \ Intelligence
      \ Agility
      \ Endurance
      \ Luck
      \ Armorer
      \ Athletics
      \ Blade
      \ Block
      \ Blunt
      \ HandToHand
      \ HeavyArmor
      \ Alchemy
      \ Alteration
      \ Conjuration
      \ Destruction
      \ Illusion
      \ Mysticism
      \ Restoration
      \ Acrobatics
      \ LightArmor
      \ Marksman
      \ Mercantile
      \ Security
      \ Sneak
      \ Speechcraft
" }}}

" Block Types {{{
syn keyword obseBlockType
      \ ExitGame
      \ ExitToMainMenu
      \ Function
      \ GameMode
      \ LoadGame
      \ MenuMode
      \ OnActivate
      \ OnActorDrop
      \ OnActorEquip
      \ OnActorUnequip
      \ OnAdd
      \ OnAlarm
      \ OnAlarmTrespass
      \ OnAlarmVictim
      \ OnAttack
      \ OnBlock
      \ OnBowAttack
      \ OnClick
      \ OnClose
      \ OnCreatePotion
      \ OnCreateSpell
      \ OnDeath
      \ OnDodge
      \ OnDrinkPotion
      \ OnDrop
      \ OnEatIngredient
      \ OnEnchant
      \ OnEquip
      \ OnFallImpact
      \ OnHealthDamage
      \ OnHit
      \ OnHitWith
      \ OnKnockout
      \ OnLoad
      \ OnMagicApply
      \ OnMagicCast
      \ OnMagicEffectHit
      \ OnMagicEffectHit2
      \ OnMapMarkerAdd
      \ OnMouseover
      \ OnMurder
      \ OnNewGame
      \ OnOpen
      \ OnPackageChange
      \ OnPackageDone
      \ OnPackageStart
      \ OnQuestComplete
      \ OnRecoil
      \ OnRelease
      \ OnReset
      \ OnSaveIni
      \ OnScriptedSkillUp
      \ OnScrollCast
      \ OnSell
      \ OnSkillUp
      \ OnSoulTrap
      \ OnSpellCast
      \ OnStagger
      \ OnStartCombat
      \ OnTrigger
      \ OnTriggerActor
      \ OnTriggerMob
      \ OnUnequip
      \ OnVampireFeed
      \ OnWaterDive
      \ OnWaterSurface
      \ PostLoadGame
      \ QQQ
      \ SaveGame
      \ ScriptEffectFinish
      \ ScriptEffectStart
      \ ScriptEffectUpdate
" }}}

" Functions {{{
" CS functions {{{
syn keyword csFunction
      \ Activate
      \ AddAchievement
      \ AddFlames
      \ AddItem
      \ AddScriptPackage
      \ AddSpell
      \ AddTopic
      \ AdvSkill
      \ AdvancePCLevel
      \ AdvancePCSkill
      \ Autosave
      \ CanHaveFlames
      \ CanPayCrimeGold
      \ Cast
      \ ClearOwnership
      \ CloseCurrentOblivionGate
      \ CloseOblivionGate
      \ CompleteQuest
      \ CreateFullActorCopy
      \ DeleteFullActorCopy
      \ Disable
      \ DisableLinkedPathPoints
      \ DisablePlayerControls
      \ Dispel
      \ DispelAllSpells
      \ Drop
      \ DropMe
      \ DuplicateAllItems
      \ DuplicateNPCStats
      \ Enable
      \ EnableFastTravel
      \ EnableLinkedPathPoints
      \ EnablePlayerControls
      \ EquipItem
      \ EssentialDeathReload
      \ EvaluatePackage	
      \ ForceAV
      \ ForceActorValue
      \ ForceCloseOblivionGate
      \ ForceFlee
      \ ForceTakeCover
      \ ForceWeather
      \ GetAV
      \ GetActionRef
      \ GetActorValue
      \ GetAlarmed
      \ GetAmountSoldStolen
      \ GetAngle
      \ GetArmorRating
      \ GetArmorRatingUpperBody
      \ GetAttacked
      \ GetBarterGold
      \ GetBaseAV
      \ GetBaseActorValue
      \ GetButtonPressed
      \ GetClassDefaultMatch
      \ GetClothingValue
      \ GetContainer
      \ GetCrime
      \ GetCrimeGold
      \ GetCrimeKnown
      \ GetCurrentAIPackage
      \ GetCurrentAIProcedure
      \ GetCurrentTime
      \ GetCurrentWeatherPercent
      \ GetDayOfWeek
      \ GetDead
      \ GetDeadCount
      \ GetDestroyed
      \ GetDetected
      \ GetDetectionLevel
      \ GetDisabled
      \ GetDisposition
      \ GetDistance
      \ GetDoorDefaultOpen
      \ GetEquipped
      \ GetFactionRank
      \ GetFactionRankDifference
      \ GetFactionReaction
      \ GetFatiguePercentage
      \ GetForceRun
      \ GetForceSneak
      \ GetFriendHit
      \ GetFurnitureMarkerID
      \ GetGS
      \ GetGameSetting
      \ GetGlobalValue
      \ GetGold
      \ GetHeadingAngle
      \ GetIdleDoneOnce
      \ GetIgnoreFriendlyHits
      \ GetInCell
      \ GetInCellParam
      \ GetInFaction
      \ GetInSameCell
      \ GetInWorldspace
      \ GetInvestmentGold
      \ GetIsAlerted
      \ GetIsClass
      \ GetIsClassDefault
      \ GetIsCreature
      \ GetIsCurrentPackage
      \ GetIsCurrentWeather
      \ GetIsGhost
      \ GetIsID
      \ GetIsPlayableRace
      \ GetIsPlayerBirthsign
      \ GetIsRace
      \ GetIsReference
      \ GetIsSex
      \ GetIsUsedItem
      \ GetIsUsedItemType
      \ GetItemCount
      \ GetKnockedState
      \ GetLOS
      \ GetLevel
      \ GetLockLevel
      \ GetLocked
      \ GetMenuHasTrait
      \ GetName
      \ GetNoRumors
      \ GetOffersServicesNow
      \ GetOpenState
      \ GetPCExpelled
      \ GetPCFactionAttack
      \ GetPCFactionMurder
      \ GetPCFactionSteal
      \ GetPCFactionSubmitAuthority
      \ GetPCFame
      \ GetPCInFaction
      \ GetPCInfamy
      \ GetPCIsClass
      \ GetPCIsRace
      \ GetPCIsSex
      \ GetPCMiscStat
      \ GetPCSleepHours
      \ GetPackageTarget
      \ GetParentRef
      \ GetPersuasionNumber
      \ GetPlayerControlsDisabled
      \ GetPlayerHasLastRiddenHorse
      \ GetPlayerInSEWorld
      \ GetPos
      \ GetQuestRunning
      \ GetQuestVariable
      \ GetRandomPercent
      \ GetRestrained
      \ GetScale
      \ GetScriptVariable
      \ GetSecondsPassed
      \ GetSelf
      \ GetShouldAttack
      \ GetSitting
      \ GetSleeping
      \ GetStage
      \ GetStageDone
      \ GetStartingAngle
      \ GetStartingPos
      \ GetTalkedToPC
      \ GetTalkedToPCParam
      \ GetTimeDead
      \ GetTotalPersuasionNumber
      \ GetTrespassWarningLevel
      \ GetUnconscious
      \ GetUsedItemActivate
      \ GetUsedItemLevel
      \ GetVampire
      \ GetWalkSpeed
      \ GetWeaponAnimType
      \ GetWeaponSkillType
      \ GetWindSpeed
      \ GoToJail
      \ HasFlames
      \ HasMagicEffect
      \ HasVampireFed
      \ IsActionRef
      \ IsActor
      \ IsActorAVictim
      \ IsActorDetected
      \ IsActorEvil
      \ IsActorUsingATorch
      \ IsActorsAIOff
      \ IsAnimPlayer
      \ IsCellOwner
      \ IsCloudy
      \ IsContinuingPackagePCNear
      \ IsCurrentFurnitureObj
      \ IsCurrentFurnitureRef
      \ IsEssential
      \ IsFacingUp
      \ IsGuard
      \ IsHorseStolen
      \ IsIdlePlaying
      \ IsInCombat
      \ IsInDangerousWater
      \ IsInInterior
      \ IsInMyOwnedCell
      \ IsLeftUp
      \ IsOwner
      \ IsPCAMurderer
      \ IsPCSleeping
      \ IsPlayerInJail
      \ IsPlayerMovingIntoNewSpace
      \ IsPlayersLastRiddenHorse
      \ IsPleasant
      \ IsRaining
      \ IsRidingHorse
      \ IsRunning
      \ IsShieldOut
      \ IsSneaking
      \ IsSnowing
      \ IsSpellTarget
      \ IsSwimming
      \ IsTalking
      \ IsTimePassing
      \ IsTorchOut
      \ IsTrespassing
      \ IsTurnArrest
      \ IsWaiting
      \ IsWeaponOut
      \ IsXBox
      \ IsYielding
      \ Kill
      \ KillActor
      \ KillAllActors
      \ Lock
      \ Look
      \ LoopGroup
      \ Message
      \ MessageBox
      \ ModAV
      \ ModActorValue
      \ ModAmountSoldStolen
      \ ModBarterGold
      \ ModCrimeGold
      \ ModDisposition
      \ ModFactionRank
      \ ModFactionReaction
      \ ModPCAttribute
      \ ModPCA
      \ ModPCFame
      \ ModPCInfamy
      \ ModPCMiscStat
      \ ModPCSkill
      \ ModPCS
      \ ModScale
      \ MoveTo
      \ MoveToMarker
      \ PCB
      \ PayFine
      \ PayFineThief
      \ PickIdle
      \ PlaceAtMe
      \ PlayBink
      \ PlayGroup
      \ PlayMagicEffectVisuals
      \ PlayMagicShaderVisuals
      \ PlaySound
      \ PlaySound3D
      \ PositionCell
      \ PositionWorld
      \ PreloadMagicEffect
      \ PurgeCellBuffers
      \ PushActorAway
      \ RefreshTopicList
      \ ReleaseWeatherOverride
      \ RemoveAllItems
      \ RemoveFlames
      \ RemoveItem
      \ RemoveMe
      \ RemoveScriptPackage
      \ RemoveSpell
      \ Reset3DState
      \ ResetFallDamageTimer
      \ ResetHealth
      \ ResetInterior
      \ Resurrect
      \ Rotate
      \ SCAOnActor
      \ SameFaction
      \ SameFactionAsPC
      \ SameRace
      \ SameRaceAsPC
      \ SameSex
      \ SameSexAsPC
      \ Say
      \ SayTo
      \ ScriptEffectElapsedSeconds
      \ SelectPlayerSpell
      \ SendTrespassAlarm
      \ SetAV
      \ SetActorAlpha
      \ SetActorFullName
      \ SetActorRefraction
      \ SetActorValue
      \ SetActorsAI
      \ SetAlert
      \ SetAllReachable
      \ SetAllVisible
      \ SetAngle
      \ SetAtStart
      \ SetBarterGold
      \ SetCellFullName
      \ SetCellOwnership
      \ SetCellPublicFlag
      \ SetClass
      \ SetCrimeGold
      \ SetDestroyed
      \ SetDoorDefaultOpen
      \ SetEssential
      \ SetFactionRank
      \ SetFactionReaction
      \ SetForceRun
      \ SetForceSneak
      \ SetGhost
      \ SetIgnoreFriendlyHits
      \ SetInCharGen
      \ SetInvestmentGold
      \ SetItemValue
      \ SetLevel
      \ SetNoAvoidance
      \ SetNoRumors
      \ SetOpenState
      \ SetOwnership
      \ SetPCExpelled
      \ SetPCFactionAttack
      \ SetPCFactionMurder
      \ SetPCFactionSteal
      \ SetPCFactionSubmitAuthority
      \ SetPCFame
      \ SetPCInfamy
      \ SetPCSleepHours
      \ SetPackDuration
      \ SetPlayerBirthsign
      \ SetPlayerInSEWorld
      \ SetPos
      \ SetQuestObject
      \ SetRestrained
      \ SetRigidBodyMass
      \ SetScale
      \ SetSceneIsComplex
      \ SetShowQuestItems
      \ SetSize
      \ SetStage
      \ SetUnconscious
      \ SetWeather
      \ ShowBirthsignMenu
      \ ShowClassMenu
      \ ShowDialogSubtitles
      \ ShowEnchantment
      \ ShowMap
      \ ShowRaceMenu
      \ ShowSpellMaking
      \ SkipAnim
      \ StartCombat
      \ StartConversation
      \ StartQuest
      \ StopCombat
      \ StopCombatAlarmOnActor
      \ StopLook
      \ StopMagicEffectVisuals
      \ StopMagicShaderVisuals
      \ StopQuest
      \ StopWaiting
      \ StreamMusic
      \ This
      \ ToggleActorsAI
      \ TrapUpdate
      \ TriggerHitShader
      \ UnequipItem
      \ Unlock
      \ VampireFeed
      \ Wait
      \ WakeUpPC
      \ WhichServiceMenu
      \ Yield
      \ evp
      \ pms
      \ saa
      \ sms
" }}}

" OBSE Functions {{{
syn keyword obseFunction
      \ abs
      \ acos
      \ activate2
      \ actorvaluetocode
      \ actorvaluetostring
      \ actorvaluetostringc
      \ addeffectitem
      \ addeffectitemc
      \ addfulleffectitem
      \ addfulleffectitemc
      \ additemns
      \ addmagiceffectcounter
      \ addmagiceffectcounterc
      \ addmecounter
      \ addmecounterc
      \ addspellns
      \ addtoleveledlist
      \ ahammerkey
      \ animpathincludes
      \ appendtoname
      \ asciitochar
      \ asin
      \ atan
      \ atan2
      \ avstring
      \ calcleveleditem
      \ calclevitemnr
      \ calclevitems
      \ cancastpower
      \ cancorpsecheck
      \ canfasttravelfromworld
      \ cantraveltomapmarker
      \ ceil
      \ chartoascii
      \ clearactivequest
      \ clearhotkey
      \ clearleveledlist
      \ clearownershipt
      \ clearplayerslastriddenhorse
      \ clickmenubutton
      \ cloneform
      \ closeallmenus
      \ closetextinput
      \ colvec
      \ comparefemalebipedpath
      \ comparefemalegroundpath
      \ comparefemaleiconpath
      \ compareiconpath
      \ comparemalebipedpath
      \ comparemalegroundpath
      \ comparemaleiconpath
      \ comparemodelpath
      \ comparename
      \ comparenames
      \ comparescripts
      \ con_cal
      \ con_getinisetting
      \ con_hairtint
      \ con_loadgame
      \ con_modwatershader
      \ con_playerspellbook
      \ con_quitgame
      \ con_refreshini
      \ con_runmemorypass
      \ con_save
      \ con_saveini
      \ con_setcamerafov
      \ con_setclipdist
      \ con_setfog
      \ con_setgamesetting
      \ con_setgamma
      \ con_sethdrparam
      \ con_setimagespaceglow
      \ con_setinisetting
      \ con_setskyparam
      \ con_settargetrefraction
      \ con_settargetrefractionfire
      \ con_sexchange
      \ con_tcl
      \ con_tfc
      \ con_tgm
      \ con_toggleai
      \ con_togglecombatai
      \ con_toggledetection
      \ con_togglemapmarkers
      \ con_togglemenus
      \ con_waterdeepcolor
      \ con_waterreflectioncolor
      \ con_watershallowcolor
      \ copyalleffectitems
      \ copyeyes
      \ copyfemalebipedpath
      \ copyfemalegroundpath
      \ copyfemaleiconpath
      \ copyhair
      \ copyiconpath
      \ copyir
      \ copymalebipedpath
      \ copymalegroundpath
      \ copymaleiconpath
      \ copymodelpath
      \ copyname
      \ copyntheffectitem
      \ copyrace
      \ cos
      \ cosh
      \ createtempref
      \ creaturehasnohead
      \ creaturehasnoleftarm
      \ creaturehasnomovement
      \ creaturehasnorightarm
      \ creaturenocombatinwater
      \ creatureusesweaponandshield
      \ dacos
      \ dasin
      \ datan
      \ datan2
      \ dcos
      \ dcosh
      \ debugprint
      \ deletefrominputtext
      \ deletereference
      \ disablecontrol
      \ disablekey
      \ disablemouse
      \ dispatchevent
      \ dispelnthactiveeffect
      \ dispelnthae
      \ dsin
      \ dsinh
      \ dtan
      \ dtanh
      \ enablecontrol
      \ enablekey
      \ enablemouse
      \ equipitem2
      \ equipitem2ns
      \ equipitemns
      \ equipitemsilent
      \ equipme
      \ eval
      \ evaluatepackage
      \ eventhandlerexist
      \ exp
      \ factionhasspecialcombat
      \ fileexists
      \ floor
      \ fmod
      \ forcecolumnvector
      \ forcerowvector
      \ generateidentitymatrix
      \ generaterotationmatrix
      \ generatezeromatrix
      \ getactiveeffectcasters
      \ getactiveeffectcodes
      \ getactiveeffectcount
      \ getactivemenucomponentid
      \ getactivemenufilter
      \ getactivemenumode
      \ getactivemenuobject
      \ getactivemenuref
      \ getactivemenuselection
      \ getactivequest
      \ getactiveuicomponentfullname
      \ getactiveuicomponentid
      \ getactiveuicomponentname
      \ getactoralpha
      \ getactorbaselevel
      \ getactorlightamount
      \ getactormaxlevel
      \ getactormaxswimbreath
      \ getactorminlevel
      \ getactorpackages
      \ getactorsoullevel
      \ getactorvaluec
      \ getalchmenuapparatus
      \ getalchmenuingredient
      \ getalchmenuingredientcount
      \ getallies
      \ getallmodlocaldata
      \ getaltcontrol2
      \ getapbowench
      \ getapench
      \ getapparatustype
      \ getappoison
      \ getarmorar
      \ getarmortype
      \ getarrayvariable
      \ getarrowprojectilebowenchantment
      \ getarrowprojectileenchantment
      \ getarrowprojectilepoison
      \ getattackdamage
      \ getavc
      \ getavforbaseactor
      \ getavforbaseactorc
      \ getavmod
      \ getavmodc
      \ getavskillmastery
      \ getavskillmasteryc
      \ getbarteritem
      \ getbarteritemquantity
      \ getbaseactorvaluec
      \ getbaseav2
      \ getbaseav2c
      \ getbaseav3
      \ getbaseav3c
      \ getbaseitems
      \ getbaseobject
      \ getbipediconpath
      \ getbipedmodelpath
      \ getbipedslotmask
      \ getbirthsignspells
      \ getbookcantbetaken
      \ getbookisscroll
      \ getbooklength
      \ getbookskilltaught
      \ getbooktext
      \ getboundingbox
      \ getboundingradius
      \ getcalcalllevels
      \ getcalceachincount
      \ getcallingscript
      \ getcellbehavesasexterior
      \ getcellchanged
      \ getcellclimate
      \ getcelldetachtime
      \ getcellfactionrank
      \ getcelllighting
      \ getcellmusictype
      \ getcellnorthrotation
      \ getcellresethours
      \ getcellwatertype
      \ getchancenone
      \ getclass
      \ getclassattribute
      \ getclassmenuhighlightedclass
      \ getclassmenuselectedclass
      \ getclassskill
      \ getclassskills
      \ getclassspecialization
      \ getclimatehasmasser
      \ getclimatehassecunda
      \ getclimatemoonphaselength
      \ getclimatesunrisebegin
      \ getclimatesunriseend
      \ getclimatesunsetbegin
      \ getclimatesunsetend
      \ getclimatevolatility
      \ getclosesound
      \ getcloudspeedlower
      \ getcloudspeedupper
      \ getcombatspells
      \ getcombatstyle
      \ getcombatstyleacrobaticsdodgechance
      \ getcombatstyleattackchance
      \ getcombatstyleattackduringblockmult
      \ getcombatstyleattacknotunderattackmult
      \ getcombatstyleattackskillmodbase
      \ getcombatstyleattackskillmodmult
      \ getcombatstyleattackunderattackmult
      \ getcombatstyleblockchance
      \ getcombatstyleblocknotunderattackmult
      \ getcombatstyleblockskillmodbase
      \ getcombatstyleblockskillmodmult
      \ getcombatstyleblockunderattackmult
      \ getcombatstylebuffstandoffdist
      \ getcombatstyledodgebacknotunderattackmult
      \ getcombatstyledodgebacktimermax
      \ getcombatstyledodgebacktimermin
      \ getcombatstyledodgebackunderattackmult
      \ getcombatstyledodgechance
      \ getcombatstyledodgefatiguemodbase
      \ getcombatstyledodgefatiguemodmult
      \ getcombatstyledodgefwattackingmult
      \ getcombatstyledodgefwnotattackingmult
      \ getcombatstyledodgefwtimermax
      \ getcombatstyledodgefwtimermin
      \ getcombatstyledodgelrchance
      \ getcombatstyledodgelrtimermax
      \ getcombatstyledodgelrtimermin
      \ getcombatstyledodgenotunderattackmult
      \ getcombatstyledodgeunderattackmult
      \ getcombatstyleencumberedspeedmodbase
      \ getcombatstyleencumberedspeedmodmult
      \ getcombatstylefleeingdisabled
      \ getcombatstylegroupstandoffdist
      \ getcombatstyleh2hbonustoattack
      \ getcombatstyleholdtimermax
      \ getcombatstyleholdtimermin
      \ getcombatstyleidletimermax
      \ getcombatstyleidletimermin
      \ getcombatstyleignorealliesinarea
      \ getcombatstylekobonustoattack
      \ getcombatstylekobonustopowerattack
      \ getcombatstylemeleealertok
      \ getcombatstylepowerattackchance
      \ getcombatstylepowerattackfatiguemodbase
      \ getcombatstylepowerattackfatiguemodmult
      \ getcombatstyleprefersranged
      \ getcombatstylerangedstandoffdist
      \ getcombatstylerangemaxmult
      \ getcombatstylerangeoptimalmult
      \ getcombatstylerejectsyields
      \ getcombatstylerushattackchance
      \ getcombatstylerushattackdistmult
      \ getcombatstylestaggerbonustoattack
      \ getcombatstylestaggerbonustopowerattack
      \ getcombatstyleswitchdistmelee
      \ getcombatstyleswitchdistranged
      \ getcombatstylewillyield
      \ getcombattarget
      \ getcompletedquests
      \ getcontainermenuview
      \ getcontainerrespawns
      \ getcontrol
      \ getcreaturebasescale
      \ getcreaturecombatskill
      \ getcreatureflies
      \ getcreaturemagicskill
      \ getcreaturemodelpaths
      \ getcreaturereach
      \ getcreaturesoullevel
      \ getcreaturesound
      \ getcreaturesoundbase
      \ getcreaturestealthskill
      \ getcreatureswims
      \ getcreaturetype
      \ getcreaturewalks
      \ getcrosshairref
      \ getcurrentcharge
      \ getcurrentclimateid
      \ getcurrenteditorpackage
      \ getcurrenteventname
      \ getcurrenthealth
      \ getcurrentpackage
      \ getcurrentpackageprocedure
      \ getcurrentquests
      \ getcurrentregion
      \ getcurrentregions
      \ getcurrentscript
      \ getcurrentsoullevel
      \ getcurrentweatherid
      \ getcursorpos
      \ getdebugselection
      \ getdescription
      \ getdoorteleportrot
      \ getdoorteleportx
      \ getdoorteleporty
      \ getdoorteleportz
      \ geteditorid
      \ geteditorsize
      \ getenchantment
      \ getenchantmentcharge
      \ getenchantmentcost
      \ getenchantmenttype
      \ getenchmenubaseitem
      \ getenchmenuenchitem
      \ getenchmenusoulgem
      \ getequipmentslot
      \ getequipmentslotmask
      \ getequippedcurrentcharge
      \ getequippedcurrenthealth
      \ getequippeditems
      \ getequippedobject
      \ getequippedtorchtimeleft
      \ getequippedweaponpoison
      \ geteyes
      \ getfactions
      \ getfalltimer
      \ getfirstref
      \ getfirstrefincell
      \ getfogdayfar
      \ getfogdaynear
      \ getfognightfar
      \ getfognightnear
      \ getfollowers
      \ getformfrommod
      \ getformidstring
      \ getfps
      \ getfullgoldvalue
      \ getgamedifficulty
      \ getgameloaded
      \ getgamerestarted
      \ getgodmode
      \ getgoldvalue
      \ getgridstoload
      \ getgroundsurfacematerial
      \ gethair
      \ gethaircolor
      \ gethdrvalue
      \ gethidesamulet
      \ gethidesrings
      \ gethighactors
      \ gethorse
      \ gethotkeyitem
      \ geticonpath
      \ getignoresresistance
      \ getingredient
      \ getingredientchance
      \ getinputtext
      \ getinventoryobject
      \ getinvrefsforitem
      \ getitems
      \ getkeyname
      \ getkeypress
      \ getlastcreatedpotion
      \ getlastcreatedspell
      \ getlastenchanteditem
      \ getlastsigilstonecreateditem
      \ getlastsigilstoneenchanteditem
      \ getlastss
      \ getlastsscreated
      \ getlastssitem
      \ getlasttransactionitem
      \ getlasttransactionquantity
      \ getlastuniquecreatedpotion
      \ getlastusedsigilstone
      \ getlevcreaturetemplate
      \ getleveledspells
      \ getlevitembylevel
      \ getlevitemindexbyform
      \ getlevitemindexbylevel
      \ getlightduration
      \ getlightningfrequency
      \ getlightradius
      \ getlightrgb
      \ getlinkeddoor
      \ getloadedtypearray
      \ getlocalgravity
      \ getloopsound
      \ getlowactors
      \ getluckmodifiedskill
      \ getmagiceffectareasound
      \ getmagiceffectareasoundc
      \ getmagiceffectbarterfactor
      \ getmagiceffectbarterfactorc
      \ getmagiceffectbasecost
      \ getmagiceffectbasecostc
      \ getmagiceffectboltsound
      \ getmagiceffectboltsoundc
      \ getmagiceffectcastingsound
      \ getmagiceffectcastingsoundc
      \ getmagiceffectchars
      \ getmagiceffectcharsc
      \ getmagiceffectcode
      \ getmagiceffectcounters
      \ getmagiceffectcountersc
      \ getmagiceffectenchantfactor
      \ getmagiceffectenchantfactorc
      \ getmagiceffectenchantshader
      \ getmagiceffectenchantshaderc
      \ getmagiceffecthitshader
      \ getmagiceffecthitshaderc
      \ getmagiceffecthitsound
      \ getmagiceffecthitsoundc
      \ getmagiceffecticon
      \ getmagiceffecticonc
      \ getmagiceffectlight
      \ getmagiceffectlightc
      \ getmagiceffectmodel
      \ getmagiceffectmodelc
      \ getmagiceffectname
      \ getmagiceffectnamec
      \ getmagiceffectnumcounters
      \ getmagiceffectnumcountersc
      \ getmagiceffectotheractorvalue
      \ getmagiceffectotheractorvaluec
      \ getmagiceffectprojectilespeed
      \ getmagiceffectprojectilespeedc
      \ getmagiceffectresistvalue
      \ getmagiceffectresistvaluec
      \ getmagiceffectschool
      \ getmagiceffectschoolc
      \ getmagiceffectusedobject
      \ getmagiceffectusedobjectc
      \ getmagicitemeffectcount
      \ getmagicitemtype
      \ getmagicprojectilespell
      \ getmapmarkers
      \ getmapmarkertype
      \ getmapmenumarkername
      \ getmapmenumarkerref
      \ getmaxav
      \ getmaxavc
      \ getmaxlevel
      \ getmeareasound
      \ getmeareasoundc
      \ getmebarterc
      \ getmebasecost
      \ getmebasecostc
      \ getmeboltsound
      \ getmeboltsoundc
      \ getmecastingsound
      \ getmecastingsoundc
      \ getmecounters
      \ getmecountersc
      \ getmeebarter
      \ getmeebarterc
      \ getmeenchant
      \ getmeenchantc
      \ getmeenchantshader
      \ getmeenchantshaderc
      \ getmehitshader
      \ getmehitshaderc
      \ getmehitsound
      \ getmehitsoundc
      \ getmeicon
      \ getmeiconc
      \ getmelight
      \ getmelightc
      \ getmemodel
      \ getmemodelc
      \ getmename
      \ getmenamec
      \ getmenufloatvalue
      \ getmenumcounters
      \ getmenumcountersc
      \ getmenustringvalue
      \ getmeotheractorvalue
      \ getmeotheractorvaluec
      \ getmeprojspeed
      \ getmeprojspeedc
      \ getmerchantcontainer
      \ getmeresistvalue
      \ getmeresistvaluec
      \ getmeschool
      \ getmeschoolc
      \ getmessageboxtype
      \ getmeusedobject
      \ getmeusedobjectc
      \ getmiddlehighactors
      \ getmieffectcount
      \ getminlevel
      \ getmitype
      \ getmodelpath
      \ getmodindex
      \ getmodlocaldata
      \ getmousebuttonpress
      \ getmousebuttonsswapped
      \ getmpspell
      \ getnextref
      \ getnthacitveeffectmagnitude
      \ getnthactiveeffectactorvalue
      \ getnthactiveeffectbounditem
      \ getnthactiveeffectcaster
      \ getnthactiveeffectcode
      \ getnthactiveeffectdata
      \ getnthactiveeffectduration
      \ getnthactiveeffectenchantobject
      \ getnthactiveeffectmagicenchantobject
      \ getnthactiveeffectmagicitem
      \ getnthactiveeffectmagicitemindex
      \ getnthactiveeffectmagnitude
      \ getnthactiveeffectsummonref
      \ getnthactiveeffecttimeelapsed
      \ getnthaeav
      \ getnthaebounditem
      \ getnthaecaster
      \ getnthaecode
      \ getnthaedata
      \ getnthaeduration
      \ getnthaeindex
      \ getnthaemagicenchantobject
      \ getnthaemagicitem
      \ getnthaemagnitude
      \ getnthaesummonref
      \ getnthaetime
      \ getnthchildref
      \ getnthdetectedactor
      \ getntheffectitem
      \ getntheffectitemactorvalue
      \ getntheffectitemarea
      \ getntheffectitemcode
      \ getntheffectitemduration
      \ getntheffectitemmagnitude
      \ getntheffectitemname
      \ getntheffectitemrange
      \ getntheffectitemscript
      \ getntheffectitemscriptname
      \ getntheffectitemscriptschool
      \ getntheffectitemscriptvisualeffect
      \ getntheiarea
      \ getntheiav
      \ getntheicode
      \ getntheiduration
      \ getntheimagnitude
      \ getntheiname
      \ getntheirange
      \ getntheiscript
      \ getntheisschool
      \ getntheisvisualeffect
      \ getnthexplicitref
      \ getnthfaction
      \ getnthfactionrankname
      \ getnthfollower
      \ getnthlevitem
      \ getnthlevitemcount
      \ getnthlevitemlevel
      \ getnthmagiceffectcounter
      \ getnthmagiceffectcounterc
      \ getnthmecounter
      \ getnthmecounterc
      \ getnthmodname
      \ getnthpackage
      \ getnthplayerspell
      \ getnthracebonusskill
      \ getnthracespell
      \ getnthspell
      \ getnumchildrefs
      \ getnumdetectedactors
      \ getnumericinisetting
      \ getnumexplicitrefs
      \ getnumfactions
      \ getnumfollowers
      \ getnumitems
      \ getnumkeyspressed
      \ getnumlevitems
      \ getnumloadedmods
      \ getnumloadedplugins
      \ getnummousebuttonspressed
      \ getnumpackages
      \ getnumranks
      \ getnumrefs
      \ getnumrefsincell
      \ getobjectcharge
      \ getobjecthealth
      \ getobjecttype
      \ getobliviondirectory
      \ getoblrevision
      \ getoblversion
      \ getopenkey
      \ getopensound
      \ getowner
      \ getowningfactionrank
      \ getowningfactionrequiredrank
      \ getpackageallowfalls
      \ getpackageallowswimming
      \ getpackagealwaysrun
      \ getpackagealwayssneak
      \ getpackagearmorunequipped
      \ getpackagecontinueifpcnear
      \ getpackagedata
      \ getpackagedefensivecombat
      \ getpackagelocationdata
      \ getpackagelockdoorsatend
      \ getpackagelockdoorsatlocation
      \ getpackagelockdoorsatstart
      \ getpackagemustcomplete
      \ getpackagemustreachlocation
      \ getpackagenoidleanims
      \ getpackageoffersservices
      \ getpackageonceperday
      \ getpackagescheduledata
      \ getpackageskipfalloutbehavior
      \ getpackagetargetdata
      \ getpackageunlockdoorsatend
      \ getpackageunlockdoorsatlocation
      \ getpackageunlockdoorsatstart
      \ getpackageusehorse
      \ getpackageweaponsunequipped
      \ getparentcell
      \ getparentcellowner
      \ getparentcellowningfactionrank
      \ getparentcellowningfactionrequiredrank
      \ getparentcellwaterheight
      \ getparentworldspace
      \ getpathnodelinkedref
      \ getpathnodepos
      \ getpathnodesinradius
      \ getpathnodesinrect
      \ getpcattributebonus
      \ getpcattributebonusc
      \ getpclastdroppeditem
      \ getpclastdroppeditemref
      \ getpclasthorse
      \ getpclastloaddoor
      \ getpcmajorskillups
      \ getpcmovementspeedmodifier
      \ getpcspelleffectivenessmodifier
      \ getpctrainingsessionsused
      \ getplayerbirthsign
      \ getplayerskilladvances
      \ getplayerskilladvancesc
      \ getplayerskilluse
      \ getplayerskillusec
      \ getplayerslastactivatedloaddoor
      \ getplayerslastriddenhorse
      \ getplayerspell
      \ getplayerspellcount
      \ getpluginversion
      \ getplyerspellcount
      \ getprocesslevel
      \ getprojectile
      \ getprojectiledistancetraveled
      \ getprojectilelifetime
      \ getprojectilesource
      \ getprojectilespeed
      \ getprojectiletype
      \ getqmcurrent
      \ getqmitem
      \ getqmmaximum
      \ getqr
      \ getquality
      \ getquantitymenucurrentquantity
      \ getquantitymenuitem
      \ getquantitymenumaximumquantity
      \ getrace
      \ getraceattribute
      \ getraceattributec
      \ getracedefaulthair
      \ getraceeyes
      \ getracehairs
      \ getracereaction
      \ getracescale
      \ getraceskillbonus
      \ getraceskillbonusc
      \ getracespellcount
      \ getracevoice
      \ getraceweight
      \ getrawformidstring
      \ getrefcount
      \ getrefvariable
      \ getrequiredskillexp
      \ getrequiredskillexpc
      \ getrider
      \ getscript
      \ getscriptactiveeffectindex
      \ getselectedspells
      \ getservicesmask
      \ getsigilstoneuses
      \ getskillgoverningattribute
      \ getskillgoverningattributec
      \ getskillspecialization
      \ getskillspecializationc
      \ getskilluseincrement
      \ getskilluseincrementc
      \ getsoulgemcapacity
      \ getsoullevel
      \ getsoundattenuation
      \ getsoundplaying
      \ getsourcemodindex
      \ getspecialanims
      \ getspellareaeffectignoreslos
      \ getspellcount
      \ getspelldisallowabsorbreflect
      \ getspelleffectiveness
      \ getspellexplodeswithnotarget
      \ getspellhostile
      \ getspellimmunetosilence
      \ getspellmagickacost
      \ getspellmasterylevel
      \ getspellpcstart
      \ getspells
      \ getspellschool
      \ getspellscripteffectalwaysapplies
      \ getspelltype
      \ getstageentries
      \ getstageids
      \ getstringgamesetting
      \ getstringinisetting
      \ getsundamage
      \ getsunglare
      \ gettailmodelpath
      \ gettargets
      \ gettelekinesisref
      \ getteleportcell
      \ getteleportcellname
      \ getterrainheight
      \ gettextinputcontrolpressed
      \ gettextinputcursorpos
      \ gettexturepath
      \ gettilechildren
      \ gettiletraits
      \ gettimeleft
      \ gettotalactiveeffectmagnitude
      \ gettotalactiveeffectmagnitudec
      \ gettotalaeabilitymagnitude
      \ gettotalaeabilitymagnitudec
      \ gettotalaealchemymagnitude
      \ gettotalaealchemymagnitudec
      \ gettotalaeallspellsmagnitude
      \ gettotalaeallspellsmagnitudec
      \ gettotalaediseasemagnitude
      \ gettotalaediseasemagnitudec
      \ gettotalaeenchantmentmagnitude
      \ gettotalaeenchantmentmagnitudec
      \ gettotalaelesserpowermagnitude
      \ gettotalaelesserpowermagnitudec
      \ gettotalaemagnitude
      \ gettotalaemagnitudec
      \ gettotalaenonabilitymagnitude
      \ gettotalaenonabilitymagnitudec
      \ gettotalaepowermagnitude
      \ gettotalaepowermagnitudec
      \ gettotalaespellmagnitude
      \ gettotalaespellmagnitudec
      \ gettotalpcattributebonus
      \ gettrainerlevel
      \ gettrainerskill
      \ gettransactioninfo
      \ gettransdelta
      \ gettravelhorse
      \ getusedpowers
      \ getusertime
      \ getvariable
      \ getvelocity
      \ getverticalvelocity
      \ getwaterheight
      \ getwatershader
      \ getweahtercloudspeedupper
      \ getweaponreach
      \ getweaponspeed
      \ getweapontype
      \ getweatherclassification
      \ getweathercloudspeedlower
      \ getweathercloudspeedupper
      \ getweathercolor
      \ getweatherfogdayfar
      \ getweatherfogdaynear
      \ getweatherfognightfar
      \ getweatherfognightnear
      \ getweatherhdrvalue
      \ getweatherlightningfrequency
      \ getweatheroverride
      \ getweathersundamage
      \ getweathersunglare
      \ getweathertransdelta
      \ getweatherwindspeed
      \ getweight
      \ getworldparentworld
      \ getworldspaceparentworldspace
      \ globalvariableexists
      \ hammerkey
      \ hasbeenpickedup
      \ haseffectshader
      \ haslowlevelprocessing
      \ hasmodel
      \ hasname
      \ hasnopersuasion
      \ hasspell
      \ hastail
      \ hasvariable
      \ haswater
      \ holdkey
      \ iconpathincludes
      \ identitymat
      \ incrementplayerskilluse
      \ incrementplayerskillusec
      \ ininvertfasttravel
      \ insertininputtext
      \ isactivatable
      \ isactivator
      \ isactorrespawning
      \ isalchemyitem
      \ isammo
      \ isanimgroupplaying
      \ isanimplaying
      \ isapparatus
      \ isarmor
      \ isattacking
      \ isautomaticdoor
      \ isbartermenuactive
      \ isbipediconpathvalid
      \ isbipedmodelpathvalid
      \ isblocking
      \ isbook
      \ iscantwait
      \ iscasting
      \ iscellpublic
      \ isclassattribute
      \ isclassattributec
      \ isclassskill
      \ isclassskillc
      \ isclonedform
      \ isclothing
      \ isconsoleopen
      \ iscontainer
      \ iscontrol
      \ iscontroldisabled
      \ iscontrolpressed
      \ iscreature
      \ iscreaturebiped
      \ isdigit
      \ isdiseased
      \ isdodging
      \ isdoor
      \ isequipped
      \ isfactionevil
      \ isfactionhidden
      \ isfemale
      \ isflora
      \ isflying
      \ isfood
      \ isformvalid
      \ isfurniture
      \ isgamemessagebox
      \ isglobalcollisiondisabled
      \ isharvested
      \ ishiddendoor
      \ isiconpathvalid
      \ isinair
      \ isingredient
      \ isinoblivion
      \ isjumping
      \ iskey
      \ iskeydisabled
      \ iskeypressed
      \ iskeypressed2
      \ iskeypressed3
      \ isletter
      \ islight
      \ islightcarriable
      \ isloaddoor
      \ ismagiceffectcanrecover
      \ ismagiceffectcanrecoverc
      \ ismagiceffectdetrimental
      \ ismagiceffectdetrimentalc
      \ ismagiceffectforenchanting
      \ ismagiceffectforenchantingc
      \ ismagiceffectforspellmaking
      \ ismagiceffectforspellmakingc
      \ ismagiceffecthostile
      \ ismagiceffecthostilec
      \ ismagiceffectmagnitudepercent
      \ ismagiceffectmagnitudepercentc
      \ ismagiceffectonselfallowed
      \ ismagiceffectonselfallowedc
      \ ismagiceffectontargetallowed
      \ ismagiceffectontargetallowedc
      \ ismagiceffectontouchallowed
      \ ismagiceffectontouchallowedc
      \ ismagicitemautocalc
      \ ismajor
      \ ismajorc
      \ ismajorref
      \ ismapmarkervisible
      \ ismecanrecover
      \ ismecanrecoverc
      \ ismedetrimental
      \ ismedetrimentalc
      \ ismeforenchanting
      \ ismeforenchantingc
      \ ismeforspellmaking
      \ ismeforspellmakingc
      \ ismehostile
      \ ismehostilec
      \ ismemagnitudepercent
      \ ismemagnitudepercentc
      \ ismeonselfallowed
      \ ismeonselfallowedc
      \ ismeontargetallowed
      \ ismeontargetallowedc
      \ ismeontouchallowed
      \ ismeontouchallowedc
      \ isminimalusedoor
      \ ismiscitem
      \ ismodelpathvalid
      \ ismodloaded
      \ ismovingbackward
      \ ismovingforward
      \ ismovingleft
      \ ismovingright
      \ isnaked
      \ isnthactiveeffectapplied
      \ isntheffectitemscripted
      \ isntheffectitemscripthostile
      \ isntheishostile
      \ isobliviongate
      \ isoblivioninterior
      \ isoblivionworld
      \ isofflimits
      \ isonground
      \ ispathnodedisabled
      \ ispcleveloffset
      \ ispersistent
      \ isplayable
      \ isplayable2
      \ isplugininstalled
      \ ispoison
      \ ispotion
      \ ispowerattacking
      \ isprintable
      \ ispunctuation
      \ isquestcomplete
      \ isquestitem
      \ isracebonusskill
      \ isracebonusskillc
      \ israceplayable
      \ isrecoiling
      \ isrefdeleted
      \ isreference
      \ isrefessential
      \ isscripted
      \ issigilstone
      \ issoulgem
      \ isspellhostile
      \ isstaggered
      \ issummonable
      \ istaken
      \ istextinputinuse
      \ isthirdperson
      \ isturningleft
      \ isturningright
      \ isunderwater
      \ isunsaferespawns
      \ isuppercase
      \ isweapon
      \ leftshift
      \ linktodoor
      \ loadgameex
      \ log
      \ log10
      \ logicaland
      \ logicalnot
      \ logicalor
      \ logicalxor
      \ magiceffectcodefromchars
      \ magiceffectfromchars
      \ magiceffectfromcode
      \ magiceffectfxpersists
      \ magiceffectfxpersistsc
      \ magiceffecthasnoarea
      \ magiceffecthasnoareac
      \ magiceffecthasnoduration
      \ magiceffecthasnodurationc
      \ magiceffecthasnohiteffect
      \ magiceffecthasnohiteffectc
      \ magiceffecthasnoingredient
      \ magiceffecthasnoingredientc
      \ magiceffecthasnomagnitude
      \ magiceffecthasnomagnitudec
      \ magiceffectusesarmor
      \ magiceffectusesarmorc
      \ magiceffectusesattribute
      \ magiceffectusesattributec
      \ magiceffectusescreature
      \ magiceffectusescreaturec
      \ magiceffectusesotheractorvalue
      \ magiceffectusesotheractorvaluec
      \ magiceffectusesskill
      \ magiceffectusesskillc
      \ magiceffectusesweapon
      \ magiceffectusesweaponc
      \ magichaseffect
      \ magichaseffectc
      \ magicitemhaseffect
      \ magicitemhaseffectcode
      \ magicitemhaseffectcount
      \ magicitemhaseffectcountc
      \ magicitemhaseffectcountcode
      \ magicitemhaseffectitemscript
      \ matadd
      \ matchpotion
      \ matinv
      \ matmult
      \ matrixadd
      \ matrixdeterminant
      \ matrixinvert
      \ matrixmultiply
      \ matrixrref
      \ matrixscale
      \ matrixsubtract
      \ matrixtrace
      \ matrixtranspose
      \ matscale
      \ matsubtract
      \ mecodefromchars
      \ mefxpersists
      \ mefxpersistsc
      \ mehasnoarea
      \ mehasnoareac
      \ mehasnoduration
      \ mehasnodurationc
      \ mehasnohiteffect
      \ mehasnohiteffectc
      \ mehasnoingredient
      \ mehasnoingredientc
      \ mehasnomagnitude
      \ mehasnomagnitudec
      \ menuholdkey
      \ menumode
      \ menureleasekey
      \ menutapkey
      \ messageboxex
      \ messageex
      \ meusesarmor
      \ meusesarmorc
      \ meusesattribute
      \ meusesattributec
      \ meusescreature
      \ meusescreaturec
      \ meusesotheractorvalue
      \ meusesotheractorvaluec
      \ meusesskill
      \ meusesskillc
      \ meusesweapon
      \ meusesweaponc
      \ modactorvalue2
      \ modactorvaluec
      \ modarmorar
      \ modattackdamage
      \ modav2
      \ modavc
      \ modavmod
      \ modavmodc
      \ modcurrentcharge
      \ modelpathincludes
      \ modenchantmentcharge
      \ modenchantmentcost
      \ modequippedcurrentcharge
      \ modequippedcurrenthealth
      \ modfemalebipedpath
      \ modfemalegroundpath
      \ modfemaleiconpath
      \ modgoldvalue
      \ modiconpath
      \ modlocaldataexists
      \ modmalebipedpath
      \ modmalegroundpath
      \ modmaleiconpath
      \ modmodelpath
      \ modname
      \ modnthactiveeffectmagnitude
      \ modnthaemagnitude
      \ modntheffectitemarea
      \ modntheffectitemduration
      \ modntheffectitemmagnitude
      \ modntheffectitemscriptname
      \ modntheiarea
      \ modntheiduration
      \ modntheimagnitude
      \ modntheisname
      \ modobjectcharge
      \ modobjecthealth
      \ modpcmovementspeed
      \ modpcspelleffectiveness
      \ modplayerskillexp
      \ modplayerskillexpc
      \ modquality
      \ modsigilstoneuses
      \ modspellmagickacost
      \ modweaponreach
      \ modweaponspeed
      \ modweight
      \ movemousex
      \ movemousey
      \ movetextinputcursor
      \ nameincludes
      \ numtohex
      \ offersapparatus
      \ offersarmor
      \ offersbooks
      \ offersclothing
      \ offersingredients
      \ offerslights
      \ offersmagicitems
      \ offersmiscitems
      \ offerspotions
      \ offersrecharging
      \ offersrepair
      \ offersservicesc
      \ offersspells
      \ offerstraining
      \ offersweapons
      \ oncontroldown
      \ onkeydown
      \ opentextinput
      \ outputlocalmappicturesoverride
      \ overrideactorswimbreath
      \ parentcellhaswater
      \ pathedgeexists
      \ playidle
      \ pow
      \ print
      \ printactivetileinfo
      \ printc
      \ printd
      \ printtileinfo
      \ printtoconsole
      \ questexists
      \ racos
      \ rand
      \ rasin
      \ ratan
      \ ratan2
      \ rcos
      \ rcosh
      \ refreshcurrentclimate
      \ releasekey
      \ removealleffectitems
      \ removebasespell
      \ removeenchantment
      \ removeequippedweaponpoison
      \ removeeventhandler
      \ removefromleveledlist
      \ removeitemns
      \ removelevitembylevel
      \ removemeir
      \ removemodlocaldata
      \ removentheffect
      \ removentheffectitem
      \ removenthlevitem
      \ removenthmagiceffectcounter
      \ removenthmagiceffectcounterc
      \ removenthmecounter
      \ removenthmecounterc
      \ removescript
      \ removescr
      \ removespellns
      \ resetallvariables
      \ resetfalrior
      \ resolvemodindex
      \ rightshift
      \ rotmat
      \ rowvec
      \ rsin
      \ rsinh
      \ rtan
      \ rtanh
      \ runbatchscript
      \ runscriptline
      \ saespassalarm
      \ setactivequest
      \ setactrfullname
      \ setactormaxswimbreath
      \ setactorrespawns
      \ setactorswimbreath
      \ setactorvaluec
      \ setalvisible
      \ setaltcontrol2
      \ setapparatustype
      \ setarmorar
      \ setarmortype
      \ setarrowprojectilebowenchantment
      \ setarrowprojectileenchantment
      \ setarrowprojectilepoison
      \ setattackdamage
      \ setavc
      \ setavmod
      \ setavmodc
      \ setbaseform
      \ setbipediconpathex
      \ setbipedmodelpathex
      \ setbipedslotmask
      \ setbookcantbetaken
      \ setbookisscroll
      \ setbookskilltaught
      \ setbuttonpressed
      \ setcalcalllevels
      \ setcamerafov2
      \ setcancastpower
      \ setcancorpsecheck
      \ setcanfasttravelfromworld
      \ setcantraveltomapmarker
      \ setcantwait
      \ setcellbehavesasexterior
      \ setcellclimate
      \ setcellhaswater
      \ setcellispublic
      \ setcelllighting
      \ setcellmusictype
      \ setcellublicflag
      \ setcellresethours
      \ setcellwaterheight
      \ setcellwatertype
      \ setchancenone
      \ setclassattribute
      \ setclassattributec
      \ setclassskills
      \ setclassskills2
      \ setclassspecialization
      \ setclimatehasmasser
      \ setclimatehasmassser
      \ setclimatehassecunda
      \ setclimatemoonphaselength
      \ setclimatesunrisebegin
      \ setclimatesunriseend
      \ setclimatesunsetbegin
      \ setclimatesunsetend
      \ setclimatevolatility
      \ setclosesound
      \ setcloudspeedlower
      \ setcloudspeedupper
      \ setcombatstyle
      \ setcombatstyleacrobaticsdodgechance
      \ setcombatstyleattackchance
      \ setcombatstyleattackduringblockmult
      \ setcombatstyleattacknotunderattackmult
      \ setcombatstyleattackskillmodbase
      \ setcombatstyleattackskillmodmult
      \ setcombatstyleattackunderattackmult
      \ setcombatstyleblockchance
      \ setcombatstyleblocknotunderattackmult
      \ setcombatstyleblockskillmodbase
      \ setcombatstyleblockskillmodmult
      \ setcombatstyleblockunderattackmult
      \ setcombatstylebuffstandoffdist
      \ setcombatstyledodgebacknotunderattackmult
      \ setcombatstyledodgebacktimermax
      \ setcombatstyledodgebacktimermin
      \ setcombatstyledodgebackunderattackmult
      \ setcombatstyledodgechance
      \ setcombatstyledodgefatiguemodbase
      \ setcombatstyledodgefatiguemodmult
      \ setcombatstyledodgefwattackingmult
      \ setcombatstyledodgefwnotattackingmult
      \ setcombatstyledodgefwtimermax
      \ setcombatstyledodgefwtimermin
      \ setcombatstyledodgelrchance
      \ setcombatstyledodgelrtimermax
      \ setcombatstyledodgelrtimermin
      \ setcombatstyledodgenotunderattackmult
      \ setcombatstyledodgeunderattackmult
      \ setcombatstyleencumberedspeedmodbase
      \ setcombatstyleencumberedspeedmodmult
      \ setcombatstylefleeingdisabled
      \ setcombatstylegroupstandoffdist
      \ setcombatstyleh2hbonustoattack
      \ setcombatstyleholdtimermax
      \ setcombatstyleholdtimermin
      \ setcombatstyleidletimermax
      \ setcombatstyleidletimermin
      \ setcombatstyleignorealliesinarea
      \ setcombatstylekobonustoattack
      \ setcombatstylekobonustopowerattack
      \ setcombatstylemeleealertok
      \ setcombatstylepowerattackchance
      \ setcombatstylepowerattackfatiguemodbase
      \ setcombatstylepowerattackfatiguemodmult
      \ setcombatstyleprefersranged
      \ setcombatstylerangedstandoffdist
      \ setcombatstylerangemaxmult
      \ setcombatstylerangeoptimalmult
      \ setcombatstylerejectsyields
      \ setcombatstylerushattackchance
      \ setcombatstylerushattackdistmult
      \ setcombatstylestaggerbonustoattack
      \ setcombatstylestaggerbonustopowerattack
      \ setcombatstyleswitchdistmelee
      \ setcombatstyleswitchdistranged
      \ setcombatstylewillyield
      \ setcontainerrespawns
      \ setcontrol
      \ setcreatureskill
      \ setcreaturesoundbase
      \ setcreaturetype
      \ setcurrentcharge
      \ setcurrenthealth
      \ setcurrentsoullevel
      \ setdebugmode
      \ setdescription
      \ setdetectionstate
      \ setdisableglobalcollision
      \ setdoorteleport
      \ setenchantment
      \ setenchantmentcharge
      \ setenchantmentcost
      \ setenchantmenttype
      \ setequipmentslot
      \ setequippedcurrentcharge
      \ setequippedcurrenthealth
      \ setequippedweaponpoison
      \ seteventhandler
      \ seteyes
      \ setfactionevil
      \ setfactionhasspecialcombat
      \ setfactionhidden
      \ setfactonreaction
      \ setfactionspecialcombat
      \ setfemale
      \ setfemalebipedpath
      \ setfemalegroundpath
      \ setfemaleiconpath
      \ setflycameraspeedmult
      \ setfogdayfar
      \ setfogdaynear
      \ setfognightfar
      \ setfognightnear
      \ setforcsneak
      \ setfunctionvalue
      \ setgamedifficulty
      \ setgoldvalue
      \ setgoldvalue_t
      \ setgoldvaluet
      \ sethair
      \ setharvested
      \ sethasbeenpickedup
      \ sethdrvalue
      \ sethidesamulet
      \ sethidesrings
      \ sethotkeyitem
      \ seticonpath
      \ setignoresresistance
      \ setingredient
      \ setingredientchance
      \ setinputtext
      \ setinvertfasttravel
      \ setisautomaticdoor
      \ setiscontrol
      \ setisfood
      \ setishiddendoor
      \ setisminimalusedoor
      \ setisobliviongate
      \ setisplayable
      \ setlevcreaturetemplate
      \ setlightduration
      \ setlightningfrequency
      \ setlightradius
      \ setlightrgb
      \ setlocalgravity
      \ setlocalgravityvector
      \ setloopsound
      \ setlowlevelprocessing
      \ setmaagiceffectuseactorvalue
      \ setmagiceffectareasound
      \ setmagiceffectareasoundc
      \ setmagiceffectbarterfactor
      \ setmagiceffectbarterfactorc
      \ setmagiceffectbasecost
      \ setmagiceffectbasecostc
      \ setmagiceffectboltsound
      \ setmagiceffectboltsoundc
      \ setmagiceffectcanrecover
      \ setmagiceffectcanrecoverc
      \ setmagiceffectcastingsound
      \ setmagiceffectcastingsoundc
      \ setmagiceffectcounters
      \ setmagiceffectcountersc
      \ setmagiceffectenchantfactor
      \ setmagiceffectenchantfactorc
      \ setmagiceffectenchantshader
      \ setmagiceffectenchantshaderc
      \ setmagiceffectforenchanting
      \ setmagiceffectforenchantingc
      \ setmagiceffectforspellmaking
      \ setmagiceffectforspellmakingc
      \ setmagiceffectfxpersists
      \ setmagiceffectfxpersistsc
      \ setmagiceffecthitshader
      \ setmagiceffecthitshaderc
      \ setmagiceffecthitsound
      \ setmagiceffecthitsoundc
      \ setmagiceffecticon
      \ setmagiceffecticonc
      \ setmagiceffectisdetrimental
      \ setmagiceffectisdetrimentalc
      \ setmagiceffectishostile
      \ setmagiceffectishostilec
      \ setmagiceffectlight
      \ setmagiceffectlightc
      \ setmagiceffectmagnitudepercent
      \ setmagiceffectmagnitudepercentc
      \ setmagiceffectmodel
      \ setmagiceffectmodelc
      \ setmagiceffectname
      \ setmagiceffectnamec
      \ setmagiceffectnoarea
      \ setmagiceffectnoareac
      \ setmagiceffectnoduration
      \ setmagiceffectnodurationc
      \ setmagiceffectnohiteffect
      \ setmagiceffectnohiteffectc
      \ setmagiceffectnoingredient
      \ setmagiceffectnoingredientc
      \ setmagiceffectnomagnitude
      \ setmagiceffectnomagnitudec
      \ setmagiceffectonselfallowed
      \ setmagiceffectonselfallowedc
      \ setmagiceffectontargetallowed
      \ setmagiceffectontargetallowedc
      \ setmagiceffectontouchallowed
      \ setmagiceffectontouchallowedc
      \ setmagiceffectotheractorvalue
      \ setmagiceffectotheractorvaluec
      \ setmagiceffectprojectilespeed
      \ setmagiceffectprojectilespeedc
      \ setmagiceffectresistvalue
      \ setmagiceffectresistvaluec
      \ setmagiceffectschool
      \ setmagiceffectschoolc
      \ setmagiceffectuseactorvaluec
      \ setmagiceffectusedobject
      \ setmagiceffectusedobjectc
      \ setmagiceffectusesactorvalue
      \ setmagiceffectusesactorvaluec
      \ setmagiceffectusesarmor
      \ setmagiceffectusesarmorc
      \ setmagiceffectusesattribute
      \ setmagiceffectusesattributec
      \ setmagiceffectusescreature
      \ setmagiceffectusescreaturec
      \ setmagiceffectusesskill
      \ setmagiceffectusesskillc
      \ setmagiceffectusesweapon
      \ setmagiceffectusesweaponc
      \ setmagicitemautocalc
      \ setmagicprojectilespell
      \ setmalebipedpath
      \ setmalegroundpath
      \ setmaleiconpath
      \ setmapmarkertype
      \ setmapmarkervisible
      \ setmeareasound
      \ setmeareasoundc
      \ setmebarterfactor
      \ setmebarterfactorc
      \ setmebasecost
      \ setmebasecostc
      \ setmeboltsound
      \ setmeboltsoundc
      \ setmecanrecover
      \ setmecanrecoverc
      \ setmecastingsound
      \ setmecastingsoundc
      \ setmeenchantfactor
      \ setmeenchantfactorc
      \ setmeenchantshader
      \ setmeenchantshaderc
      \ setmeforenchanting
      \ setmeforenchantingc
      \ setmeforspellmaking
      \ setmeforspellmakingc
      \ setmefxpersists
      \ setmefxpersistsc
      \ setmehitshader
      \ setmehitshaderc
      \ setmehitsound
      \ setmehitsoundc
      \ setmeicon
      \ setmeiconc
      \ setmeisdetrimental
      \ setmeisdetrimentalc
      \ setmeishostile
      \ setmeishostilec
      \ setmelight
      \ setmelightc
      \ setmemagnitudepercent
      \ setmemagnitudepercentc
      \ setmemodel
      \ setmemodelc
      \ setmename
      \ setmenamec
      \ setmenoarea
      \ setmenoareac
      \ setmenoduration
      \ setmenodurationc
      \ setmenohiteffect
      \ setmenohiteffectc
      \ setmenoingredient
      \ setmenoingredientc
      \ setmenomagnitude
      \ setmenomagnitudec
      \ setmenufloatvalue
      \ setmenustringvalue
      \ setmeonselfallowed
      \ setmeonselfallowedc
      \ setmeontargetallowed
      \ setmeontargetallowedc
      \ setmeontouchallowed
      \ setmeontouchallowedc
      \ setmeotheractorvalue
      \ setmeotheractorvaluec
      \ setmeprojectilespeed
      \ setmeprojectilespeedc
      \ setmerchantcontainer
      \ setmeresistvalue
      \ setmeresistvaluec
      \ setmeschool
      \ setmeschoolc
      \ setmessageicon
      \ setmessagesound
      \ setmeuseactorvalue
      \ setmeuseactorvaluec
      \ setmeusedobject
      \ setmeusedobjectc
      \ setmeusesarmor
      \ setmeusesarmorc
      \ setmeusesattribute
      \ setmeusesattributec
      \ setmeusescreature
      \ setmeusescreaturec
      \ setmeusesskill
      \ setmeusesskillc
      \ setmeusesweapon
      \ setmeusesweaponc
      \ setmodelpath
      \ setmodlocaldata
      \ setmousespeedx
      \ setmousespeedy
      \ setmpspell
      \ setname
      \ setnameex
      \ setnopersuasion
      \ setnthactiveeffectmagnitude
      \ setnthaemagnitude
      \ setntheffectitemactorvalue
      \ setntheffectitemactorvaluec
      \ setntheffectitemarea
      \ setntheffectitemduration
      \ setntheffectitemmagnitude
      \ setntheffectitemrange
      \ setntheffectitemscript
      \ setntheffectitemscripthostile
      \ setntheffectitemscriptname
      \ setntheffectitemscriptnameex
      \ setntheffectitemscriptschool
      \ setntheffectitemscriptvisualeffect
      \ setntheffectitemscriptvisualeffectc
      \ setntheiarea
      \ setntheiav
      \ setntheiavc
      \ setntheiduration
      \ setntheimagnitude
      \ setntheirange
      \ setntheiscript
      \ setntheishostile
      \ setntheisname
      \ setntheisschool
      \ setntheisvisualeffect
      \ setntheisvisualeffectc
      \ setnthfactionranknameex
      \ setnumericgamesetting
      \ setnumericinisetting
      \ setobjectcharge
      \ setobjecthealth
      \ setoffersapparatus
      \ setoffersarmor
      \ setoffersbooks
      \ setoffersclothing
      \ setoffersingredients
      \ setofferslights
      \ setoffersmagicitems
      \ setoffersmiscitems
      \ setofferspotions
      \ setoffersrecharging
      \ setoffersrepair
      \ setoffersservicesc
      \ setoffersspells
      \ setofferstraining
      \ setoffersweapons
      \ setolmpgrids
      \ setopenkey
      \ setopensound
      \ setopenstip
      \ setownership_t
      \ setowningrequiredrank
      \ setpackageallowfalls
      \ setpackageallowswimming
      \ setpackagealwaysrun
      \ setpackagealwayssneak
      \ setpackagearmorunequipped
      \ setpackagecontinueifpcnear
      \ setpackagedata
      \ setpackagedefensivecombat
      \ setpackagelocationdata
      \ setpackagelockdoorsatend
      \ setpackagelockdoorsatlocation
      \ setpackagelockdoorsatstart
      \ setpackagemustcomplete
      \ setpackagemustreachlocation
      \ setpackagenoidleanims
      \ setpackageoffersservices
      \ setpackageonceperday
      \ setpackagescheduledata
      \ setpackageskipfalloutbehavior
      \ setpackagetarget
      \ setpackagetargetdata
      \ setpackageunlockdoorsatend
      \ setpackageunlockdoorsatlocation
      \ setpackageunlockdoorsatstart
      \ setpackageusehorse
      \ setpackageweaponsunequipped
      \ setparentcellowningfactionrequiredrank
      \ setpathnodedisabled
      \ setpcamurderer
      \ setpcattributebonus
      \ setpcattributebonusc
      \ setpcexpy
      \ setpcleveloffset
      \ setpcmajorskillups
      \ setpctrainingsessionsused
      \ setplayerbseworld
      \ setplayerprojectile
      \ setplayerskeletonpath
      \ setplayerskilladvances
      \ setplayerskilladvancesc
      \ setplayerslastriddenhorse
      \ setpos_t
      \ setpowertimer
      \ setprojectilesource
      \ setprojectilespeed
      \ setquality
      \ setquestitem
      \ setracealias
      \ setraceplayable
      \ setracescale
      \ setracevoice
      \ setraceweight
      \ setrefcount
      \ setrefessential
      \ setreale
      \ setscaleex
      \ setscript
      \ setsigilstoneuses
      \ setskillgoverningattribute
      \ setskillgoverningattributec
      \ setskillspecialization
      \ setskillspecializationc
      \ setskilluseincrement
      \ setskilluseincrementc
      \ setsoulgemcapacity
      \ setsoullevel
      \ setsoundattenuation
      \ setspellareaeffectignoreslos
      \ setspelldisallowabsorbreflect
      \ setspellexplodeswithnotarget
      \ setspellhostile
      \ setspellimmunetosilence
      \ setspellmagickacost
      \ setspellmasterylevel
      \ setspellpcstart
      \ setspellscripteffectalwaysapplies
      \ setspelltype
      \ setstagedate
      \ setstagetext
      \ setstringgamesettingex
      \ setstringinisetting
      \ setsummonable
      \ setsundamage
      \ setsunglare
      \ settaken
      \ settextinputcontrolhandler
      \ settextinputdefaultcontrolsdisabled
      \ settextinputhandler
      \ settexturepath
      \ settimeleft
      \ settrainerlevel
      \ settrainerskill
      \ settransdelta
      \ settravelhorse
      \ setunsafecontainer
      \ setvelocity
      \ setverticalvelocity
      \ setweaponreach
      \ setweaponspeed
      \ setweapontype
      \ setweathercloudspeedlower
      \ setweathercloudspeedupper
      \ setweathercolor
      \ setweatherfogdayfar
      \ setweatherfogdaynear
      \ setweatherfognightfar
      \ setweatherfognightnear
      \ setweatherhdrvalue
      \ setweatherlightningfrequency
      \ setweathersundamage
      \ setweathersunglare
      \ setweathertransdelta
      \ setweatherwindspeed
      \ setweight
      \ setwindspeed
      \ showellmaking
      \ sin
      \ sinh
      \ skipansqrt
      \ squareroot
      \ startcc
      \ stringtoactorvalue
      \ tan
      \ tanh
      \ tapcontrol
      \ tapkey
      \ testexpr
      \ thiactorsai
      \ togglecreaturemodel
      \ togglefirstperson
      \ toggleskillperk
      \ togglespecialanim
      \ tolower
      \ tonumber
      \ tostring
      \ toupper
      \ trapuphitshader
      \ triggerplayerskilluse
      \ triggerplayerskillusec
      \ typeof
      \ uncompletequest
      \ unequipitemns
      \ unequipitemsilent
      \ unequipme
      \ unhammerkey
      \ unsetstagetext
      \ update3d
      \ updatecontainermenu
      \ updatespellpurchasemenu
      \ updatetextinput
      \ vecmag
      \ vecnorm
      \ vectorcross
      \ vectordot
      \ vectormagnitude
      \ vectornormalize
      \ zeromat
" }}}

" Array Functions {{{
syn keyword obseArrayFunction
      \ ar_Append
      \ ar_BadNumericIndex
      \ ar_BadStringIndex
      \ ar_Construct
      \ ar_Copy
      \ ar_CustomSort
      \ ar_DeepCopy
      \ ar_Dump
      \ ar_DumpID
      \ ar_Erase
      \ ar_Find
      \ ar_First
      \ ar_HasKey
      \ ar_Insert
      \ ar_InsertRange
      \ ar_Keys
      \ ar_Last
      \ ar_List
      \ ar_Map
      \ ar_Next
      \ ar_Null
      \ ar_Prev
      \ ar_Range
      \ ar_Resize
      \ ar_Size
      \ ar_Sort
      \ ar_SortAlpha
" }}}

" String Functions {{{
syn keyword obseStringFunction
      \ sv_ToLower
      \ sv_ToUpper
      \ sv_Compare
      \ sv_Construct
      \ sv_Count
      \ sv_Destruct
      \ sv_Erase
      \ sv_Find
      \ sv_Insert
      \ sv_Length
      \ sv_Percentify
      \ sv_Replace
      \ sv_Split
      \ sv_ToNumeric
" }}}

" Pluggy Functions {{{
syn keyword pluggyFunction
      \ ArrayCmp
      \ ArrayCount
      \ ArrayEsp
      \ ArrayProtect
      \ ArraySize
      \ AutoSclHudS
      \ AutoSclHudT
      \ CopyArray
      \ CopyString
      \ CreateArray
      \ CreateEspBook
      \ CreateString
      \ DelAllHudSs
      \ DelAllHudTs
      \ DelFile
      \ DelHudS
      \ DelHudT
      \ DelTxtFile
      \ DestroyAllArrays
      \ DestroyAllStrings
      \ DestroyArray
      \ DestroyString
      \ DupArray
      \ EspToString
      \ FileToString
      \ FindFirstFile
      \ FindFloatInArray
      \ FindInArray
      \ FindNextFile
      \ FindRefInArray
      \ FirstFreeInArray
      \ FirstInArray
      \ FixName
      \ FixNameEx
      \ FloatToString
      \ FmtString
      \ FromOBSEString
      \ FromTSFC
      \ GetEsp
      \ GetFileSize
      \ GetInArray
      \ GetRefEsp
      \ GetTypeInArray
      \ Halt
      \ HasFixedName
      \ HudSEsp
      \ HudSProtect
      \ HudS_Align
      \ HudS_L
      \ HudS_Opac
      \ HudS_SclX
      \ HudS_SclY
      \ HudS_Show
      \ HudS_Tex
      \ HudS_X
      \ HudS_Y
      \ HudTEsp
      \ HudTInfo
      \ HudTProtect
      \ HudT_Align
      \ HudT_Font
      \ HudT_L
      \ HudT_Opac
      \ HudT_SclX
      \ HudT_SclY
      \ HudT_Show
      \ HudT_Text
      \ HudT_X
      \ HudT_Y
      \ HudsInfo
      \ IniDelKey
      \ IniGetNthSection
      \ IniKeyExists
      \ IniReadFloat
      \ IniReadInt
      \ IniReadRef
      \ IniReadString
      \ IniSectionsCount
      \ IniWriteFloat
      \ IniWriteInt
      \ IniWriteRef
      \ IniWriteString
      \ IntToHex
      \ IntToString
      \ IsHUDEnabled
      \ IsPluggyDataReset
      \ KillMenu
      \ LC
      \ LongToRef
      \ ModRefEsp
      \ NewHudS
      \ NewHudT
      \ PackArray
      \ PauseBox
      \ PlgySpcl
      \ RefToLong
      \ RefToString
      \ RemInArray
      \ RenFile
      \ RenTxtFile
      \ ResetName
      \ RunBatString
      \ SanString
      \ ScreenInfo
      \ SetFloatInArray
      \ SetHudT
      \ SetInArray
      \ SetRefInArray
      \ SetString
      \ StrLC
      \ StringCat
      \ StringCmp
      \ StringEsp
      \ StringGetName
      \ StringGetNameEx
      \ StringIns
      \ StringLen
      \ StringMsg
      \ StringMsgBox
      \ StringPos
      \ StringProtect
      \ StringRep
      \ StringSetName
      \ StringSetNameEx
      \ StringToFloat
      \ StringToInt
      \ StringToRef
      \ StringToTxtFile
      \ ToOBSE
      \ ToOBSEString
      \ ToTSFC
      \ TxtFileExists
      \ UserFileExists
      \ csc
      \ rcsc
" }}}

" tfscFunction {{{
syn keyword tfscFunction
      \ StrAddNewLine
      \ StrAppend
      \ StrAppendCharCode
      \ StrCat
      \ StrClear
      \ StrClearLast
      \ StrCompare
      \ StrCopy
      \ StrDel
      \ StrDeleteAll
      \ StrExpr
      \ StrGetFemaleBipedPath
      \ StrGetFemaleGroundPath
      \ StrGetFemaleIconPath
      \ StrGetMaleBipedPath
      \ StrGetMaleIconPath
      \ StrGetModelPath
      \ StrGetName
      \ StrGetNthEffectItemScriptName
      \ StrGetNthFactionRankName
      \ StrGetRandomName
      \ StrIDReplace
      \ StrLength
      \ StrLoad
      \ StrMessageBox
      \ StrNew
      \ StrPrint
      \ StrReplace
      \ StrSave
      \ StrSet
      \ StrSetFemaleBipedPath
      \ StrSetFemaleGroundPath
      \ StrSetFemaleIconPath
      \ StrSetMaleBipedPath
      \ StrSetMaleIconPath
      \ StrSetModelPath
      \ StrSetName
      \ StrSetNthEffectItemScriptName
" }}}

" Blockhead Functions {{{
syn keyword blockheadFunction
      \ GetBodyAssetOverride
      \ GetFaceGenAge
      \ GetHeadAssetOverride
      \ RefreshAnimData
      \ RegisterEquipmentOverrideHandler
      \ ResetAgeTextureOverride
      \ ResetBodyAssetOverride
      \ ResetHeadAssetOverride
      \ SetAgeTextureOverride
      \ SetBodyAssetOverride
      \ SetFaceGenAge
      \ SetHeadAssetOverride
      \ ToggleAnimOverride
      \ UnregisterEquipmentOverrideHandler
" }}}

" switchNightEyeShaderFunction {{{
syn keyword switchNightEyeShaderFunction
      \ EnumNightEyeShader
      \ SetNightEyeShader
" }}}

" Oblivion Reloaded Functions {{{
syn keyword obseivionReloadedFunction
      \ cameralookat
      \ cameralookatposition
      \ camerareset
      \ camerarotate
      \ camerarotatetoposition
      \ cameratranslate
      \ cameratranslatetoposition
      \ getlocationname
      \ getsetting
      \ getversion
      \ getweathername
      \ isthirdperson
      \ setcustomconstant
      \ setextraeffectenabled
      \ setsetting
" }}}
" menuQue Functions {{{
syn keyword menuQueFunction
      \ GetAllSkills
      \ GetAVSkillMasteryLevelC
      \ GetAVSkillMasteryLevelF
      \ GetFontLoaded
      \ GetGenericButtonPressed
      \ GetLoadedFonts
      \ GetLocalMapSeen
      \ GetMenuEventType
      \ GetMenuFloatValue
      \ GetMenuStringValue
      \ GetMouseImage
      \ GetMousePos
      \ GetPlayerSkillAdvancesF
      \ GetPlayerSkillUseF
      \ GetRequiredSkillExpC
      \ GetRequiredSkillExpF
      \ GetSkillCode
      \ GetSkillForm
      \ GetSkillGoverningAttributeF
      \ GetSkillSpecializationC
      \ GetSkillSpecializationF
      \ GetSkillUseIncrementF
      \ GetTextEditBox
      \ GetTextEditString
      \ GetTrainingMenuCost
      \ GetTrainingMenuLevel
      \ GetTrainingMenuSkill
      \ GetWorldMapData
      \ GetWorldMapDoor
      \ IncrementPlayerSkillUseF
      \ InsertXML
      \ InsertXMLTemplate
      \ IsTextEditInUse
      \ Kyoma_Test
      \ ModPlayerSkillExpF
      \ mqCreateMenuFloatValue
      \ mqCreateMenuStringValue
      \ mqGetActiveQuest
      \ mqGetActiveQuestTargets
      \ mqGetCompletedQuests
      \ mqGetCurrentQuests
      \ mqGetEnchMenuBaseItem
      \ mqGetHighlightedClass
      \ mqGetMapMarkers
      \ mqGetMenuActiveChildIndex
      \ mqGetMenuActiveFloatValue
      \ mqGetMenuActiveStringValue
      \ mqGetMenuChildCount
      \ mqGetMenuChildFloatValue
      \ mqGetMenuChildHasTrait
      \ mqGetMenuChildName
      \ mqGetMenuChildStringValue
      \ mqGetMenuGlobalFloatValue
      \ mqGetMenuGlobalStringValue
      \ mqGetQuestCompleted
      \ mqGetSelectedClass
      \ mqSetActiveQuest
      \ mqSetMenuActiveFloatValue
      \ mqSetMenuActiveStringValue
      \ mqSetMenuChildFloatValue
      \ mqSetMenuChildStringValue
      \ mqSetMenuGlobalStringValue
      \ mqSetMenuGlobalFloatValue
      \ mqSetMessageBoxSource
      \ mqUncompleteQuest
      \ RemoveMenuEventHandler
      \ SetMenuEventHandler
      \ SetMouseImage
      \ SetPlayerSkillAdvancesF
      \ SetSkillGoverningAttributeF
      \ SetSkillSpecializationC
      \ SetSkillSpecializationF
      \ SetSkillUseIncrementF
      \ SetTextEditString
      \ SetTrainerSkillC
      \ SetWorldMapData
      \ ShowGenericMenu
      \ ShowLevelUpMenu
      \ ShowMagicPopupMenu
      \ ShowTextEditMenu
      \ ShowTrainingMenu
      \ tile_FadeFloat
      \ tile_GetFloat
      \ tile_GetInfo
      \ tile_GetName
      \ tile_GetString
      \ tile_GetVar
      \ tile_HasTrait
      \ tile_SetFloat
      \ tile_SetString
      \ TriggerPlayerSkillUseF
      \ UpdateLocalMap
" }}}

" eaxFunction {{{
syn keyword eaxFunction
      \ CreateEAXeffect
      \ DeleteEAXeffect
      \ DisableEAX
      \ EAXcopyEffect
      \ EAXeffectExists
      \ EAXeffectsAreEqual
      \ EAXgetActiveEffect
      \ EAXnumEffects
      \ EAXpushEffect
      \ EAXpopEffect
      \ EAXremoveAllInstances
      \ EAXremoveFirstInstance
      \ EAXstackIsEmpty
      \ EAXstackSize
      \ EnableEAX
      \ GetEAXAirAbsorptionHF
      \ GetEAXDecayHFRatio
      \ GetEAXDecayTime
      \ GetEAXEnvironment
      \ GetEAXEnvironmentSize
      \ GetEAXEnvironmentDiffusion
      \ GetEAXReflections
      \ GetEAXReflectionsDelay
      \ GetEAXReverb
      \ GetEAXReverbDelay
      \ GetEAXRoom
      \ GetEAXRoomHF
      \ GetEAXRoomRolloffFactor
      \ InitializeEAX
      \ IsEAXEnabled
      \ IsEAXInitialized
      \ SetEAXAirAbsorptionHF
      \ SetEAXallProperties
      \ SetEAXDecayTime
      \ SetEAXDecayHFRatio
      \ SetEAXEnvironment
      \ SetEAXEnvironmentSize
      \ SetEAXEnvironmentDiffusion
      \ SetEAXReflections
      \ SetEAXReflectionsDelay
      \ SetEAXReverb
      \ SetEAXReverbDelay
      \ SetEAXRoom
      \ SetEAXRoomHF
      \ SetEAXRoomRolloffFactor
" }}}

" networkPipeFunction {{{
syn keyword networkPipeFunction
      \ NetworkPipe_CreateClient
      \ NetworkPipe_GetData
      \ NetworkPipe_IsNewGame
      \ NetworkPipe_KillClient
      \ NetworkPipe_Receive
      \ NetworkPipe_SetData
      \ NetworkPipe_Send
      \ NetworkPipe_StartService
      \ NetworkPipe_StopService
" }}}

" nifseFunction {{{
syn keyword nifseFunction
      \ BSFurnitureMarkerGetPositionRefs
      \ BSFurnitureMarkerSetPositionRefs
      \ GetNifTypeIndex
      \ NiAVObjectAddProperty
      \ NiAVObjectClearCollisionObject
      \ NiAVObjectCopyCollisionObject
      \ NiAVObjectDeleteProperty
      \ NiAVObjectGetCollisionMode
      \ NiAVObjectGetCollisionObject
      \ NiAVObjectGetLocalRotation
      \ NiAVObjectGetLocalScale
      \ NiAVObjectGetLocalTransform
      \ NiAVObjectGetLocalTranslation
      \ NiAVObjectGetNumProperties
      \ NiAVObjectGetProperties
      \ NiAVObjectGetPropertyByType
      \ NiAVObjectSetCollisionMode
      \ NiAVObjectSetLocalRotation
      \ NiAVObjectSetLocalScale
      \ NiAVObjectSetLocalTransform
      \ NiAVObjectSetLocalTranslation
      \ NiAlphaPropertyGetBlendState
      \ NiAlphaPropertyGetDestinationBlendFunction
      \ NiAlphaPropertyGetSourceBlendFunction
      \ NiAlphaPropertyGetTestFunction
      \ NiAlphaPropertyGetTestState
      \ NiAlphaPropertyGetTestThreshold
      \ NiAlphaPropertyGetTriangleSortMode
      \ NiAlphaPropertySetBlendState
      \ NiAlphaPropertySetDestinationBlendFunction
      \ NiAlphaPropertySetSourceBlendFunction
      \ NiAlphaPropertySetTestFunction
      \ NiAlphaPropertySetTestState
      \ NiAlphaPropertySetTestThreshold
      \ NiAlphaPropertySetTriangleSortMode
      \ NiExtraDataGetArray
      \ NiExtraDataGetName
      \ NiExtraDataGetNumber
      \ NiExtraDataGetString
      \ NiExtraDataSetArray
      \ NiExtraDataSetName
      \ NiExtraDataSetNumber
      \ NiExtraDataSetString
      \ NiMaterialPropertyGetAmbientColor
      \ NiMaterialPropertyGetDiffuseColor
      \ NiMaterialPropertyGetEmissiveColor
      \ NiMaterialPropertyGetGlossiness
      \ NiMaterialPropertyGetSpecularColor
      \ NiMaterialPropertyGetTransparency
      \ NiMaterialPropertySetAmbientColor
      \ NiMaterialPropertySetDiffuseColor
      \ NiMaterialPropertySetEmissiveColor
      \ NiMaterialPropertySetGlossiness
      \ NiMaterialPropertySetSpecularColor
      \ NiMaterialPropertySetTransparency
      \ NiNodeAddChild
      \ NiNodeCopyChild
      \ NiNodeDeleteChild
      \ NiNodeGetChildByName
      \ NiNodeGetChildren
      \ NiNodeGetNumChildren
      \ NiObjectGetType
      \ NiObjectGetTypeName
      \ NiObjectNETAddExtraData
      \ NiObjectNETDeleteExtraData
      \ NiObjectNETGetExtraData
      \ NiObjectNETGetExtraDataByName
      \ NiObjectNETGetName
      \ NiObjectNETGetNumExtraData
      \ NiObjectNETSetName
      \ NiObjectTypeDerivesFrom
      \ NiSourceTextureGetFile
      \ NiSourceTextureIsExternal
      \ NiSourceTextureSetExternalTexture
      \ NiStencilPropertyGetFaceDrawMode
      \ NiStencilPropertyGetFailAction
      \ NiStencilPropertyGetPassAction
      \ NiStencilPropertyGetStencilFunction
      \ NiStencilPropertyGetStencilMask
      \ NiStencilPropertyGetStencilRef
      \ NiStencilPropertyGetStencilState
      \ NiStencilPropertyGetZFailAction
      \ NiStencilPropertySetFaceDrawMode
      \ NiStencilPropertySetFailAction
      \ NiStencilPropertySetPassAction
      \ NiStencilPropertySetStencilFunction
      \ NiStencilPropertySetStencilMask
      \ NiStencilPropertySetStencilRef
      \ NiStencilPropertySetStencilState
      \ NiStencilPropertySetZFailAction
      \ NiTexturingPropertyAddTextureSource
      \ NiTexturingPropertyDeleteTextureSource
      \ NiTexturingPropertyGetTextureCenterOffset
      \ NiTexturingPropertyGetTextureClampMode
      \ NiTexturingPropertyGetTextureCount
      \ NiTexturingPropertyGetTextureFilterMode
      \ NiTexturingPropertyGetTextureFlags
      \ NiTexturingPropertyGetTextureRotation
      \ NiTexturingPropertyGetTextureSource
      \ NiTexturingPropertyGetTextureTiling
      \ NiTexturingPropertyGetTextureTranslation
      \ NiTexturingPropertyGetTextureUVSet
      \ NiTexturingPropertyHasTexture
      \ NiTexturingPropertySetTextureCenterOffset
      \ NiTexturingPropertySetTextureClampMode
      \ NiTexturingPropertySetTextureCount
      \ NiTexturingPropertySetTextureFilterMode
      \ NiTexturingPropertySetTextureFlags
      \ NiTexturingPropertySetTextureHasTransform
      \ NiTexturingPropertySetTextureRotation
      \ NiTexturingPropertySetTextureTiling
      \ NiTexturingPropertySetTextureTranslation
      \ NiTexturingPropertySetTextureUVSet
      \ NiTexturingPropertyTextureHasTransform
      \ NiVertexColorPropertyGetLightingMode
      \ NiVertexColorPropertyGetVertexMode
      \ NiVertexColorPropertySetLightingMode
      \ NiVertexColorPropertySetVertexMode
      \ NifClose
      \ NifGetAltGrip
      \ NifGetBackShield
      \ NifGetNumBlocks
      \ NifGetOffHand
      \ NifGetOriginalPath
      \ NifGetPath
      \ NifOpen
      \ NifWriteToDisk
" }}}

" reidFunction {{{
syn keyword reidFunction
      \ GetRuntimeEditorID
" }}}

" runtimeDebuggerFunction {{{
syn keyword runtimeDebuggerFunction
      \ DebugBreak
      \ ToggleDebugBreaking
" }}}

" addActorValuesFunction {{{
syn keyword addActorValuesFunction
      \ DumpActorValueC
      \ DumpActorValueF
      \ GetActorValueBaseCalcC
      \ GetActorValueBaseCalcF
      \ GetActorValueCurrentC
      \ GetActorValueCurrentF
      \ GetActorValueMaxC
      \ GetActorValueMaxF
      \ GetActorValueModC
      \ GetActorValueModF
      \ ModActorValueModC
      \ ModActorValueModF
      \ SetActorValueModC
      \ SetActorValueModF
      \ DumpAVC
      \ DumpAVF
      \ GetAVModC
      \ GetAVModF
      \ ModAVModC
      \ ModAVModF
      \ SetAVModC
      \ SetAVModF
      \ GetAVBaseCalcC
      \ GetAVBaseCalcF
      \ GetAVMaxC
      \ GetAVMaxF
      \ GetAVCurrentC
      \ GetAVCurrent 
" }}}

" memoryDumperFunction {{{
syn keyword memoryDumperFunction
      \ SetDumpAddr
      \ SetDumpType
      \ SetFadeAmount
      \ SetObjectAddr
      \ ShowMemoryDump
" }}}

" algoholFunction {{{
syn keyword algoholFunction
      \ QFromAxisAngle
      \ QFromEuler
      \ QInterpolate
      \ QMultQuat
      \ QMultVector3
      \ QNormalize
      \ QToEuler
      \ V3Crossproduct
      \ V3Length
      \ V3Normalize
" }}}

" soundCommandsFunction {{{
syn keyword soundCommandsFunction
      \ FadeMusic
      \ GetEffectsVolume
      \ GetFootVolume
      \ GetMasterVolume
      \ GetMusicVolume
      \ GetVoiceVolume
      \ PlayMusicFile
      \ SetEffectsVolume
      \ SetFootVolume
      \ SetMasterVolume
      \ SetMusicVolume
      \ SetVoiceVolume
" }}}

" emcFunction {{{
syn keyword emcFunction
      \ emcAddPathToPlaylist
      \ emcCreatePlaylist
      \ emcGetAllPlaylists
      \ emcGetAfterBattleDelay
      \ emcGetBattleDelay
      \ emcGetEffectsVolume
      \ emcGetFadeTime
      \ emcGetFootVolume
      \ emcGetMasterVolume
      \ emcGetMaxRestoreTime
      \ emcGetMusicSpeed
      \ emcGetMusicType
      \ emcGetMusicVolume
      \ emcGetPauseTime
      \ emcGetPlaylist
      \ emcGetPlaylistTracks
      \ emcGetTrackName
      \ emcGetTrackDuration
      \ emcGetTrackPosition
      \ emcGetVoiceVolume
      \ emcIsBattleOverridden
      \ emcIsMusicOnHold
      \ emcIsMusicSwitching
      \ emcIsPlaylistActive
      \ emcMusicNextTrack
      \ emcMusicPause
      \ emcMusicRestart
      \ emcMusicResume
      \ emcMusicStop
      \ emcPlaylistExists
      \ emcPlayTrack
      \ emcRestorePlaylist
      \ emcSetAfterBattleDelay
      \ emcSetBattleDelay
      \ emcSetBattleOverride
      \ emcSetEffectsVolume
      \ emcSetFadeTime
      \ emcSetFootVolume
      \ emcSetMasterVolume
      \ emcSetMaxRestoreTime
      \ emcSetMusicHold
      \ emcSetMusicSpeed
      \ emcSetMusicVolume
      \ emcSetPauseTime
      \ emcSetPlaylist
      \ emcSetTrackPosition
      \ emcSetMusicType
      \ emcSetVoiceVolume
" }}}

" vipcxjFunction {{{
syn keyword vipcxjFunction
      \ vcAddMark
      \ vcGetFilePath
      \ vcGetHairColorRGB
      \ vcGetValueNumeric
      \ vcGetValueString
      \ vcIsMarked
      \ vcPrintIni
      \ vcSetActorState
      \ vcSetHairColor
      \ vcSetHairColorRGB
      \ vcSetHairColorRGB3P
" }}}

" cameraCommandsFunction {{{
syn keyword cameraCommandsFunction
      \ CameraGetRef
      \ CameraLookAt
      \ CameraLookAtPosition
      \ CameraMove
      \ CameraMoveToPosition
      \ CameraReset
      \ CameraRotate
      \ CameraRotateToPosition
      \ CameraSetRef
      \ CameraStopLook
" }}}

" obmeFunction {{{
syn keyword obmeFunction
      \ ClearNthEIBaseCost
      \ ClearNthEIEffectName
      \ ClearNthEIHandlerParam
      \ ClearNthEIHostility
      \ ClearNthEIIconPath
      \ ClearNthEIResistAV
      \ ClearNthEISchool
      \ ClearNthEIVFXCode
      \ CreateMgef
      \ GetMagicEffectHandlerC
      \ GetMagicEffectHandlerParamC
      \ GetMagicEffectHostilityC
      \ GetNthEIBaseCost
      \ GetNthEIEffectName
      \ GetNthEIHandlerParam
      \ GetNthEIHostility
      \ GetNthEIIconPath
      \ GetNthEIResistAV
      \ GetNthEISchool
      \ GetNthEIVFXCode
      \ ResolveMgefCode
      \ SetMagicEffectHandlerC
      \ SetMagicEffectHandlerIntParamC
      \ SetMagicEffectHandlerRefParamC
      \ SetMagicEffectHostilityC
      \ SetNthEIBaseCost
      \ SetNthEIEffectName
      \ SetNthEIHandlerIntParam
      \ SetNthEIHandlerRefParam
      \ SetNthEIHostility
      \ SetNthEIIconPath
      \ SetNthEIResistAV
      \ SetNthEISchool
      \ SetNthEIVFXCode
" }}}

" conscribeFunction {{{
syn keyword conscribeFunction
      \ DeleteLinesFromLog
      \ GetLogLineCount
      \ GetRegisteredLogNames
      \ ReadFromLog
      \ RegisterLog
      \ Scribe
      \ UnregisterLog
" }}}

" systemDialogFunction {{{
syn keyword systemDialogFunction
      \ Sysdlg_Browser
      \ Sysdlg_ReadBrowser
      \ Sysdlg_TextInput
" }}}

" csiFunction {{{
syn keyword csiFunction
      \ ClearSpellIcon
      \ HasAssignedIcon
      \ OverwriteSpellIcon
      \ SetSpellIcon
" }}}

" haelFunction {{{
syn keyword haelFunction
      \ GetHUDActiveEffectLimit
      \ SetHUDActiveEffectLimit
" }}}

" lcdFunction {{{
syn keyword lcdFunction
      \ lcd_addinttobuffer
      \ lcd_addtexttobuffer
      \ lcd_clearrect
      \ lcd_cleartextbuffer
      \ lcd_close
      \ lcd_drawcircle
      \ lcd_drawgrid
      \ lcd_drawint
      \ lcd_drawline
      \ lcd_drawprogressbarh
      \ lcd_drawprogressbarv
      \ lcd_drawprogresscircle
      \ lcd_drawrect
      \ lcd_drawtext
      \ lcd_drawtextbuffer
      \ lcd_drawtexture
      \ lcd_flush
      \ lcd_getbuttonstate
      \ lcd_getheight
      \ lcd_getwidth
      \ lcd_ismulti
      \ lcd_isopen
      \ lcd_open
      \ lcd_refresh
      \ lcd_savebuttonsnapshot
      \ lcd_scale
      \ lcd_setfont
" }}}

" Deprecated: {{{
syn keyword obDeprecated
      \ SetAltControl
      \ GetAltControl
      \ RefreshControlMap
" }}}
" }}}

if !exists("did_obl_inits")

  let did_obl_inits = 1
  hi def link obseStatement Statement
  hi def link obseStatementTwo Statement
  hi def link obseDescBlock String
  hi def link obseComment Comment
  hi def link obseString String
  hi def link obseStringFormatting Keyword
  hi def link obseFloat Float
  hi def link obseInt Number
  hi def link obseToDo Todo
  hi def link obseTypes Type
  hi def link obseCondition Conditional
  hi def link obseOperator Operator
  hi def link obseOtherKey Special
  hi def link obseScriptName Special
  hi def link obseBlock Conditional
  hi def link obseBlockType Structure
  hi def link obseScriptNameRegion Underlined
  hi def link obseNames Identifier
  hi def link obseVariable Identifier
  hi def link obseReference Special
  hi def link obseRepeat Repeat

  hi def link csFunction Function
  hi def link obseFunction Function
  hi def link obseArrayFunction Function
  hi def link pluggyFunction Function
  hi def link obseStringFunction Function
  hi def link obseArrayFunction Function
  hi def link tsfcFunction Function
  hi def link blockheadFunction Function
  hi def link switchNightEyeShaderFunction Function
  hi def link obseivionReloadedFunction Function
  hi def link menuQueFunction Function
  hi def link eaxFunction Function
  hi def link networkPipeFunction Function
  hi def link nifseFunction Function
  hi def link reidFunction Function
  hi def link runtimeDebuggerFunction Function
  hi def link addActorValuesFunction Function
  hi def link memoryDumperFunction Function
  hi def link algoholFunction Function
  hi def link soundCommandsFunction Function
  hi def link emcFunction Function
  hi def link vipcxjFunction Function
  hi def link cameraCommands Function
  hi def link obmeFunction Function
  hi def link conscribeFunction Function
  hi def link systemDialogFunction Function
  hi def link csiFunction Function
  hi def link haelFunction Function
  hi def link lcdFunction Function
  hi def link skillAttribute String
  hi def link obDeprecated WarningMsg

endif

let b:current_syntax = 'obse'

let &cpo = s:cpo_save
unlet s:cpo_save
