/*
 * Decompiled with CFR 0.152.
 */
package liqp.nodes;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import liqp.LValue;
import liqp.TemplateContext;
import liqp.nodes.LNode;

public class BlockNode
implements LNode {
    private List<LNode> children = new ArrayList<LNode>();
    private final boolean isRootBlock;

    public BlockNode() {
        this(false);
    }

    public BlockNode(boolean isRootBlock) {
        this.isRootBlock = isRootBlock;
    }

    public void add(LNode node) {
        this.children.add(node);
    }

    public List<LNode> getChildren() {
        return new ArrayList<LNode>(this.children);
    }

    @Override
    public Object render(TemplateContext context) {
        StringBuilder builder = new StringBuilder();
        for (LNode node : this.children) {
            Object value = node.render(context);
            if (value == null) continue;
            if (value == LValue.BREAK || value == LValue.CONTINUE) {
                return value;
            }
            if (value instanceof List) {
                List list = (List)value;
                for (Object obj : list) {
                    builder.append(this.asString(obj, context));
                }
            } else if (value.getClass().isArray()) {
                Object[] array;
                for (Object obj : array = (Object[])value) {
                    builder.append(this.asString(obj, context));
                }
            } else {
                builder.append(this.asString(value, context));
            }
            if (builder.length() <= context.protectionSettings.maxSizeRenderedString) continue;
            throw new RuntimeException("rendered string exceeds " + context.protectionSettings.maxSizeRenderedString);
        }
        return builder.toString();
    }

    private String asString(Object value, TemplateContext context) {
        if (LValue.isTemporal(value)) {
            ZonedDateTime time = LValue.asTemporal(value, context);
            return LValue.rubyDateTimeFormat.format(time);
        }
        return String.valueOf(value);
    }
}

