/*
 * Decompiled with CFR 0.152.
 */
package xsbti.compile;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import xsbti.compile.AuxiliaryClassFiles;
import xsbti.compile.ClassFileManagerType;
import xsbti.compile.DefaultExternalHooks;
import xsbti.compile.ExternalHooks;

public final class IncOptions
implements Serializable {
    private int transitiveStep;
    private double recompileAllFraction;
    private boolean relationsDebug;
    private boolean apiDebug;
    private int apiDiffContextSize;
    private Optional<File> apiDumpDirectory;
    private Optional<ClassFileManagerType> classfileManagerType;
    private AuxiliaryClassFiles[] auxiliaryClassFiles;
    private boolean useCustomizedFileManager;
    private Optional<Boolean> recompileOnMacroDef;
    private boolean useOptimizedSealed;
    private boolean storeApis;
    private boolean enabled;
    private Map<String, String> extra;
    private boolean logRecompileOnMacro;
    private ExternalHooks externalHooks;
    private String[] ignoredScalacOptions;
    private boolean strictMode;
    private boolean allowMachinePath;
    private boolean pipelining;

    public static int defaultTransitiveStep() {
        return 3;
    }

    public static double defaultRecompileAllFraction() {
        return 0.5;
    }

    public static boolean defaultRelationsDebug() {
        return false;
    }

    public static boolean defaultApiDebug() {
        return false;
    }

    public static int defaultApiDiffContextSize() {
        return 5;
    }

    public static Optional<File> defaultApiDumpDirectory() {
        return Optional.empty();
    }

    public static Optional<ClassFileManagerType> defaultClassFileManagerType() {
        return Optional.empty();
    }

    public static AuxiliaryClassFiles[] defaultAuxiliaryClassFiles() {
        return new AuxiliaryClassFiles[0];
    }

    public static Optional<Boolean> defaultRecompileOnMacroDef() {
        return Optional.empty();
    }

    public static boolean defaultUseOptimizedSealed() {
        return false;
    }

    public static boolean defaultRecompileOnMacroDefImpl() {
        return true;
    }

    public static boolean getRecompileOnMacroDef(IncOptions incOptions) {
        if (incOptions.recompileOnMacroDef().isPresent()) {
            return incOptions.recompileOnMacroDef().get();
        }
        return IncOptions.defaultRecompileOnMacroDefImpl();
    }

    public static boolean defaultUseCustomizedFileManager() {
        return false;
    }

    public static boolean defaultStoreApis() {
        return true;
    }

    public static boolean defaultEnabled() {
        return true;
    }

    public static Map<String, String> defaultExtra() {
        return new HashMap<String, String>();
    }

    public static ExternalHooks defaultExternal() {
        return new DefaultExternalHooks(Optional.empty(), Optional.empty());
    }

    public static String[] defaultIgnoredScalacOptions() {
        return new String[0];
    }

    public static boolean defaultLogRecompileOnMacro() {
        return true;
    }

    public static boolean defaultStrictMode() {
        return false;
    }

    public static boolean defaultAllowMachinePath() {
        return true;
    }

    public static boolean defaultPipelining() {
        return false;
    }

    public static IncOptions create() {
        return new IncOptions();
    }

    public static IncOptions of() {
        return new IncOptions();
    }

    public static IncOptions create(int n, double d, boolean bl, boolean bl2, int n2, Optional<File> optional, Optional<ClassFileManagerType> optional2, boolean bl3, Optional<Boolean> optional3, boolean bl4, boolean bl5, boolean bl6, Map<String, String> map, boolean bl7, ExternalHooks externalHooks) {
        return new IncOptions(n, d, bl, bl2, n2, optional, optional2, bl3, optional3, bl4, bl5, bl6, map, bl7, externalHooks);
    }

    public static IncOptions of(int n, double d, boolean bl, boolean bl2, int n2, Optional<File> optional, Optional<ClassFileManagerType> optional2, boolean bl3, Optional<Boolean> optional3, boolean bl4, boolean bl5, boolean bl6, Map<String, String> map, boolean bl7, ExternalHooks externalHooks) {
        return new IncOptions(n, d, bl, bl2, n2, optional, optional2, bl3, optional3, bl4, bl5, bl6, map, bl7, externalHooks);
    }

    public static IncOptions create(int n, double d, boolean bl, boolean bl2, int n2, File file, ClassFileManagerType classFileManagerType, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, Map<String, String> map, boolean bl8, ExternalHooks externalHooks) {
        return new IncOptions(n, d, bl, bl2, n2, file, classFileManagerType, bl3, bl4, bl5, bl6, bl7, map, bl8, externalHooks);
    }

    public static IncOptions of(int n, double d, boolean bl, boolean bl2, int n2, File file, ClassFileManagerType classFileManagerType, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, Map<String, String> map, boolean bl8, ExternalHooks externalHooks) {
        return new IncOptions(n, d, bl, bl2, n2, file, classFileManagerType, bl3, bl4, bl5, bl6, bl7, map, bl8, externalHooks);
    }

    public static IncOptions create(int n, double d, boolean bl, boolean bl2, int n2, Optional<File> optional, Optional<ClassFileManagerType> optional2, boolean bl3, Optional<Boolean> optional3, boolean bl4, boolean bl5, boolean bl6, Map<String, String> map, boolean bl7, ExternalHooks externalHooks, String[] stringArray) {
        return new IncOptions(n, d, bl, bl2, n2, optional, optional2, bl3, optional3, bl4, bl5, bl6, map, bl7, externalHooks, stringArray);
    }

    public static IncOptions of(int n, double d, boolean bl, boolean bl2, int n2, Optional<File> optional, Optional<ClassFileManagerType> optional2, boolean bl3, Optional<Boolean> optional3, boolean bl4, boolean bl5, boolean bl6, Map<String, String> map, boolean bl7, ExternalHooks externalHooks, String[] stringArray) {
        return new IncOptions(n, d, bl, bl2, n2, optional, optional2, bl3, optional3, bl4, bl5, bl6, map, bl7, externalHooks, stringArray);
    }

    public static IncOptions create(int n, double d, boolean bl, boolean bl2, int n2, File file, ClassFileManagerType classFileManagerType, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, Map<String, String> map, boolean bl8, ExternalHooks externalHooks, String[] stringArray) {
        return new IncOptions(n, d, bl, bl2, n2, file, classFileManagerType, bl3, bl4, bl5, bl6, bl7, map, bl8, externalHooks, stringArray);
    }

    public static IncOptions of(int n, double d, boolean bl, boolean bl2, int n2, File file, ClassFileManagerType classFileManagerType, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, Map<String, String> map, boolean bl8, ExternalHooks externalHooks, String[] stringArray) {
        return new IncOptions(n, d, bl, bl2, n2, file, classFileManagerType, bl3, bl4, bl5, bl6, bl7, map, bl8, externalHooks, stringArray);
    }

    public static IncOptions create(int n, double d, boolean bl, boolean bl2, int n2, Optional<File> optional, Optional<ClassFileManagerType> optional2, boolean bl3, Optional<Boolean> optional3, boolean bl4, boolean bl5, boolean bl6, Map<String, String> map, boolean bl7, ExternalHooks externalHooks, String[] stringArray, boolean bl8) {
        return new IncOptions(n, d, bl, bl2, n2, optional, optional2, bl3, optional3, bl4, bl5, bl6, map, bl7, externalHooks, stringArray, bl8);
    }

    public static IncOptions of(int n, double d, boolean bl, boolean bl2, int n2, Optional<File> optional, Optional<ClassFileManagerType> optional2, boolean bl3, Optional<Boolean> optional3, boolean bl4, boolean bl5, boolean bl6, Map<String, String> map, boolean bl7, ExternalHooks externalHooks, String[] stringArray, boolean bl8) {
        return new IncOptions(n, d, bl, bl2, n2, optional, optional2, bl3, optional3, bl4, bl5, bl6, map, bl7, externalHooks, stringArray, bl8);
    }

    public static IncOptions create(int n, double d, boolean bl, boolean bl2, int n2, File file, ClassFileManagerType classFileManagerType, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, Map<String, String> map, boolean bl8, ExternalHooks externalHooks, String[] stringArray, boolean bl9) {
        return new IncOptions(n, d, bl, bl2, n2, file, classFileManagerType, bl3, bl4, bl5, bl6, bl7, map, bl8, externalHooks, stringArray, bl9);
    }

    public static IncOptions of(int n, double d, boolean bl, boolean bl2, int n2, File file, ClassFileManagerType classFileManagerType, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, Map<String, String> map, boolean bl8, ExternalHooks externalHooks, String[] stringArray, boolean bl9) {
        return new IncOptions(n, d, bl, bl2, n2, file, classFileManagerType, bl3, bl4, bl5, bl6, bl7, map, bl8, externalHooks, stringArray, bl9);
    }

    public static IncOptions create(int n, double d, boolean bl, boolean bl2, int n2, Optional<File> optional, Optional<ClassFileManagerType> optional2, boolean bl3, Optional<Boolean> optional3, boolean bl4, boolean bl5, boolean bl6, Map<String, String> map, boolean bl7, ExternalHooks externalHooks, String[] stringArray, boolean bl8, boolean bl9, boolean bl10) {
        return new IncOptions(n, d, bl, bl2, n2, optional, optional2, bl3, optional3, bl4, bl5, bl6, map, bl7, externalHooks, stringArray, bl8, bl9, bl10);
    }

    public static IncOptions of(int n, double d, boolean bl, boolean bl2, int n2, Optional<File> optional, Optional<ClassFileManagerType> optional2, boolean bl3, Optional<Boolean> optional3, boolean bl4, boolean bl5, boolean bl6, Map<String, String> map, boolean bl7, ExternalHooks externalHooks, String[] stringArray, boolean bl8, boolean bl9, boolean bl10) {
        return new IncOptions(n, d, bl, bl2, n2, optional, optional2, bl3, optional3, bl4, bl5, bl6, map, bl7, externalHooks, stringArray, bl8, bl9, bl10);
    }

    public static IncOptions create(int n, double d, boolean bl, boolean bl2, int n2, File file, ClassFileManagerType classFileManagerType, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, Map<String, String> map, boolean bl8, ExternalHooks externalHooks, String[] stringArray, boolean bl9, boolean bl10, boolean bl11) {
        return new IncOptions(n, d, bl, bl2, n2, file, classFileManagerType, bl3, bl4, bl5, bl6, bl7, map, bl8, externalHooks, stringArray, bl9, bl10, bl11);
    }

    public static IncOptions of(int n, double d, boolean bl, boolean bl2, int n2, File file, ClassFileManagerType classFileManagerType, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, Map<String, String> map, boolean bl8, ExternalHooks externalHooks, String[] stringArray, boolean bl9, boolean bl10, boolean bl11) {
        return new IncOptions(n, d, bl, bl2, n2, file, classFileManagerType, bl3, bl4, bl5, bl6, bl7, map, bl8, externalHooks, stringArray, bl9, bl10, bl11);
    }

    public static IncOptions create(int n, double d, boolean bl, boolean bl2, int n2, Optional<File> optional, Optional<ClassFileManagerType> optional2, AuxiliaryClassFiles[] auxiliaryClassFilesArray, boolean bl3, Optional<Boolean> optional3, boolean bl4, boolean bl5, boolean bl6, Map<String, String> map, boolean bl7, ExternalHooks externalHooks, String[] stringArray, boolean bl8, boolean bl9, boolean bl10) {
        return new IncOptions(n, d, bl, bl2, n2, optional, optional2, auxiliaryClassFilesArray, bl3, optional3, bl4, bl5, bl6, map, bl7, externalHooks, stringArray, bl8, bl9, bl10);
    }

    public static IncOptions of(int n, double d, boolean bl, boolean bl2, int n2, Optional<File> optional, Optional<ClassFileManagerType> optional2, AuxiliaryClassFiles[] auxiliaryClassFilesArray, boolean bl3, Optional<Boolean> optional3, boolean bl4, boolean bl5, boolean bl6, Map<String, String> map, boolean bl7, ExternalHooks externalHooks, String[] stringArray, boolean bl8, boolean bl9, boolean bl10) {
        return new IncOptions(n, d, bl, bl2, n2, optional, optional2, auxiliaryClassFilesArray, bl3, optional3, bl4, bl5, bl6, map, bl7, externalHooks, stringArray, bl8, bl9, bl10);
    }

    public static IncOptions create(int n, double d, boolean bl, boolean bl2, int n2, File file, ClassFileManagerType classFileManagerType, AuxiliaryClassFiles[] auxiliaryClassFilesArray, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, Map<String, String> map, boolean bl8, ExternalHooks externalHooks, String[] stringArray, boolean bl9, boolean bl10, boolean bl11) {
        return new IncOptions(n, d, bl, bl2, n2, file, classFileManagerType, auxiliaryClassFilesArray, bl3, bl4, bl5, bl6, bl7, map, bl8, externalHooks, stringArray, bl9, bl10, bl11);
    }

    public static IncOptions of(int n, double d, boolean bl, boolean bl2, int n2, File file, ClassFileManagerType classFileManagerType, AuxiliaryClassFiles[] auxiliaryClassFilesArray, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, Map<String, String> map, boolean bl8, ExternalHooks externalHooks, String[] stringArray, boolean bl9, boolean bl10, boolean bl11) {
        return new IncOptions(n, d, bl, bl2, n2, file, classFileManagerType, auxiliaryClassFilesArray, bl3, bl4, bl5, bl6, bl7, map, bl8, externalHooks, stringArray, bl9, bl10, bl11);
    }

    protected IncOptions() {
        this.transitiveStep = IncOptions.defaultTransitiveStep();
        this.recompileAllFraction = IncOptions.defaultRecompileAllFraction();
        this.relationsDebug = IncOptions.defaultRelationsDebug();
        this.apiDebug = IncOptions.defaultApiDebug();
        this.apiDiffContextSize = IncOptions.defaultApiDiffContextSize();
        this.apiDumpDirectory = IncOptions.defaultApiDumpDirectory();
        this.classfileManagerType = IncOptions.defaultClassFileManagerType();
        this.auxiliaryClassFiles = IncOptions.defaultAuxiliaryClassFiles();
        this.useCustomizedFileManager = IncOptions.defaultUseCustomizedFileManager();
        this.recompileOnMacroDef = IncOptions.defaultRecompileOnMacroDef();
        this.useOptimizedSealed = IncOptions.defaultUseOptimizedSealed();
        this.storeApis = IncOptions.defaultStoreApis();
        this.enabled = IncOptions.defaultEnabled();
        this.extra = IncOptions.defaultExtra();
        this.logRecompileOnMacro = IncOptions.defaultLogRecompileOnMacro();
        this.externalHooks = IncOptions.defaultExternal();
        this.ignoredScalacOptions = IncOptions.defaultIgnoredScalacOptions();
        this.strictMode = IncOptions.defaultStrictMode();
        this.allowMachinePath = IncOptions.defaultAllowMachinePath();
        this.pipelining = IncOptions.defaultPipelining();
    }

    protected IncOptions(int n, double d, boolean bl, boolean bl2, int n2, Optional<File> optional, Optional<ClassFileManagerType> optional2, boolean bl3, Optional<Boolean> optional3, boolean bl4, boolean bl5, boolean bl6, Map<String, String> map, boolean bl7, ExternalHooks externalHooks) {
        this.transitiveStep = n;
        this.recompileAllFraction = d;
        this.relationsDebug = bl;
        this.apiDebug = bl2;
        this.apiDiffContextSize = n2;
        this.apiDumpDirectory = optional;
        this.classfileManagerType = optional2;
        this.auxiliaryClassFiles = IncOptions.defaultAuxiliaryClassFiles();
        this.useCustomizedFileManager = bl3;
        this.recompileOnMacroDef = optional3;
        this.useOptimizedSealed = bl4;
        this.storeApis = bl5;
        this.enabled = bl6;
        this.extra = map;
        this.logRecompileOnMacro = bl7;
        this.externalHooks = externalHooks;
        this.ignoredScalacOptions = IncOptions.defaultIgnoredScalacOptions();
        this.strictMode = IncOptions.defaultStrictMode();
        this.allowMachinePath = IncOptions.defaultAllowMachinePath();
        this.pipelining = IncOptions.defaultPipelining();
    }

    protected IncOptions(int n, double d, boolean bl, boolean bl2, int n2, File file, ClassFileManagerType classFileManagerType, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, Map<String, String> map, boolean bl8, ExternalHooks externalHooks) {
        this.transitiveStep = n;
        this.recompileAllFraction = d;
        this.relationsDebug = bl;
        this.apiDebug = bl2;
        this.apiDiffContextSize = n2;
        this.apiDumpDirectory = Optional.ofNullable(file);
        this.classfileManagerType = Optional.ofNullable(classFileManagerType);
        this.auxiliaryClassFiles = IncOptions.defaultAuxiliaryClassFiles();
        this.useCustomizedFileManager = bl3;
        this.recompileOnMacroDef = Optional.ofNullable(bl4);
        this.useOptimizedSealed = bl5;
        this.storeApis = bl6;
        this.enabled = bl7;
        this.extra = map;
        this.logRecompileOnMacro = bl8;
        this.externalHooks = externalHooks;
        this.ignoredScalacOptions = IncOptions.defaultIgnoredScalacOptions();
        this.strictMode = IncOptions.defaultStrictMode();
        this.allowMachinePath = IncOptions.defaultAllowMachinePath();
        this.pipelining = IncOptions.defaultPipelining();
    }

    protected IncOptions(int n, double d, boolean bl, boolean bl2, int n2, Optional<File> optional, Optional<ClassFileManagerType> optional2, boolean bl3, Optional<Boolean> optional3, boolean bl4, boolean bl5, boolean bl6, Map<String, String> map, boolean bl7, ExternalHooks externalHooks, String[] stringArray) {
        this.transitiveStep = n;
        this.recompileAllFraction = d;
        this.relationsDebug = bl;
        this.apiDebug = bl2;
        this.apiDiffContextSize = n2;
        this.apiDumpDirectory = optional;
        this.classfileManagerType = optional2;
        this.auxiliaryClassFiles = IncOptions.defaultAuxiliaryClassFiles();
        this.useCustomizedFileManager = bl3;
        this.recompileOnMacroDef = optional3;
        this.useOptimizedSealed = bl4;
        this.storeApis = bl5;
        this.enabled = bl6;
        this.extra = map;
        this.logRecompileOnMacro = bl7;
        this.externalHooks = externalHooks;
        this.ignoredScalacOptions = stringArray;
        this.strictMode = IncOptions.defaultStrictMode();
        this.allowMachinePath = IncOptions.defaultAllowMachinePath();
        this.pipelining = IncOptions.defaultPipelining();
    }

    protected IncOptions(int n, double d, boolean bl, boolean bl2, int n2, File file, ClassFileManagerType classFileManagerType, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, Map<String, String> map, boolean bl8, ExternalHooks externalHooks, String[] stringArray) {
        this.transitiveStep = n;
        this.recompileAllFraction = d;
        this.relationsDebug = bl;
        this.apiDebug = bl2;
        this.apiDiffContextSize = n2;
        this.apiDumpDirectory = Optional.ofNullable(file);
        this.classfileManagerType = Optional.ofNullable(classFileManagerType);
        this.auxiliaryClassFiles = IncOptions.defaultAuxiliaryClassFiles();
        this.useCustomizedFileManager = bl3;
        this.recompileOnMacroDef = Optional.ofNullable(bl4);
        this.useOptimizedSealed = bl5;
        this.storeApis = bl6;
        this.enabled = bl7;
        this.extra = map;
        this.logRecompileOnMacro = bl8;
        this.externalHooks = externalHooks;
        this.ignoredScalacOptions = stringArray;
        this.strictMode = IncOptions.defaultStrictMode();
        this.allowMachinePath = IncOptions.defaultAllowMachinePath();
        this.pipelining = IncOptions.defaultPipelining();
    }

    protected IncOptions(int n, double d, boolean bl, boolean bl2, int n2, Optional<File> optional, Optional<ClassFileManagerType> optional2, boolean bl3, Optional<Boolean> optional3, boolean bl4, boolean bl5, boolean bl6, Map<String, String> map, boolean bl7, ExternalHooks externalHooks, String[] stringArray, boolean bl8) {
        this.transitiveStep = n;
        this.recompileAllFraction = d;
        this.relationsDebug = bl;
        this.apiDebug = bl2;
        this.apiDiffContextSize = n2;
        this.apiDumpDirectory = optional;
        this.classfileManagerType = optional2;
        this.auxiliaryClassFiles = IncOptions.defaultAuxiliaryClassFiles();
        this.useCustomizedFileManager = bl3;
        this.recompileOnMacroDef = optional3;
        this.useOptimizedSealed = bl4;
        this.storeApis = bl5;
        this.enabled = bl6;
        this.extra = map;
        this.logRecompileOnMacro = bl7;
        this.externalHooks = externalHooks;
        this.ignoredScalacOptions = stringArray;
        this.strictMode = bl8;
        this.allowMachinePath = IncOptions.defaultAllowMachinePath();
        this.pipelining = IncOptions.defaultPipelining();
    }

    protected IncOptions(int n, double d, boolean bl, boolean bl2, int n2, File file, ClassFileManagerType classFileManagerType, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, Map<String, String> map, boolean bl8, ExternalHooks externalHooks, String[] stringArray, boolean bl9) {
        this.transitiveStep = n;
        this.recompileAllFraction = d;
        this.relationsDebug = bl;
        this.apiDebug = bl2;
        this.apiDiffContextSize = n2;
        this.apiDumpDirectory = Optional.ofNullable(file);
        this.classfileManagerType = Optional.ofNullable(classFileManagerType);
        this.auxiliaryClassFiles = IncOptions.defaultAuxiliaryClassFiles();
        this.useCustomizedFileManager = bl3;
        this.recompileOnMacroDef = Optional.ofNullable(bl4);
        this.useOptimizedSealed = bl5;
        this.storeApis = bl6;
        this.enabled = bl7;
        this.extra = map;
        this.logRecompileOnMacro = bl8;
        this.externalHooks = externalHooks;
        this.ignoredScalacOptions = stringArray;
        this.strictMode = bl9;
        this.allowMachinePath = IncOptions.defaultAllowMachinePath();
        this.pipelining = IncOptions.defaultPipelining();
    }

    protected IncOptions(int n, double d, boolean bl, boolean bl2, int n2, Optional<File> optional, Optional<ClassFileManagerType> optional2, boolean bl3, Optional<Boolean> optional3, boolean bl4, boolean bl5, boolean bl6, Map<String, String> map, boolean bl7, ExternalHooks externalHooks, String[] stringArray, boolean bl8, boolean bl9, boolean bl10) {
        this.transitiveStep = n;
        this.recompileAllFraction = d;
        this.relationsDebug = bl;
        this.apiDebug = bl2;
        this.apiDiffContextSize = n2;
        this.apiDumpDirectory = optional;
        this.classfileManagerType = optional2;
        this.auxiliaryClassFiles = IncOptions.defaultAuxiliaryClassFiles();
        this.useCustomizedFileManager = bl3;
        this.recompileOnMacroDef = optional3;
        this.useOptimizedSealed = bl4;
        this.storeApis = bl5;
        this.enabled = bl6;
        this.extra = map;
        this.logRecompileOnMacro = bl7;
        this.externalHooks = externalHooks;
        this.ignoredScalacOptions = stringArray;
        this.strictMode = bl8;
        this.allowMachinePath = bl9;
        this.pipelining = bl10;
    }

    protected IncOptions(int n, double d, boolean bl, boolean bl2, int n2, File file, ClassFileManagerType classFileManagerType, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, Map<String, String> map, boolean bl8, ExternalHooks externalHooks, String[] stringArray, boolean bl9, boolean bl10, boolean bl11) {
        this.transitiveStep = n;
        this.recompileAllFraction = d;
        this.relationsDebug = bl;
        this.apiDebug = bl2;
        this.apiDiffContextSize = n2;
        this.apiDumpDirectory = Optional.ofNullable(file);
        this.classfileManagerType = Optional.ofNullable(classFileManagerType);
        this.auxiliaryClassFiles = IncOptions.defaultAuxiliaryClassFiles();
        this.useCustomizedFileManager = bl3;
        this.recompileOnMacroDef = Optional.ofNullable(bl4);
        this.useOptimizedSealed = bl5;
        this.storeApis = bl6;
        this.enabled = bl7;
        this.extra = map;
        this.logRecompileOnMacro = bl8;
        this.externalHooks = externalHooks;
        this.ignoredScalacOptions = stringArray;
        this.strictMode = bl9;
        this.allowMachinePath = bl10;
        this.pipelining = bl11;
    }

    protected IncOptions(int n, double d, boolean bl, boolean bl2, int n2, Optional<File> optional, Optional<ClassFileManagerType> optional2, AuxiliaryClassFiles[] auxiliaryClassFilesArray, boolean bl3, Optional<Boolean> optional3, boolean bl4, boolean bl5, boolean bl6, Map<String, String> map, boolean bl7, ExternalHooks externalHooks, String[] stringArray, boolean bl8, boolean bl9, boolean bl10) {
        this.transitiveStep = n;
        this.recompileAllFraction = d;
        this.relationsDebug = bl;
        this.apiDebug = bl2;
        this.apiDiffContextSize = n2;
        this.apiDumpDirectory = optional;
        this.classfileManagerType = optional2;
        this.auxiliaryClassFiles = auxiliaryClassFilesArray;
        this.useCustomizedFileManager = bl3;
        this.recompileOnMacroDef = optional3;
        this.useOptimizedSealed = bl4;
        this.storeApis = bl5;
        this.enabled = bl6;
        this.extra = map;
        this.logRecompileOnMacro = bl7;
        this.externalHooks = externalHooks;
        this.ignoredScalacOptions = stringArray;
        this.strictMode = bl8;
        this.allowMachinePath = bl9;
        this.pipelining = bl10;
    }

    protected IncOptions(int n, double d, boolean bl, boolean bl2, int n2, File file, ClassFileManagerType classFileManagerType, AuxiliaryClassFiles[] auxiliaryClassFilesArray, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, Map<String, String> map, boolean bl8, ExternalHooks externalHooks, String[] stringArray, boolean bl9, boolean bl10, boolean bl11) {
        this.transitiveStep = n;
        this.recompileAllFraction = d;
        this.relationsDebug = bl;
        this.apiDebug = bl2;
        this.apiDiffContextSize = n2;
        this.apiDumpDirectory = Optional.ofNullable(file);
        this.classfileManagerType = Optional.ofNullable(classFileManagerType);
        this.auxiliaryClassFiles = auxiliaryClassFilesArray;
        this.useCustomizedFileManager = bl3;
        this.recompileOnMacroDef = Optional.ofNullable(bl4);
        this.useOptimizedSealed = bl5;
        this.storeApis = bl6;
        this.enabled = bl7;
        this.extra = map;
        this.logRecompileOnMacro = bl8;
        this.externalHooks = externalHooks;
        this.ignoredScalacOptions = stringArray;
        this.strictMode = bl9;
        this.allowMachinePath = bl10;
        this.pipelining = bl11;
    }

    public int transitiveStep() {
        return this.transitiveStep;
    }

    public double recompileAllFraction() {
        return this.recompileAllFraction;
    }

    public boolean relationsDebug() {
        return this.relationsDebug;
    }

    public boolean apiDebug() {
        return this.apiDebug;
    }

    public int apiDiffContextSize() {
        return this.apiDiffContextSize;
    }

    public Optional<File> apiDumpDirectory() {
        return this.apiDumpDirectory;
    }

    public Optional<ClassFileManagerType> classfileManagerType() {
        return this.classfileManagerType;
    }

    public AuxiliaryClassFiles[] auxiliaryClassFiles() {
        return this.auxiliaryClassFiles;
    }

    public boolean useCustomizedFileManager() {
        return this.useCustomizedFileManager;
    }

    public Optional<Boolean> recompileOnMacroDef() {
        return this.recompileOnMacroDef;
    }

    public boolean useOptimizedSealed() {
        return this.useOptimizedSealed;
    }

    public boolean storeApis() {
        return this.storeApis;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public Map<String, String> extra() {
        return this.extra;
    }

    public boolean logRecompileOnMacro() {
        return this.logRecompileOnMacro;
    }

    public ExternalHooks externalHooks() {
        return this.externalHooks;
    }

    public String[] ignoredScalacOptions() {
        return this.ignoredScalacOptions;
    }

    public boolean strictMode() {
        return this.strictMode;
    }

    public boolean allowMachinePath() {
        return this.allowMachinePath;
    }

    public boolean pipelining() {
        return this.pipelining;
    }

    public IncOptions withTransitiveStep(int n) {
        return new IncOptions(n, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withRecompileAllFraction(double d) {
        return new IncOptions(this.transitiveStep, d, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withRelationsDebug(boolean bl) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, bl, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withApiDebug(boolean bl) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, bl, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withApiDiffContextSize(int n) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, n, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withApiDumpDirectory(Optional<File> optional) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, optional, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withApiDumpDirectory(File file) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, Optional.ofNullable(file), this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withClassfileManagerType(Optional<ClassFileManagerType> optional) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, optional, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withClassfileManagerType(ClassFileManagerType classFileManagerType) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, Optional.ofNullable(classFileManagerType), this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withAuxiliaryClassFiles(AuxiliaryClassFiles[] auxiliaryClassFilesArray) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, auxiliaryClassFilesArray, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withUseCustomizedFileManager(boolean bl) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, bl, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withRecompileOnMacroDef(Optional<Boolean> optional) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, optional, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withRecompileOnMacroDef(boolean bl) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, Optional.ofNullable(bl), this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withUseOptimizedSealed(boolean bl) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, bl, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withStoreApis(boolean bl) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, bl, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withEnabled(boolean bl) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, bl, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withExtra(Map<String, String> map) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, map, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withLogRecompileOnMacro(boolean bl) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, bl, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withExternalHooks(ExternalHooks externalHooks) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withIgnoredScalacOptions(String[] stringArray) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, stringArray, this.strictMode, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withStrictMode(boolean bl) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, bl, this.allowMachinePath, this.pipelining);
    }

    public IncOptions withAllowMachinePath(boolean bl) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, bl, this.pipelining);
    }

    public IncOptions withPipelining(boolean bl) {
        return new IncOptions(this.transitiveStep, this.recompileAllFraction, this.relationsDebug, this.apiDebug, this.apiDiffContextSize, this.apiDumpDirectory, this.classfileManagerType, this.auxiliaryClassFiles, this.useCustomizedFileManager, this.recompileOnMacroDef, this.useOptimizedSealed, this.storeApis, this.enabled, this.extra, this.logRecompileOnMacro, this.externalHooks, this.ignoredScalacOptions, this.strictMode, this.allowMachinePath, bl);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IncOptions)) {
            return false;
        }
        IncOptions incOptions = (IncOptions)object;
        return this.transitiveStep() == incOptions.transitiveStep() && this.recompileAllFraction() == incOptions.recompileAllFraction() && this.relationsDebug() == incOptions.relationsDebug() && this.apiDebug() == incOptions.apiDebug() && this.apiDiffContextSize() == incOptions.apiDiffContextSize() && this.apiDumpDirectory().equals(incOptions.apiDumpDirectory()) && this.classfileManagerType().equals(incOptions.classfileManagerType()) && Arrays.deepEquals(this.auxiliaryClassFiles(), incOptions.auxiliaryClassFiles()) && this.useCustomizedFileManager() == incOptions.useCustomizedFileManager() && this.recompileOnMacroDef().equals(incOptions.recompileOnMacroDef()) && this.useOptimizedSealed() == incOptions.useOptimizedSealed() && this.storeApis() == incOptions.storeApis() && this.enabled() == incOptions.enabled() && this.extra().equals(incOptions.extra()) && this.logRecompileOnMacro() == incOptions.logRecompileOnMacro() && this.externalHooks().equals(incOptions.externalHooks()) && Arrays.deepEquals(this.ignoredScalacOptions(), incOptions.ignoredScalacOptions()) && this.strictMode() == incOptions.strictMode() && this.allowMachinePath() == incOptions.allowMachinePath() && this.pipelining() == incOptions.pipelining();
    }

    public int hashCode() {
        return 37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (17 + "xsbti.compile.IncOptions".hashCode()) + Integer.valueOf(this.transitiveStep()).hashCode()) + Double.valueOf(this.recompileAllFraction()).hashCode()) + Boolean.valueOf(this.relationsDebug()).hashCode()) + Boolean.valueOf(this.apiDebug()).hashCode()) + Integer.valueOf(this.apiDiffContextSize()).hashCode()) + this.apiDumpDirectory().hashCode()) + this.classfileManagerType().hashCode()) + Arrays.deepHashCode(this.auxiliaryClassFiles())) + Boolean.valueOf(this.useCustomizedFileManager()).hashCode()) + this.recompileOnMacroDef().hashCode()) + Boolean.valueOf(this.useOptimizedSealed()).hashCode()) + Boolean.valueOf(this.storeApis()).hashCode()) + Boolean.valueOf(this.enabled()).hashCode()) + this.extra().hashCode()) + Boolean.valueOf(this.logRecompileOnMacro()).hashCode()) + this.externalHooks().hashCode()) + Arrays.deepHashCode(this.ignoredScalacOptions())) + Boolean.valueOf(this.strictMode()).hashCode()) + Boolean.valueOf(this.allowMachinePath()).hashCode()) + Boolean.valueOf(this.pipelining()).hashCode());
    }

    public String toString() {
        return "IncOptions(transitiveStep: " + this.transitiveStep() + ", recompileAllFraction: " + this.recompileAllFraction() + ", relationsDebug: " + this.relationsDebug() + ", apiDebug: " + this.apiDebug() + ", apiDiffContextSize: " + this.apiDiffContextSize() + ", apiDumpDirectory: " + this.apiDumpDirectory() + ", classfileManagerType: " + this.classfileManagerType() + ", auxiliaryClassFiles: " + this.auxiliaryClassFiles() + ", useCustomizedFileManager: " + this.useCustomizedFileManager() + ", recompileOnMacroDef: " + this.recompileOnMacroDef() + ", useOptimizedSealed: " + this.useOptimizedSealed() + ", storeApis: " + this.storeApis() + ", enabled: " + this.enabled() + ", extra: " + this.extra() + ", logRecompileOnMacro: " + this.logRecompileOnMacro() + ", externalHooks: " + this.externalHooks() + ", ignoredScalacOptions: " + this.ignoredScalacOptions() + ", strictMode: " + this.strictMode() + ", allowMachinePath: " + this.allowMachinePath() + ", pipelining: " + this.pipelining() + ")";
    }
}

