/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.gfm.tasklist.internal;

import com.vladsch.flexmark.ast.BulletList;
import com.vladsch.flexmark.ast.ListBlock;
import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ast.OrderedList;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ext.gfm.tasklist.TaskListItem;
import com.vladsch.flexmark.ext.gfm.tasklist.TaskListItemPlacement;
import com.vladsch.flexmark.ext.gfm.tasklist.internal.TaskListFormatOptions;
import com.vladsch.flexmark.formatter.FormatterUtils;
import com.vladsch.flexmark.formatter.MarkdownWriter;
import com.vladsch.flexmark.formatter.NodeFormatter;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.formatter.NodeFormattingHandler;
import com.vladsch.flexmark.parser.ListOptions;
import com.vladsch.flexmark.util.ast.BlankLine;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.builder.SequenceBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class TaskListNodeFormatter
implements NodeFormatter {
    private final TaskListFormatOptions taskListFormatOptions;
    private final ListOptions listOptions;

    public TaskListNodeFormatter(DataHolder options) {
        this.taskListFormatOptions = new TaskListFormatOptions(options);
        this.listOptions = ListOptions.get((DataHolder)options);
    }

    @Nullable
    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        return new HashSet(Arrays.asList(new NodeFormattingHandler(TaskListItem.class, this::render), new NodeFormattingHandler(BulletList.class, this::render), new NodeFormattingHandler(OrderedList.class, this::render)));
    }

    @Nullable
    public Set<Class<?>> getNodeClasses() {
        return null;
    }

    private void render(TaskListItem node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (context.isTransformingText()) {
            FormatterUtils.renderListItem((ListItem)node, (NodeFormatterContext)context, (MarkdownWriter)markdown, (ListOptions)this.listOptions, (BasedSequence)node.getMarkerSuffix(), (boolean)false);
        } else {
            BasedSequence markerSuffix = node.getMarkerSuffix();
            switch (this.taskListFormatOptions.taskListItemCase) {
                case AS_IS: {
                    break;
                }
                case LOWERCASE: {
                    markerSuffix = (BasedSequence)markerSuffix.toLowerCase();
                    break;
                }
                case UPPERCASE: {
                    markerSuffix = (BasedSequence)markerSuffix.toUpperCase();
                    break;
                }
                default: {
                    throw new IllegalStateException("Missing case for TaskListItemCase " + this.taskListFormatOptions.taskListItemCase.name());
                }
            }
            if (node.isItemDoneMarker()) {
                switch (this.taskListFormatOptions.taskListItemPlacement) {
                    case AS_IS: 
                    case INCOMPLETE_FIRST: 
                    case INCOMPLETE_NESTED_FIRST: {
                        break;
                    }
                    case COMPLETE_TO_NON_TASK: 
                    case COMPLETE_NESTED_TO_NON_TASK: {
                        markerSuffix = markerSuffix.getEmptySuffix();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Missing case for ListItemPlacement " + this.taskListFormatOptions.taskListItemPlacement.name());
                    }
                }
            }
            if (markerSuffix.isNotEmpty() && this.taskListFormatOptions.formatPrioritizedTaskItems) {
                node.setCanChangeMarker(false);
            }
            boolean forceLooseItem = node.isLoose() && node.hasChildren() && node.getFirstChildAnyNot(new Class[]{BlankLine.class}) != null;
            FormatterUtils.renderListItem((ListItem)node, (NodeFormatterContext)context, (MarkdownWriter)markdown, (ListOptions)this.listOptions, (BasedSequence)(markerSuffix.isEmpty() ? markerSuffix : ((SequenceBuilder)((SequenceBuilder)((SequenceBuilder)markerSuffix.getBuilder().append((CharSequence)markerSuffix)).append((CharSequence)" ")).append((CharSequence)markerSuffix.baseSubSequence(markerSuffix.getEndOffset() + 1, markerSuffix.getEndOffset() + 1))).toSequence()), (boolean)forceLooseItem);
        }
    }

    private void render(BulletList node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.renderList((ListBlock)node, context, markdown);
    }

    private void render(OrderedList node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.renderList((ListBlock)node, context, markdown);
    }

    public static boolean hasIncompleteDescendants(Node node) {
        for (Node item = node.getFirstChild(); item != null; item = item.getNext()) {
            if (item instanceof TaskListItem && !((TaskListItem)item).isItemDoneMarker()) {
                return true;
            }
            if (!(item instanceof Block) || item instanceof Paragraph || !TaskListNodeFormatter.hasIncompleteDescendants(item)) continue;
            return true;
        }
        return false;
    }

    public int taskItemPriority(Node node) {
        if (node instanceof TaskListItem) {
            if (((TaskListItem)node).isOrderedItem()) {
                return this.taskListFormatOptions.formatOrderedTaskItemPriority;
            }
            BasedSequence openingMarker = ((ListItem)node).getOpeningMarker();
            if (openingMarker.length() > 0) {
                Integer priority = this.taskListFormatOptions.formatTaskItemPriorities.get(Character.valueOf(openingMarker.charAt(0)));
                if (priority != null) {
                    return priority;
                }
                return this.taskListFormatOptions.formatDefaultTaskItemPriority;
            }
        }
        return Integer.MIN_VALUE;
    }

    public int itemPriority(Node node) {
        Node item = node.getFirstChild();
        int priority = Integer.MIN_VALUE;
        if (node instanceof TaskListItem && !((TaskListItem)node).isItemDoneMarker()) {
            priority = Math.max(priority, this.taskItemPriority(node));
        }
        while (item != null) {
            if (item instanceof TaskListItem && !((TaskListItem)item).isItemDoneMarker()) {
                priority = Math.max(priority, this.taskItemPriority(item));
            }
            if (item instanceof Block && !(item instanceof Paragraph)) {
                priority = Math.max(priority, this.itemPriority(item));
            }
            item = item.getNext();
        }
        return priority;
    }

    public void renderList(ListBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (context.isTransformingText()) {
            context.renderChildren((Node)node);
        } else {
            ArrayList itemList = new ArrayList();
            TaskListItemPlacement taskListItemPlacement = this.taskListFormatOptions.taskListItemPlacement;
            if (taskListItemPlacement != TaskListItemPlacement.AS_IS) {
                ArrayList<ListItem> incompleteTasks = new ArrayList<ListItem>();
                ArrayList<ListItem> completeItems = new ArrayList<ListItem>();
                boolean incompleteDescendants = taskListItemPlacement == TaskListItemPlacement.INCOMPLETE_NESTED_FIRST || taskListItemPlacement == TaskListItemPlacement.COMPLETE_NESTED_TO_NON_TASK;
                for (Node item = node.getFirstChild(); item != null; item = item.getNext()) {
                    if (item instanceof TaskListItem) {
                        TaskListItem taskItem = (TaskListItem)item;
                        if (!taskItem.isItemDoneMarker() || incompleteDescendants && TaskListNodeFormatter.hasIncompleteDescendants(item)) {
                            incompleteTasks.add((ListItem)item);
                            continue;
                        }
                        completeItems.add((ListItem)item);
                        continue;
                    }
                    if (!(item instanceof ListItem)) continue;
                    if (incompleteDescendants && TaskListNodeFormatter.hasIncompleteDescendants(item)) {
                        incompleteTasks.add((ListItem)item);
                        continue;
                    }
                    completeItems.add((ListItem)item);
                }
                if (this.taskListFormatOptions.formatPrioritizedTaskItems) {
                    for (ListItem listItem : incompleteTasks) {
                        listItem.setPriority(this.itemPriority((Node)listItem));
                    }
                    incompleteTasks.sort((o1, o2) -> Integer.compare(o2.getPriority(), o1.getPriority()));
                    itemList.addAll(incompleteTasks);
                } else {
                    itemList.addAll(incompleteTasks);
                }
                itemList.addAll(completeItems);
            } else {
                for (Node item = node.getFirstChild(); item != null; item = item.getNext()) {
                    itemList.add(item);
                }
            }
            FormatterUtils.renderList((ListBlock)node, (NodeFormatterContext)context, (MarkdownWriter)markdown, itemList);
        }
    }
}

