/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security.asn1;

import com.ca.commons.security.asn1.ASN1Exception;
import com.ca.commons.security.asn1.ASN1OID;
import com.ca.commons.security.asn1.ASN1Object;
import com.ca.commons.security.asn1.ASN1Type;
import java.util.StringTokenizer;
import java.util.Vector;

public class Name {
    private String country = null;
    private String state = null;
    private String locality = null;
    private String org = null;
    private Vector orgUnit = new Vector();
    private String commonName = null;
    private String emailAdd = null;
    private String uniqueID = null;
    private String addressIP = null;
    private ASN1Object name = null;

    public Name() {
    }

    public Name(String input) {
        StringTokenizer tok = new StringTokenizer(input, ",");
        while (tok.hasMoreTokens()) {
            String nextToken = tok.nextToken().trim();
            StringTokenizer fieldTok = new StringTokenizer(nextToken, "=");
            if (fieldTok.countTokens() != 2) continue;
            String name = fieldTok.nextToken().trim();
            String value = fieldTok.nextToken().trim();
            if (name.equalsIgnoreCase("C")) {
                if (value.equalsIgnoreCase("null")) continue;
                this.country = value;
                continue;
            }
            if (name.equalsIgnoreCase("S")) {
                if (value.equalsIgnoreCase("null")) continue;
                this.state = value;
                continue;
            }
            if (name.equalsIgnoreCase("L")) {
                if (value.equalsIgnoreCase("null")) continue;
                this.locality = value;
                continue;
            }
            if (name.equalsIgnoreCase("O")) {
                if (value.equalsIgnoreCase("null")) continue;
                this.org = value;
                continue;
            }
            if (name.equalsIgnoreCase("OU")) {
                if (value.equalsIgnoreCase("null")) continue;
                this.orgUnit.add(value);
                continue;
            }
            if (name.equalsIgnoreCase("CN")) {
                if (value.equalsIgnoreCase("null")) continue;
                this.commonName = value;
                continue;
            }
            if (name.equalsIgnoreCase("E")) {
                if (value.equalsIgnoreCase("null")) continue;
                this.emailAdd = value;
                continue;
            }
            if (name.equalsIgnoreCase("EM")) {
                if (value.equalsIgnoreCase("null")) continue;
                this.emailAdd = value;
                continue;
            }
            if (name.equalsIgnoreCase("Email")) {
                if (value.equalsIgnoreCase("null")) continue;
                this.emailAdd = value;
                continue;
            }
            if (!name.equalsIgnoreCase("EmailAddress") || value.equalsIgnoreCase("null")) continue;
            this.emailAdd = value;
        }
        if (!this.valid()) {
            throw new IllegalArgumentException("invalid parameters for Name object.");
        }
    }

    public Name(String c, String s, String l, String o, String ou, String cn, String em) {
        this.country = c;
        this.state = s;
        this.locality = l;
        this.org = o;
        this.orgUnit.add(ou);
        this.commonName = cn;
        this.emailAdd = em;
        if (!this.valid()) {
            throw new IllegalArgumentException("invalid parameters for Name object.");
        }
    }

    public Name(ASN1Object o) {
        this.name = o;
        this.init();
        if (this.name == null) {
            throw new IllegalArgumentException("cannot construct a Name from input ASN1Object");
        }
    }

    public Name(byte[] input) {
        this.name = ASN1Object.fromBytes(input);
        this.init();
        if (this.name == null) {
            throw new IllegalArgumentException("cannot construct a Name from input byte array");
        }
    }

    private void init() {
        ASN1Object o = this.name;
        if (o == null || !o.isASN1Type(ASN1Type.SEQUENCE)) {
            this.name = null;
            return;
        }
        for (int i = 0; i < o.size(); ++i) {
            ASN1Object rdn = o.getComponent(i);
            if (!rdn.isASN1Type(ASN1Type.SET)) {
                this.name = null;
                return;
            }
            for (int j = 0; j < rdn.size(); ++j) {
                ASN1Object ava = rdn.getComponent(j);
                String type = (String)ava.getComponent(0).getValue();
                String value = (String)ava.getComponent(1).getValue();
                if (type.equals(ASN1OID.commonName)) {
                    this.commonName = value;
                    continue;
                }
                if (type.equals(ASN1OID.country)) {
                    this.country = value;
                    continue;
                }
                if (type.equals(ASN1OID.stateOrProvince)) {
                    this.state = value;
                    continue;
                }
                if (type.equals(ASN1OID.locality)) {
                    this.locality = value;
                    continue;
                }
                if (type.equals(ASN1OID.organization)) {
                    this.org = value;
                    continue;
                }
                if (type.equals(ASN1OID.organizationalUnit)) {
                    this.orgUnit.add(value);
                    continue;
                }
                if (type.equals(ASN1OID.emailAddress)) {
                    this.emailAdd = value;
                    continue;
                }
                if (type.equals(ASN1OID.unstructuredName)) {
                    this.uniqueID = value;
                    continue;
                }
                if (!type.equals(ASN1OID.unstructuredAddress)) continue;
                this.addressIP = value;
            }
        }
        if (!this.valid()) {
            this.name = null;
        }
    }

    private void createName() {
        if (!this.valid()) {
            this.name = null;
            return;
        }
        try {
            this.name = ASN1Object.create(ASN1Type.SEQUENCE);
            if (this.country != null) {
                this.name.addComponent(this.createRDN(ASN1OID.country, this.country));
            }
            if (this.state != null) {
                this.name.addComponent(this.createRDN(ASN1OID.stateOrProvince, this.state));
            }
            if (this.locality != null) {
                this.name.addComponent(this.createRDN(ASN1OID.locality, this.locality));
            }
            if (this.org != null) {
                this.name.addComponent(this.createRDN(ASN1OID.organization, this.org));
            }
            for (int i = 0; i < this.orgUnit.size(); ++i) {
                String myou = (String)this.orgUnit.elementAt(i);
                if (myou == null || myou.trim().length() <= 0) continue;
                this.name.addComponent(this.createRDN(ASN1OID.organizationalUnit, myou));
            }
            if (this.emailAdd != null) {
                this.name.addComponent(this.createEmail(ASN1OID.emailAddress, this.emailAdd));
            }
            if (this.commonName != null) {
                this.name.addComponent(this.createRDN(ASN1OID.commonName, this.commonName));
            }
            if (this.uniqueID != null) {
                this.name.addComponent(this.createEmail(ASN1OID.unstructuredName, this.uniqueID));
            }
            if (this.addressIP != null) {
                this.name.addComponent(this.createRDN(ASN1OID.unstructuredAddress, this.addressIP));
            }
        }
        catch (ASN1Exception asn1e) {
            this.name = null;
            return;
        }
        this.name.initByteArray();
    }

    private ASN1Object createRDN(String t, String v) throws ASN1Exception {
        ASN1Object rdn = ASN1Object.create(ASN1Type.SET);
        ASN1Object ava = ASN1Object.create(ASN1Type.SEQUENCE);
        ASN1Object type = ASN1Object.create(ASN1Type.OBJECT_ID, t);
        ASN1Object value = ASN1Object.create(ASN1Type.PrintableString, v);
        ava.addComponent(type);
        ava.addComponent(value);
        rdn.addComponent(ava);
        return rdn;
    }

    private ASN1Object createEmail(String t, String v) throws ASN1Exception {
        ASN1Object rdn = ASN1Object.create(ASN1Type.SET);
        ASN1Object ava = ASN1Object.create(ASN1Type.SEQUENCE);
        ASN1Object type = ASN1Object.create(ASN1Type.OBJECT_ID, t);
        ASN1Object value = ASN1Object.create(ASN1Type.IA5String, v);
        ava.addComponent(type);
        ava.addComponent(value);
        rdn.addComponent(ava);
        return rdn;
    }

    public ASN1Object toASN1Object() {
        if (this.name == null) {
            this.createName();
        }
        return this.name;
    }

    public byte[] toByteArrayDER() {
        if (this.name == null) {
            this.createName();
        }
        if (this.name == null) {
            return null;
        }
        return this.name.toDERBytes();
    }

    public String country() {
        return this.country;
    }

    public String stateOrProvince() {
        return this.state;
    }

    public String locality() {
        return this.locality;
    }

    public String organization() {
        return this.org;
    }

    public String organizationalUnit() {
        if (this.orgUnit.size() >= 1) {
            return (String)this.orgUnit.elementAt(0);
        }
        return null;
    }

    public Vector organizationalUnits() {
        return this.orgUnit;
    }

    public String commonName() {
        if (this.commonName != null && this.commonName.trim().length() != 0) {
            return this.commonName;
        }
        return this.toString();
    }

    public String emailAddress() {
        return this.emailAdd;
    }

    public String uniqueID() {
        return this.uniqueID;
    }

    public String addressIP() {
        return this.addressIP;
    }

    public void set(Name o) {
        this.country = o.country;
        this.state = o.state;
        this.locality = o.locality;
        this.org = o.org;
        this.orgUnit = o.orgUnit;
        this.commonName = o.commonName;
        this.emailAdd = o.emailAdd;
        this.uniqueID = o.uniqueID;
        this.addressIP = o.addressIP;
        this.name = o.name;
    }

    public boolean equals(Object n) {
        if (!(n instanceof Name)) {
            return false;
        }
        Name o = (Name)n;
        return this.toASN1Object().equals(o.toASN1Object());
    }

    public boolean valid() {
        return this.country != null && this.country.length() != 0 || this.state != null && this.state.length() != 0 || this.locality != null && this.locality.length() != 0 || this.org != null && this.org.length() != 0 || this.orgUnit != null && this.orgUnit.size() != 0 || this.commonName != null && this.commonName.length() != 0 || this.emailAdd != null && this.emailAdd.length() != 0;
    }

    public String toString() {
        String result = null;
        if (this.country != null && !this.country.equals("null") && this.country.trim().length() > 0) {
            result = "C = " + this.country;
        }
        if (this.state != null && !this.state.equals("null") && this.state.trim().length() > 0) {
            result = result + ", ST = " + this.state;
        }
        if (this.locality != null && !this.locality.equals("null") && this.locality.trim().length() > 0) {
            result = result + ", L = " + this.locality;
        }
        if (this.org != null && !this.org.equals("null") && this.org.trim().length() > 0) {
            result = result + ", O = " + this.org;
        }
        for (int i = 0; i < this.orgUnit.size(); ++i) {
            String anOrgUnit = (String)this.orgUnit.elementAt(i);
            if (anOrgUnit == null || anOrgUnit.equals("null") || anOrgUnit.trim().length() <= 0) continue;
            result = result + ", OU = " + anOrgUnit;
        }
        if (this.commonName != null && !this.commonName.equals("null") && this.commonName.trim().length() > 0) {
            result = result + ", CN = " + this.commonName;
        }
        if (this.emailAdd != null && !this.emailAdd.equals("null") && this.emailAdd.trim().length() > 0) {
            result = result + ", EM = " + this.emailAdd;
        }
        if (this.uniqueID != null && !this.uniqueID.equals("null") && this.uniqueID.trim().length() > 0) {
            result = result + ", unstructuredName = " + this.uniqueID;
        }
        if (this.addressIP != null && !this.addressIP.equals("null") && this.addressIP.trim().length() > 0) {
            result = result + ", unstructuredAddress = " + this.addressIP;
        }
        return result;
    }
}

