/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasons;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;

public class ModuleForcingResolveRule
implements Action<DependencySubstitutionInternal> {
    private final Map<ModuleIdentifier, String> forcedModules;

    public ModuleForcingResolveRule(Collection<? extends ModuleVersionSelector> forcedModules) {
        if (!forcedModules.isEmpty()) {
            this.forcedModules = new HashMap<ModuleIdentifier, String>();
            for (ModuleVersionSelector moduleVersionSelector : forcedModules) {
                this.forcedModules.put(moduleVersionSelector.getModule(), moduleVersionSelector.getVersion());
            }
        } else {
            this.forcedModules = null;
        }
    }

    public void execute(DependencySubstitutionInternal details) {
        ModuleComponentSelector selector;
        ModuleIdentifier key;
        if (this.forcedModules == null) {
            return;
        }
        if (details.getRequested() instanceof ModuleComponentSelector && this.forcedModules.containsKey(key = (selector = (ModuleComponentSelector)details.getRequested()).getModuleIdentifier())) {
            DefaultImmutableVersionConstraint versionConstraint = new DefaultImmutableVersionConstraint(this.forcedModules.get(key));
            details.useTarget(DefaultModuleComponentSelector.newSelector(key, versionConstraint, selector.getAttributes(), selector.getRequestedCapabilities()), ComponentSelectionReasons.FORCED);
        }
    }
}

