# (c) Copyright 2009-2015. CodeWeavers, Inc.

from gi.repository import GLib
from gi.repository import Gtk

import bottlecollection
import bottleoperation

import cxguitools
import pyop

# for localization
from cxutils import cxgettext as _

class ResetDialogController:

    def __init__(self, target_bottle=None):
        #-----------------------------------------------------------------------
        #  Setup the GUI
        #-----------------------------------------------------------------------
        self.resetOp = None
        self.forceQuitOp = None
        self.resetFailed = False
        self.animateEvent = None
        cxguitools.set_default_icon("cxreset")

        self.xml = Gtk.Builder()
        self.xml.set_translation_domain("crossover")
        self.xml.add_from_file(cxguitools.get_ui_path("cxreset"))
        self.xml.connect_signals(self)

        icons = cxguitools.get_std_icon_list('cxreset')
        self.xml.get_object("ResetWindow").set_icon_list(icons)


        #-----------------------------------------------------------------------
        #  Set up progress bar
        #-----------------------------------------------------------------------
        progbar = self.xml.get_object("ProgBar")
        progbar.set_pulse_step(.05)
        progbar.hide()


        #-----------------------------------------------------------------------
        #  Fill Bottle popup list
        #-----------------------------------------------------------------------
        bottlePopupWidget = self.xml.get_object("BottlePopup")
        self.bottleListStore = Gtk.ListStore(str, object)
        bottlePopupWidget.set_model(self.bottleListStore)
        collection = bottlecollection.sharedCollection()

        newrow = self.bottleListStore.append()
        self.bottleListStore.set_value(newrow, 0, _("All Bottles"))
        self.bottleListStore.set_value(newrow, 1, "")
        selectIter = newrow

        self.allBottles = []

        for bottleName in sorted(collection.bottleList()):
            self.allBottles.append(bottleName)
            newrow = self.bottleListStore.append()
            self.bottleListStore.set_value(newrow, 0, bottleName)
            self.bottleListStore.set_value(newrow, 1, bottleName)
            if bottleName == target_bottle:
                selectIter = newrow

        if selectIter:
            bottlePopupWidget.set_active_iter(selectIter)
        else:
            bottlePopupWidget.set_active_iter(self.bottleListStore.get_iter_first())

        self.set_widget_sensitivities(self)

    def quit_requested(self, _caller):
        # pylint: disable=R0201
        Gtk.main_quit()

    def progbar_pulse(self):
        progBar = self.xml.get_object("ProgBar")
        progBar.pulse()
        return True

    def set_widget_sensitivities(self, _caller):
        progBar = self.xml.get_object("ProgBar")

        if self.forceQuitOp is not None:
            self.xml.get_object("BottlePopup").set_sensitive(False)
            self.xml.get_object("ResetButton").set_sensitive(False)
            self.xml.get_object("ForceQuitButton").set_sensitive(False)
            self.xml.get_object("CloseButton").set_sensitive(False)
            progBar.show()
        if self.resetOp is not None:
            self.xml.get_object("BottlePopup").set_sensitive(False)
            self.xml.get_object("ResetButton").set_sensitive(False)
            self.xml.get_object("ForceQuitButton").set_sensitive(True)
            self.xml.get_object("CloseButton").set_sensitive(False)
            progBar.show()
        else:
            self.xml.get_object("BottlePopup").set_sensitive(True)
            self.xml.get_object("ResetButton").set_sensitive(True)
            self.xml.get_object("ForceQuitButton").set_sensitive(self.resetFailed)
            self.xml.get_object("CloseButton").set_sensitive(True)
            progBar.hide()


    def reset_bottle(self, _caller):
        self.animateEvent = GLib.timeout_add(100, self.progbar_pulse)

        if self.get_selected_bottle_name() == "":
            self.resetOp = bottleoperation.QuitBottleOperation(self.allBottles, False, self)
        else:
            self.resetOp = bottleoperation.QuitBottleOperation([self.get_selected_bottle_name()], False, self)

        self.resetFailed = False

        self.set_widget_sensitivities(self)
        pyop.sharedOperationQueue.enqueue(self.resetOp)

    def force_quit_bottle(self, _caller):
        self.animateEvent = GLib.timeout_add(100, self.progbar_pulse)

        if self.get_selected_bottle_name() == "":
            self.forceQuitOp = bottleoperation.QuitBottleOperation(self.allBottles, True, self)
        else:
            self.forceQuitOp = bottleoperation.QuitBottleOperation([self.get_selected_bottle_name()], True, self)

        self.resetFailed = False

        self.set_widget_sensitivities(self)
        pyop.sharedOperationQueue.enqueue(self.forceQuitOp)


    def op_finished(self, runCommandOp):
        if runCommandOp == self.forceQuitOp:
            self.forceQuitOp = None
        else:
            self.resetOp = None
            self.resetFailed = not runCommandOp.succeeded
        self.set_widget_sensitivities(self)

        GLib.source_remove(self.animateEvent)


    def bottle_changed(self, _widget):
        self.resetFailed = False
        self.set_widget_sensitivities(self)


    def get_selected_bottle_name(self):
        bottlecollection.sharedCollection()
        bottlePopup = self.xml.get_object("BottlePopup")
        activeIndex = bottlePopup.get_active_iter()
        selectedBottleName = self.bottleListStore.get_value(activeIndex, 1)
        return selectedBottleName
