-- SchemaCrawler
-- http://www.schemacrawler.com
-- Copyright (c) 2000-2025, Sualeh Fatehi <sualeh@hotmail.com>.
-- All rights reserved.
-- SPDX-License-Identifier: EPL-2.0

SELECT
  NULL AS VIEW_CATALOG,
  VIEW_TABLE_USAGE.OWNER AS VIEW_SCHEMA,
  VIEW_TABLE_USAGE.NAME AS VIEW_NAME,
  NULL AS TABLE_CATALOG,
  VIEW_TABLE_USAGE.REFERENCED_OWNER AS TABLE_SCHEMA,
  VIEW_TABLE_USAGE.REFERENCED_NAME AS TABLE_NAME
FROM
  ${catalogscope}_DEPENDENCIES VIEW_TABLE_USAGE
  INNER JOIN ${catalogscope}_USERS USERS
    ON VIEW_TABLE_USAGE.OWNER = USERS.USERNAME
      AND USERS.ORACLE_MAINTAINED = 'N'
      AND NOT REGEXP_LIKE(USERS.USERNAME, '^APEX_[0-9]{6}$')
      AND NOT REGEXP_LIKE(USERS.USERNAME, '^FLOWS_[0-9]{5}$')
      AND NOT REGEXP_LIKE(USERS.USERNAME, '^OPS\$ORACLE$')
WHERE
  VIEW_TABLE_USAGE.TYPE = 'VIEW'
  AND REGEXP_LIKE(VIEW_TABLE_USAGE.OWNER, '${schema-inclusion-rule}')
  AND REGEXP_LIKE(VIEW_TABLE_USAGE.OWNER || '.' || VIEW_TABLE_USAGE.NAME, '${table-inclusion-rule}')
  AND VIEW_TABLE_USAGE.NAME NOT LIKE 'BIN$%'
  AND NOT REGEXP_LIKE(VIEW_TABLE_USAGE.NAME, '^(SYS_IOT|MDOS|MDRS|MDRT|MDOT|MDXT)_.*$')
