/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.jcc.am;

import com.ibm.db2.jcc.DBTimestamp;
import com.ibm.db2.jcc.am.InternalDate;
import java.sql.Timestamp;
import java.util.Calendar;

public class InternalTimestamp
extends DBTimestamp {
    private static final long serialVersionUID = -2298215234200651231L;
    private int date_;
    private int month_;
    private int year_;
    private int hour_;
    private int minute_;
    private int second_;

    public InternalTimestamp(Timestamp timestamp, Calendar calendar) {
        super(timestamp, calendar);
        calendar.setTimeInMillis(this.getTime());
        this.date_ = calendar.get(5);
        this.month_ = calendar.get(2);
        this.year_ = calendar.get(1) - 1900;
        this.hour_ = calendar.get(11);
        this.minute_ = calendar.get(12);
        this.second_ = calendar.get(13);
    }

    public InternalTimestamp(long l2, Calendar calendar) {
        super(l2, calendar);
        calendar.setTimeInMillis(this.getTime());
        this.date_ = calendar.get(5);
        this.month_ = calendar.get(2);
        this.year_ = calendar.get(1) - 1900;
        this.hour_ = calendar.get(11);
        this.minute_ = calendar.get(12);
        this.second_ = calendar.get(13);
    }

    public InternalTimestamp(InternalDate internalDate) {
        super(internalDate.getTime());
        this.setTimeZone(internalDate.timeZone_);
        this.hour_ = 0;
        this.minute_ = 0;
        this.second_ = 0;
        this.setNanos(0);
        this.date_ = internalDate.getDate();
        this.month_ = internalDate.getMonth();
        this.year_ = internalDate.getYear();
    }

    @Override
    public int getDate() {
        return this.date_;
    }

    @Override
    public int getMonth() {
        return this.month_;
    }

    @Override
    public int getYear() {
        return this.year_;
    }

    @Override
    public int getHours() {
        return this.hour_;
    }

    @Override
    public int getMinutes() {
        return this.minute_;
    }

    @Override
    public int getSeconds() {
        return this.second_;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(29);
        int n2 = this.getYear() + 1900;
        if (n2 < 10) {
            stringBuffer.append(0);
        }
        if (n2 < 100) {
            stringBuffer.append(0);
        }
        if (n2 < 1000) {
            stringBuffer.append(0);
        }
        stringBuffer.append(n2);
        stringBuffer.append('-');
        stringBuffer.append((this.getMonth() + 1) / 10);
        stringBuffer.append((this.getMonth() + 1) % 10);
        stringBuffer.append('-');
        stringBuffer.append(this.getDate() / 10);
        stringBuffer.append(this.getDate() % 10);
        stringBuffer.append(' ');
        stringBuffer.append(this.getHours() / 10);
        stringBuffer.append(this.getHours() % 10);
        stringBuffer.append(':');
        stringBuffer.append(this.getMinutes() / 10);
        stringBuffer.append(this.getMinutes() % 10);
        stringBuffer.append(':');
        stringBuffer.append(this.getSeconds() / 10);
        stringBuffer.append(this.getSeconds() % 10);
        stringBuffer.append('.');
        String string = Integer.toString(this.getNanos());
        for (int i10 = 0; i10 < 9 - string.length(); ++i10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

