/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.integration.test.utility;

import java.time.Duration;
import java.util.ArrayList;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.OracleContainer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.utility.DockerImageName;

public final class OracleTestUtility {
    public static JdbcDatabaseContainer<?> newOracleContainer() {
        return OracleTestUtility.newOracleContainer("23.5-slim-faststart");
    }

    private static OracleContainer newOracleContainer(String version) {
        DockerImageName imageName = DockerImageName.parse((String)"gvenzl/oracle-free").asCompatibleSubstituteFor("gvenzl/oracle-xe");
        class OracleFreeContainer
        extends OracleContainer {
            OracleFreeContainer(DockerImageName dockerImageName) {
                super(dockerImageName);
                ArrayList<Integer> ports = new ArrayList<Integer>();
                ports.add(1521);
                this.setExposedPorts(ports);
                this.waitStrategy = new LogMessageWaitStrategy().withRegEx(".*DATABASE IS READY TO USE!.*\\s").withTimes(1).withStartupTimeout(Duration.ofMinutes(5L));
            }

            public String getDatabaseName() {
                return "freepdb1";
            }
        }
        return (OracleContainer)new OracleFreeContainer(imageName.withTag(version)).withStartupTimeout(Duration.ofMinutes(5L));
    }

    private OracleTestUtility() {
    }
}

