/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.catalogloader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.tools.catalogloader.BaseCatalogLoader;
import schemacrawler.tools.catalogloader.CatalogLoader;
import schemacrawler.tools.options.Config;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.property.PropertyName;
import us.fatehi.utility.string.StringFormat;

public class ChainedCatalogLoader
extends BaseCatalogLoader
implements Iterable<CatalogLoader> {
    private static final Logger LOGGER = Logger.getLogger(ChainedCatalogLoader.class.getName());
    private final List<CatalogLoader> chainedCatalogLoaders;

    public ChainedCatalogLoader(List<CatalogLoader> chainedCatalogLoaders) {
        super(new PropertyName("chainloader", "Chain of all catalog loaders, called in turn by priority"), Integer.MIN_VALUE);
        Objects.requireNonNull(chainedCatalogLoaders);
        this.chainedCatalogLoaders = new ArrayList<CatalogLoader>(chainedCatalogLoaders);
    }

    @Override
    public Iterator<CatalogLoader> iterator() {
        return this.chainedCatalogLoaders.iterator();
    }

    @Override
    public void loadCatalog() {
        Catalog catalog = null;
        DatabaseConnectionSource dataSource = this.getDataSource();
        SchemaCrawlerOptions schemaCrawlerOptions = this.getSchemaCrawlerOptions();
        SchemaRetrievalOptions schemaRetrievalOptions = this.getSchemaRetrievalOptions();
        Config additionalConfig = this.getAdditionalConfiguration();
        for (CatalogLoader nextCatalogLoader : this.chainedCatalogLoaders) {
            LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Loading catalog with <%s>", new Object[]{nextCatalogLoader.getClass()}));
            nextCatalogLoader.setCatalog(catalog);
            nextCatalogLoader.setDataSource(dataSource);
            nextCatalogLoader.setSchemaCrawlerOptions(schemaCrawlerOptions);
            nextCatalogLoader.setSchemaRetrievalOptions(schemaRetrievalOptions);
            nextCatalogLoader.setAdditionalConfiguration(additionalConfig);
            nextCatalogLoader.loadCatalog();
            catalog = nextCatalogLoader.getCatalog();
        }
        this.setCatalog(catalog);
    }

    public String toString() {
        return "CatalogLoader [" + this.chainedCatalogLoaders + "]";
    }
}

