/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import java.rmi.RemoteException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.server.LongRunningTask;
import org.jetbrains.idea.maven.server.LongRunningTaskStatus;
import org.jetbrains.idea.maven.server.MavenRemoteObject;
import org.jetbrains.idea.maven.server.MavenServerConsoleIndicatorImpl;
import org.jetbrains.idea.maven.server.MavenServerConsoleIndicatorWrapper;
import org.jetbrains.idea.maven.server.MavenServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerUtil;
import org.jetbrains.idea.maven.server.security.MavenToken;

public abstract class MavenServerEmbeddedBase
extends MavenRemoteObject
implements MavenServerEmbedder {
    private final Map<String, LongRunningTaskImpl> myLongRunningTasks = new ConcurrentHashMap<String, LongRunningTaskImpl>();

    @Override
    @NotNull
    public LongRunningTaskStatus getLongRunningTaskStatus(@NotNull String longRunningTaskId, MavenToken token) {
        if (longRunningTaskId == null) {
            MavenServerEmbeddedBase.$$$reportNull$$$0(0);
        }
        MavenServerUtil.checkToken(token);
        LongRunningTaskImpl task = this.myLongRunningTasks.get(longRunningTaskId);
        if (null == task) {
            LongRunningTaskStatus longRunningTaskStatus = LongRunningTaskStatus.EMPTY;
            if (longRunningTaskStatus == null) {
                MavenServerEmbeddedBase.$$$reportNull$$$0(1);
            }
            return longRunningTaskStatus;
        }
        return new LongRunningTaskStatus(task.getTotalRequests(), task.getFinishedRequests(), task.getIndicator().pullConsoleEvents(), task.getIndicator().pullDownloadEvents());
    }

    @Override
    public boolean cancelLongRunningTask(@NotNull String longRunningTaskId, MavenToken token) throws RemoteException {
        if (longRunningTaskId == null) {
            MavenServerEmbeddedBase.$$$reportNull$$$0(2);
        }
        MavenServerUtil.checkToken(token);
        LongRunningTask task = this.myLongRunningTasks.get(longRunningTaskId);
        if (null == task) {
            return false;
        }
        task.cancel();
        return true;
    }

    @NotNull
    protected LongRunningTask newLongRunningTask(@NotNull String id, int totalRequests, @NotNull MavenServerConsoleIndicatorWrapper indicatorWrapper) {
        if (id == null) {
            MavenServerEmbeddedBase.$$$reportNull$$$0(3);
        }
        if (indicatorWrapper == null) {
            MavenServerEmbeddedBase.$$$reportNull$$$0(4);
        }
        return new LongRunningTaskImpl(id, totalRequests, indicatorWrapper);
    }

    @Override
    public boolean ping(MavenToken token) throws RemoteException {
        MavenServerUtil.checkToken(token);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "longRunningTaskId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/MavenServerEmbeddedBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicatorWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/MavenServerEmbeddedBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLongRunningTaskStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLongRunningTaskStatus";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "cancelLongRunningTask";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "newLongRunningTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class LongRunningTaskImpl
    implements LongRunningTask {
        @NotNull
        private final String myId;
        private final AtomicInteger myFinishedRequests;
        private final AtomicInteger myTotalRequests;
        private final AtomicBoolean isCanceled;
        @NotNull
        private final MavenServerConsoleIndicatorImpl myIndicator;
        @NotNull
        private final MavenServerConsoleIndicatorWrapper myIndicatorWrapper;

        public LongRunningTaskImpl(String id, @NotNull int totalRequests, MavenServerConsoleIndicatorWrapper indicatorWrapper) {
            if (id == null) {
                LongRunningTaskImpl.$$$reportNull$$$0(0);
            }
            if (indicatorWrapper == null) {
                LongRunningTaskImpl.$$$reportNull$$$0(1);
            }
            this.myFinishedRequests = new AtomicInteger(0);
            this.isCanceled = new AtomicBoolean(false);
            this.myId = id;
            this.myTotalRequests = new AtomicInteger(totalRequests);
            this.myIndicator = new MavenServerConsoleIndicatorImpl();
            this.myIndicatorWrapper = indicatorWrapper;
            this.myIndicatorWrapper.setWrappee(this.myIndicator);
            MavenServerEmbeddedBase.this.myLongRunningTasks.put(this.myId, this);
        }

        @Override
        public void incrementFinishedRequests() {
            this.myFinishedRequests.incrementAndGet();
        }

        @Override
        public int getFinishedRequests() {
            return this.myFinishedRequests.get();
        }

        @Override
        public int getTotalRequests() {
            return this.myTotalRequests.get();
        }

        @Override
        public void updateTotalRequests(int newValue) {
            this.myTotalRequests.set(newValue);
        }

        @Override
        public void cancel() {
            this.isCanceled.set(true);
        }

        @Override
        public boolean isCanceled() {
            return this.isCanceled.get();
        }

        @Override
        public void close() {
            MavenServerEmbeddedBase.this.myLongRunningTasks.remove(this.myId);
            this.myIndicatorWrapper.setWrappee(null);
        }

        @Override
        public MavenServerConsoleIndicatorImpl getIndicator() {
            return this.myIndicator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "id";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "indicatorWrapper";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/server/MavenServerEmbeddedBase$LongRunningTaskImpl";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

