/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants.evaluate;

import com.intellij.psi.tree.IElementType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.CompileTimeType;
import org.jetbrains.kotlin.resolve.constants.evaluate.OperationsMapGeneratedKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.utils.exceptions.PlatformExceptionUtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\u001a \u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a \u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0007\u001a\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0002\u001a\u000e\u0010\u0012\u001a\u00020\f*\u0006\u0012\u0002\b\u00030\u0005\u001a\u000e\u0010\u0012\u001a\u00020\f*\u0006\u0012\u0002\b\u00030\u0013\u001a\u0012\u0010\u0014\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0007H\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0002\u001a \u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0007\u001a0\u0010\u001b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u00072\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002\u001a0\u0010 \u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u0007\u001a@\u0010%\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010&\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u00072\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002\"\u0019\u0010\u0000\u001a\r\u0012\t\u0012\u00070\u0002\u00a2\u0006\u0002\b\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"DIVISION_OPERATION_NAMES", "", "", "Lkotlin/jvm/internal/EnhancedNullability;", "createCompileTimeConstantForEquals", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "result", "", "operationReference", "Lorg/jetbrains/kotlin/psi/KtExpression;", "createCompileTimeConstantForCompareTo", "isIntegerType", "", "value", "getReceiverExpressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "isStandaloneOnlyConstant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "isZero", "typeStrToCompileTimeType", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "str", "evaluateUnary", "name", "typeStr", "evaluateUnaryAndCheck", "type", "reportIntegerOverflow", "Lkotlin/Function0;", "", "evaluateBinary", "receiverTypeStr", "receiverValue", "parameterTypeStr", "parameterValue", "evaluateBinaryAndCheck", "receiverType", "parameterType", "frontend"})
@SourceDebugExtension(value={"SMAP\nConstantExpressionEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstantExpressionEvaluator.kt\norg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1293:1\n1#2:1294\n1563#3:1295\n1634#3,3:1296\n*S KotlinDebug\n*F\n+ 1 ConstantExpressionEvaluator.kt\norg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorKt\n*L\n385#1:1295\n385#1:1296,3\n*E\n"})
public final class ConstantExpressionEvaluatorKt {
    @NotNull
    private static final Set<String> DIVISION_OPERATION_NAMES;

    private static final ConstantValue<?> createCompileTimeConstantForEquals(Object result, KtExpression operationReference) {
        if (result instanceof Boolean) {
            boolean bl;
            boolean bl2 = operationReference instanceof KtSimpleNameExpression;
            if (_Assertions.ENABLED && !bl2) {
                boolean $i$a$-assert-ConstantExpressionEvaluatorKt$createCompileTimeConstantForEquals$22 = false;
                String $i$a$-assert-ConstantExpressionEvaluatorKt$createCompileTimeConstantForEquals$22 = "This method should be called only for equals operations";
                throw new AssertionError((Object)$i$a$-assert-ConstantExpressionEvaluatorKt$createCompileTimeConstantForEquals$22);
            }
            Intrinsics.checkNotNull((Object)operationReference, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSimpleNameExpression");
            IElementType operationToken = ((KtSimpleNameExpression)operationReference).getReferencedNameElementType();
            if (Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.EQEQ)) {
                bl = (Boolean)result;
            } else if (Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.EXCLEQ)) {
                bl = !((Boolean)result).booleanValue();
            } else if (Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.IDENTIFIER)) {
                boolean bl3 = Intrinsics.areEqual((Object)((KtSimpleNameExpression)operationReference).getReferencedNameAsName(), (Object)OperatorNameConventions.EQUALS);
                if (_Assertions.ENABLED && !bl3) {
                    boolean bl4 = false;
                    String string = "This method should be called only for equals operations";
                    throw new AssertionError((Object)string);
                }
                bl = (Boolean)result;
            } else {
                throw new IllegalStateException("Unknown equals operation token: " + operationToken + ' ' + ((KtSimpleNameExpression)operationReference).getText());
            }
            boolean value = bl;
            return new BooleanValue(value);
        }
        return null;
    }

    private static final ConstantValue<?> createCompileTimeConstantForCompareTo(Object result, KtExpression operationReference) {
        if (result instanceof Integer) {
            ConstantValue constantValue;
            boolean bl = operationReference instanceof KtSimpleNameExpression;
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string = "This method should be called only for compareTo operations";
                throw new AssertionError((Object)string);
            }
            Intrinsics.checkNotNull((Object)operationReference, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSimpleNameExpression");
            IElementType operationToken = ((KtSimpleNameExpression)operationReference).getReferencedNameElementType();
            if (Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.LT)) {
                constantValue = new BooleanValue(((Number)result).intValue() < 0);
            } else if (Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.LTEQ)) {
                constantValue = new BooleanValue(((Number)result).intValue() <= 0);
            } else if (Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.GT)) {
                constantValue = new BooleanValue(((Number)result).intValue() > 0);
            } else if (Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.GTEQ)) {
                constantValue = new BooleanValue(((Number)result).intValue() >= 0);
            } else {
                if (Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.IDENTIFIER)) {
                    boolean bl3 = Intrinsics.areEqual((Object)((KtSimpleNameExpression)operationReference).getReferencedNameAsName(), (Object)OperatorNameConventions.COMPARE_TO);
                    if (_Assertions.ENABLED && !bl3) {
                        boolean bl4 = false;
                        String string = "This method should be called only for compareTo operations";
                        throw new AssertionError((Object)string);
                    }
                    return new IntValue(((Number)result).intValue());
                }
                throw new IllegalStateException("Unknown compareTo operation token: " + operationToken);
            }
            return constantValue;
        }
        return null;
    }

    public static final boolean isIntegerType(@Nullable Object value) {
        return value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long;
    }

    private static final KotlinType getReceiverExpressionType(ResolvedCall<?> resolvedCall2) {
        KotlinType kotlinType;
        switch (WhenMappings.$EnumSwitchMapping$0[resolvedCall2.getExplicitReceiverKind().ordinal()]) {
            case 1: {
                ReceiverValue receiverValue = resolvedCall2.getDispatchReceiver();
                Intrinsics.checkNotNull((Object)receiverValue);
                kotlinType = receiverValue.getType();
                break;
            }
            case 2: {
                ReceiverValue receiverValue = resolvedCall2.getExtensionReceiver();
                Intrinsics.checkNotNull((Object)receiverValue);
                kotlinType = receiverValue.getType();
                break;
            }
            case 3: {
                kotlinType = null;
                break;
            }
            case 4: {
                kotlinType = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return kotlinType;
    }

    public static final boolean isStandaloneOnlyConstant(@NotNull ConstantValue<?> $this$isStandaloneOnlyConstant) {
        Intrinsics.checkNotNullParameter($this$isStandaloneOnlyConstant, (String)"<this>");
        return $this$isStandaloneOnlyConstant instanceof KClassValue || $this$isStandaloneOnlyConstant instanceof EnumValue || $this$isStandaloneOnlyConstant instanceof AnnotationValue || $this$isStandaloneOnlyConstant instanceof ArrayValue;
    }

    public static final boolean isStandaloneOnlyConstant(@NotNull CompileTimeConstant<?> $this$isStandaloneOnlyConstant) {
        Intrinsics.checkNotNullParameter($this$isStandaloneOnlyConstant, (String)"<this>");
        if (!($this$isStandaloneOnlyConstant instanceof TypedCompileTimeConstant)) {
            return false;
        }
        return ConstantExpressionEvaluatorKt.isStandaloneOnlyConstant(((TypedCompileTimeConstant)$this$isStandaloneOnlyConstant).getConstantValue());
    }

    private static final boolean isZero(Object value) {
        boolean bl;
        if (ConstantExpressionEvaluatorKt.isIntegerType(value)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Number");
            bl = ((Number)value).longValue() == 0L;
        } else {
            bl = value instanceof Float || value instanceof Double ? ((Number)value).doubleValue() == 0.0 : false;
        }
        return bl;
    }

    private static final CompileTimeType typeStrToCompileTimeType(String str) {
        CompileTimeType compileTimeType;
        switch (str) {
            case "Byte": {
                compileTimeType = CompileTimeType.BYTE;
                break;
            }
            case "Short": {
                compileTimeType = CompileTimeType.SHORT;
                break;
            }
            case "Int": {
                compileTimeType = CompileTimeType.INT;
                break;
            }
            case "Long": {
                compileTimeType = CompileTimeType.LONG;
                break;
            }
            case "Double": {
                compileTimeType = CompileTimeType.DOUBLE;
                break;
            }
            case "Float": {
                compileTimeType = CompileTimeType.FLOAT;
                break;
            }
            case "Char": {
                compileTimeType = CompileTimeType.CHAR;
                break;
            }
            case "Boolean": {
                compileTimeType = CompileTimeType.BOOLEAN;
                break;
            }
            case "String": {
                compileTimeType = CompileTimeType.STRING;
                break;
            }
            case "Any": {
                compileTimeType = CompileTimeType.ANY;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + str);
            }
        }
        return compileTimeType;
    }

    @Nullable
    public static final Object evaluateUnary(@NotNull String name, @NotNull String typeStr, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)typeStr, (String)"typeStr");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return OperationsMapGeneratedKt.evalUnaryOp((String)name, (CompileTimeType)ConstantExpressionEvaluatorKt.typeStrToCompileTimeType(typeStr), (Object)value);
    }

    private static final Object evaluateUnaryAndCheck(String name, CompileTimeType type, Object value, Function0<Unit> reportIntegerOverflow) {
        Object object;
        Object result = object = OperationsMapGeneratedKt.evalUnaryOp((String)name, (CompileTimeType)type, (Object)value);
        boolean bl = false;
        if (ConstantExpressionEvaluatorKt.isIntegerType(value) && (Intrinsics.areEqual((Object)name, (Object)"minus") || Intrinsics.areEqual((Object)name, (Object)"unaryMinus")) && Intrinsics.areEqual((Object)value, (Object)result) && !ConstantExpressionEvaluatorKt.isZero(value)) {
            reportIntegerOverflow.invoke();
        }
        return object;
    }

    @Nullable
    public static final Object evaluateBinary(@NotNull String name, @NotNull String receiverTypeStr, @NotNull Object receiverValue, @NotNull String parameterTypeStr, @NotNull Object parameterValue) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)receiverTypeStr, (String)"receiverTypeStr");
        Intrinsics.checkNotNullParameter((Object)receiverValue, (String)"receiverValue");
        Intrinsics.checkNotNullParameter((Object)parameterTypeStr, (String)"parameterTypeStr");
        Intrinsics.checkNotNullParameter((Object)parameterValue, (String)"parameterValue");
        CompileTimeType receiverType = ConstantExpressionEvaluatorKt.typeStrToCompileTimeType(receiverTypeStr);
        CompileTimeType parameterType = ConstantExpressionEvaluatorKt.typeStrToCompileTimeType(parameterTypeStr);
        try {
            object = OperationsMapGeneratedKt.evalBinaryOp((String)name, (CompileTimeType)receiverType, (Object)receiverValue, (CompileTimeType)parameterType, (Object)parameterValue);
        }
        catch (Exception e) {
            PlatformExceptionUtilsKt.rethrowIntellijPlatformExceptionIfNeeded((Throwable)e);
            object = null;
        }
        return object;
    }

    private static final Object evaluateBinaryAndCheck(String name, CompileTimeType receiverType, Object receiverValue, CompileTimeType parameterType, Object parameterValue, Function0<Unit> reportIntegerOverflow) {
        Object object;
        try {
            object = OperationsMapGeneratedKt.evalBinaryOp((String)name, (CompileTimeType)receiverType, (Object)receiverValue, (CompileTimeType)parameterType, (Object)parameterValue);
        }
        catch (Exception e) {
            PlatformExceptionUtilsKt.rethrowIntellijPlatformExceptionIfNeeded((Throwable)e);
            object = null;
        }
        Object actualResult = object;
        if (actualResult != null && ConstantExpressionEvaluatorKt.isIntegerType(receiverValue) && ConstantExpressionEvaluatorKt.isIntegerType(parameterValue)) {
            BigInteger bigInteger = ConstantExpressionEvaluatorKt.evaluateBinaryAndCheck$toBigInteger(receiverValue);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"evaluateBinaryAndCheck$toBigInteger(...)");
            BigInteger bigInteger2 = ConstantExpressionEvaluatorKt.evaluateBinaryAndCheck$toBigInteger(parameterValue);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"evaluateBinaryAndCheck$toBigInteger(...)");
            BigInteger checkedResult = OperationsMapGeneratedKt.checkBinaryOp((String)name, (CompileTimeType)receiverType, (BigInteger)bigInteger, (CompileTimeType)parameterType, (BigInteger)bigInteger2);
            if (checkedResult != null && !Intrinsics.areEqual((Object)ConstantExpressionEvaluatorKt.evaluateBinaryAndCheck$toBigInteger(actualResult), (Object)checkedResult)) {
                reportIntegerOverflow.invoke();
            }
        }
        return actualResult;
    }

    private static final BigInteger evaluateBinaryAndCheck$toBigInteger(Object value) {
        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Number");
        return BigInteger.valueOf(((Number)value).longValue());
    }

    public static final /* synthetic */ ConstantValue access$createCompileTimeConstantForCompareTo(Object result, KtExpression operationReference) {
        return ConstantExpressionEvaluatorKt.createCompileTimeConstantForCompareTo(result, operationReference);
    }

    public static final /* synthetic */ ConstantValue access$createCompileTimeConstantForEquals(Object result, KtExpression operationReference) {
        return ConstantExpressionEvaluatorKt.createCompileTimeConstantForEquals(result, operationReference);
    }

    public static final /* synthetic */ Object access$evaluateUnaryAndCheck(String name, CompileTimeType type, Object value, Function0 reportIntegerOverflow) {
        return ConstantExpressionEvaluatorKt.evaluateUnaryAndCheck(name, type, value, (Function0<Unit>)reportIntegerOverflow);
    }

    public static final /* synthetic */ Object access$evaluateBinaryAndCheck(String name, CompileTimeType receiverType, Object receiverValue, CompileTimeType parameterType, Object parameterValue, Function0 reportIntegerOverflow) {
        return ConstantExpressionEvaluatorKt.evaluateBinaryAndCheck(name, receiverType, receiverValue, parameterType, parameterValue, (Function0<Unit>)reportIntegerOverflow);
    }

    public static final /* synthetic */ Set access$getDIVISION_OPERATION_NAMES$p() {
        return DIVISION_OPERATION_NAMES;
    }

    public static final /* synthetic */ boolean access$isZero(Object value) {
        return ConstantExpressionEvaluatorKt.isZero(value);
    }

    public static final /* synthetic */ KotlinType access$getReceiverExpressionType(ResolvedCall resolvedCall2) {
        return ConstantExpressionEvaluatorKt.getReceiverExpressionType(resolvedCall2);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Object[] objectArray = new Name[]{OperatorNameConventions.DIV, OperatorNameConventions.REM};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Name name = (Name)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.asString());
        }
        DIVISION_OPERATION_NAMES = CollectionsKt.toSet((Iterable)((List)var3_3));
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExplicitReceiverKind.values().length];
            try {
                nArray[ExplicitReceiverKind.DISPATCH_RECEIVER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExplicitReceiverKind.EXTENSION_RECEIVER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExplicitReceiverKind.NO_EXPLICIT_RECEIVER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExplicitReceiverKind.BOTH_RECEIVERS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

