/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.nrl;

import com.thaiopensource.validate.nrl.IntSet;
import org.xml.sax.Attributes;

class FilteredAttributes
implements Attributes {
    private final Attributes attributes;
    private final IntSet indexSet;
    private int[] reverseIndexMap;

    public FilteredAttributes(IntSet intSet, Attributes attributes) {
        this.indexSet = intSet;
        this.attributes = attributes;
    }

    private int reverseIndex(int n) {
        if (this.reverseIndexMap == null) {
            this.reverseIndexMap = new int[this.attributes.getLength()];
            int n2 = 0;
            int n3 = this.indexSet.size();
            while (n2 < n3) {
                this.reverseIndexMap[this.indexSet.get((int)n2)] = n2 + 1;
                ++n2;
            }
        }
        return this.reverseIndexMap[n] - 1;
    }

    public int getLength() {
        return this.indexSet.size();
    }

    public String getURI(int n) {
        if (n < 0 || n >= this.indexSet.size()) {
            return null;
        }
        return this.attributes.getURI(this.indexSet.get(n));
    }

    public String getLocalName(int n) {
        if (n < 0 || n >= this.indexSet.size()) {
            return null;
        }
        return this.attributes.getLocalName(this.indexSet.get(n));
    }

    public String getQName(int n) {
        if (n < 0 || n >= this.indexSet.size()) {
            return null;
        }
        return this.attributes.getQName(this.indexSet.get(n));
    }

    public String getType(int n) {
        if (n < 0 || n >= this.indexSet.size()) {
            return null;
        }
        return this.attributes.getType(this.indexSet.get(n));
    }

    public String getValue(int n) {
        if (n < 0 || n >= this.indexSet.size()) {
            return null;
        }
        return this.attributes.getValue(this.indexSet.get(n));
    }

    public int getIndex(String string, String string2) {
        int n = this.attributes.getIndex(string, string2);
        if (n < 0) {
            return n;
        }
        return this.reverseIndex(n);
    }

    public int getIndex(String string) {
        int n = this.attributes.getIndex(string);
        if (n < 0) {
            return n;
        }
        return this.reverseIndex(n);
    }

    private int getRealIndex(String string, String string2) {
        int n = this.attributes.getIndex(string, string2);
        if (n < 0 || this.reverseIndex(n) < 0) {
            return -1;
        }
        return n;
    }

    private int getRealIndex(String string) {
        int n = this.attributes.getIndex(string);
        if (n < 0 || this.reverseIndex(n) < 0) {
            return -1;
        }
        return n;
    }

    public String getType(String string, String string2) {
        return this.attributes.getType(this.getRealIndex(string, string2));
    }

    public String getValue(String string, String string2) {
        return this.attributes.getValue(this.getRealIndex(string, string2));
    }

    public String getType(String string) {
        return this.attributes.getType(this.getRealIndex(string));
    }

    public String getValue(String string) {
        return this.attributes.getValue(this.getRealIndex(string));
    }
}

