/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ml.tools.model.catboostOld;

import com.jetbrains.ml.tools.model.catboostOld.Feature;
import com.jetbrains.ml.tools.model.catboostOld.FeatureMapper;
import com.jetbrains.ml.tools.model.catboostOld.InconsistentMetadataException;
import com.jetbrains.ml.tools.model.catboostOld.UndefinedMapper;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0003\u0019\u001a\u001bB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\b\u0010\u0017\u001a\u00020\u000fH\u0002J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/ml/tools/model/catboostOld/CategoricalFeature;", "Lcom/jetbrains/ml/tools/model/catboostOld/Feature;", "name", "", "categories", "", "(Ljava/lang/String;Ljava/util/Set;)V", "getCategories", "()Ljava/util/Set;", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "createMapper", "Lcom/jetbrains/ml/tools/model/catboostOld/FeatureMapper;", "suffix", "equals", "", "other", "", "hashCode", "", "otherCategoryMapper", "toString", "CategoryMapper", "Companion", "OtherCategoryMapper", "ml-tools"})
public final class CategoricalFeature
extends Feature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final Set<String> categories;
    @NotNull
    public static final String OTHER = "OTHER";

    public CategoricalFeature(@NotNull String name, @NotNull Set<String> categories) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(categories, (String)"categories");
        super(null);
        this.name = name;
        this.categories = categories;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final Set<String> getCategories() {
        return this.categories;
    }

    @Override
    @NotNull
    public FeatureMapper createMapper(@Nullable String suffix) {
        FeatureMapper featureMapper;
        String string = suffix;
        if (Intrinsics.areEqual((Object)string, (Object)"UNDEFINED")) {
            featureMapper = UndefinedMapper.Companion.checkAndCreate(this.getName(), this.categories.contains("UNDEFINED"));
        } else if (Intrinsics.areEqual((Object)string, (Object)OTHER)) {
            featureMapper = this.otherCategoryMapper();
        } else {
            if (string == null) {
                throw new InconsistentMetadataException("Categorical feature usage must have suffix");
            }
            if (!this.categories.contains(suffix)) {
                throw new InconsistentMetadataException("Unknown category '" + suffix + "' of categorical feature '" + this.getName() + "'");
            }
            String string2 = suffix.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            featureMapper = new CategoryMapper(string2);
        }
        return featureMapper;
    }

    private final FeatureMapper otherCategoryMapper() {
        if (!this.categories.contains(OTHER)) {
            throw new InconsistentMetadataException("Feature " + this.getName() + " does not allow other category");
        }
        Object[] objectArray = new String[]{"UNDEFINED", OTHER};
        return new OtherCategoryMapper(this.getName(), SetsKt.minus(this.categories, (Iterable)CollectionsKt.listOf((Object[])objectArray)));
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final Set<String> component2() {
        return this.categories;
    }

    @NotNull
    public final CategoricalFeature copy(@NotNull String name, @NotNull Set<String> categories) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(categories, (String)"categories");
        return new CategoricalFeature(name, categories);
    }

    public static /* synthetic */ CategoricalFeature copy$default(CategoricalFeature categoricalFeature, String string, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            string = categoricalFeature.name;
        }
        if ((n & 2) != 0) {
            set = categoricalFeature.categories;
        }
        return categoricalFeature.copy(string, set);
    }

    @NotNull
    public String toString() {
        return "CategoricalFeature(name=" + this.name + ", categories=" + this.categories + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + ((Object)this.categories).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CategoricalFeature)) {
            return false;
        }
        CategoricalFeature categoricalFeature = (CategoricalFeature)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)categoricalFeature.name)) {
            return false;
        }
        return Intrinsics.areEqual(this.categories, categoricalFeature.categories);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/jetbrains/ml/tools/model/catboostOld/CategoricalFeature$CategoryMapper;", "Lcom/jetbrains/ml/tools/model/catboostOld/FeatureMapper;", "category", "", "(Lcom/jetbrains/ml/tools/model/catboostOld/CategoricalFeature;Ljava/lang/String;)V", "featureName", "getFeatureName", "()Ljava/lang/String;", "asArrayValue", "", "value", "", "ml-tools"})
    private final class CategoryMapper
    implements FeatureMapper {
        @NotNull
        private final String category;
        @NotNull
        private final String featureName;

        public CategoryMapper(String category) {
            Intrinsics.checkNotNullParameter((Object)category, (String)"category");
            this.category = category;
            this.featureName = CategoricalFeature.this.getName();
        }

        @Override
        @NotNull
        public String getFeatureName() {
            return this.featureName;
        }

        @Override
        public double asArrayValue(@Nullable Object value) {
            if (value == null) {
                return 0.0;
            }
            String string = value.toString().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            return Intrinsics.areEqual((Object)string, (Object)this.category) ? 1.0 : 0.0;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/ml/tools/model/catboostOld/CategoricalFeature$Companion;", "", "()V", "OTHER", "", "ml-tools"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/ml/tools/model/catboostOld/CategoricalFeature$OtherCategoryMapper;", "Lcom/jetbrains/ml/tools/model/catboostOld/FeatureMapper;", "name", "", "knownCategories", "", "(Ljava/lang/String;Ljava/util/Set;)V", "featureName", "getFeatureName", "()Ljava/lang/String;", "asArrayValue", "", "value", "", "ml-tools"})
    private static final class OtherCategoryMapper
    implements FeatureMapper {
        @NotNull
        private final String name;
        @NotNull
        private final Set<String> knownCategories;
        @NotNull
        private final String featureName;

        public OtherCategoryMapper(@NotNull String name, @NotNull Set<String> knownCategories) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(knownCategories, (String)"knownCategories");
            this.name = name;
            this.knownCategories = knownCategories;
            this.featureName = this.name;
        }

        @Override
        @NotNull
        public String getFeatureName() {
            return this.featureName;
        }

        @Override
        public double asArrayValue(@Nullable Object value) {
            return value == null || this.knownCategories.contains(value.toString()) ? 0.0 : 1.0;
        }
    }
}

