/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.mapping.AliasConstraint;
import gnu.mapping.Constraint;
import gnu.mapping.Environment;
import gnu.mapping.Location;
import gnu.mapping.Named;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.mapping.TrivialConstraint;
import gnu.mapping.UnboundSymbol;
import gnu.mapping.WrappedException;
import java.lang.reflect.Field;

public class ClassMemberConstraint
extends Constraint {
    ClassType type;
    String name;
    Field rfield;

    public ClassMemberConstraint(ClassType classType, String string) {
        this.type = classType;
        this.name = string;
    }

    public ClassMemberConstraint(Class clazz, String string) {
        this.type = (ClassType)Type.make(clazz);
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public ClassType getDeclaringClass() {
        return this.type;
    }

    public ClassMemberConstraint(Field field) {
        this.rfield = field;
        this.name = field.getName();
    }

    void setup(Symbol symbol) {
        if (this.rfield == null) {
            Class clazz;
            try {
                clazz = this.type.getReflectClass();
            }
            catch (RuntimeException runtimeException) {
                String string = symbol.getName();
                throw new UnboundSymbol(string, "Unbound symbol " + string + " - " + runtimeException.toString());
            }
            try {
                this.rfield = clazz.getField(this.name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                String string = symbol.getName();
                throw new UnboundSymbol(string, "Unbound symbol " + string + " - no field " + this.name + " in " + this.type.getName());
            }
        }
    }

    public Object get(Symbol symbol, Object object2) {
        if (this.rfield == null) {
            Class clazz;
            try {
                clazz = this.type.getReflectClass();
            }
            catch (RuntimeException runtimeException) {
                return object2;
            }
            try {
                this.rfield = clazz.getField(this.name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                return object2;
            }
        }
        try {
            return this.rfield.get(ClassMemberConstraint.getValue(symbol));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new WrappedException(illegalAccessException);
        }
    }

    public void set(Symbol symbol, Object object2) {
        this.setup(symbol);
        try {
            this.rfield.set(ClassMemberConstraint.getValue(symbol), object2);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            ClassMemberConstraint.setConstraint(symbol, new TrivialConstraint(this.getEnvironment(symbol)));
            ClassMemberConstraint.setValue(symbol, object2);
            return;
        }
    }

    public static void define(String string, Object object2, String string2) {
        ClassMemberConstraint.define(string, object2, string2, Environment.getCurrent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void define(String string, Object object2, String string2, Environment environment) {
        Symbol symbol;
        Symbol symbol2 = symbol = environment.getSymbol(string);
        synchronized (symbol2) {
            ClassMemberConstraint.setValue(symbol, object2);
            ClassMemberConstraint.setConstraint(symbol, new ClassMemberConstraint(object2.getClass(), string2));
        }
    }

    public static void define(String object2, Object object3, Field field, Environment environment) {
        if ((field.getModifiers() & 0x10) != 0) {
            try {
                Object object4;
                Object object5 = field.get(object3);
                if (field.getType().getName() == "gnu.mapping.Location") {
                    object2 = Compilation.demangleName((String)object2, true).intern();
                    Symbol symbol = environment.getSymbol((String)object2);
                    AliasConstraint.define(symbol, (Location)object5);
                    return;
                }
                if (object5 instanceof Symbol) {
                    environment.addSymbol((Symbol)object5);
                    return;
                }
                if (object5 instanceof Procedure && (object4 = ((Procedure)object5).getSymbol()) instanceof Symbol) {
                    ((Symbol)object4).setFunctionValue(object5);
                    return;
                }
                object4 = object5 instanceof Named ? ((Named)object5).getName() : null;
                object2 = object4 != null ? object4 : Compilation.demangleName((String)object2, true);
                object2 = ((String)object2).intern();
                environment.define((String)object2, object5);
                return;
            }
            catch (Exception exception) {
                throw new WrappedException("error accessing field " + field, exception);
            }
        }
        Symbol symbol = new Symbol(Compilation.demangleName((String)object2, true).intern());
        ClassMemberConstraint.setValue(symbol, object3);
        ClassMemberConstraint.setConstraint(symbol, new ClassMemberConstraint(field));
        environment.addSymbol(symbol);
    }

    public static void defineAll(Object object2, Environment environment) {
        Class<?> clazz = object2.getClass();
        Field[] fieldArray = clazz.getFields();
        int n = fieldArray.length;
        while (--n >= 0) {
            Field field = fieldArray[n];
            ClassMemberConstraint.define(field.getName(), object2, field, environment);
        }
    }
}

