// re2rust $INPUT -o $OUTPUT --header lexer/state.rs

mod lexer;
use lexer::state::State; // the module is generated by re2c

/*!header:re2c:on*/
pub struct State<'a> {
    pub str: &'a [u8],
    pub cur: usize,
    /*!stags:re2c format = "pub @@: usize,"; */
}
/*!header:re2c:off*/

fn lex(st: &mut State) -> usize {
    let t: usize;
    /*!re2c
        re2c:header = "lexer/state.rs";
        re2c:yyfill:enable = 0;
        re2c:define:YYCTYPE = "u8";
        re2c:define:YYPEEK  = "*st.str.get_unchecked(st.cur)";
        re2c:define:YYSKIP  = "st.cur += 1;";
        re2c:define:YYSTAGP = "@@ = st.cur;";
        re2c:tags = 1;
        re2c:tags:expression = "st.@@";

        [a]* @t [b]* { return t; }
    */
}

fn main() {
    let mut st = State {
        str: b"ab\0",
        cur: 0,
        /*!stags:re2c format = "@@: 0,"; */
    };
    assert_eq!(lex(&mut st), 1);
}
