/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.runtime;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DocumentSequence;
import com.xmlcalabash.io.Pipe;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.model.Log;
import com.xmlcalabash.model.Output;
import java.util.Vector;
import net.sf.saxon.s9api.XdmNode;

public class XOutput {
    private DocumentSequence documents = null;
    private XProcRuntime runtime = null;
    private String port = null;
    private XdmNode node = null;
    private boolean sequenceOk = false;
    private WritablePipe writer = null;
    private WritablePipe inputWriter = null;
    private Vector<ReadablePipe> readers = null;

    public XOutput(XProcRuntime xProcRuntime, Output output) {
        this.runtime = xProcRuntime;
        this.node = output.getNode();
        this.port = output.getPort();
        this.sequenceOk = output.getSequence();
        this.documents = new DocumentSequence(xProcRuntime);
        this.readers = new Vector();
    }

    public void setLogger(Log log) {
        this.documents.setLogger(log);
    }

    public XdmNode getNode() {
        return this.node;
    }

    public String getPort() {
        return this.port;
    }

    public boolean getSequence() {
        return this.sequenceOk;
    }

    public ReadablePipe getReader() {
        Pipe pipe = new Pipe(this.runtime, this.documents);
        this.readers.add(pipe);
        return pipe;
    }

    public WritablePipe getWriter() {
        if (this.writer != null) {
            throw new XProcException(this.node, "Attempt to create two writers for the same output.");
        }
        this.writer = this.inputWriter != null ? this.inputWriter : new Pipe(this.runtime, this.documents);
        this.writer.canWriteSequence(this.sequenceOk);
        return this.writer;
    }
}

