/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Stack;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.om.ValueRepresentation;

public class StackFrame {
    protected SlotManager map;
    protected ValueRepresentation[] slots;
    protected Stack<ValueRepresentation> dynamicStack;
    public static final StackFrame EMPTY = new StackFrame(SlotManager.EMPTY, ValueRepresentation.EMPTY_VALUE_ARRAY);

    public StackFrame(SlotManager map, ValueRepresentation[] slots) {
        this.map = map;
        this.slots = slots;
    }

    public SlotManager getStackFrameMap() {
        return this.map;
    }

    public ValueRepresentation[] getStackFrameValues() {
        return this.slots;
    }

    public void setStackFrameValues(ValueRepresentation[] values) {
        this.slots = values;
    }

    public StackFrame copy() {
        ValueRepresentation[] v2 = new ValueRepresentation[this.slots.length];
        System.arraycopy(this.slots, 0, v2, 0, this.slots.length);
        StackFrame s = new StackFrame(this.map, v2);
        if (this.dynamicStack != null) {
            s.dynamicStack = new Stack();
            s.dynamicStack.addAll(this.dynamicStack);
        }
        return s;
    }

    public void pushDynamicValue(ValueRepresentation value) {
        if (this.dynamicStack == null) {
            this.dynamicStack = new Stack();
        }
        this.dynamicStack.push(value);
    }

    public ValueRepresentation popDynamicValue() {
        return this.dynamicStack.pop();
    }
}

