// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "pdata/internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"go.opentelemetry.io/collector/pdata/internal"
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1experimental"
)

// Function describes a function, including its human-readable name, system name, source file, and starting line number in the source.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewFunction function to create new instances.
// Important: zero-initialized instance is not valid for use.
type Function struct {
	orig  *otlpprofiles.Function
	state *internal.State
}

func newFunction(orig *otlpprofiles.Function, state *internal.State) Function {
	return Function{orig: orig, state: state}
}

// NewFunction creates a new empty Function.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewFunction() Function {
	state := internal.StateMutable
	return newFunction(&otlpprofiles.Function{}, &state)
}

// MoveTo moves all properties from the current struct overriding the destination and
// resetting the current instance to its zero value
func (ms Function) MoveTo(dest Function) {
	ms.state.AssertMutable()
	dest.state.AssertMutable()
	*dest.orig = *ms.orig
	*ms.orig = otlpprofiles.Function{}
}

// ID returns the id associated with this Function.
func (ms Function) ID() uint64 {
	return ms.orig.Id
}

// SetID replaces the id associated with this Function.
func (ms Function) SetID(v uint64) {
	ms.state.AssertMutable()
	ms.orig.Id = v
}

// Name returns the name associated with this Function.
func (ms Function) Name() int64 {
	return ms.orig.Name
}

// SetName replaces the name associated with this Function.
func (ms Function) SetName(v int64) {
	ms.state.AssertMutable()
	ms.orig.Name = v
}

// SystemName returns the systemname associated with this Function.
func (ms Function) SystemName() int64 {
	return ms.orig.SystemName
}

// SetSystemName replaces the systemname associated with this Function.
func (ms Function) SetSystemName(v int64) {
	ms.state.AssertMutable()
	ms.orig.SystemName = v
}

// Filename returns the filename associated with this Function.
func (ms Function) Filename() int64 {
	return ms.orig.Filename
}

// SetFilename replaces the filename associated with this Function.
func (ms Function) SetFilename(v int64) {
	ms.state.AssertMutable()
	ms.orig.Filename = v
}

// StartLine returns the startline associated with this Function.
func (ms Function) StartLine() int64 {
	return ms.orig.StartLine
}

// SetStartLine replaces the startline associated with this Function.
func (ms Function) SetStartLine(v int64) {
	ms.state.AssertMutable()
	ms.orig.StartLine = v
}

// CopyTo copies all properties from the current struct overriding the destination.
func (ms Function) CopyTo(dest Function) {
	dest.state.AssertMutable()
	dest.SetID(ms.ID())
	dest.SetName(ms.Name())
	dest.SetSystemName(ms.SystemName())
	dest.SetFilename(ms.Filename())
	dest.SetStartLine(ms.StartLine())
}
