// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	networkv1 "github.com/openshift/api/network/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeHostSubnets implements HostSubnetInterface
type FakeHostSubnets struct {
	Fake *FakeNetworkV1
}

var hostsubnetsResource = schema.GroupVersionResource{Group: "network.openshift.io", Version: "v1", Resource: "hostsubnets"}

var hostsubnetsKind = schema.GroupVersionKind{Group: "network.openshift.io", Version: "v1", Kind: "HostSubnet"}

// Get takes name of the hostSubnet, and returns the corresponding hostSubnet object, and an error if there is any.
func (c *FakeHostSubnets) Get(ctx context.Context, name string, options v1.GetOptions) (result *networkv1.HostSubnet, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(hostsubnetsResource, name), &networkv1.HostSubnet{})
	if obj == nil {
		return nil, err
	}
	return obj.(*networkv1.HostSubnet), err
}

// List takes label and field selectors, and returns the list of HostSubnets that match those selectors.
func (c *FakeHostSubnets) List(ctx context.Context, opts v1.ListOptions) (result *networkv1.HostSubnetList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(hostsubnetsResource, hostsubnetsKind, opts), &networkv1.HostSubnetList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &networkv1.HostSubnetList{ListMeta: obj.(*networkv1.HostSubnetList).ListMeta}
	for _, item := range obj.(*networkv1.HostSubnetList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested hostSubnets.
func (c *FakeHostSubnets) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(hostsubnetsResource, opts))
}

// Create takes the representation of a hostSubnet and creates it.  Returns the server's representation of the hostSubnet, and an error, if there is any.
func (c *FakeHostSubnets) Create(ctx context.Context, hostSubnet *networkv1.HostSubnet, opts v1.CreateOptions) (result *networkv1.HostSubnet, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(hostsubnetsResource, hostSubnet), &networkv1.HostSubnet{})
	if obj == nil {
		return nil, err
	}
	return obj.(*networkv1.HostSubnet), err
}

// Update takes the representation of a hostSubnet and updates it. Returns the server's representation of the hostSubnet, and an error, if there is any.
func (c *FakeHostSubnets) Update(ctx context.Context, hostSubnet *networkv1.HostSubnet, opts v1.UpdateOptions) (result *networkv1.HostSubnet, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(hostsubnetsResource, hostSubnet), &networkv1.HostSubnet{})
	if obj == nil {
		return nil, err
	}
	return obj.(*networkv1.HostSubnet), err
}

// Delete takes name of the hostSubnet and deletes it. Returns an error if one occurs.
func (c *FakeHostSubnets) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteAction(hostsubnetsResource, name), &networkv1.HostSubnet{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeHostSubnets) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(hostsubnetsResource, listOpts)

	_, err := c.Fake.Invokes(action, &networkv1.HostSubnetList{})
	return err
}

// Patch applies the patch and returns the patched hostSubnet.
func (c *FakeHostSubnets) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *networkv1.HostSubnet, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(hostsubnetsResource, name, pt, data, subresources...), &networkv1.HostSubnet{})
	if obj == nil {
		return nil, err
	}
	return obj.(*networkv1.HostSubnet), err
}
