/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contentmodel.internal.modelqueryimpl;

import java.util.Collection;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAnyElement;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMAnyElementImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMAttributeDeclarationImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMDocumentImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMElementDeclarationImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMGroupImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMNamedNodeMapImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMNodeListImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMDescriptionBuilder;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class InferredGrammarFactory {
    public CMDocument createCMDocument(String uri) {
        CMDocumentImpl cmdocument = new CMDocumentImpl(uri);
        cmdocument.setInferred(true);
        return cmdocument;
    }

    public CMElementDeclaration createCMElementDeclaration(CMDocument cmDocument, Element element, boolean isLocal) {
        String localName = element.getLocalName();
        CMDocumentImpl cmDocumentImpl = (CMDocumentImpl)cmDocument;
        CMNamedNodeMapImpl elementMap = isLocal ? cmDocumentImpl.getLocalElementPool() : (CMNamedNodeMapImpl)cmDocumentImpl.getElements();
        CMElementDeclarationImpl ed = (CMElementDeclarationImpl)elementMap.getNamedItem(localName);
        if (ed == null) {
            ed = new CMElementDeclarationImpl(cmDocument, localName);
            ed.setInferred(true);
            ed.setLocal(isLocal);
            ed.setMaxOccur(1);
            CMGroupImpl group = new CMGroupImpl(new CMNodeListImpl(), 2);
            group.setInferred(true);
            group.setMinOccur(0);
            group.setMaxOccur(-1);
            ed.setContent(group);
            elementMap.put(ed);
        }
        NamedNodeMap attributeMap = element.getAttributes();
        int attributeMapLength = attributeMap.getLength();
        int i = 0;
        while (i < attributeMapLength) {
            Attr attr = (Attr)attributeMap.item(i);
            CMAttributeDeclarationImpl ad = (CMAttributeDeclarationImpl)ed.getAttributeMap().getNamedItem(attr.getNodeName());
            if (ad == null) {
                ad = new CMAttributeDeclarationImpl(attr.getNodeName(), 1);
                ad.setInferred(true);
                ed.getAttributeMap().put(ad);
            }
            ++i;
        }
        return ed;
    }

    public void createCMContent(CMDocument parentCMDocument, CMElementDeclaration parentEd, CMDocument childCMDocument, CMElementDeclaration childEd, boolean isLocal, String uri) {
        CMGroupImpl group = (CMGroupImpl)parentEd.getContent();
        CMNodeListImpl groupChildNodeList = (CMNodeListImpl)group.getChildNodes();
        if (parentCMDocument == childCMDocument) {
            if (!groupChildNodeList.contains(childEd)) {
                groupChildNodeList.add(childEd);
            }
            if (isLocal) {
                CMNamedNodeMapImpl localElementMap = (CMNamedNodeMapImpl)parentEd.getLocalElements();
                localElementMap.put(childEd);
            }
        } else {
            CMAnyElement cmAnyElement = this.lookupOrCreateCMAnyElement((CMDocumentImpl)parentCMDocument, uri);
            if (!groupChildNodeList.contains(cmAnyElement)) {
                groupChildNodeList.add(cmAnyElement);
            }
        }
    }

    protected CMAnyElement lookupOrCreateCMAnyElement(CMDocumentImpl parentCMDocument, String uri) {
        CMNamedNodeMapImpl anyElementMap = parentCMDocument.getAnyElements();
        CMAnyElementImpl anyElement = (CMAnyElementImpl)anyElementMap.getNamedItem(CMAnyElementImpl.computeNodeName(uri));
        if (anyElement == null) {
            anyElement = new CMAnyElementImpl(uri);
            anyElement.setInferred(true);
            anyElementMap.put(anyElement);
        }
        return anyElement;
    }

    public void debugPrint(Collection collection) {
        for (CMDocument cmDocument : collection) {
            System.out.println("-----------------------------------------------");
            System.out.println("cmDocument (" + String.valueOf(cmDocument.getProperty("http://org.eclipse.wst/cm/properties/targetNamespaceURI")) + ")");
            CMNamedNodeMapImpl elementMap = (CMNamedNodeMapImpl)cmDocument.getElements();
            int size = elementMap.getLength();
            int i = 0;
            while (i < size) {
                CMElementDeclaration ed = (CMElementDeclaration)elementMap.item(i);
                CMDescriptionBuilder builder = new CMDescriptionBuilder();
                System.out.println("  ELEMENT " + ed.getNodeName() + " = " + builder.buildDescription(ed));
                ++i;
            }
        }
    }
}

