/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.util.BufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetectorConnectionFactory
extends AbstractConnectionFactory
implements ConnectionFactory.Detecting {
    private static final Logger LOG = LoggerFactory.getLogger(DetectorConnectionFactory.class);
    private final List<ConnectionFactory.Detecting> _detectingConnectionFactories;

    public DetectorConnectionFactory(ConnectionFactory.Detecting ... detectingConnectionFactories) {
        super(DetectorConnectionFactory.toProtocolString(detectingConnectionFactories));
        this._detectingConnectionFactories = Arrays.asList(detectingConnectionFactories);
        for (ConnectionFactory.Detecting detectingConnectionFactory : detectingConnectionFactories) {
            this.installBean(detectingConnectionFactory);
        }
    }

    private static String toProtocolString(ConnectionFactory.Detecting ... detectingConnectionFactories) {
        if (detectingConnectionFactories.length == 0) {
            throw new IllegalArgumentException("At least one detecting instance is required");
        }
        LinkedHashSet protocols = Arrays.stream(detectingConnectionFactories).map(ConnectionFactory::getProtocol).collect(Collectors.toCollection(LinkedHashSet::new));
        String protocol = protocols.stream().collect(Collectors.joining("|", "[", "]"));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Detector generated protocol name : {}", (Object)protocol);
        }
        return protocol;
    }

    @Override
    public ConnectionFactory.Detecting.Detection detect(ByteBuffer buffer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Detector {} detecting from buffer {} using {}", new Object[]{this.getProtocol(), BufferUtil.toHexString((ByteBuffer)buffer), this._detectingConnectionFactories});
        }
        boolean needMoreBytes = true;
        for (ConnectionFactory.Detecting detectingConnectionFactory : this._detectingConnectionFactories) {
            ConnectionFactory.Detecting.Detection detection = detectingConnectionFactory.detect(buffer);
            if (detection == ConnectionFactory.Detecting.Detection.RECOGNIZED) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Detector {} recognized bytes using {}", (Object)this.getProtocol(), (Object)detection);
                }
                return ConnectionFactory.Detecting.Detection.RECOGNIZED;
            }
            needMoreBytes &= detection == ConnectionFactory.Detecting.Detection.NEED_MORE_BYTES;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Detector {} {}", (Object)this.getProtocol(), (Object)(needMoreBytes ? "requires more bytes" : "failed to recognize bytes"));
        }
        return needMoreBytes ? ConnectionFactory.Detecting.Detection.NEED_MORE_BYTES : ConnectionFactory.Detecting.Detection.NOT_RECOGNIZED;
    }

    protected static void upgradeToConnectionFactory(ConnectionFactory connectionFactory, Connector connector, EndPoint endPoint) throws IllegalStateException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Upgrading to connection factory {}", (Object)connectionFactory);
        }
        if (connectionFactory == null) {
            throw new IllegalStateException("Cannot upgrade: connection factory must not be null for " + String.valueOf(endPoint));
        }
        Connection nextConnection = connectionFactory.newConnection(connector, endPoint);
        if (!(nextConnection instanceof Connection.UpgradeTo)) {
            throw new IllegalStateException("Cannot upgrade: " + String.valueOf(nextConnection) + " does not implement " + Connection.UpgradeTo.class.getName() + " for " + String.valueOf(endPoint));
        }
        endPoint.upgrade(nextConnection);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Upgraded to connection factory {} and released buffer", (Object)connectionFactory);
        }
    }

    protected void nextProtocol(Connector connector, EndPoint endPoint, ByteBuffer buffer) throws IllegalStateException {
        String nextProtocol = this.findNextProtocol(connector);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Detector {} detection unsuccessful, found '{}' as the next protocol to upgrade to", (Object)this.getProtocol(), (Object)nextProtocol);
        }
        if (nextProtocol == null) {
            throw new IllegalStateException("Cannot find protocol following '" + this.getProtocol() + "' in connector's protocol list " + String.valueOf(connector.getProtocols()) + " for " + String.valueOf(endPoint));
        }
        DetectorConnectionFactory.upgradeToConnectionFactory(connector.getConnectionFactory(nextProtocol), connector, endPoint);
    }

    @Override
    public Connection newConnection(Connector connector, EndPoint endPoint) {
        return this.configure(new DetectorConnection(endPoint, connector), connector, endPoint);
    }

    private class DetectorConnection
    extends AbstractConnection.NonBlocking
    implements Connection.UpgradeFrom,
    Connection.UpgradeTo {
        private final Connector _connector;
        private final RetainableByteBuffer _buffer;

        private DetectorConnection(EndPoint endp, Connector connector) {
            super(endp, connector.getExecutor());
            this._connector = connector;
            this._buffer = connector.getByteBufferPool().acquire(this.getInputBufferSize(), true);
        }

        public void onUpgradeTo(ByteBuffer byteBuffer) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Detector {} adopting {}", (Object)DetectorConnectionFactory.this.getProtocol(), (Object)BufferUtil.toDetailString((ByteBuffer)byteBuffer));
            }
            BufferUtil.append((ByteBuffer)this._buffer.getByteBuffer(), (ByteBuffer)byteBuffer);
        }

        public ByteBuffer onUpgradeFrom() {
            if (this._buffer.hasRemaining()) {
                ByteBuffer unconsumed = ByteBuffer.allocateDirect(this._buffer.remaining());
                unconsumed.put(this._buffer.getByteBuffer());
                unconsumed.flip();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Detector {} abandoning {}", (Object)DetectorConnectionFactory.this.getProtocol(), (Object)BufferUtil.toDetailString((ByteBuffer)unconsumed));
                }
                return unconsumed;
            }
            return null;
        }

        public void onOpen() {
            super.onOpen();
            try {
                boolean upgraded = this.detectAndUpgrade();
                if (upgraded) {
                    this._buffer.release();
                } else {
                    this.fillInterested();
                }
            }
            catch (Throwable x) {
                this.releaseAndClose(x);
            }
        }

        public void onFillable() {
            try {
                ByteBuffer byteBuffer = this._buffer.getByteBuffer();
                while (BufferUtil.space((ByteBuffer)byteBuffer) > 0) {
                    int fill = this.getEndPoint().fill(byteBuffer);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Detector {} filled buffer with {} bytes", (Object)DetectorConnectionFactory.this.getProtocol(), (Object)fill);
                    }
                    if (fill < 0) {
                        this._buffer.release();
                        this.getEndPoint().shutdownOutput();
                        return;
                    }
                    if (fill == 0) {
                        this.fillInterested();
                        return;
                    }
                    if (!this.detectAndUpgrade()) continue;
                    this._buffer.release();
                    return;
                }
                LOG.warn("Detector {} failed to detect upgrade target on {} for {}", new Object[]{DetectorConnectionFactory.this.getProtocol(), DetectorConnectionFactory.this._detectingConnectionFactories, this.getEndPoint()});
                this.releaseAndClose(new IOException("Detector %s buffer overflow %d".formatted(DetectorConnectionFactory.this.getProtocol(), this._buffer.capacity())));
            }
            catch (Throwable x) {
                LOG.warn("Detector {} error for {}", new Object[]{DetectorConnectionFactory.this.getProtocol(), this.getEndPoint(), x});
                this.releaseAndClose(x);
            }
        }

        private boolean detectAndUpgrade() {
            if (this._buffer.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Detector {} skipping detection on an empty buffer", (Object)DetectorConnectionFactory.this.getProtocol());
                }
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Detector {} performing detection with {} bytes", (Object)DetectorConnectionFactory.this.getProtocol(), (Object)this._buffer.remaining());
            }
            boolean notRecognized = true;
            for (ConnectionFactory.Detecting detectingConnectionFactory : DetectorConnectionFactory.this._detectingConnectionFactories) {
                ConnectionFactory.Detecting.Detection detection = detectingConnectionFactory.detect(this._buffer.getByteBuffer());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Detector {} performed detection from {} with {} which returned {}", new Object[]{DetectorConnectionFactory.this.getProtocol(), this._buffer, detectingConnectionFactory, detection});
                }
                if (detection == ConnectionFactory.Detecting.Detection.RECOGNIZED) {
                    try {
                        Connection nextConnection = detectingConnectionFactory.newConnection(this._connector, this.getEndPoint());
                        if (!(nextConnection instanceof Connection.UpgradeTo)) {
                            throw new IllegalStateException("Cannot upgrade: " + String.valueOf(nextConnection) + " does not implement " + Connection.UpgradeTo.class.getName());
                        }
                        this.getEndPoint().upgrade(nextConnection);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Detector {} upgraded to {}", (Object)DetectorConnectionFactory.this.getProtocol(), (Object)nextConnection);
                        }
                        return true;
                    }
                    catch (DetectionFailureException x) {
                        if (LOG.isDebugEnabled()) {
                            LOG.atDebug().setCause((Throwable)x).log("Detector {} failed to upgrade, rethrowing", (Object)DetectorConnectionFactory.this.getProtocol());
                        }
                        throw x;
                    }
                    catch (Throwable x) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Detector {} failed to upgrade", (Object)DetectorConnectionFactory.this.getProtocol());
                        }
                        throw new DetectionFailureException(x);
                    }
                }
                notRecognized &= detection == ConnectionFactory.Detecting.Detection.NOT_RECOGNIZED;
            }
            if (notRecognized) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Detector {} failed to detect a known protocol, falling back to nextProtocol()", (Object)DetectorConnectionFactory.this.getProtocol());
                }
                DetectorConnectionFactory.this.nextProtocol(this._connector, this.getEndPoint(), this._buffer.getByteBuffer());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Detector {} call to nextProtocol() succeeded, assuming upgrade performed", (Object)DetectorConnectionFactory.this.getProtocol());
                }
                return true;
            }
            return false;
        }

        private void releaseAndClose(Throwable failure) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Detector {} releasing buffer and closing", (Object)DetectorConnectionFactory.this.getProtocol());
            }
            this._buffer.release();
            this.getEndPoint().close(failure);
        }
    }

    private static class DetectionFailureException
    extends RuntimeException {
        public DetectionFailureException(Throwable cause) {
            super(cause);
        }
    }
}

