/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.XmlDataProviderManager;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.tracecompass.tmf.analysis.xml.core";
    private static Activator fPlugin;
    private IEclipsePreferences fCorePreferenceStore;

    public Activator() {
        Activator.setDefault(this);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Activator.setDefault(this);
        XmlUtils.loadFilesStatus();
        XmlUtils.initOutputElements();
    }

    public void stop(BundleContext context) throws Exception {
        XmlUtils.saveFilesStatus();
        Activator.setDefault(null);
        XmlDataProviderManager.dispose();
        XmlUtils.clearOutputElements();
        super.stop(context);
    }

    public IEclipsePreferences getCorePreferenceStore() {
        if (this.fCorePreferenceStore == null) {
            this.fCorePreferenceStore = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        }
        return this.fCorePreferenceStore;
    }

    public static Activator getDefault() {
        return fPlugin;
    }

    private static void setDefault(Activator plugin) {
        fPlugin = plugin;
    }

    public static void log(IStatus status) {
        fPlugin.getLog().log(status);
    }

    public static void logInfo(String message) {
        fPlugin.getLog().log((IStatus)new Status(1, PLUGIN_ID, message));
    }

    public static void logInfo(String message, Throwable exception) {
        fPlugin.getLog().log((IStatus)new Status(1, PLUGIN_ID, message, exception));
    }

    public static void logWarning(String message) {
        fPlugin.getLog().log((IStatus)new Status(2, PLUGIN_ID, message));
    }

    public static void logWarning(String message, Throwable exception) {
        fPlugin.getLog().log((IStatus)new Status(2, PLUGIN_ID, message, exception));
    }

    public static void logError(String message) {
        fPlugin.getLog().log((IStatus)new Status(4, PLUGIN_ID, message));
    }

    public static void logError(String message, Throwable exception) {
        fPlugin.getLog().log((IStatus)new Status(4, PLUGIN_ID, message, exception));
    }
}

