/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.style;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension4;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.preferences.EditorPreferenceNames;
import org.eclipse.wst.sse.ui.internal.provisional.style.StructuredPresentationReconciler;
import org.eclipse.wst.sse.ui.internal.style.SemanticHighlightingManager;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;

public class SemanticHighlightingPresenter
implements ITextPresentationListener,
ITextInputListener,
IDocumentListener {
    private IPositionUpdater fPositionUpdater = new HighlightingPositionUpdater(this.getPositionCategory());
    private ISourceViewer fSourceViewer;
    private StructuredPresentationReconciler fPresentationReconciler;
    private List fPositions = new ArrayList();
    private Object fPositionLock = new Object();
    private boolean fIsCanceled = false;
    private YUV_RGBConverter rgbConverter;
    private Map readOnlyColorTable;
    double readOnlyForegroundScaleFactor = 30.0;

    public SemanticHighlightingPresenter() {
        IPreferenceStore editorStore = SSEUIPlugin.getDefault().getPreferenceStore();
        this.readOnlyForegroundScaleFactor = editorStore.getInt(EditorPreferenceNames.READ_ONLY_FOREGROUND_SCALE);
    }

    public SemanticHighlightingManager.HighlightedPosition createHighlightedPosition(int offset, int length, SemanticHighlightingManager.HighlightingStyle highlighting) {
        return new SemanticHighlightingManager.HighlightedPosition(offset, length, highlighting, this.fPositionUpdater);
    }

    public SemanticHighlightingManager.HighlightedPosition createHighlightedPosition(Position position, SemanticHighlightingManager.HighlightingStyle highlighting) {
        return new SemanticHighlightingManager.HighlightedPosition(position, highlighting, this.fPositionUpdater);
    }

    public SemanticHighlightingManager.HighlightedPosition createHighlightedPosition(Position position, SemanticHighlightingManager.HighlightingStyle highlighting, boolean isReadOnly) {
        return new SemanticHighlightingManager.HighlightedPosition(position, highlighting, this.fPositionUpdater, isReadOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllPositions(List list) {
        Object object = this.fPositionLock;
        synchronized (object) {
            list.addAll(this.fPositions);
        }
    }

    public TextPresentation createPresentation(List addedPositions, List removedPositions) {
        int offset;
        Position position;
        ISourceViewer sourceViewer = this.fSourceViewer;
        StructuredPresentationReconciler presentationReconciler = this.fPresentationReconciler;
        if (sourceViewer == null || presentationReconciler == null) {
            return null;
        }
        if (this.isCanceled()) {
            return null;
        }
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return null;
        }
        int minStart = Integer.MAX_VALUE;
        int maxEnd = Integer.MIN_VALUE;
        int i = 0;
        int n = removedPositions.size();
        while (i < n) {
            position = (Position)removedPositions.get(i);
            offset = position.getOffset();
            minStart = Math.min(minStart, offset);
            maxEnd = Math.max(maxEnd, offset + position.getLength());
            ++i;
        }
        i = 0;
        n = addedPositions.size();
        while (i < n) {
            position = (Position)addedPositions.get(i);
            offset = position.getOffset();
            minStart = Math.min(minStart, offset);
            maxEnd = Math.max(maxEnd, offset + position.getLength());
            ++i;
        }
        if (minStart < maxEnd) {
            try {
                return presentationReconciler.createRepairDescription((IRegion)new Region(minStart, maxEnd - minStart), document);
            }
            catch (RuntimeException runtimeException) {}
        }
        return null;
    }

    public Runnable createUpdateRunnable(final TextPresentation textPresentation, List addedPositions, List removedPositions) {
        if (this.fSourceViewer == null || textPresentation == null) {
            return null;
        }
        final SemanticHighlightingManager.HighlightedPosition[] added = new SemanticHighlightingManager.HighlightedPosition[addedPositions.size()];
        addedPositions.toArray(added);
        final SemanticHighlightingManager.HighlightedPosition[] removed = new SemanticHighlightingManager.HighlightedPosition[removedPositions.size()];
        removedPositions.toArray(removed);
        if (this.isCanceled()) {
            return null;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SemanticHighlightingPresenter.this.updatePresentation(textPresentation, added, removed);
            }
        };
        return runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updatePresentation(TextPresentation textPresentation, SemanticHighlightingManager.HighlightedPosition[] addedPositions, SemanticHighlightingManager.HighlightedPosition[] removedPositions) {
        if (this.fSourceViewer == null) {
            return;
        }
        if (this.isCanceled()) {
            return;
        }
        IDocument document = this.fSourceViewer.getDocument();
        if (document == null) {
            return;
        }
        String positionCategory = this.getPositionCategory();
        List<SemanticHighlightingManager.HighlightedPosition> removedPositionsList = Arrays.asList(removedPositions);
        try {
            Object object = this.fPositionLock;
            synchronized (object) {
                List oldPositions = this.fPositions;
                int newSize = Math.max(this.fPositions.size() + addedPositions.length - removedPositions.length, 10);
                ArrayList<Position> newPositions = new ArrayList<Position>(newSize);
                Position position = null;
                SemanticHighlightingManager.HighlightedPosition addedPosition = null;
                int i = 0;
                int j = 0;
                int n = oldPositions.size();
                int m = addedPositions.length;
                block6: while (true) {
                    block17: {
                        block18: {
                            if (i >= n && position == null && j >= m && addedPosition == null) {
                                this.fPositions = newPositions;
                                Collections.sort(this.fPositions, new Comparator(){

                                    public int compare(Object arg0, Object arg1) {
                                        Position p1 = (Position)arg0;
                                        Position p2 = (Position)arg1;
                                        return p1.offset - p2.offset;
                                    }
                                });
                                break;
                            }
                            while (true) {
                                if (position != null || i >= n) {
                                    if (addedPosition == null && j < m) {
                                        addedPosition = addedPositions[j++];
                                        document.addPosition(positionCategory, (Position)addedPosition);
                                    }
                                    if (position == null) break block17;
                                    if (addedPosition != null) {
                                        if (position.getOffset() > addedPosition.getOffset()) break;
                                        newPositions.add(position);
                                        position = null;
                                        continue block6;
                                    }
                                    break block18;
                                }
                                if (!(position = (Position)oldPositions.get(i++)).isDeleted() && !this.contain(removedPositionsList, position)) continue;
                                document.removePosition(positionCategory, position);
                                position = null;
                            }
                            newPositions.add(addedPosition);
                            addedPosition = null;
                            continue;
                        }
                        newPositions.add(position);
                        position = null;
                        continue;
                    }
                    if (addedPosition == null) continue;
                    newPositions.add(addedPosition);
                    addedPosition = null;
                }
            }
        }
        catch (BadPositionCategoryException e) {
            Logger.logException(e);
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
        if (textPresentation != null) {
            this.fSourceViewer.changeTextPresentation(textPresentation, false);
            return;
        }
        this.fSourceViewer.invalidateTextPresentation();
    }

    private boolean contain(List positions, Position position) {
        return this.indexOf(positions, position) != -1;
    }

    private int indexOf(List positions, Position position) {
        int index = this.computeIndexAtOffset(positions, position.getOffset());
        int size = positions.size();
        while (index < size) {
            if (positions.get(index) == position) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private void insertPosition(Position position) {
        int i = this.computeIndexAfterOffset(this.fPositions, position.getOffset());
        this.fPositions.add(i, position);
    }

    private int computeIndexAfterOffset(List positions, int offset) {
        int i = -1;
        int j = positions.size();
        while (j - i > 1) {
            int k = i + j >> 1;
            Position position = (Position)positions.get(k);
            if (position.getOffset() > offset) {
                j = k;
                continue;
            }
            i = k;
        }
        return j;
    }

    private int computeIndexAtOffset(List positions, int offset) {
        int i = -1;
        int j = positions.size();
        while (j - i > 1) {
            int k = i + j >> 1;
            Position position = (Position)positions.get(k);
            if (position.getOffset() >= offset) {
                j = k;
                continue;
            }
            i = k;
        }
        return j;
    }

    /*
     * Unable to fully structure code
     */
    public void applyTextPresentation(TextPresentation textPresentation) {
        block10: {
            region = textPresentation.getExtent();
            minStart = 0x7FFFFFFF;
            maxEnd = -2147483648;
            i = this.computeIndexAtOffset(this.fPositions, region.getOffset());
            n = this.computeIndexAtOffset(this.fPositions, region.getOffset() + region.getLength());
            if (n - i <= 2) ** GOTO lbl33
            ranges = new ArrayList<StyleRange>(n - i);
            while (i < n) {
                position = (SemanticHighlightingManager.HighlightedPosition)this.fPositions.get(i);
                if (!position.isDeleted()) {
                    if (!position.isReadOnly()) {
                        ranges.add(position.createStyleRange());
                    } else {
                        offset = position.getOffset();
                        minStart = Math.min(minStart, offset);
                        maxEnd = Math.max(maxEnd, offset + position.getLength());
                    }
                }
                ++i;
            }
            array = new StyleRange[ranges.size()];
            array = ranges.toArray(array);
            textPresentation.replaceStyleRanges(array);
            break block10;
lbl-1000:
            // 1 sources

            {
                position = (SemanticHighlightingManager.HighlightedPosition)this.fPositions.get(i);
                if (!position.isDeleted()) {
                    if (!position.isReadOnly()) {
                        textPresentation.replaceStyleRange(position.createStyleRange());
                    } else {
                        offset = position.getOffset();
                        minStart = Math.min(minStart, offset);
                        maxEnd = Math.max(maxEnd, offset + position.getLength());
                    }
                }
                ++i;
lbl33:
                // 2 sources

                ** while (i < n)
            }
        }
        if (minStart < maxEnd && (document = (IStructuredDocument)this.fSourceViewer.getDocument()).containsReadOnly(minStart, maxEnd)) {
            nonDefaultStyleRangeIterator = textPresentation.getNonDefaultStyleRangeIterator();
            while (nonDefaultStyleRangeIterator.hasNext()) {
                styleRange = (StyleRange)nonDefaultStyleRangeIterator.next();
                if (!document.containsReadOnly(styleRange.start, styleRange.length)) continue;
                this.adjustForeground(styleRange);
            }
        }
    }

    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        this.setCanceled(true);
        this.releaseDocument(oldInput);
        this.resetState();
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        this.manageDocument(newInput);
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        this.setCanceled(true);
    }

    public void documentChanged(DocumentEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanceled() {
        IDocument document;
        IDocument iDocument = document = this.fSourceViewer != null ? this.fSourceViewer.getDocument() : null;
        if (document == null) {
            return this.fIsCanceled;
        }
        Object object = this.getLockObject(document);
        synchronized (object) {
            return this.fIsCanceled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCanceled(boolean isCanceled) {
        IDocument document;
        IDocument iDocument = document = this.fSourceViewer != null ? this.fSourceViewer.getDocument() : null;
        if (document == null) {
            this.fIsCanceled = isCanceled;
            return;
        }
        Object object = this.getLockObject(document);
        synchronized (object) {
            this.fIsCanceled = isCanceled;
        }
    }

    private Object getLockObject(IDocument document) {
        Object lock;
        if (document instanceof ISynchronizable && (lock = ((ISynchronizable)document).getLockObject()) != null) {
            return lock;
        }
        return document;
    }

    public void install(ISourceViewer sourceViewer, StructuredPresentationReconciler backgroundPresentationReconciler) {
        this.fSourceViewer = sourceViewer;
        this.fPresentationReconciler = backgroundPresentationReconciler;
        if (this.fSourceViewer instanceof StructuredTextViewer) {
            ((StructuredTextViewer)this.fSourceViewer).prependTextPresentationListener(this);
        } else if (this.fSourceViewer instanceof ITextViewerExtension4) {
            ((ITextViewerExtension4)this.fSourceViewer).addTextPresentationListener((ITextPresentationListener)this);
        }
        this.fSourceViewer.addTextInputListener((ITextInputListener)this);
        this.manageDocument(this.fSourceViewer.getDocument());
    }

    public void uninstall() {
        this.setCanceled(true);
        if (this.fSourceViewer != null) {
            if (this.fSourceViewer instanceof ITextViewerExtension4) {
                ((ITextViewerExtension4)this.fSourceViewer).addTextPresentationListener((ITextPresentationListener)this);
            }
            this.releaseDocument(this.fSourceViewer.getDocument());
            this.invalidateTextPresentation();
            this.resetState();
            this.fSourceViewer.removeTextInputListener((ITextInputListener)this);
            this.fSourceViewer = null;
        }
    }

    public void highlightingStyleChanged(SemanticHighlightingManager.HighlightingStyle highlighting) {
        if (this.fSourceViewer instanceof ITextViewerExtension2) {
            ITextViewerExtension2 viewer = (ITextViewerExtension2)this.fSourceViewer;
            int i = 0;
            int n = this.fPositions.size();
            while (i < n) {
                SemanticHighlightingManager.HighlightedPosition position = (SemanticHighlightingManager.HighlightedPosition)((Object)this.fPositions.get(i));
                if (position.getHighlighting() == highlighting) {
                    viewer.invalidateTextPresentation(position.getOffset(), position.getLength());
                }
                ++i;
            }
        } else {
            this.fSourceViewer.invalidateTextPresentation();
        }
    }

    private void invalidateTextPresentation() {
        if (this.fSourceViewer instanceof ITextViewerExtension2) {
            ITextViewerExtension2 viewer = (ITextViewerExtension2)this.fSourceViewer;
            int i = 0;
            int n = this.fPositions.size();
            while (i < n) {
                Position position = (Position)this.fPositions.get(i);
                viewer.invalidateTextPresentation(position.getOffset(), position.getLength());
                ++i;
            }
        } else {
            this.fSourceViewer.invalidateTextPresentation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPositionFromUI(SemanticHighlightingManager.HighlightedPosition uiPosition) {
        SemanticHighlightingManager.HighlightedPosition position = this.createHighlightedPosition(uiPosition, uiPosition.getHighlighting(), uiPosition.isReadOnly());
        Object object = this.fPositionLock;
        synchronized (object) {
            this.insertPosition(position);
        }
        IDocument document = this.fSourceViewer.getDocument();
        if (document == null) {
            return;
        }
        String positionCategory = this.getPositionCategory();
        try {
            document.addPosition(positionCategory, (Position)position);
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
        catch (BadPositionCategoryException e) {
            Logger.logException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetState() {
        Object object = this.fPositionLock;
        synchronized (object) {
            this.fPositions.clear();
        }
    }

    private void manageDocument(IDocument document) {
        if (document != null) {
            document.addPositionCategory(this.getPositionCategory());
            document.addPositionUpdater(this.fPositionUpdater);
            document.addDocumentListener((IDocumentListener)this);
        }
    }

    private void releaseDocument(IDocument document) {
        if (document != null) {
            document.removeDocumentListener((IDocumentListener)this);
            document.removePositionUpdater(this.fPositionUpdater);
            try {
                document.removePositionCategory(this.getPositionCategory());
            }
            catch (BadPositionCategoryException e) {
                Logger.logException(e);
            }
        }
    }

    private String getPositionCategory() {
        return this.toString();
    }

    private void adjustForeground(StyleRange styleRange) {
        RGB oldRGB = null;
        Color oldColor = styleRange.background;
        if (oldColor == null) {
            oldColor = this.fSourceViewer.getTextWidget().getBackground();
            oldRGB = oldColor.getRGB();
        } else {
            oldRGB = oldColor.getRGB();
        }
        Color newColor = this.getCachedColorFor(oldRGB);
        if (newColor == null) {
            double target = this.getRGBConverter().calculateYComponent(oldColor);
            RGB newRGB = this.getRGBConverter().transformRGBToGrey(oldRGB, this.readOnlyForegroundScaleFactor / 100.0, target);
            this.cacheColor(oldRGB, newRGB);
            newColor = this.getCachedColorFor(oldRGB);
        }
        styleRange.foreground = newColor;
    }

    private YUV_RGBConverter getRGBConverter() {
        if (this.rgbConverter == null) {
            this.rgbConverter = new YUV_RGBConverter();
        }
        return this.rgbConverter;
    }

    private void cacheColor(RGB oldRGB, RGB newColor) {
        if (this.readOnlyColorTable == null) {
            this.readOnlyColorTable = new HashMap();
        }
        this.readOnlyColorTable.put(oldRGB, newColor);
    }

    private Color getCachedColorFor(RGB oldRGB) {
        Color result = null;
        if (this.readOnlyColorTable != null) {
            RGB readOnlyRGB = (RGB)this.readOnlyColorTable.get(oldRGB);
            result = EditorUtility.getColor(readOnlyRGB);
        }
        return result;
    }

    private class HighlightingPositionUpdater
    implements IPositionUpdater {
        private final String fCategory;

        public HighlightingPositionUpdater(String category) {
            this.fCategory = category;
        }

        public void update(DocumentEvent event) {
            int eventOffset = event.getOffset();
            int eventOldLength = event.getLength();
            int eventEnd = eventOffset + eventOldLength;
            try {
                Position[] positions = event.getDocument().getPositions(this.fCategory);
                int i = 0;
                while (i != positions.length) {
                    SemanticHighlightingManager.HighlightedPosition position = (SemanticHighlightingManager.HighlightedPosition)positions[i];
                    int offset = position.getOffset();
                    int length = position.getLength();
                    int end = offset + length;
                    if (offset > eventEnd) {
                        this.updateWithPrecedingEvent(position, event);
                    } else if (end >= eventOffset) {
                        if (offset <= eventOffset && end >= eventEnd) {
                            if (i > 0 && positions[i - 1].offset + positions[i - 1].length > offset + length && positions[i - 1].offset != offset) {
                                this.updateWithPrecedingEvent(position, event);
                            } else {
                                this.updateWithIncludedEvent(position, event);
                            }
                        } else if (offset <= eventOffset) {
                            this.updateWithOverEndEvent(position, event);
                        } else if (end >= eventEnd) {
                            this.updateWithOverStartEvent(position, event);
                        } else {
                            this.updateWithIncludingEvent(position, event);
                        }
                    }
                    ++i;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }

        private void updateWithPrecedingEvent(SemanticHighlightingManager.HighlightedPosition position, DocumentEvent event) {
            String newText = event.getText();
            int eventNewLength = newText != null ? newText.length() : 0;
            int deltaLength = eventNewLength - event.getLength();
            position.setOffset(position.getOffset() + deltaLength);
        }

        private void updateWithIncludedEvent(SemanticHighlightingManager.HighlightedPosition position, DocumentEvent event) {
            int eventOffset = event.getOffset();
            String newText = event.getText();
            if (newText == null) {
                newText = "";
            }
            int eventNewLength = newText.length();
            int deltaLength = eventNewLength - event.getLength();
            int offset = position.getOffset();
            int length = position.getLength();
            int end = offset + length;
            int includedLength = 0;
            while (includedLength < eventNewLength && !Character.isWhitespace(newText.charAt(includedLength))) {
                ++includedLength;
            }
            if (includedLength == eventNewLength) {
                position.setLength(length + deltaLength);
            } else {
                int newLeftLength = eventOffset - offset + includedLength;
                int excludedLength = eventNewLength;
                while (excludedLength > 0 && !Character.isWhitespace(newText.charAt(excludedLength - 1))) {
                    --excludedLength;
                }
                int newRightOffset = eventOffset + excludedLength;
                int newRightLength = end + deltaLength - newRightOffset;
                if (newRightLength == 0) {
                    position.setLength(newLeftLength);
                } else if (newLeftLength == 0) {
                    position.update(newRightOffset, newRightLength);
                } else {
                    position.setLength(newLeftLength);
                    SemanticHighlightingPresenter.this.addPositionFromUI(position);
                }
            }
        }

        private void updateWithOverEndEvent(SemanticHighlightingManager.HighlightedPosition position, DocumentEvent event) {
            String newText = event.getText();
            if (newText == null) {
                newText = "";
            }
            int eventNewLength = newText.length();
            int includedLength = 0;
            while (includedLength < eventNewLength && !Character.isWhitespace(newText.charAt(includedLength))) {
                ++includedLength;
            }
            position.setLength(event.getOffset() - position.getOffset() + includedLength);
        }

        private void updateWithOverStartEvent(SemanticHighlightingManager.HighlightedPosition position, DocumentEvent event) {
            int eventNewLength;
            int eventOffset = event.getOffset();
            int eventEnd = eventOffset + event.getLength();
            String newText = event.getText();
            if (newText == null) {
                newText = "";
            }
            int excludedLength = eventNewLength = newText.length();
            while (excludedLength > 0 && !Character.isWhitespace(newText.charAt(excludedLength - 1))) {
                --excludedLength;
            }
            int deleted = eventEnd - position.getOffset();
            int inserted = eventNewLength - excludedLength;
            position.update(eventOffset + excludedLength, position.getLength() - deleted + inserted);
        }

        private void updateWithIncludingEvent(SemanticHighlightingManager.HighlightedPosition position, DocumentEvent event) {
            position.delete();
            position.update(event.getOffset(), 0);
        }
    }

    private class YUV_RGBConverter {
        public double calculateYComponent(Color targetColor) {
            return new YUV(targetColor.getRGB()).getY();
        }

        public RGB transformRGBToGrey(RGB originalRGB, double scaleFactor, double target) {
            RGB transformedRGB = null;
            double y = 0.0;
            double mid = 0.5;
            y = target < mid ? target + scaleFactor : target - scaleFactor;
            int c = (int)Math.round(y * 255.0);
            if (c > 255) {
                c = 255;
            }
            if (c < 0) {
                c = 0;
            }
            transformedRGB = new RGB(c, c, c);
            return transformedRGB;
        }

        private class YUV {
            private NormalizedRGB normalizedRGB;
            private double u = -1.0;
            private double v = -1.0;
            private double y = -1.0;

            private YUV() {
            }

            public YUV(RGB rgb) {
                this();
                this.normalizedRGB = new NormalizedRGB(rgb);
                this.getY();
                this.getV();
                this.getU();
            }

            double gammaNormalized(double colorComponent) {
                if (colorComponent < 0.018) {
                    return colorComponent * 0.45;
                }
                return 1.099 * Math.pow(colorComponent, 0.45) - 0.099;
            }

            public double getU() {
                if (this.u == -1.0) {
                    this.u = 0.4949 * (this.normalizedRGB.blue - this.getY());
                }
                return this.u;
            }

            public double getV() {
                if (this.v == -1.0) {
                    this.v = 0.877 * (this.normalizedRGB.red - this.getY());
                }
                return this.v;
            }

            public double getY() {
                if (this.y == -1.0) {
                    this.y = 0.299 * this.normalizedRGB.red + 0.587 * this.normalizedRGB.green + 0.114 * this.normalizedRGB.blue;
                }
                return this.y;
            }

            class NormalizedRGB {
                double blue;
                double green;
                private final double maxRGB = 256.0;
                double red;

                public NormalizedRGB(RGB rgb) {
                    this.red = (double)rgb.red / 256.0;
                    this.green = (double)rgb.green / 256.0;
                    this.blue = (double)rgb.blue / 256.0;
                    this.red = YUV.this.gammaNormalized(this.red);
                    this.green = YUV.this.gammaNormalized(this.green);
                    this.blue = YUV.this.gammaNormalized(this.blue);
                }
            }
        }
    }
}

