/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.component;

import org.eclipse.tracecompass.internal.tmf.core.component.TmfProviderManager;
import org.eclipse.tracecompass.tmf.core.component.TmfEventProvider;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.junit.Assert;
import org.junit.Test;

public class TmfProviderManagerTest {
    @Test
    public void testRegister_0() {
        TmfEventProvider[] providers = TmfProviderManager.getProviders(ITmfEvent.class);
        Assert.assertEquals((String)"getProviders", (long)0L, (long)providers.length);
        providers = TmfProviderManager.getProviders(ITmfEvent.class, TestProvider1.class);
        Assert.assertEquals((String)"getProviders", (long)0L, (long)providers.length);
    }

    @Test
    public void testRegister_Unregister_1() {
        TestProvider1 testProvider1 = new TestProvider1(ITmfEvent.class);
        TmfEventProvider[] providers = TmfProviderManager.getProviders(ITmfEvent.class);
        Assert.assertEquals((String)"getProviders", (long)1L, (long)providers.length);
        Assert.assertEquals((String)"getProviders", (Object)((Object)testProvider1), (Object)providers[0]);
        providers = TmfProviderManager.getProviders(ITmfEvent.class, TestProvider1.class);
        Assert.assertEquals((String)"getProviders", (long)1L, (long)providers.length);
        Assert.assertEquals((String)"getProviders", (Object)((Object)testProvider1), (Object)providers[0]);
        testProvider1.dispose();
        providers = TmfProviderManager.getProviders(ITmfEvent.class);
        Assert.assertEquals((String)"getProviders", (long)0L, (long)providers.length);
        providers = TmfProviderManager.getProviders(ITmfEvent.class, TestProvider1.class);
        Assert.assertEquals((String)"getProviders", (long)0L, (long)providers.length);
    }

    @Test
    public void testRegister_Unregister_2() {
        TestProvider1 testProvider1 = new TestProvider1(ITmfEvent.class);
        TestProvider2 testProvider2 = new TestProvider2(ITmfEvent.class);
        TmfEventProvider[] providers = TmfProviderManager.getProviders(ITmfEvent.class);
        Assert.assertEquals((String)"getProviders", (long)2L, (long)providers.length);
        Assert.assertTrue((providers.length == 2 ? 1 : 0) != 0);
        if (providers[0] == testProvider1) {
            Assert.assertEquals((String)"getProviders", (Object)((Object)testProvider2), (Object)providers[1]);
        } else {
            Assert.assertEquals((String)"getProviders", (Object)((Object)testProvider2), (Object)providers[0]);
            Assert.assertEquals((String)"getProviders", (Object)((Object)testProvider1), (Object)providers[1]);
        }
        providers = TmfProviderManager.getProviders(ITmfEvent.class, TestProvider1.class);
        Assert.assertEquals((String)"getProviders", (long)1L, (long)providers.length);
        Assert.assertEquals((String)"getProviders", (Object)((Object)testProvider1), (Object)providers[0]);
        providers = TmfProviderManager.getProviders(ITmfEvent.class, TestProvider2.class);
        Assert.assertEquals((String)"getProviders", (long)1L, (long)providers.length);
        Assert.assertEquals((String)"getProviders", (Object)((Object)testProvider2), (Object)providers[0]);
        testProvider1.dispose();
        providers = TmfProviderManager.getProviders(ITmfEvent.class);
        Assert.assertEquals((String)"getProviders", (long)1L, (long)providers.length);
        Assert.assertEquals((String)"getProviders", (Object)((Object)testProvider2), (Object)providers[0]);
        providers = TmfProviderManager.getProviders(ITmfEvent.class, TestProvider1.class);
        Assert.assertEquals((String)"getProviders", (long)0L, (long)providers.length);
        providers = TmfProviderManager.getProviders(ITmfEvent.class, TestProvider2.class);
        Assert.assertEquals((String)"getProviders", (long)1L, (long)providers.length);
        Assert.assertEquals((String)"getProviders", (Object)((Object)testProvider2), (Object)providers[0]);
        testProvider2.dispose();
        providers = TmfProviderManager.getProviders(ITmfEvent.class);
        Assert.assertEquals((String)"getProviders", (long)0L, (long)providers.length);
        providers = TmfProviderManager.getProviders(ITmfEvent.class, TestProvider1.class);
        Assert.assertEquals((String)"getProviders", (long)0L, (long)providers.length);
        providers = TmfProviderManager.getProviders(ITmfEvent.class, TestProvider2.class);
        Assert.assertEquals((String)"getProviders", (long)0L, (long)providers.length);
    }

    @Test
    public void testRegister_Unregister_3() {
        TestProvider1 testProvider1 = new TestProvider1(ITmfEvent.class);
        TestProvider2 testProvider2 = new TestProvider2(ITmfEvent.class);
        TestProvider3 testProvider3 = new TestProvider3(TmfEvent3.class);
        TmfEventProvider[] providers = TmfProviderManager.getProviders(ITmfEvent.class);
        Assert.assertEquals((String)"getProviders", (long)2L, (long)providers.length);
        if (providers[0] == testProvider1) {
            Assert.assertEquals((String)"getProviders", (Object)((Object)testProvider2), (Object)providers[1]);
        } else {
            Assert.assertEquals((String)"getProviders", (Object)((Object)testProvider2), (Object)providers[0]);
            Assert.assertEquals((String)"getProviders", (Object)((Object)testProvider1), (Object)providers[1]);
        }
        TmfEventProvider[] providers3 = TmfProviderManager.getProviders(TmfEvent3.class);
        Assert.assertEquals((String)"getProviders", (long)1L, (long)providers3.length);
        Assert.assertEquals((String)"getProviders", (Object)((Object)testProvider3), (Object)providers3[0]);
        providers = TmfProviderManager.getProviders(ITmfEvent.class, TestProvider1.class);
        Assert.assertEquals((String)"getProviders", (long)1L, (long)providers.length);
        Assert.assertEquals((String)"getProviders", (Object)((Object)testProvider1), (Object)providers[0]);
        providers = TmfProviderManager.getProviders(ITmfEvent.class, TestProvider2.class);
        Assert.assertEquals((String)"getProviders", (long)1L, (long)providers.length);
        Assert.assertEquals((String)"getProviders", (Object)((Object)testProvider2), (Object)providers[0]);
        providers3 = TmfProviderManager.getProviders(TmfEvent3.class, TestProvider3.class);
        Assert.assertEquals((String)"getProviders", (long)1L, (long)providers3.length);
        Assert.assertEquals((String)"getProviders", (Object)((Object)testProvider3), (Object)providers3[0]);
        testProvider1.dispose();
        providers = TmfProviderManager.getProviders(ITmfEvent.class);
        Assert.assertEquals((String)"getProviders", (long)1L, (long)providers.length);
        Assert.assertEquals((String)"getProviders", (Object)((Object)testProvider2), (Object)providers[0]);
        providers = TmfProviderManager.getProviders(ITmfEvent.class, TestProvider1.class);
        Assert.assertEquals((String)"getProviders", (long)0L, (long)providers.length);
        providers = TmfProviderManager.getProviders(ITmfEvent.class, TestProvider2.class);
        Assert.assertEquals((String)"getProviders", (long)1L, (long)providers.length);
        Assert.assertEquals((String)"getProviders", (Object)((Object)testProvider2), (Object)providers[0]);
        providers3 = TmfProviderManager.getProviders(TmfEvent3.class);
        Assert.assertEquals((String)"getProviders", (long)1L, (long)providers3.length);
        Assert.assertEquals((String)"getProviders", (Object)((Object)testProvider3), (Object)providers3[0]);
        providers3 = TmfProviderManager.getProviders(TmfEvent3.class, TestProvider3.class);
        Assert.assertEquals((String)"getProviders", (long)1L, (long)providers3.length);
        Assert.assertEquals((String)"getProviders", (Object)((Object)testProvider3), (Object)providers3[0]);
        testProvider2.dispose();
        providers = TmfProviderManager.getProviders(ITmfEvent.class);
        Assert.assertEquals((String)"getProviders", (long)0L, (long)providers.length);
        providers = TmfProviderManager.getProviders(ITmfEvent.class, TestProvider1.class);
        Assert.assertEquals((String)"getProviders", (long)0L, (long)providers.length);
        providers = TmfProviderManager.getProviders(ITmfEvent.class, TestProvider2.class);
        Assert.assertEquals((String)"getProviders", (long)0L, (long)providers.length);
        providers3 = TmfProviderManager.getProviders(TmfEvent3.class);
        Assert.assertTrue((providers3.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((providers3[0] == testProvider3 ? 1 : 0) != 0);
        providers3 = TmfProviderManager.getProviders(TmfEvent3.class, TestProvider3.class);
        Assert.assertEquals((String)"getProviders", (long)1L, (long)providers3.length);
        Assert.assertEquals((String)"getProviders", (Object)((Object)testProvider3), (Object)providers3[0]);
        testProvider3.dispose();
        providers = TmfProviderManager.getProviders(ITmfEvent.class);
        Assert.assertEquals((String)"getProviders", (long)0L, (long)providers.length);
        providers = TmfProviderManager.getProviders(ITmfEvent.class, TestProvider1.class);
        Assert.assertEquals((String)"getProviders", (long)0L, (long)providers.length);
        providers = TmfProviderManager.getProviders(ITmfEvent.class, TestProvider2.class);
        Assert.assertEquals((String)"getProviders", (long)0L, (long)providers.length);
        providers3 = TmfProviderManager.getProviders(TmfEvent3.class);
        Assert.assertEquals((String)"getProviders", (long)0L, (long)providers.length);
        providers3 = TmfProviderManager.getProviders(TmfEvent3.class, TestProvider3.class);
        Assert.assertEquals((String)"getProviders", (long)0L, (long)providers.length);
    }

    @Test
    public void testGetProvider() {
        TestProvider1 testProvider1 = new TestProvider1(ITmfEvent.class);
        TestProvider2 testProvider2 = new TestProvider2(ITmfEvent.class);
        TestProvider3 testProvider3 = new TestProvider3(TmfEvent3.class);
        TmfEventProvider[] providers = TmfProviderManager.getProviders(ITmfEvent.class, null);
        Assert.assertEquals((String)"getProviders", (long)2L, (long)providers.length);
        if (providers[0] == testProvider1) {
            Assert.assertEquals((String)"getProviders", (Object)((Object)testProvider2), (Object)providers[1]);
        } else {
            Assert.assertEquals((String)"getProviders", (Object)((Object)testProvider2), (Object)providers[0]);
            Assert.assertEquals((String)"getProviders", (Object)((Object)testProvider1), (Object)providers[1]);
        }
        providers = TmfProviderManager.getProviders(TmfEvent3.class, null);
        Assert.assertEquals((String)"getProviders", (long)1L, (long)providers.length);
        Assert.assertEquals((String)"getProviders", (Object)((Object)testProvider3), (Object)providers[0]);
        testProvider1.dispose();
        testProvider2.dispose();
        testProvider3.dispose();
    }

    private class TestProvider1
    extends TmfEventProvider {
        public TestProvider1(Class<ITmfEvent> type) {
            super("TestProvider1", type);
        }

        public ITmfContext armRequest(ITmfEventRequest request) {
            return null;
        }

        public ITmfEvent getNext(ITmfContext context) {
            return null;
        }

        public boolean isCompleted(ITmfEventRequest request, ITmfEvent data, int nbRead) {
            return false;
        }
    }

    private class TestProvider2
    extends TmfEventProvider {
        public TestProvider2(Class<ITmfEvent> type) {
            super("TestProvider2", type);
        }

        public ITmfContext armRequest(ITmfEventRequest request) {
            return null;
        }

        public ITmfEvent getNext(ITmfContext context) {
            return null;
        }

        public boolean isCompleted(ITmfEventRequest request, ITmfEvent data, int nbRead) {
            return false;
        }
    }

    private class TestProvider3
    extends TmfEventProvider {
        public TestProvider3(Class<TmfEvent3> type) {
            super("TestProvider3", type);
        }

        public ITmfContext armRequest(ITmfEventRequest request) {
            return null;
        }

        public TmfEvent3 getNext(ITmfContext context) {
            return null;
        }

        public boolean isCompleted(ITmfEventRequest request, ITmfEvent data, int nbRead) {
            return false;
        }
    }

    private class TmfEvent3
    extends TmfEvent {
        private TmfEvent3() {
            super(null, -1L, null, null, null);
        }
    }
}

