/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;

public final class Region
extends Resource {
    private int initialZoom;
    private HashMap<Integer, Long> zoomToHandle = new HashMap();
    private List<Operation> operations = new ArrayList<Operation>();

    public Region() {
        this(null);
    }

    public Region(Device device) {
        super(device);
        this.initialZoom = DPIUtil.getDeviceZoom();
        long handle = OS.CreateRectRgn(0, 0, 0, 0);
        this.zoomToHandle.put(this.initialZoom, handle);
        if (handle == 0L) {
            SWT.error(2);
        }
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    public void add(int[] pointArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        OperationWithArray operation = new OperationWithArray(Operation::add, Arrays.copyOf(pointArray, pointArray.length));
        this.storeAndApplyOperationForAllHandles(operation);
    }

    public void add(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        OperationWithRectangle operation = new OperationWithRectangle(Operation::add, new Rectangle(rect.x, rect.y, rect.width, rect.height));
        this.storeAndApplyOperationForAllHandles(operation);
    }

    public void add(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OperationWithRectangle operation = new OperationWithRectangle(Operation::add, new Rectangle(x, y, width, height));
        this.storeAndApplyOperationForAllHandles(operation);
    }

    public void add(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OperationWithRegion operation = new OperationWithRegion(Operation::add, region);
        this.storeAndApplyOperationForAllHandles(operation);
    }

    public boolean contains(int x, int y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.containsInPixels(DPIUtil.scaleUp(x, this.initialZoom), DPIUtil.scaleUp(y, this.initialZoom));
    }

    boolean containsInPixels(int x, int y) {
        return OS.PtInRegion(this.getHandleForInitialZoom(), x, y);
    }

    public boolean contains(Point pt) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pt == null) {
            SWT.error(4);
        }
        Point p = DPIUtil.scaleUp(pt, this.initialZoom);
        return this.containsInPixels(p.x, p.y);
    }

    @Override
    void destroy() {
        this.device.deregisterResourceWithZoomSupport(this);
        this.zoomToHandle.values().forEach(handle -> {
            boolean bl = OS.DeleteObject(handle);
        });
        this.zoomToHandle.clear();
        this.operations.clear();
    }

    @Override
    void destroyHandlesExcept(Set<Integer> zoomLevels) {
        this.zoomToHandle.entrySet().removeIf(entry -> {
            Integer zoom = (Integer)entry.getKey();
            if (!zoomLevels.contains(zoom) && zoom != this.initialZoom) {
                OS.DeleteObject((Long)entry.getValue());
                return true;
            }
            return false;
        });
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Region)) {
            return false;
        }
        Region rgn = (Region)object;
        return this.getHandleForInitialZoom() == rgn.getHandleForInitialZoom();
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return DPIUtil.scaleDown(this.getBoundsInPixels(), this.initialZoom);
    }

    Rectangle getBoundsInPixels() {
        RECT rect = new RECT();
        OS.GetRgnBox(this.getHandleForInitialZoom(), rect);
        return new Rectangle(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    public int hashCode() {
        return (int)this.getHandleForInitialZoom();
    }

    public void intersect(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        OperationWithRectangle operation = new OperationWithRectangle(Operation::intersect, new Rectangle(rect.x, rect.y, rect.width, rect.height));
        this.storeAndApplyOperationForAllHandles(operation);
    }

    public void intersect(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OperationWithRectangle operation = new OperationWithRectangle(Operation::intersect, new Rectangle(x, y, width, height));
        this.storeAndApplyOperationForAllHandles(operation);
    }

    public void intersect(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OperationWithRegion operation = new OperationWithRegion(Operation::intersect, region);
        this.storeAndApplyOperationForAllHandles(operation);
    }

    public boolean intersects(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.intersectsInPixels(DPIUtil.scaleUp(x, this.initialZoom), DPIUtil.scaleUp(y, this.initialZoom), DPIUtil.scaleUp(width, this.initialZoom), DPIUtil.scaleUp(height, this.initialZoom));
    }

    boolean intersectsInPixels(int x, int y, int width, int height) {
        RECT r = new RECT();
        OS.SetRect(r, x, y, x + width, y + height);
        return OS.RectInRegion(this.getHandleForInitialZoom(), r);
    }

    public boolean intersects(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        Rectangle r = DPIUtil.scaleUp(rect, this.initialZoom);
        return this.intersectsInPixels(r.x, r.y, r.width, r.height);
    }

    @Override
    public boolean isDisposed() {
        return this.zoomToHandle.isEmpty();
    }

    public boolean isEmpty() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        RECT rect = new RECT();
        int result = OS.GetRgnBox(this.getHandleForInitialZoom(), rect);
        if (result == 1) {
            return true;
        }
        return rect.right - rect.left <= 0 || rect.bottom - rect.top <= 0;
    }

    public void subtract(int[] pointArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        OperationWithArray operation = new OperationWithArray(Operation::subtract, Arrays.copyOf(pointArray, pointArray.length));
        this.storeAndApplyOperationForAllHandles(operation);
    }

    public void subtract(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        OperationWithRectangle operation = new OperationWithRectangle(Operation::subtract, new Rectangle(rect.x, rect.y, rect.width, rect.height));
        this.storeAndApplyOperationForAllHandles(operation);
    }

    public void subtract(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OperationWithRectangle operation = new OperationWithRectangle(Operation::subtract, new Rectangle(x, y, width, height));
        this.storeAndApplyOperationForAllHandles(operation);
    }

    public void subtract(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OperationWithRegion operation = new OperationWithRegion(Operation::subtract, region);
        this.storeAndApplyOperationForAllHandles(operation);
    }

    public void translate(int x, int y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OperationWithPoint operation = new OperationWithPoint(Operation::translate, new Point(x, y));
        this.storeAndApplyOperationForAllHandles(operation);
    }

    public void translate(Point pt) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pt == null) {
            SWT.error(4);
        }
        OperationWithPoint operation = new OperationWithPoint(Operation::translate, new Point(pt.x, pt.y));
        this.storeAndApplyOperationForAllHandles(operation);
    }

    private long getHandleForInitialZoom() {
        return Region.win32_getHandle(this, this.initialZoom);
    }

    private void storeAndApplyOperationForAllHandles(Operation operation) {
        this.operations.add(operation);
        this.zoomToHandle.forEach((zoom, handle) -> operation.apply((long)handle, (int)zoom));
    }

    public static long win32_getHandle(Region region, int zoom) {
        if (!region.zoomToHandle.containsKey(zoom)) {
            long handle = OS.CreateRectRgn(0, 0, 0, 0);
            for (Operation operation : region.operations) {
                operation.apply(handle, zoom);
            }
            region.zoomToHandle.put(zoom, handle);
        }
        return region.zoomToHandle.get(zoom);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Region {*DISPOSED*}";
        }
        return "Region {" + this.zoomToHandle.entrySet().stream().map(entry -> String.valueOf(entry.getValue()) + "(zoom:" + String.valueOf(entry.getKey()) + ")").collect(Collectors.joining(","));
    }

    private abstract class Operation {
        private OperationStrategy operationStrategy;

        Operation(OperationStrategy operationStrategy) {
            this.operationStrategy = operationStrategy;
        }

        void apply(long handle, int zoom) {
            this.operationStrategy.apply(this, handle, zoom);
        }

        abstract void add(long var1, int var3);

        abstract void subtract(long var1, int var3);

        abstract void intersect(long var1, int var3);

        abstract void translate(long var1, int var3);
    }

    @FunctionalInterface
    private static interface OperationStrategy {
        public void apply(Operation var1, long var2, int var4);
    }

    private class OperationWithArray
    extends Operation {
        int[] data;

        public OperationWithArray(OperationStrategy operationStrategy, int[] data) {
            super(operationStrategy);
            this.data = data;
        }

        @Override
        void add(long handle, int zoom) {
            int[] points = this.getScaledPoints(zoom);
            this.addInPixels(handle, points);
        }

        @Override
        void subtract(long handle, int zoom) {
            int[] pointArray = this.getScaledPoints(zoom);
            this.subtractInPixels(handle, pointArray);
        }

        @Override
        void intersect(long handle, int zoom) {
            throw new UnsupportedOperationException();
        }

        @Override
        void translate(long handle, int zoom) {
            throw new UnsupportedOperationException();
        }

        private void addInPixels(long handle, int[] pointArray) {
            long polyRgn = OS.CreatePolygonRgn(pointArray, pointArray.length / 2, 1);
            OS.CombineRgn(handle, handle, polyRgn, 2);
            OS.DeleteObject(polyRgn);
        }

        private void subtractInPixels(long handle, int[] pointArray) {
            long polyRgn = OS.CreatePolygonRgn(pointArray, pointArray.length / 2, 1);
            OS.CombineRgn(handle, handle, polyRgn, 4);
            OS.DeleteObject(polyRgn);
        }

        private int[] getScaledPoints(int zoom) {
            return DPIUtil.scaleUp(this.data, zoom);
        }
    }

    private class OperationWithPoint
    extends Operation {
        Point data;

        public OperationWithPoint(OperationStrategy operationStrategy, Point data) {
            super(operationStrategy);
            this.data = data;
        }

        @Override
        void add(long handle, int zoom) {
            throw new UnsupportedOperationException();
        }

        @Override
        void subtract(long handle, int zoom) {
            throw new UnsupportedOperationException();
        }

        @Override
        void intersect(long handle, int zoom) {
            throw new UnsupportedOperationException();
        }

        @Override
        void translate(long handle, int zoom) {
            Point pt = DPIUtil.scaleUp(this.data, zoom);
            OS.OffsetRgn(handle, pt.x, pt.y);
        }
    }

    private class OperationWithRectangle
    extends Operation {
        Rectangle data;

        OperationWithRectangle(OperationStrategy operationStrategy, Rectangle data) {
            super(operationStrategy);
            this.data = data;
        }

        @Override
        void add(long handle, int zoom) {
            Rectangle bounds = this.getScaledRectangle(zoom);
            this.addInPixels(handle, bounds.x, bounds.y, bounds.width, bounds.height);
        }

        @Override
        void subtract(long handle, int zoom) {
            Rectangle bounds = this.getScaledRectangle(zoom);
            this.subtractInPixels(handle, bounds.x, bounds.y, bounds.width, bounds.height);
        }

        @Override
        void intersect(long handle, int zoom) {
            Rectangle bounds = this.getScaledRectangle(zoom);
            this.intersectInPixels(handle, bounds.x, bounds.y, bounds.width, bounds.height);
        }

        @Override
        void translate(long handle, int zoom) {
            throw new UnsupportedOperationException();
        }

        private void addInPixels(long handle, int x, int y, int width, int height) {
            if (width < 0 || height < 0) {
                SWT.error(5);
            }
            long rectRgn = OS.CreateRectRgn(x, y, x + width, y + height);
            OS.CombineRgn(handle, handle, rectRgn, 2);
            OS.DeleteObject(rectRgn);
        }

        private void subtractInPixels(long handle, int x, int y, int width, int height) {
            if (width < 0 || height < 0) {
                SWT.error(5);
            }
            long rectRgn = OS.CreateRectRgn(x, y, x + width, y + height);
            OS.CombineRgn(handle, handle, rectRgn, 4);
            OS.DeleteObject(rectRgn);
        }

        private void intersectInPixels(long handle, int x, int y, int width, int height) {
            if (width < 0 || height < 0) {
                SWT.error(5);
            }
            long rectRgn = OS.CreateRectRgn(x, y, x + width, y + height);
            OS.CombineRgn(handle, handle, rectRgn, 1);
            OS.DeleteObject(rectRgn);
        }

        private Rectangle getScaledRectangle(int zoom) {
            return DPIUtil.scaleUp(this.data, zoom);
        }
    }

    private class OperationWithRegion
    extends Operation {
        Region data;

        OperationWithRegion(OperationStrategy operationStrategy, Region data) {
            super(operationStrategy);
            this.data = data;
        }

        @Override
        void add(long handle, int zoom) {
            long scaledHandle = this.getHandleForScaledRegion(zoom);
            OS.CombineRgn(handle, handle, scaledHandle, 2);
        }

        @Override
        void subtract(long handle, int zoom) {
            long scaledHandle = this.getHandleForScaledRegion(zoom);
            OS.CombineRgn(handle, handle, scaledHandle, 4);
        }

        @Override
        void intersect(long handle, int zoom) {
            long scaledHandle = this.getHandleForScaledRegion(zoom);
            OS.CombineRgn(handle, handle, scaledHandle, 1);
        }

        @Override
        void translate(long handle, int zoom) {
            throw new UnsupportedOperationException();
        }

        private long getHandleForScaledRegion(int zoom) {
            if (this.data.isDisposed() || this.data == Region.this) {
                SWT.error(5);
            }
            return Region.win32_getHandle(this.data, zoom);
        }
    }
}

