/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.util.HashSet;
import org.eclipse.compare.ICompareInputLabelProvider;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffChangeEvent;
import org.eclipse.team.core.diff.IDiffChangeListener;
import org.eclipse.team.core.diff.IDiffTree;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.history.FileRevisionTypedElement;
import org.eclipse.team.internal.ui.mapping.CompareInputChangeNotifier;
import org.eclipse.team.internal.ui.mapping.ResourceDiffCompareInput;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;

public class ResourceCompareInputChangeNotifier
extends CompareInputChangeNotifier
implements IDiffChangeListener {
    static final String RESOURCE_CHANGE_NOTIFIER_PROPERTY = "org.eclipse.team.ui.ResourceChangeNotifier";
    private final ISynchronizationContext context;
    private final CompareInputLabelProvider labelProvider = new CompareInputLabelProvider();
    private Object fetchingInput;

    public static ResourceCompareInputChangeNotifier getChangeNotifier(ISynchronizationContext context) {
        ResourceCompareInputChangeNotifier notifier = (ResourceCompareInputChangeNotifier)context.getCache().get(RESOURCE_CHANGE_NOTIFIER_PROPERTY);
        if (notifier == null) {
            notifier = new ResourceCompareInputChangeNotifier(context);
            context.getCache().put(RESOURCE_CHANGE_NOTIFIER_PROPERTY, (Object)notifier);
        }
        return notifier;
    }

    public ResourceCompareInputChangeNotifier(ISynchronizationContext context) {
        this.context = context;
        this.initialize();
    }

    @Override
    public void initialize() {
        this.context.getDiffTree().addDiffChangeListener((IDiffChangeListener)this);
        this.context.getCache().addCacheListener(cache -> this.dispose());
        super.initialize();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.context.getDiffTree().removeDiffChangeListener((IDiffChangeListener)this);
        this.labelProvider.dispose();
    }

    public void diffsChanged(IDiffChangeEvent event, IProgressMonitor monitor) {
        IPath[] paths;
        IDiff[] changed;
        IDiff[] added;
        HashSet<ICompareInput> changedInputs = new HashSet<ICompareInput>();
        IDiff[] iDiffArray = added = event.getAdditions();
        int n = added.length;
        int n2 = 0;
        while (n2 < n) {
            IDiff diff = iDiffArray[n2];
            ICompareInput input = this.findInput(ResourceDiffTree.getResourceFor((IDiff)diff));
            if (input != null) {
                changedInputs.add(input);
            }
            ++n2;
        }
        IDiff[] iDiffArray2 = changed = event.getChanges();
        int n3 = changed.length;
        n = 0;
        while (n < n3) {
            IDiff diff = iDiffArray2[n];
            ICompareInput input = this.findInput(ResourceDiffTree.getResourceFor((IDiff)diff));
            if (input != null) {
                changedInputs.add(input);
            }
            ++n;
        }
        IPath[] iPathArray = paths = event.getRemovals();
        int n4 = paths.length;
        n3 = 0;
        while (n3 < n4) {
            IPath path = iPathArray[n3];
            ICompareInput input = this.findInput(path);
            if (input != null) {
                changedInputs.add(input);
            }
            ++n3;
        }
        if (!changedInputs.isEmpty()) {
            this.handleInputChanges(changedInputs.toArray(new ICompareInput[changedInputs.size()]), false);
        }
    }

    public void propertyChanged(IDiffTree tree, int property, IPath[] paths) {
    }

    @Override
    protected IResource[] getResources(ICompareInput input) {
        IResource resource = this.getResource(input);
        if (resource == null) {
            return new IResource[0];
        }
        return new IResource[]{resource};
    }

    private IResource getResource(ICompareInput input) {
        if (input instanceof IResourceProvider) {
            IResourceProvider rp = (IResourceProvider)input;
            return rp.getResource();
        }
        return Utils.getResource(input);
    }

    private ICompareInput findInput(IPath path) {
        ICompareInput[] inputs;
        ICompareInput[] iCompareInputArray = inputs = this.getConnectedInputs();
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            ICompareInput input = iCompareInputArray[n2];
            IResource inputResource = this.getResource(input);
            if (inputResource != null && inputResource.getFullPath().equals((Object)path)) {
                return input;
            }
            ++n2;
        }
        return null;
    }

    private ICompareInput findInput(IResource resource) {
        ICompareInput[] inputs;
        ICompareInput[] iCompareInputArray = inputs = this.getConnectedInputs();
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            ICompareInput input = iCompareInputArray[n2];
            IResource inputResource = this.getResource(input);
            if (inputResource != null && inputResource.equals((Object)resource)) {
                return input;
            }
            ++n2;
        }
        return null;
    }

    @Override
    protected void prepareInput(ICompareInput input, IProgressMonitor monitor) {
        if (input instanceof ResourceDiffCompareInput) {
            ResourceDiffCompareInput rdci = (ResourceDiffCompareInput)input;
            IResource resource = rdci.getResource();
            IDiff diff = this.getContext().getDiffTree().getDiff(resource);
            try {
                ResourceDiffCompareInput.ensureContentsCached(diff, monitor);
            }
            catch (CoreException e) {
                TeamUIPlugin.log(e);
            }
        }
        super.prepareInput(input, monitor);
    }

    public ICompareInputLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void fetchAuthors(ResourceDiffCompareInput input) {
        if (this.fetchingInput == input) {
            return;
        }
        this.fetchingInput = input;
        this.runInBackground(monitor -> this.fetchAuthors(input, monitor));
    }

    protected void fetchAuthors(ResourceDiffCompareInput input, IProgressMonitor monitor) throws CoreException {
        if (input.updateAuthorInfo(monitor)) {
            this.fireLabelProviderChange(input);
        }
    }

    private void fireLabelProviderChange(Object input) {
        this.labelProvider.fireChangeEvent(input);
    }

    public final ISynchronizationContext getContext() {
        return this.context;
    }

    @Override
    protected boolean belongsTo(Object family) {
        return family == this.getContext();
    }

    private class CompareInputLabelProvider
    extends BaseLabelProvider
    implements ICompareInputLabelProvider {
        private CompareInputLabelProvider() {
        }

        public Image getAncestorImage(Object input) {
            return null;
        }

        public String getAncestorLabel(Object input) {
            ResourceDiffCompareInput rdci;
            ITypedElement element;
            if (input instanceof ResourceDiffCompareInput && (element = (rdci = (ResourceDiffCompareInput)input).getAncestor()) != null) {
                IFileRevision revision = ((FileRevisionTypedElement)element).getFileRevision();
                if (revision != null) {
                    if (Utils.isShowAuthor()) {
                        String author = ((FileRevisionTypedElement)element).getAuthor();
                        if (author != null) {
                            return NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_baseLabelAuthorExists, (Object[])new String[]{revision.getContentIdentifier(), author});
                        }
                        if (revision.isPropertyMissing()) {
                            ResourceCompareInputChangeNotifier.this.fetchAuthors(rdci);
                        }
                    }
                    return NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_baseLabelExists, (Object[])new String[]{revision.getContentIdentifier()});
                }
                return TeamUIMessages.SyncInfoCompareInput_baseLabel;
            }
            return null;
        }

        public Image getLeftImage(Object input) {
            return null;
        }

        public String getLeftLabel(Object input) {
            if (input instanceof ResourceDiffCompareInput) {
                ResourceDiffCompareInput rdci = (ResourceDiffCompareInput)input;
                String localContentId = rdci.getLocalContentId();
                if (localContentId != null) {
                    ITypedElement element = rdci.getLeft();
                    if (element instanceof LocalResourceTypedElement && Utils.isShowAuthor()) {
                        String author = ((LocalResourceTypedElement)element).getAuthor();
                        if (author != null) {
                            return NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_localLabelAuthorExists, (Object[])new String[]{localContentId, author});
                        }
                        ResourceCompareInputChangeNotifier.this.fetchAuthors(rdci);
                    }
                    return NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_localLabelExists, (Object[])new String[]{localContentId});
                }
                return TeamUIMessages.SyncInfoCompareInput_localLabel;
            }
            return null;
        }

        public Image getRightImage(Object input) {
            return null;
        }

        public String getRightLabel(Object input) {
            ResourceDiffCompareInput rdci;
            ITypedElement element;
            if (input instanceof ResourceDiffCompareInput && (element = (rdci = (ResourceDiffCompareInput)input).getRight()) != null) {
                IFileRevision revision = ((FileRevisionTypedElement)element).getFileRevision();
                if (revision != null) {
                    if (Utils.isShowAuthor()) {
                        String author = ((FileRevisionTypedElement)element).getAuthor();
                        if (author != null) {
                            return NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_remoteLabelAuthorExists, (Object[])new String[]{revision.getContentIdentifier(), author});
                        }
                        if (revision.isPropertyMissing()) {
                            ResourceCompareInputChangeNotifier.this.fetchAuthors(rdci);
                        }
                    }
                    return NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_remoteLabelExists, (Object[])new String[]{revision.getContentIdentifier()});
                }
                return TeamUIMessages.SyncInfoCompareInput_remoteLabel;
            }
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof ICompareInput) {
                ICompareInput ci = (ICompareInput)element;
                return ci.getImage();
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ICompareInput) {
                ICompareInput ci = (ICompareInput)element;
                return ci.getName();
            }
            return null;
        }

        public void fireChangeEvent(Object element) {
            Display.getDefault().asyncExec(() -> this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, element)));
        }
    }
}

