/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ITraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.LogLevelType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceDomainType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceJulLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLog4jLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TracePythonLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.ui.Activator;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.BaseGetInfoDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IGetLoggerInfoDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;

public class GetLoggerInfoDialog
extends BaseGetInfoDialog
implements IGetLoggerInfoDialog {
    private Button fLogLevelButton;
    private Button fLogLevelOnlyButton;
    private CCombo fLogLevelCombo;
    private ITraceLogLevel fLogLevel;
    private LogLevelType fLogLevelType;
    private TraceDomainType fLoggerDomain = TraceDomainType.UNKNOWN;

    public GetLoggerInfoDialog(Shell shell) {
        super(shell);
    }

    @Override
    public ITraceLogLevel getLogLevel() {
        return this.fLogLevel;
    }

    @Override
    public LogLevelType getLogLevelType() {
        return this.fLogLevelType;
    }

    @Override
    public void setLoggerDomain(TraceDomainType domain) {
        this.fLoggerDomain = domain;
    }

    @Override
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.TraceControl_EnableLoggersDialogTitle);
        newShell.setImage(Activator.getDefault().loadIcon("icons/elcl16/enable_event.gif"));
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        this.fLogLevel = null;
        this.fLogLevelType = null;
        super.createDialogArea(parent);
        Composite dialogComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        dialogComposite.setLayout((Layout)layout);
        dialogComposite.setLayoutData((Object)new GridData(1808));
        this.fSessionsCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GetLoggerInfoDialog.this.fSessionIndex = GetLoggerInfoDialog.this.fSessionsCombo.getSelectionIndex();
                GetLoggerInfoDialog.this.fLogLevelCombo.setEnabled(GetLoggerInfoDialog.this.fSessionIndex >= 0);
                GetLoggerInfoDialog.this.fLogLevelButton.setEnabled(GetLoggerInfoDialog.this.fSessionsCombo.getText() != null);
                GetLoggerInfoDialog.this.fLogLevelOnlyButton.setEnabled(!GetLoggerInfoDialog.this.fSessionsCombo.getText().isEmpty());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group logLevelGroup = new Group(dialogComposite, 32);
        layout = new GridLayout(2, true);
        logLevelGroup.setLayout((Layout)layout);
        logLevelGroup.setLayoutData((Object)new GridData(768));
        GridData data = new GridData(768);
        this.fLogLevelButton = new Button((Composite)logLevelGroup, 16);
        this.fLogLevelButton.setText(Messages.TraceControl_EnableEventsLogLevelTypeName);
        this.fLogLevelButton.setToolTipText(Messages.TraceControl_EnableEventsLogLevelTypeTooltip);
        data = new GridData(1808);
        this.fLogLevelButton.setLayoutData((Object)data);
        this.fLogLevelButton.setSelection(true);
        this.fLogLevelOnlyButton = new Button((Composite)logLevelGroup, 16);
        this.fLogLevelOnlyButton.setText(Messages.TraceControl_EnableEventsLogLevelOnlyTypeName);
        this.fLogLevelOnlyButton.setToolTipText(Messages.TraceControl_EnableEventsLogLevelOnlyTypeTooltip);
        data = new GridData(1808);
        this.fLogLevelButton.setLayoutData((Object)data);
        String[] levelNames = null;
        switch (this.fLoggerDomain) {
            case JUL: {
                levelNames = GetLoggerInfoDialog.findLoglevelNames(TraceJulLogLevel.class);
                break;
            }
            case LOG4J: {
                levelNames = GetLoggerInfoDialog.findLoglevelNames(TraceLog4jLogLevel.class);
                break;
            }
            case PYTHON: {
                levelNames = GetLoggerInfoDialog.findLoglevelNames(TracePythonLogLevel.class);
                break;
            }
        }
        this.fLogLevelCombo = new CCombo((Composite)logLevelGroup, 8);
        this.fLogLevelCombo.setItems(levelNames);
        this.fLogLevelCombo.setToolTipText(Messages.TraceControl_EnableEventsLogLevelTooltip);
        data = new GridData(768);
        data.horizontalSpan = 4;
        this.fLogLevelCombo.setLayoutData((Object)data);
        this.fLogLevelCombo.setEnabled(false);
        this.fLogLevelButton.setEnabled(false);
        this.fLogLevelOnlyButton.setEnabled(false);
        this.getShell().setMinimumSize(new Point(300, 200));
        return dialogComposite;
    }

    protected void okPressed() {
        if (this.fSessionsCombo.getSelectionIndex() < 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_EnableLoggersDialogTitle, (String)Messages.TraceControl_EnableEventsNoSessionError);
            return;
        }
        this.fSessionIndex = this.fSessionsCombo.getSelectionIndex();
        this.fLogLevel = null;
        if (!this.fLogLevelCombo.getText().isEmpty()) {
            int id = this.fLogLevelCombo.getSelectionIndex();
            this.fLogLevel = (switch (this.fLoggerDomain) {
                case TraceDomainType.JUL -> TraceJulLogLevel.values();
                case TraceDomainType.LOG4J -> TraceLog4jLogLevel.values();
                case TraceDomainType.PYTHON -> TracePythonLogLevel.values();
                default -> TraceLogLevel.values();
            })[id];
            if (id < 0) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_EnableLoggersDialogTitle, (String)Messages.TraceControl_InvalidLogLevel);
            }
            this.fLogLevelType = LogLevelType.LOGLEVEL_NONE;
            if (this.fLogLevelButton.getSelection()) {
                this.fLogLevelType = LogLevelType.LOGLEVEL;
            } else if (this.fLogLevelOnlyButton.getSelection()) {
                this.fLogLevelType = LogLevelType.LOGLEVEL_ONLY;
            }
        }
        super.okPressed();
    }

    private static String[] findLoglevelNames(Class<? extends ITraceLogLevel> enumType) {
        ITraceLogLevel[] levels = enumType.getEnumConstants();
        if (levels == null) {
            return new String[0];
        }
        String[] levelNames = new String[levels.length - 1];
        int l = 0;
        int i = 0;
        while (i < levels.length) {
            if (!(levels[i].equals(TraceLog4jLogLevel.LEVEL_UNKNOWN) || levels[i].equals(TracePythonLogLevel.LEVEL_UNKNOWN) || levels[i].equals(TraceJulLogLevel.LEVEL_UNKNOWN))) {
                levelNames[l++] = levels[i].getInName();
            }
            ++i;
        }
        return levelNames;
    }
}

