/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.application;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.window.Window;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.ChooseWorkspaceData;
import org.eclipse.ui.internal.ide.ChooseWorkspaceDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.ide.application.DelayedEventsProcessor;
import org.eclipse.ui.internal.ide.application.IDEWorkbenchAdvisor;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class IDEApplication
implements IApplication,
IExecutableExtension {
    public static final String METADATA_FOLDER = ".metadata";
    private static final String VERSION_FILENAME = "version.ini";
    private static final Path LOCK_INFO_FILE = Path.of(".metadata", ".lock_info");
    private static final String DISPLAY_VAR = "DISPLAY";
    private static final String HOST_NAME_VAR = "HOSTNAME";
    private static final String PROCESS_ID = "process-id";
    private static final String DISPLAY = "display";
    private static final String HOST = "host";
    private static final String USER = "user";
    private static final String USER_NAME = "user.name";
    private static final String WORKSPACE_CHECK_REFERENCE_BUNDLE_NAME = "org.eclipse.platform";
    private static final Version WORKSPACE_CHECK_REFERENCE_BUNDLE_VERSION;
    private static final String WORKSPACE_CHECK_REFERENCE_BUNDLE_NAME_LEGACY = "org.eclipse.core.runtime";
    private static final String WORKSPACE_CHECK_LEGACY_VERSION_INCREMENTED = "2";
    private static final int RETRY_LOAD = 0;
    private static final Integer EXIT_WORKSPACE_LOCKED;
    public static final String PLUGIN_ID = "org.eclipse.ui.ide.application";

    static {
        Bundle bundle = Platform.getBundle((String)WORKSPACE_CHECK_REFERENCE_BUNDLE_NAME);
        WORKSPACE_CHECK_REFERENCE_BUNDLE_VERSION = bundle != null ? bundle.getVersion() : null;
        EXIT_WORKSPACE_LOCKED = 15;
    }

    public Object start(IApplicationContext appContext) throws Exception {
        Job.getJobManager().suspend();
        Display display = this.createDisplay();
        DelayedEventsProcessor processor = new DelayedEventsProcessor(display);
        try {
            Object instanceLocationCheck;
            Shell shell = WorkbenchPlugin.getSplashShell((Display)display);
            if (shell != null) {
                shell.setText(ChooseWorkspaceDialog.getWindowTitle());
                shell.setImages(Window.getDefaultImages());
            }
            if ((instanceLocationCheck = this.checkInstanceLocation(shell, appContext.getArguments())) != null) {
                WorkbenchPlugin.unsetSplashShell((Display)display);
                Object object = instanceLocationCheck;
                return object;
            }
            int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new IDEWorkbenchAdvisor(processor));
            if (returnCode != 1) {
                Integer n = EXIT_OK;
                return n;
            }
            Integer n = EXIT_RELAUNCH.equals(Integer.getInteger("eclipse.exitcode")) ? EXIT_RELAUNCH : EXIT_RESTART;
            return n;
        }
        finally {
            Location instanceLoc;
            if (display != null) {
                display.dispose();
            }
            if ((instanceLoc = Platform.getInstanceLocation()) != null) {
                instanceLoc.release();
            }
        }
    }

    protected Display createDisplay() {
        return PlatformUI.createDisplay();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
    }

    protected Object checkInstanceLocation(Shell shell, Map applicationArguments) {
        Location instanceLoc = Platform.getInstanceLocation();
        if (instanceLoc == null) {
            MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceMandatoryTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceMandatoryMessage);
            return EXIT_OK;
        }
        boolean force = false;
        if (instanceLoc.isSet()) {
            ReturnCode result = this.checkValidWorkspace(shell, instanceLoc.getURL());
            if (result == ReturnCode.EXIT) {
                return EXIT_OK;
            }
            if (result == ReturnCode.VALID) {
                block23: {
                    if (!instanceLoc.lock()) break block23;
                    IDEApplication.writeWorkspaceVersion();
                    this.writeWsLockInfo(instanceLoc.getURL());
                    return null;
                }
                try {
                    File workspaceDirectory = new File(instanceLoc.getURL().getFile());
                    if (workspaceDirectory.exists()) {
                        if (IDEApplication.isDevLaunchMode(applicationArguments)) {
                            return EXIT_WORKSPACE_LOCKED;
                        }
                        Object wsLockedError = NLS.bind((String)IDEWorkbenchMessages.IDEApplication_workspaceCannotLockMessage, (Object)workspaceDirectory.getAbsolutePath());
                        String lockInfo = this.getWorkspaceLockInfo(instanceLoc.getURL());
                        if (lockInfo != null && !lockInfo.isBlank()) {
                            wsLockedError = (String)wsLockedError + System.lineSeparator() + System.lineSeparator() + NLS.bind((String)IDEWorkbenchMessages.IDEApplication_Ws_Lock_Owner_Message, (Object)lockInfo);
                        }
                        MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotLockTitle, (String)wsLockedError);
                    } else {
                        MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotBeSetTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotBeSetMessage);
                    }
                }
                catch (IOException e) {
                    IDEWorkbenchPlugin.log((String)"Could not obtain lock for workspace location", (Throwable)e);
                    MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.InternalError, (String)e.getMessage());
                }
                return EXIT_OK;
            }
            if (result == ReturnCode.INVALID) {
                force = true;
            }
        }
        ChooseWorkspaceData launchData = new ChooseWorkspaceData(instanceLoc.getDefault());
        boolean parentShellVisible = false;
        if (Util.isValid((Widget)shell) && (parentShellVisible = shell.getVisible()) && launchData.getShowDialog()) {
            shell.setVisible(false);
        }
        int returnValue = -1;
        URL workspaceUrl = null;
        while (true) {
            if (returnValue != 0) {
                try {
                    workspaceUrl = this.promptForWorkspace(shell, launchData, force);
                }
                catch (OperationCanceledException e) {
                    launchData = new ChooseWorkspaceData(instanceLoc.getDefault());
                    force = true;
                    continue;
                }
            }
            if (workspaceUrl == null) {
                return EXIT_OK;
            }
            force = true;
            try {
                if (instanceLoc.isSet()) {
                    return Workbench.setRestartArguments((String)workspaceUrl.getFile());
                }
                if (instanceLoc.set(workspaceUrl, true)) {
                    launchData.writePersistedData();
                    IDEApplication.writeWorkspaceVersion();
                    this.writeWsLockInfo(instanceLoc.getURL());
                    return null;
                }
            }
            catch (IllegalStateException e) {
                MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotBeSetTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotBeSetMessage);
                return EXIT_OK;
            }
            catch (IOException e) {
                MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotBeSetTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceCannotBeSetMessage);
            }
            final String lockInfo = this.getWorkspaceLockInfo(workspaceUrl);
            MessageDialog dialog = new MessageDialog(null, IDEWorkbenchMessages.IDEApplication_workspaceInUseTitle, null, NLS.bind((String)IDEWorkbenchMessages.IDEApplication_workspaceInUseMessage, (Object)workspaceUrl.getFile()), 1, 1, new String[]{IDEWorkbenchMessages.IDEApplication_workspaceInUse_Retry, IDEWorkbenchMessages.IDEApplication_workspaceInUse_Choose}){

                protected Control createCustomArea(Composite parent) {
                    if (lockInfo == null || lockInfo.isBlank()) {
                        return null;
                    }
                    Composite container = new Composite(parent, 0);
                    container.setLayout((Layout)new FillLayout());
                    Label multiLineText = new Label(container, 0);
                    multiLineText.setText(NLS.bind((String)IDEWorkbenchMessages.IDEApplication_Ws_Lock_Owner_Message, (Object)lockInfo));
                    return container;
                }
            };
            returnValue = dialog.open();
            launchData.writePersistedData();
        }
    }

    protected String getWorkspaceLockInfo(URL workspaceUrl) {
        Path lockFile;
        block16: {
            try {
                lockFile = IDEApplication.getLockInfoFile(workspaceUrl);
                if (Files.exists(lockFile, new LinkOption[0])) break block16;
                return null;
            }
            catch (Exception e) {
                IDEWorkbenchPlugin.log((String)"Could not read lock info file: ", (Throwable)e);
                return null;
            }
        }
        StringBuilder sb = new StringBuilder();
        Properties props = new Properties();
        Throwable throwable = null;
        Object var6_8 = null;
        try (InputStream is = Files.newInputStream(lockFile, new OpenOption[0]);){
            props.load(is);
            String prop = props.getProperty(USER);
            if (prop != null) {
                sb.append(NLS.bind((String)IDEWorkbenchMessages.IDEApplication_Ws_Lock_Owner_User, (Object)prop));
            }
            if ((prop = props.getProperty(HOST)) != null) {
                sb.append(NLS.bind((String)IDEWorkbenchMessages.IDEApplication_Ws_Lock_Owner_Host, (Object)prop));
            }
            if ((prop = props.getProperty(DISPLAY)) != null) {
                sb.append(NLS.bind((String)IDEWorkbenchMessages.IDEApplication_Ws_Lock_Owner_Disp, (Object)prop));
            }
            if ((prop = props.getProperty(PROCESS_ID)) != null) {
                sb.append(NLS.bind((String)IDEWorkbenchMessages.IDEApplication_Ws_Lock_Owner_P_Id, (Object)prop));
            }
            return sb.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void writeWsLockInfo(URL workspaceUrl) {
        String pid;
        String display;
        String host;
        Properties props = new Properties();
        String user = System.getProperty(USER_NAME);
        if (user != null) {
            props.setProperty(USER, user);
        }
        if ((host = this.getHostName()) != null) {
            props.setProperty(HOST, host);
        }
        if ((display = this.getDisplay()) != null) {
            props.setProperty(DISPLAY, display);
        }
        if ((pid = this.getProcessId()) != null) {
            props.setProperty(PROCESS_ID, pid);
        }
        if (props.isEmpty()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (OutputStream output = Files.newOutputStream(IDEApplication.createLockInfoFile(workspaceUrl), new OpenOption[0]);){
                props.store(output, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            IDEWorkbenchPlugin.log((String)"Could not write lock info file", (Throwable)e);
        }
    }

    private String getDisplay() {
        String displayEnv = null;
        try {
            displayEnv = System.getenv(DISPLAY_VAR);
        }
        catch (Exception e) {
            IDEWorkbenchPlugin.log((String)"Failed to read DISPLAY variable.", (Throwable)e);
        }
        return displayEnv;
    }

    private String getProcessId() {
        Long pid = null;
        try {
            pid = ProcessHandle.current().pid();
        }
        catch (Exception e) {
            IDEWorkbenchPlugin.log((String)"Failed to read Java process id.", (Throwable)e);
        }
        return pid != null ? pid.toString() : null;
    }

    private String getHostName() {
        String hostName = null;
        try {
            hostName = System.getenv(HOST_NAME_VAR);
            if (hostName != null && !hostName.isEmpty()) {
                return hostName;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            IDEWorkbenchPlugin.log((String)"Failed to read host name.", (Throwable)e);
        }
        return hostName;
    }

    private static Path getLockInfoFile(URL workspaceUrl) {
        try {
            return Path.of(URIUtil.toURI((URL)workspaceUrl)).resolve(LOCK_INFO_FILE);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Path createLockInfoFile(URL workspaceUrl) throws Exception {
        Path lockInfoFile = IDEApplication.getLockInfoFile(workspaceUrl);
        if (!Files.exists(lockInfoFile, new LinkOption[0])) {
            Files.createFile(lockInfoFile, new FileAttribute[0]);
        }
        return lockInfoFile;
    }

    private static boolean isDevLaunchMode(Map args) {
        if (Boolean.getBoolean("eclipse.pde.launch")) {
            return true;
        }
        return args.containsKey("-pdelaunch");
    }

    private URL promptForWorkspace(Shell shell, ChooseWorkspaceData launchData, boolean force) {
        URL url = null;
        while (true) {
            this.showChooseWorkspaceDialog(shell, launchData, force);
            String instancePath = launchData.getSelection();
            if (instancePath == null) {
                return null;
            }
            force = true;
            if (instancePath.length() <= 0) {
                MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceEmptyTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceEmptyMessage);
                continue;
            }
            File workspace = new File(instancePath);
            if (!workspace.exists()) {
                workspace.mkdir();
            }
            try {
                String path = workspace.getAbsolutePath().replace(File.separatorChar, '/');
                url = new URL("file", null, path);
            }
            catch (MalformedURLException e) {
                MessageDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.IDEApplication_workspaceInvalidTitle, (String)IDEWorkbenchMessages.IDEApplication_workspaceInvalidMessage);
                continue;
            }
            break;
        }
        ReturnCode result = this.checkValidWorkspace(shell, url);
        if (result == ReturnCode.INVALID) {
            throw new OperationCanceledException("Invalid workspace location: " + String.valueOf(url));
        }
        if (result == ReturnCode.EXIT) {
            return null;
        }
        return url;
    }

    protected void showChooseWorkspaceDialog(Shell shell, ChooseWorkspaceData launchData, boolean force) {
        new ChooseWorkspaceDialog(shell, launchData, false, true){

            protected Shell getParentShell() {
                return null;
            }
        }.prompt(force);
    }

    protected ReturnCode checkValidWorkspace(Shell shell, URL url) {
        String message;
        String title;
        int severity;
        if (url == null) {
            return ReturnCode.INVALID;
        }
        if (WORKSPACE_CHECK_REFERENCE_BUNDLE_VERSION == null) {
            return ReturnCode.VALID;
        }
        int versionCompareResult = this.compareWorkspaceAndIdeVersions(url);
        if (versionCompareResult == 0) {
            return ReturnCode.VALID;
        }
        if (versionCompareResult < 0) {
            severity = 2;
            title = IDEWorkbenchMessages.IDEApplication_versionTitle_olderWorkspace;
            message = NLS.bind((String)IDEWorkbenchMessages.IDEApplication_versionMessage_olderWorkspace, (Object)url.getFile());
        } else {
            severity = 4;
            title = IDEWorkbenchMessages.IDEApplication_versionTitle_newerWorkspace;
            message = NLS.bind((String)IDEWorkbenchMessages.IDEApplication_versionMessage_newerWorkspace, (Object)url.getFile());
        }
        ScopedPreferenceStore prefStore = new ScopedPreferenceStore(ConfigurationScope.INSTANCE, "org.eclipse.ui.ide");
        boolean keepOnWarning = prefStore.getBoolean("WARN_ABOUT_WORKSPACE_INCOMPATIBILITY");
        if (keepOnWarning) {
            int returnCode;
            LinkedHashMap<String, Integer> buttonLabelToId = new LinkedHashMap<String, Integer>();
            buttonLabelToId.put(IDEWorkbenchMessages.IDEApplication_version_continue, 2);
            buttonLabelToId.put(IDEWorkbenchMessages.IDEApplication_version_switch, 8);
            buttonLabelToId.put(IDEWorkbenchMessages.IDEApplication_version_exit, 12);
            MessageDialogWithToggle dialog = new MessageDialogWithToggle(shell, title, null, message, severity, buttonLabelToId, 0, IDEWorkbenchMessages.IDEApplication_version_doNotWarnAgain, false){

                protected Shell getParentShell() {
                    return null;
                }
            };
            if (Util.isValid((Widget)shell)) {
                shell.setVisible(false);
            }
            if ((returnCode = dialog.open()) == 8 || returnCode == -1) {
                return ReturnCode.INVALID;
            }
            if (returnCode == 12) {
                return ReturnCode.EXIT;
            }
            keepOnWarning = !dialog.getToggleState();
            try {
                prefStore.setValue("WARN_ABOUT_WORKSPACE_INCOMPATIBILITY", keepOnWarning);
                prefStore.save();
            }
            catch (IOException e) {
                IDEWorkbenchPlugin.log((String)"Error writing to configuration preferences", (IStatus)new Status(4, "org.eclipse.ui.ide", e.getMessage(), (Throwable)e));
            }
        }
        return ReturnCode.VALID;
    }

    protected int compareWorkspaceAndIdeVersions(URL url) {
        Version version = IDEApplication.readWorkspaceVersion(url);
        if (version == null) {
            return 0;
        }
        Version ide_version = IDEApplication.toMajorMinorVersion(WORKSPACE_CHECK_REFERENCE_BUNDLE_VERSION);
        Version workspace_version = IDEApplication.toMajorMinorVersion(version);
        return workspace_version.compareTo(ide_version);
    }

    protected static Version readWorkspaceVersion(URL workspace) {
        File versionFile = IDEApplication.getVersionFile(workspace, false);
        if (versionFile == null || !versionFile.exists()) {
            return null;
        }
        try {
            Properties props = new Properties();
            Throwable throwable = null;
            Object var4_7 = null;
            try (FileInputStream is = new FileInputStream(versionFile);){
                props.load(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            String versionString = props.getProperty(WORKSPACE_CHECK_REFERENCE_BUNDLE_NAME);
            if (versionString != null) {
                return Version.parseVersion((String)versionString);
            }
            versionString = props.getProperty(WORKSPACE_CHECK_REFERENCE_BUNDLE_NAME_LEGACY);
            if (versionString != null) {
                return Version.parseVersion((String)versionString);
            }
            return null;
        }
        catch (IOException e) {
            IDEWorkbenchPlugin.log((String)("Could not read version file " + String.valueOf(versionFile)), (IStatus)new Status(4, "org.eclipse.ui.ide", 4, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e));
            return null;
        }
        catch (IllegalArgumentException e) {
            IDEWorkbenchPlugin.log((String)("Could not parse version in " + String.valueOf(versionFile)), (IStatus)new Status(4, "org.eclipse.ui.ide", 4, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e));
            return null;
        }
    }

    private static void writeWorkspaceVersion() {
        if (WORKSPACE_CHECK_REFERENCE_BUNDLE_VERSION == null) {
            return;
        }
        Location instanceLoc = Platform.getInstanceLocation();
        if (instanceLoc == null || instanceLoc.isReadOnly()) {
            return;
        }
        File versionFile = IDEApplication.getVersionFile(instanceLoc.getURL(), true);
        if (versionFile == null) {
            return;
        }
        Properties props = new Properties();
        props.setProperty(WORKSPACE_CHECK_REFERENCE_BUNDLE_NAME, WORKSPACE_CHECK_REFERENCE_BUNDLE_VERSION.toString());
        props.setProperty(WORKSPACE_CHECK_REFERENCE_BUNDLE_NAME_LEGACY, WORKSPACE_CHECK_LEGACY_VERSION_INCREMENTED);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileOutputStream output = new FileOutputStream(versionFile);){
                props.store(output, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            IDEWorkbenchPlugin.log((String)"Could not write version file", (IStatus)StatusUtil.newError((Throwable)e));
        }
    }

    protected static File getVersionFile(URL workspaceUrl, boolean create) {
        File versionFile;
        block6: {
            File metaDir;
            block5: {
                if (workspaceUrl == null) {
                    return null;
                }
                try {
                    metaDir = new File(workspaceUrl.getPath(), METADATA_FOLDER);
                    if (metaDir.exists() || create && metaDir.mkdir()) break block5;
                    return null;
                }
                catch (IOException e) {
                    return null;
                }
            }
            versionFile = new File(metaDir, VERSION_FILENAME);
            if (versionFile.exists() || create && versionFile.createNewFile()) break block6;
            return null;
        }
        return versionFile;
    }

    protected static Version toMajorMinorVersion(Version version) {
        return new Version(version.getMajor(), version.getMinor(), 0);
    }

    public void stop() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        Display display = workbench.getDisplay();
        display.syncExec(() -> {
            if (!display.isDisposed()) {
                workbench.close();
            }
        });
    }

    public static enum ReturnCode {
        VALID,
        INVALID,
        EXIT;

    }
}

