/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.traceevent.core.analysis.objectlife;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.traceevent.core.event.TraceEventAspects;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class ObjectLifeStateProvider
extends AbstractTmfStateProvider {
    public ObjectLifeStateProvider(@NonNull ITmfTrace trace) {
        super(trace, "org.eclipse.tracecompass.incubator.traceevent.analysis.objectlife");
    }

    public int getVersion() {
        return 1;
    }

    public @NonNull ITmfStateProvider getNewInstance() {
        return new ObjectLifeStateProvider(this.getTrace());
    }

    protected void eventHandle(@NonNull ITmfEvent event) {
        ITmfStateSystemBuilder ss = this.getStateSystemBuilder();
        if (ss == null) {
            return;
        }
        String phase = (String)event.getContent().getFieldValue(String.class, new String[]{"ph"});
        if (phase == null) {
            return;
        }
        long t = event.getTimestamp().toNanos();
        int quark = -2;
        Object id = TmfTraceUtils.resolveEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TraceEventAspects.ID_ASPECT.getClass(), (ITmfEvent)event);
        String name = String.valueOf(TmfTraceUtils.resolveAspectOfNameForEvent((ITmfTrace)event.getTrace(), (String)"Name", (ITmfEvent)event));
        if (id == null) {
            return;
        }
        switch (phase) {
            case "N": {
                quark = ss.getQuarkAbsoluteAndAdd(new String[]{name, String.valueOf(id)});
                ss.modifyAttribute(t, (Object)"", quark);
                break;
            }
            case "O": {
                quark = ss.getQuarkAbsoluteAndAdd(new String[]{name, String.valueOf(id)});
                ss.modifyAttribute(t, (Object)String.valueOf(TraceEventAspects.ARGS_ASPECT.resolve(event)), quark);
                break;
            }
            case "D": {
                quark = ss.getQuarkAbsoluteAndAdd(new String[]{name, String.valueOf(id)});
                ss.modifyAttribute(t, null, quark);
                break;
            }
        }
    }
}

