/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completion.provider;

import org.eclipse.ease.ICompletionContext;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.ui.Activator;
import org.eclipse.ease.ui.completion.IImageResolver;
import org.eclipse.ease.ui.completion.provider.AbstractCompletionProvider;
import org.eclipse.ease.ui.completion.tokenizer.TokenList;
import org.eclipse.ease.ui.modules.ui.ModulesTools;
import org.eclipse.jface.viewers.StyledString;

public class LoadedModuleCompletionProvider
extends AbstractCompletionProvider {
    @Override
    public boolean isActive(ICompletionContext context) {
        return super.isActive(context) && this.isModuleMethodFilter(context);
    }

    private boolean isModuleMethodFilter(ICompletionContext context) {
        TokenList tokensToInvestigate = new TokenList(context.getTokens());
        TokenList methodCall = tokensToInvestigate.getFromLast("(");
        if (!methodCall.isEmpty()) {
            methodCall.remove(0);
            while (methodCall.removeIfMatches(0, ",")) {
            }
            tokensToInvestigate = methodCall;
        }
        if (tokensToInvestigate.isEmpty()) {
            return true;
        }
        return tokensToInvestigate.size() == 1 && tokensToInvestigate.get(0) instanceof String && !context.isStringLiteral(tokensToInvestigate.get(0).toString());
    }

    @Override
    protected void prepareProposals(ICompletionContext context) {
        for (ModuleDefinition definition : context.getLoadedModules()) {
            definition.getFields().stream().filter(f -> f.getName().startsWith(context.getFilter())).forEach(field -> {
                StyledString styledString = new StyledString(field.getName());
                styledString.append(" : " + field.getType().getSimpleName(), StyledString.DECORATIONS_STYLER);
                styledString.append(" - " + definition.getName(), StyledString.QUALIFIER_STYLER);
                this.addProposal(styledString, field.getName(), (IImageResolver)new AbstractCompletionProvider.DescriptorImageResolver(Activator.getLocalImageDescriptor("/icons/eobj16/field_public_obj.png")), 80, null);
            });
            definition.getMethods().stream().filter(m -> m.getName().startsWith(context.getFilter())).forEach(method -> {
                StyledString styledString = ModulesTools.getSignature(method, true);
                styledString.append(" - " + definition.getName(), StyledString.QUALIFIER_STYLER);
                if (method.getParameterTypes().length - ModulesTools.getOptionalParameterCount(method) > 0) {
                    this.addProposal(styledString, String.valueOf(method.getName()) + "(", (IImageResolver)new AbstractCompletionProvider.DescriptorImageResolver(Activator.getLocalImageDescriptor("/icons/eobj16/field_public_obj.png")), 90, null);
                } else {
                    this.addProposal(styledString, String.valueOf(method.getName()) + "()", (IImageResolver)new AbstractCompletionProvider.DescriptorImageResolver(Activator.getLocalImageDescriptor("/icons/eobj16/field_public_obj.png")), 90, null);
                }
            });
        }
    }
}

