/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.pty;

import java.io.IOException;
import org.eclipse.cdt.internal.core.natives.CNativePlugin;
import org.eclipse.cdt.internal.core.natives.Messages;
import org.eclipse.cdt.utils.pty.ConPTY;
import org.eclipse.cdt.utils.pty.ConPTYInputStream;
import org.eclipse.cdt.utils.pty.ConPTYOutputStream;
import org.eclipse.cdt.utils.pty.PTYInputStream;
import org.eclipse.cdt.utils.pty.PTYOutputStream;
import org.eclipse.cdt.utils.spawner.Spawner;
import org.eclipse.core.runtime.Platform;

public class PTY {
    final Mode mode;
    final String slave;
    final PTYInputStream in;
    final PTYOutputStream out;
    int master;
    private static boolean hasPTY;
    private static IS_CONPTY isConPTY;
    private static boolean isWinPTY;
    private static boolean isConsoleModeSupported;
    private static boolean setTerminalSizeErrorAlreadyLogged;
    private ConPTY conPTY;

    static {
        isConPTY = IS_CONPTY.CONPTY_UNKNOWN;
        try {
            boolean conPtyEnabled;
            boolean isWindows = "win32".equals(Platform.getOS());
            if (!isWindows) {
                isConPTY = IS_CONPTY.CONPTY_NO;
            }
            if (!(conPtyEnabled = Boolean.parseBoolean(System.getProperty("org.eclipse.cdt.core.conpty_enabled", "true")))) {
                isConPTY = IS_CONPTY.CONPTY_NO;
            }
            isWinPTY = isWindows;
            if (isWindows) {
                System.loadLibrary("winpty");
            }
            System.loadLibrary("pty");
            hasPTY = true;
            isConsoleModeSupported = !isWinPTY || Boolean.getBoolean("org.eclipse.cdt.core.winpty_console_mode");
        }
        catch (SecurityException | UnsatisfiedLinkError e) {
            CNativePlugin.log("Failed to load the PTY library. This may indicate a configuration problem, but can be ignored if no further problems are observed.", e);
        }
    }

    @Deprecated
    public static boolean isSupported() {
        return PTY.isSupported(Mode.CONSOLE);
    }

    public static boolean isSupported(Mode mode) {
        return hasPTY && (isConsoleModeSupported || mode == Mode.TERMINAL);
    }

    public PTY() throws IOException {
        this(Mode.CONSOLE);
    }

    public PTY(Mode mode) throws IOException {
        this.mode = mode;
        if (this.isConsole() && !isConsoleModeSupported) {
            throw new IOException(Messages.Util_exception_cannotCreatePty);
        }
        PTYInputStream inInit = null;
        PTYOutputStream outInit = null;
        String slaveInit = null;
        if (isConPTY != IS_CONPTY.CONPTY_NO) {
            try {
                this.conPTY = new ConPTY();
                isConPTY = IS_CONPTY.CONPTY_YES;
                slaveInit = "conpty";
                inInit = new ConPTYInputStream(this.conPTY);
                outInit = new ConPTYOutputStream(this.conPTY);
            }
            catch (NoClassDefFoundError e) {
                isConPTY = IS_CONPTY.CONPTY_NO;
                CNativePlugin.log(Messages.PTY_NoClassDefFoundError, e);
            }
            catch (Throwable e) {
                isConPTY = IS_CONPTY.CONPTY_NO;
                CNativePlugin.log(Messages.PTY_FailedToStartConPTY, e);
            }
        }
        if (isConPTY == IS_CONPTY.CONPTY_NO) {
            String string = slaveInit = hasPTY ? this.openMaster(this.isConsole()) : null;
            if (slaveInit == null) {
                throw new IOException(Messages.Util_exception_cannotCreatePty);
            }
            inInit = new PTYInputStream(new MasterFD());
            outInit = new PTYOutputStream(new MasterFD(), !isWinPTY);
        }
        this.slave = slaveInit;
        this.in = inInit;
        this.out = outInit;
    }

    public void validateSlaveName() throws IOException {
        if (isWinPTY) {
            throw new IOException("Slave name is not valid");
        }
    }

    public String getSlaveName() {
        return this.slave;
    }

    public MasterFD getMasterFD() {
        return new MasterFD();
    }

    public final boolean isConsole() {
        return this.mode == Mode.CONSOLE;
    }

    public PTYOutputStream getOutputStream() {
        return this.out;
    }

    public PTYInputStream getInputStream() {
        return this.in;
    }

    public final void setTerminalSize(int width, int height) {
        block4: {
            try {
                if (isConPTY == IS_CONPTY.CONPTY_YES) {
                    this.conPTY.setTerminalSize(width, height);
                } else {
                    this.change_window_size(this.master, width, height);
                }
            }
            catch (IOException | UnsatisfiedLinkError e) {
                if (setTerminalSizeErrorAlreadyLogged) break block4;
                setTerminalSizeErrorAlreadyLogged = true;
                CNativePlugin.log(Messages.Util_exception_cannotSetTerminalSize, e);
            }
        }
    }

    public int exec_pty(Spawner spawner, String[] cmdarray, String[] envp, String dir, Spawner.IChannel[] chan) throws IOException {
        if (isConPTY == IS_CONPTY.CONPTY_YES) {
            return this.conPTY.exec(cmdarray, envp, dir);
        }
        if (isWinPTY) {
            return this.exec2(cmdarray, envp, dir, chan, this.slave, this.master, this.isConsole());
        }
        return spawner.exec2(cmdarray, envp, dir, chan, this.slave, this.master, this.isConsole());
    }

    public int waitFor(Spawner spawner, int pid) {
        if (isConPTY == IS_CONPTY.CONPTY_YES) {
            return this.conPTY.waitFor();
        }
        if (isWinPTY) {
            return this.waitFor(this.master, pid);
        }
        return spawner.waitFor(pid);
    }

    native String openMaster(boolean var1);

    native int change_window_size(int var1, int var2, int var3);

    native int exec2(String[] var1, String[] var2, String var3, Spawner.IChannel[] var4, String var5, int var6, boolean var7) throws IOException;

    native int waitFor(int var1, int var2);

    private static enum IS_CONPTY {
        CONPTY_UNKNOWN,
        CONPTY_YES,
        CONPTY_NO;

    }

    public class MasterFD {
        public int getFD() {
            return PTY.this.master;
        }

        void setFD(int fd) {
            PTY.this.master = fd;
        }
    }

    public static enum Mode {
        CONSOLE,
        TERMINAL;

    }
}

