/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.internal.base.util.ProxyUtil;
import org.eclipse.help.internal.webapp.utils.Utils;

public class ContentService
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setCharacterEncoding("UTF-8");
        String baseURL = req.getRequestURL().toString();
        Object contentURL = baseURL.replaceFirst("/vs/service", "");
        String query = req.getQueryString();
        if (query != null) {
            contentURL = (String)contentURL + "?" + query;
        }
        URL url = new URL((String)contentURL);
        URLConnection con = ProxyUtil.getConnection((URL)url);
        con.setAllowUserInteraction(false);
        con.setDoInput(true);
        con.connect();
        ServletContext context = this.getServletContext();
        String pathInfo = req.getPathInfo();
        String mimeType = context.getMimeType(pathInfo);
        String contentType = mimeType != null && !mimeType.equals("application/xhtml+xml") ? mimeType : con.getContentType();
        resp.setContentType(contentType);
        InputStream is = con.getInputStream();
        ServletOutputStream out = resp.getOutputStream();
        if (!(contentType.equals("application/xhtml+xml") || contentType.equals("text/html") || con.getContentType().equals("text/html"))) {
            Utils.transferContent(is, (OutputStream)out);
            out.flush();
        } else {
            String response = Utils.readString(url);
            response = Utils.updateResponse(response);
            Throwable throwable = null;
            Object var16_17 = null;
            try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));){
                writer.write(response);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

