/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.plugin.util;

import com.microsoft.java.test.plugin.model.JavaTestItem;
import com.microsoft.java.test.plugin.model.TestKind;
import com.microsoft.java.test.plugin.model.TestLevel;
import com.microsoft.java.test.plugin.model.builder.JavaTestItemBuilder;
import com.microsoft.java.test.plugin.provider.TestKindProvider;
import com.microsoft.java.test.plugin.searcher.TestFrameworkSearcher;
import com.microsoft.java.test.plugin.util.JUnitPlugin;
import com.microsoft.java.test.plugin.util.ProjectTestUtils;
import com.microsoft.java.test.plugin.util.TestFrameworkUtils;
import com.microsoft.java.test.plugin.util.TestItemUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.junit.util.CoreTestSearchEngine;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.lsp4j.Location;

public class TestSearchUtils {
    public static List<JavaTestItem> findJavaProjects(List<Object> arguments, IProgressMonitor monitor) {
        if (arguments == null || arguments.size() == 0) {
            return Collections.emptyList();
        }
        String workspaceFolderUri = (String)arguments.get(0);
        IPath workspaceFolderPath = ResourceUtils.canonicalFilePathFromURI((String)workspaceFolderUri);
        if (workspaceFolderPath == null) {
            JUnitPlugin.logError("Failed to parse workspace folder path from uri: " + workspaceFolderUri);
            return Collections.emptyList();
        }
        String invisibleProjectName = ProjectUtils.getWorkspaceInvisibleProjectName((IPath)workspaceFolderPath);
        LinkedList<JavaTestItem> resultList = new LinkedList<JavaTestItem>();
        IJavaProject[] iJavaProjectArray = ProjectUtils.getJavaProjects();
        int n = iJavaProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject project = iJavaProjectArray[n2];
            if (monitor != null && monitor.isCanceled()) {
                return Collections.emptyList();
            }
            IProject iProject = project.getProject();
            JavaLanguageServerPlugin.getProjectsManager();
            if (!iProject.equals((Object)ProjectsManager.getDefaultProject()) && (ResourceUtils.isContainedIn((IPath)project.getProject().getLocation(), Collections.singletonList(workspaceFolderPath)) || Objects.equals(project.getProject().getName(), invisibleProjectName))) {
                List<TestKind> testKinds = TestKindProvider.getTestKindsFromCache(project);
                TestKind testKind = testKinds.isEmpty() ? TestKind.None : testKinds.get(0);
                try {
                    JavaTestItem item = new JavaTestItemBuilder().setJavaElement((IJavaElement)project).setLevel(TestLevel.PROJECT).setKind(testKind).build();
                    item.setNatureIds(project.getProject().getDescription().getNatureIds());
                    resultList.add(item);
                }
                catch (CoreException e) {
                    JUnitPlugin.logError("Failed to parse project item: " + project.getElementName());
                }
            }
            ++n2;
        }
        return resultList;
    }

    public static List<JavaTestItem> findTestPackagesAndTypes(List<Object> arguments, IProgressMonitor monitor) throws CoreException {
        String handlerId = (String)arguments.get(0);
        IJavaElement element = JavaCore.create((String)handlerId);
        if (!(element instanceof IJavaProject)) {
            JUnitPlugin.logError("failed to parse IJavaProject from JDT handler ID: " + handlerId);
            return Collections.emptyList();
        }
        IJavaProject javaProject = (IJavaProject)element;
        HashMap<String, JavaTestItem> testItemMapping = new HashMap<String, JavaTestItem>();
        List<TestKind> testKinds = TestKindProvider.getTestKindsFromCache(javaProject);
        for (TestKind kind : testKinds) {
            if (monitor != null && monitor.isCanceled()) {
                return Collections.emptyList();
            }
            TestFrameworkSearcher searcher = TestFrameworkUtils.getSearcherByTestKind(kind);
            HashSet<IType> testTypes = new HashSet<IType>();
            List<IClasspathEntry> testEntries = ProjectTestUtils.getTestEntries(javaProject);
            for (IClasspathEntry entry : testEntries) {
                IPackageFragmentRoot[] packageRoots;
                IPackageFragmentRoot[] iPackageFragmentRootArray = packageRoots = javaProject.findPackageFragmentRoots(entry);
                int n = packageRoots.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    try {
                        testTypes.addAll(searcher.findTestItemsInContainer((IJavaElement)root, monitor));
                    }
                    catch (CoreException e) {
                        JUnitPlugin.logException("failed to search tests in: " + root.getElementName(), e);
                    }
                    ++n2;
                }
            }
            for (IType type : testTypes) {
                JavaTestItem classItem = (JavaTestItem)testItemMapping.get(type.getHandleIdentifier());
                if (classItem == null) {
                    classItem = new JavaTestItemBuilder().setJavaElement((IJavaElement)type).setLevel(TestLevel.CLASS).setKind(kind).build();
                    testItemMapping.put(classItem.getJdtHandler(), classItem);
                } else if (classItem.getTestKind() == TestKind.JUnit5 && kind == TestKind.JUnit) {
                    classItem.setTestKind(TestKind.JUnit);
                }
                IType declaringType = type.getDeclaringType();
                if (declaringType == null) {
                    IPackageFragment packageFragment = type.getPackageFragment();
                    String packageIdentifier = packageFragment.getHandleIdentifier();
                    JavaTestItem packageItem = (JavaTestItem)testItemMapping.get(packageIdentifier);
                    if (packageItem == null) {
                        packageItem = new JavaTestItemBuilder().setJavaElement((IJavaElement)packageFragment).setLevel(TestLevel.PACKAGE).setKind(TestKind.None).build();
                        testItemMapping.put(packageIdentifier, packageItem);
                    }
                    if (packageItem.getChildren() != null && packageItem.getChildren().contains(classItem)) continue;
                    packageItem.addChild(classItem);
                    continue;
                }
                String declaringTypeIdentifier = declaringType.getHandleIdentifier();
                JavaTestItem declaringTypeItem = (JavaTestItem)testItemMapping.get(declaringTypeIdentifier);
                if (declaringTypeItem == null) {
                    declaringTypeItem = new JavaTestItemBuilder().setJavaElement((IJavaElement)declaringType).setLevel(TestLevel.CLASS).setKind(kind).build();
                    testItemMapping.put(declaringTypeIdentifier, declaringTypeItem);
                }
                if (declaringTypeItem.getChildren() != null && declaringTypeItem.getChildren().contains(classItem)) continue;
                declaringTypeItem.addChild(classItem);
            }
        }
        LinkedList<JavaTestItem> result = new LinkedList<JavaTestItem>();
        for (JavaTestItem item : testItemMapping.values()) {
            if (item.getTestLevel() != TestLevel.PACKAGE) continue;
            result.add(item);
        }
        return result;
    }

    public static List<JavaTestItem> findDirectTestChildrenForClass(List<Object> arguments, IProgressMonitor monitor) throws JavaModelException, OperationCanceledException, InterruptedException {
        String handlerId = (String)arguments.get(0);
        Job.getJobManager().join((Object)"DocumentLifeCycleJobs", monitor);
        IType testType = (IType)JavaCore.create((String)handlerId);
        if (testType == null) {
            return Collections.emptyList();
        }
        ICompilationUnit unit = testType.getCompilationUnit();
        if (unit == null) {
            return Collections.emptyList();
        }
        List<TestKind> testKinds = TestKindProvider.getTestKindsFromCache(unit.getJavaProject());
        LinkedList<JavaTestItem> result = new LinkedList<JavaTestItem>();
        CompilationUnit root = (CompilationUnit)TestSearchUtils.parseToAst(unit, true, monitor);
        IType[] iTypeArray = unit.getAllTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding binding;
            TypeDeclaration typeDeclaration;
            IType type = iTypeArray[n2];
            if (monitor != null && monitor.isCanceled()) {
                return result;
            }
            IType declaringType = type.getDeclaringType();
            if (declaringType != null && declaringType.getFullyQualifiedName().equals(testType.getFullyQualifiedName())) {
                for (TestKind kind : testKinds) {
                    TestFrameworkSearcher searcher = TestFrameworkUtils.getSearcherByTestKind(kind);
                    if (!searcher.isTestClass(type)) continue;
                    JavaTestItem typeItem = new JavaTestItemBuilder().setJavaElement((IJavaElement)type).setLevel(TestLevel.CLASS).setKind(kind).build();
                    result.add(typeItem);
                    break;
                }
            } else if (type.getFullyQualifiedName().equals(testType.getFullyQualifiedName()) && (typeDeclaration = ASTNodeSearchUtil.getTypeDeclarationNode((IType)type, (CompilationUnit)root)) != null && (binding = typeDeclaration.resolveBinding()) != null) {
                IMethodBinding[] iMethodBindingArray = binding.getDeclaredMethods();
                int n3 = iMethodBindingArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMethodBinding methodBinding = iMethodBindingArray[n4];
                    for (TestKind kind : testKinds) {
                        TestFrameworkSearcher searcher = TestFrameworkUtils.getSearcherByTestKind(kind);
                        if (!searcher.isTestMethod(methodBinding)) continue;
                        JavaTestItem item = new JavaTestItemBuilder().setJavaElement(methodBinding.getJavaElement()).setLevel(TestLevel.METHOD).setKind(kind).build();
                        result.add(item);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return result;
    }

    public static List<JavaTestItem> findTestTypesAndMethods(List<Object> arguments, IProgressMonitor monitor) throws CoreException, OperationCanceledException, InterruptedException {
        TypeDeclaration typeDeclaration;
        String uriString = (String)arguments.get(0);
        Job.getJobManager().join((Object)"DocumentLifeCycleJobs", monitor);
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit((String)uriString);
        if (unit == null) {
            return Collections.emptyList();
        }
        IType primaryType = unit.findPrimaryType();
        if (primaryType == null) {
            return Collections.emptyList();
        }
        CompilationUnit root = (CompilationUnit)TestSearchUtils.parseToAst(unit, true, monitor);
        if (root == null) {
            return Collections.emptyList();
        }
        List<TestKind> testKinds = TestKindProvider.getTestKindsFromCache(unit.getJavaProject());
        LinkedList<TestFrameworkSearcher> searchers = new LinkedList<TestFrameworkSearcher>();
        for (TestKind kind : testKinds) {
            TestFrameworkSearcher searcher = TestFrameworkUtils.getSearcherByTestKind(kind);
            if (searcher == null) continue;
            searchers.add(searcher);
        }
        if (searchers.size() == 0) {
            Collections.emptyList();
        }
        if ((typeDeclaration = ASTNodeSearchUtil.getTypeDeclarationNode((IType)primaryType, (CompilationUnit)root)) == null) {
            return Collections.emptyList();
        }
        ITypeBinding binding = typeDeclaration.resolveBinding();
        if (binding == null) {
            return Collections.emptyList();
        }
        JavaTestItem fakeRoot = new JavaTestItem();
        TestSearchUtils.findTestItemsInTypeBinding(binding, fakeRoot, searchers, monitor);
        return fakeRoot.getChildren();
    }

    private static void findTestItemsInTypeBinding(ITypeBinding typeBinding, JavaTestItem parentItem, List<TestFrameworkSearcher> searchers, IProgressMonitor monitor) throws JavaModelException {
        if (monitor.isCanceled()) {
            return;
        }
        IType type = (IType)typeBinding.getJavaElement();
        LinkedList<JavaTestItem> testMethods = new LinkedList<JavaTestItem>();
        searchers = searchers.stream().filter(s -> {
            try {
                return CoreTestSearchEngine.isAccessibleClass((IType)type, (String)s.getJdtTestKind());
            }
            catch (JavaModelException e) {
                return false;
            }
        }).collect(Collectors.toList());
        IMethodBinding[] iMethodBindingArray = typeBinding.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding methodBinding = iMethodBindingArray[n2];
            for (TestFrameworkSearcher searcher : searchers) {
                IJavaElement element;
                if (!searcher.isTestMethod(methodBinding) || (element = methodBinding.getJavaElement()) == null) continue;
                JavaTestItem methodItem = new JavaTestItemBuilder().setJavaElement(element).setLevel(TestLevel.METHOD).setKind(searcher.getTestKind()).build();
                testMethods.add(methodItem);
                break;
            }
            ++n2;
        }
        JavaTestItem classItem = null;
        if (testMethods.size() > 0) {
            classItem = new JavaTestItemBuilder().setJavaElement((IJavaElement)type).setLevel(TestLevel.CLASS).setKind(((JavaTestItem)testMethods.get(0)).getTestKind()).build();
            classItem.setChildren(testMethods);
        } else if (TestFrameworkUtils.JUNIT4_TEST_SEARCHER.isTestClass(type)) {
            classItem = new JavaTestItemBuilder().setJavaElement((IJavaElement)type).setLevel(TestLevel.CLASS).setKind(TestKind.JUnit).build();
        } else if (TestFrameworkUtils.JUNIT5_TEST_SEARCHER.isTestClass(type)) {
            classItem = new JavaTestItemBuilder().setJavaElement((IJavaElement)type).setLevel(TestLevel.CLASS).setKind(TestKind.JUnit5).build();
        }
        if (classItem != null && parentItem != null) {
            parentItem.addChild(classItem);
        }
        ITypeBinding[] iTypeBindingArray = typeBinding.getDeclaredTypes();
        int n3 = iTypeBindingArray.length;
        n = 0;
        while (n < n3) {
            ITypeBinding childTypeBinding = iTypeBindingArray[n];
            TestSearchUtils.findTestItemsInTypeBinding(childTypeBinding, classItem, searchers, monitor);
            ++n;
        }
    }

    public static List<JavaTestItem> resolvePath(List<Object> arguments, IProgressMonitor monitor) throws JavaModelException {
        LinkedList<JavaTestItem> result = new LinkedList<JavaTestItem>();
        String uriString = (String)arguments.get(0);
        if (JavaCore.isJavaLikeFileName((String)uriString)) {
            ICompilationUnit unit = JDTUtils.resolveCompilationUnit((String)uriString);
            if (unit == null) {
                return Collections.emptyList();
            }
            IJavaProject project = unit.getJavaProject();
            if (project == null) {
                return Collections.emptyList();
            }
            List<TestKind> testKinds = TestKindProvider.getTestKindsFromCache(project);
            if (testKinds.isEmpty()) {
                return Collections.emptyList();
            }
            TestKind testKind = testKinds.get(0);
            JavaTestItem projectItem = new JavaTestItemBuilder().setJavaElement((IJavaElement)project).setLevel(TestLevel.PROJECT).setKind(testKind).build();
            result.add(projectItem);
            IPackageFragment packageFragment = (IPackageFragment)unit.getParent();
            if (packageFragment == null || !(packageFragment instanceof IPackageFragment)) {
                return Collections.emptyList();
            }
            JavaTestItem packageItem = new JavaTestItemBuilder().setJavaElement((IJavaElement)packageFragment).setLevel(TestLevel.PACKAGE).setKind(testKind).build();
            result.add(packageItem);
        }
        return result;
    }

    public static Location findTestLocation(List<Object> arguments, IProgressMonitor monitor) throws JavaModelException {
        IType[] supertypes;
        String methodName;
        String typeName;
        String fullName = (String)arguments.get(0);
        if (StringUtils.isEmpty((CharSequence)fullName)) {
            return null;
        }
        int projectNameEnd = fullName.indexOf("@");
        if (projectNameEnd < 0) {
            return null;
        }
        String projectName = fullName.substring(0, projectNameEnd);
        if (StringUtils.isEmpty((CharSequence)projectName)) {
            return null;
        }
        IJavaProject javaProject = ProjectUtils.getJavaProject((String)projectName);
        if (javaProject == null) {
            return null;
        }
        int methodStart = fullName.indexOf("#");
        if (methodStart > 0) {
            typeName = fullName.substring(projectNameEnd + 1, methodStart);
            methodName = fullName.substring(methodStart + 1);
        } else {
            typeName = fullName.substring(projectNameEnd + 1);
            methodName = null;
        }
        IType type = TestSearchUtils.findType(javaProject, typeName, monitor);
        if (type == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)methodName)) {
            return new Location(JDTUtils.getFileURI((IResource)type.getResource()), TestItemUtils.parseTestItemRange((IJavaElement)type));
        }
        IMethod method = TestSearchUtils.findMethod(type, methodName);
        if (method != null) {
            return new Location(JDTUtils.getFileURI((IResource)method.getResource()), TestItemUtils.parseTestItemRange((IJavaElement)method));
        }
        ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(null);
        IType[] iTypeArray = supertypes = typeHierarchy.getAllSupertypes(type);
        int n = supertypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType supertype = iTypeArray[n2];
            method = TestSearchUtils.findMethod(supertype, methodName);
            if (method != null) {
                return new Location(JDTUtils.getFileURI((IResource)method.getResource()), TestItemUtils.parseTestItemRange((IJavaElement)method));
            }
            ++n2;
        }
        return new Location(JDTUtils.getFileURI((IResource)type.getResource()), TestItemUtils.parseTestItemRange((IJavaElement)type));
    }

    protected static final IMethod findMethod(IType type, String methodName) throws JavaModelException {
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (methodName.equals(method.getElementName())) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    protected static final IType findType(IJavaProject project, String className, IProgressMonitor monitor) {
        final IType[] result = new IType[1];
        String dottedName = className.replace('$', '.');
        try {
            if (project != null) {
                result[0] = TestSearchUtils.internalFindType(project, dottedName, new HashSet<IJavaProject>(), monitor);
            }
            if (result[0] == null) {
                int lastDot = dottedName.lastIndexOf(46);
                TypeNameMatchRequestor nameMatchRequestor = new TypeNameMatchRequestor(){

                    public void acceptTypeNameMatch(TypeNameMatch match) {
                        result[0] = match.getType();
                    }
                };
                new SearchEngine().searchAllTypeNames(lastDot >= 0 ? dottedName.substring(0, lastDot).toCharArray() : null, 8, (lastDot >= 0 ? dottedName.substring(lastDot + 1) : dottedName).toCharArray(), 8, 0, SearchEngine.createWorkspaceScope(), nameMatchRequestor, 3, monitor);
            }
        }
        catch (JavaModelException e) {
            JUnitPlugin.log((CoreException)((Object)e));
        }
        return result[0];
    }

    private static IType internalFindType(IJavaProject project, String className, Set<IJavaProject> visitedProjects, IProgressMonitor monitor) throws JavaModelException {
        try {
            if (visitedProjects.contains(project)) {
                return null;
            }
            monitor.beginTask("", 2);
            IType type = project.findType(className, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (type != null) {
                IType iType = type;
                return iType;
            }
            visitedProjects.add(project);
            IJavaModel javaModel = project.getJavaModel();
            String[] requiredProjectNames = project.getRequiredProjectNames();
            SubProgressMonitor reqMonitor = new SubProgressMonitor(monitor, 1);
            reqMonitor.beginTask("", requiredProjectNames.length);
            String[] stringArray = requiredProjectNames;
            int n = requiredProjectNames.length;
            int n2 = 0;
            while (n2 < n) {
                String requiredProjectName = stringArray[n2];
                IJavaProject requiredProject = javaModel.getJavaProject(requiredProjectName);
                if (requiredProject.exists() && (type = TestSearchUtils.internalFindType(requiredProject, className, visitedProjects, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)reqMonitor, 1))) != null) {
                    IType iType = type;
                    return iType;
                }
                ++n2;
            }
            return null;
        }
        finally {
            monitor.done();
        }
    }

    public static ASTNode parseToAst(ICompilationUnit unit, boolean fromCache, IProgressMonitor monitor) {
        CompilationUnit astRoot;
        if (fromCache && (astRoot = CoreASTProvider.getInstance().getAST((ITypeRoot)unit, CoreASTProvider.WAIT_YES, monitor)) != null) {
            return astRoot;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        ASTParser parser = ASTParser.newParser((int)AST.getJLSLatest());
        parser.setSource(unit);
        parser.setFocalPosition(0);
        parser.setResolveBindings(true);
        parser.setIgnoreMethodBodies(true);
        return parser.createAST(monitor);
    }
}

