/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Chars;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.List;
import java.util.RandomAccess;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

@GwtIncompatible(value="reflection")
public final class Conversions {
    private Conversions() {
        throw new RuntimeException("Can't create instances of this class");
    }

    @Pure
    public static Object doWrapArray(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> arrayClass = object.getClass();
        if (!arrayClass.isArray()) {
            return object;
        }
        if (!arrayClass.getComponentType().isPrimitive()) {
            return WrappedArray.create((Object[])object);
        }
        if (object instanceof int[]) {
            return WrappedIntegerArray.create((int[])object);
        }
        if (object instanceof long[]) {
            return WrappedLongArray.create((long[])object);
        }
        if (object instanceof float[]) {
            return WrappedFloatArray.create((float[])object);
        }
        if (object instanceof double[]) {
            return WrappedDoubleArray.create((double[])object);
        }
        if (object instanceof byte[]) {
            return WrappedByteArray.create((byte[])object);
        }
        if (object instanceof short[]) {
            return WrappedShortArray.create((short[])object);
        }
        if (object instanceof boolean[]) {
            return WrappedBooleanArray.create((boolean[])object);
        }
        if (object instanceof char[]) {
            return WrappedCharacterArray.create((char[])object);
        }
        throw new ArrayStoreException("Unrecognised type: " + arrayClass.getCanonicalName());
    }

    @Pure
    public static Object unwrapArray(Object value) {
        return Conversions.unwrapArray(value, Object.class);
    }

    @Pure
    public static Object unwrapArray(Object value, Class<?> componentType) {
        if (value instanceof WrappedArray) {
            T[] result = ((WrappedArray)value).internalToArray();
            return Conversions.checkComponentType(result, componentType);
        }
        if (value instanceof WrappedIntegerArray) {
            int[] result = ((WrappedIntegerArray)value).internalToArray();
            return Conversions.checkComponentType(result, componentType);
        }
        if (value instanceof WrappedLongArray) {
            long[] result = ((WrappedLongArray)value).internalToArray();
            return Conversions.checkComponentType(result, componentType);
        }
        if (value instanceof WrappedFloatArray) {
            float[] result = ((WrappedFloatArray)value).internalToArray();
            return Conversions.checkComponentType(result, componentType);
        }
        if (value instanceof WrappedDoubleArray) {
            double[] result = ((WrappedDoubleArray)value).internalToArray();
            return Conversions.checkComponentType(result, componentType);
        }
        if (value instanceof WrappedByteArray) {
            byte[] result = ((WrappedByteArray)value).internalToArray();
            return Conversions.checkComponentType(result, componentType);
        }
        if (value instanceof WrappedShortArray) {
            short[] result = ((WrappedShortArray)value).internalToArray();
            return Conversions.checkComponentType(result, componentType);
        }
        if (value instanceof WrappedBooleanArray) {
            boolean[] result = ((WrappedBooleanArray)value).internalToArray();
            return Conversions.checkComponentType(result, componentType);
        }
        if (value instanceof WrappedCharacterArray) {
            char[] result = ((WrappedCharacterArray)value).internalToArray();
            return Conversions.checkComponentType(result, componentType);
        }
        if (!(value instanceof Iterable)) {
            return value;
        }
        if (!componentType.isPrimitive()) {
            Object[] result = Iterables.toArray((Iterable)((Iterable)value), componentType);
            return result;
        }
        try {
            List list = IterableExtensions.toList((Iterable)value);
            Object result = Array.newInstance(componentType, list.size());
            for (int i = 0; i < list.size(); ++i) {
                Object element = list.get(i);
                if (element == null) {
                    throw new ArrayStoreException("Cannot store <null> in primitive arrays.");
                }
                Array.set(result, i, element);
            }
            return result;
        }
        catch (IllegalArgumentException iae) {
            throw new ArrayStoreException("Primitive conversion failed: " + iae.getMessage());
        }
    }

    private static Object checkComponentType(Object array, Class<?> expectedComponentType) {
        Class<?> actualComponentType = array.getClass().getComponentType();
        if (!expectedComponentType.isAssignableFrom(actualComponentType)) {
            throw new ArrayStoreException(String.format("The expected component type %s is not assignable from the actual type %s", expectedComponentType.getCanonicalName(), actualComponentType.getCanonicalName()));
        }
        return array;
    }

    public static final class WrappedBooleanArray
    extends AbstractList<Boolean>
    implements RandomAccess {
        private final boolean[] array;

        @Pure
        public static WrappedBooleanArray create(boolean[] array) {
            return new WrappedBooleanArray(array);
        }

        protected WrappedBooleanArray(boolean[] array) {
            this.array = array;
        }

        @Override
        public Boolean get(int index) {
            return this.array[index];
        }

        @Override
        public Boolean set(int index, Boolean element) {
            ++this.modCount;
            boolean old = this.array[index];
            this.array[index] = element;
            return old;
        }

        @Override
        public int indexOf(Object o) {
            if (this.size() < 1) {
                return -1;
            }
            if (o instanceof Boolean) {
                return Booleans.indexOf((boolean[])this.array, (boolean)((Boolean)o));
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (this.size() < 1) {
                return -1;
            }
            if (o instanceof Boolean) {
                return Booleans.lastIndexOf((boolean[])this.array, (boolean)((Boolean)o));
            }
            return -1;
        }

        @Override
        public boolean contains(Object o) {
            if (this.size() < 1) {
                return false;
            }
            if (o instanceof Boolean) {
                return Booleans.contains((boolean[])this.array, (boolean)((Boolean)o));
            }
            return false;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        public boolean[] internalToArray() {
            ++this.modCount;
            return this.array;
        }
    }

    public static final class WrappedCharacterArray
    extends AbstractList<Character>
    implements RandomAccess {
        private final char[] array;

        @Pure
        public static WrappedCharacterArray create(char[] array) {
            return new WrappedCharacterArray(array);
        }

        protected WrappedCharacterArray(char[] array) {
            this.array = array;
        }

        @Override
        public Character get(int index) {
            return Character.valueOf(this.array[index]);
        }

        @Override
        public Character set(int index, Character element) {
            ++this.modCount;
            char old = this.array[index];
            this.array[index] = element.charValue();
            return Character.valueOf(old);
        }

        @Override
        public int indexOf(Object o) {
            if (this.size() < 1) {
                return -1;
            }
            if (o instanceof Character) {
                return Chars.indexOf((char[])this.array, (char)((Character)o).charValue());
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (this.size() < 1) {
                return -1;
            }
            if (o instanceof Character) {
                return Chars.lastIndexOf((char[])this.array, (char)((Character)o).charValue());
            }
            return -1;
        }

        @Override
        public boolean contains(Object o) {
            if (this.size() < 1) {
                return false;
            }
            if (o instanceof Character) {
                return Chars.contains((char[])this.array, (char)((Character)o).charValue());
            }
            return false;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        public char[] internalToArray() {
            ++this.modCount;
            return this.array;
        }
    }

    public static final class WrappedDoubleArray
    extends AbstractList<Double>
    implements RandomAccess {
        private final double[] array;

        @Pure
        public static WrappedDoubleArray create(double[] array) {
            return new WrappedDoubleArray(array);
        }

        protected WrappedDoubleArray(double[] array) {
            this.array = array;
        }

        @Override
        public Double get(int index) {
            return this.array[index];
        }

        @Override
        public Double set(int index, Double element) {
            ++this.modCount;
            double old = this.array[index];
            this.array[index] = element;
            return old;
        }

        @Override
        public int indexOf(Object o) {
            if (this.size() < 1) {
                return -1;
            }
            if (o instanceof Double) {
                return Doubles.indexOf((double[])this.array, (double)((Double)o));
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (this.size() < 1) {
                return -1;
            }
            if (o instanceof Double) {
                return Doubles.lastIndexOf((double[])this.array, (double)((Double)o));
            }
            return -1;
        }

        @Override
        public boolean contains(Object o) {
            if (this.size() < 1) {
                return false;
            }
            if (o instanceof Double) {
                return Doubles.contains((double[])this.array, (double)((Double)o));
            }
            return false;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        public double[] internalToArray() {
            ++this.modCount;
            return this.array;
        }
    }

    public static final class WrappedFloatArray
    extends AbstractList<Float>
    implements RandomAccess {
        private final float[] array;

        @Pure
        public static WrappedFloatArray create(float[] array) {
            return new WrappedFloatArray(array);
        }

        protected WrappedFloatArray(float[] array) {
            this.array = array;
        }

        @Override
        public Float get(int index) {
            return Float.valueOf(this.array[index]);
        }

        @Override
        public Float set(int index, Float element) {
            ++this.modCount;
            float old = this.array[index];
            this.array[index] = element.floatValue();
            return Float.valueOf(old);
        }

        @Override
        public int indexOf(Object o) {
            if (this.size() < 1) {
                return -1;
            }
            if (o instanceof Float) {
                return Floats.indexOf((float[])this.array, (float)((Float)o).floatValue());
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (this.size() < 1) {
                return -1;
            }
            if (o instanceof Float) {
                return Floats.lastIndexOf((float[])this.array, (float)((Float)o).floatValue());
            }
            return -1;
        }

        @Override
        public boolean contains(Object o) {
            if (this.size() < 1) {
                return false;
            }
            if (o instanceof Float) {
                return Floats.contains((float[])this.array, (float)((Float)o).floatValue());
            }
            return false;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        public float[] internalToArray() {
            ++this.modCount;
            return this.array;
        }
    }

    public static final class WrappedLongArray
    extends AbstractList<Long>
    implements RandomAccess {
        private final long[] array;

        @Pure
        public static WrappedLongArray create(long[] array) {
            return new WrappedLongArray(array);
        }

        protected WrappedLongArray(long[] array) {
            this.array = array;
        }

        @Override
        public Long get(int index) {
            return this.array[index];
        }

        @Override
        public Long set(int index, Long element) {
            ++this.modCount;
            long old = this.array[index];
            this.array[index] = element;
            return old;
        }

        @Override
        public int indexOf(Object o) {
            if (this.size() < 1) {
                return -1;
            }
            if (o instanceof Long) {
                return Longs.indexOf((long[])this.array, (long)((Long)o));
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (this.size() < 1) {
                return -1;
            }
            if (o instanceof Long) {
                return Longs.lastIndexOf((long[])this.array, (long)((Long)o));
            }
            return -1;
        }

        @Override
        public boolean contains(Object o) {
            if (this.size() < 1) {
                return false;
            }
            if (o instanceof Long) {
                return Longs.contains((long[])this.array, (long)((Long)o));
            }
            return false;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        public long[] internalToArray() {
            ++this.modCount;
            return this.array;
        }
    }

    public static final class WrappedIntegerArray
    extends AbstractList<Integer>
    implements RandomAccess {
        private final int[] array;

        @Pure
        public static WrappedIntegerArray create(int[] array) {
            return new WrappedIntegerArray(array);
        }

        protected WrappedIntegerArray(int[] array) {
            this.array = array;
        }

        @Override
        public Integer get(int index) {
            return this.array[index];
        }

        @Override
        public Integer set(int index, Integer element) {
            ++this.modCount;
            int old = this.array[index];
            this.array[index] = element;
            return old;
        }

        @Override
        public int indexOf(Object o) {
            if (this.size() < 1) {
                return -1;
            }
            if (o instanceof Integer) {
                return Ints.indexOf((int[])this.array, (int)((Integer)o));
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (this.size() < 1) {
                return -1;
            }
            if (o instanceof Integer) {
                return Ints.lastIndexOf((int[])this.array, (int)((Integer)o));
            }
            return -1;
        }

        @Override
        public boolean contains(Object o) {
            if (this.size() < 1) {
                return false;
            }
            if (o instanceof Integer) {
                return Ints.contains((int[])this.array, (int)((Integer)o));
            }
            return false;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        public int[] internalToArray() {
            ++this.modCount;
            return this.array;
        }
    }

    public static final class WrappedShortArray
    extends AbstractList<Short>
    implements RandomAccess {
        private final short[] array;

        @Pure
        public static WrappedShortArray create(short[] array) {
            return new WrappedShortArray(array);
        }

        protected WrappedShortArray(short[] array) {
            this.array = array;
        }

        @Override
        public Short get(int index) {
            return this.array[index];
        }

        @Override
        public Short set(int index, Short element) {
            ++this.modCount;
            short old = this.array[index];
            this.array[index] = element;
            return old;
        }

        @Override
        public int indexOf(Object o) {
            if (this.size() < 1) {
                return -1;
            }
            if (o instanceof Short) {
                return Shorts.indexOf((short[])this.array, (short)((Short)o));
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (this.size() < 1) {
                return -1;
            }
            if (o instanceof Short) {
                return Shorts.lastIndexOf((short[])this.array, (short)((Short)o));
            }
            return -1;
        }

        @Override
        public boolean contains(Object o) {
            if (this.size() < 1) {
                return false;
            }
            if (o instanceof Short) {
                return Shorts.contains((short[])this.array, (short)((Short)o));
            }
            return false;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        public short[] internalToArray() {
            ++this.modCount;
            return this.array;
        }
    }

    public static final class WrappedByteArray
    extends AbstractList<Byte>
    implements RandomAccess {
        private final byte[] array;

        @Pure
        public static WrappedByteArray create(byte[] array) {
            return new WrappedByteArray(array);
        }

        protected WrappedByteArray(byte[] array) {
            this.array = array;
        }

        @Override
        public Byte get(int index) {
            return this.array[index];
        }

        @Override
        public Byte set(int index, Byte element) {
            ++this.modCount;
            byte old = this.array[index];
            this.array[index] = element;
            return old;
        }

        @Override
        public int indexOf(Object o) {
            if (this.size() < 1) {
                return -1;
            }
            if (o instanceof Byte) {
                return Bytes.indexOf((byte[])this.array, (byte)((Byte)o));
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (this.size() < 1) {
                return -1;
            }
            if (o instanceof Byte) {
                return Bytes.lastIndexOf((byte[])this.array, (byte)((Byte)o));
            }
            return -1;
        }

        @Override
        public boolean contains(Object o) {
            if (this.size() < 1) {
                return false;
            }
            if (o instanceof Byte) {
                return Bytes.contains((byte[])this.array, (byte)((Byte)o));
            }
            return false;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        public byte[] internalToArray() {
            ++this.modCount;
            return this.array;
        }
    }

    public static final class WrappedArray<T>
    extends AbstractList<T>
    implements RandomAccess {
        private T[] array;

        public static <T> WrappedArray<T> create(T[] array) {
            return new WrappedArray<T>(array);
        }

        protected WrappedArray(T[] array) {
            this.array = array;
        }

        @Override
        public T get(int index) {
            return this.array[index];
        }

        @Override
        public T set(int index, T element) {
            T old = this.array[index];
            this.array[index] = element;
            ++this.modCount;
            return old;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Object[] toArray() {
            return (Object[])this.array.clone();
        }

        public T[] internalToArray() {
            ++this.modCount;
            return this.array;
        }
    }
}

