/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.sync;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.api.util.RefreshIdsHolder;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMappingImport;
import org.eclipse.sirius.diagram.description.NodeMappingImport;
import org.eclipse.sirius.viewpoint.description.AbstractMappingImport;

public class DNodeCandidate {
    private static final int INVALID_ID = -1;
    private DragAndDropTarget viewContainer;
    private EObject semantic;
    private AbstractNodeMapping mapping;
    private AbstractNodeMapping rootMapping;
    private AbstractDNode element;
    private RefreshIdsHolder ids;

    public DNodeCandidate(AbstractNodeMapping mapping, EObject semanticElement, DragAndDropTarget viewContainer, RefreshIdsHolder ids) {
        this.ids = ids;
        this.mapping = mapping;
        this.semantic = semanticElement;
        this.viewContainer = viewContainer;
        this.rootMapping = this.getRootMapping(mapping);
    }

    public DNodeCandidate(AbstractDNode diagElement, RefreshIdsHolder ids) {
        this.ids = ids;
        this.mapping = (AbstractNodeMapping)diagElement.getMapping();
        this.semantic = diagElement.getTarget();
        this.viewContainer = (DragAndDropTarget)diagElement.eContainer();
        this.element = diagElement;
        this.rootMapping = this.getRootMapping(this.mapping);
    }

    public boolean comesFromDiagramElement() {
        return this.getOriginalElement() != null;
    }

    public AbstractDNode getOriginalElement() {
        return this.element;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.rootMapping == null ? 0 : this.rootMapping.hashCode());
        result = 31 * result + (this.semantic == null ? 0 : this.getSemanticID());
        result = 31 * result + (this.viewContainer == null ? 0 : this.getViewContainerID());
        return result;
    }

    private int getViewContainerID() {
        if (this.semantic == null) {
            return -1;
        }
        return this.ids.getOrCreateID((EObject)this.viewContainer);
    }

    private int getSemanticID() {
        if (this.semantic == null) {
            return -1;
        }
        return this.ids.getOrCreateID(this.semantic);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DNodeCandidate)) {
            return false;
        }
        DNodeCandidate other = (DNodeCandidate)obj;
        if (this.rootMapping == null ? other.rootMapping != null : !this.rootMapping.equals(other.rootMapping)) {
            return false;
        }
        if (this.semantic == null ? other.semantic != null : this.getSemanticID() != other.getSemanticID()) {
            return false;
        }
        return !(this.viewContainer == null ? other.viewContainer != null : this.getViewContainerID() != other.getViewContainerID());
    }

    public AbstractNodeMapping getMapping() {
        return this.mapping;
    }

    public EObject getSemantic() {
        return this.semantic;
    }

    public DragAndDropTarget getViewContainer() {
        return this.viewContainer;
    }

    private AbstractNodeMapping getRootMapping(AbstractNodeMapping mappingImport) {
        if (mappingImport == null) {
            return null;
        }
        AbstractNodeMapping result = mappingImport;
        while (result instanceof AbstractMappingImport) {
            if (result instanceof ContainerMappingImport) {
                result = ((ContainerMappingImport)result).getImportedMapping();
                continue;
            }
            if (!(result instanceof NodeMappingImport)) continue;
            result = ((NodeMappingImport)result).getImportedMapping();
        }
        return result;
    }
}

