/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.remoteservice.rest;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.provider.IContainerInstantiator;
import org.eclipse.ecf.core.util.ExtensionRegistryRunnable;
import org.eclipse.ecf.core.util.LogHelper;
import org.eclipse.ecf.core.util.SystemLogService;
import org.eclipse.ecf.internal.remoteservice.rest.RestClientContainerInstantiator;
import org.eclipse.ecf.remoteservice.rest.identity.RestNamespace;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf.remoteservice.rest";
    private static Activator plugin;
    private BundleContext context;
    private ServiceTracker logServiceTracker = null;
    private LogService logService = null;

    public void start(final BundleContext context1) throws Exception {
        plugin = this;
        this.context = context1;
        SafeRunner.run((ISafeRunnable)new ExtensionRegistryRunnable(context1){

            protected void runWithoutRegistry() throws Exception {
                context1.registerService(Namespace.class, (Object)new RestNamespace(), null);
                context1.registerService(ContainerTypeDescription.class, (Object)new ContainerTypeDescription("ecf.rest.client", (IContainerInstantiator)new RestClientContainerInstantiator(), "Rest Client Container"), null);
            }
        });
    }

    public void stop(BundleContext context1) throws Exception {
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
            this.logServiceTracker = null;
            this.logService = null;
        }
        plugin = null;
        this.context = null;
    }

    public static synchronized Activator getDefault() {
        if (plugin == null) {
            plugin = new Activator();
        }
        return plugin;
    }

    public BundleContext getContext() {
        return this.context;
    }

    protected LogService getLogService() {
        if (this.logServiceTracker == null) {
            this.logServiceTracker = new ServiceTracker(this.context, LogService.class.getName(), null);
            this.logServiceTracker.open();
        }
        this.logService = (LogService)this.logServiceTracker.getService();
        if (this.logService == null) {
            this.logService = new SystemLogService(PLUGIN_ID);
        }
        return this.logService;
    }

    public void log(IStatus status) {
        if (this.logService == null) {
            this.logService = this.getLogService();
        }
        if (this.logService != null) {
            this.logService.log(LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
        }
    }
}

