/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.dnssd;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.discovery.identity.ServiceID;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.TextParseException;

public class DnsSdServiceID
extends ServiceID {
    private static final long serialVersionUID = -5265675009221335638L;

    protected DnsSdServiceID(Namespace namespace, IServiceTypeID type, URI anUri) {
        super(namespace, type, anUri);
    }

    Name getDnsName() throws TextParseException {
        return new Name("_" + this.type.getServices()[0] + "._" + this.type.getProtocols()[0]);
    }

    Record toSRVRecord() throws IOException {
        Name name = new Name(this.getDnsName().toString(), new Name(this.type.getScopes()[0] + "."));
        long ttl = this.serviceInfo.getTTL();
        int priority = this.serviceInfo.getPriority();
        int weight = this.serviceInfo.getWeight();
        int port = this.serviceInfo.getLocation().getPort();
        Name target = Name.fromString((String)(this.serviceInfo.getLocation().getHost() + "."));
        return new SRVRecord(name, 1, ttl, priority, weight, port, target);
    }

    Record[] toTXTRecords(Record aRecord) throws IOException {
        ArrayList<TXTRecord> result = new ArrayList<TXTRecord>();
        IServiceProperties properties = this.serviceInfo.getServiceProperties();
        Enumeration enumeration = properties.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            Object property = enumeration.nextElement();
            String key = property.toString();
            String value = properties.getProperty(key).toString();
            long ttl = this.serviceInfo.getTTL();
            result.add(new TXTRecord(aRecord.getName(), 1, ttl, key + "=" + value));
        }
        return result.toArray(new Record[result.size()]);
    }
}

