/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.manifests;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.JarEntryEditorInput;
import org.eclipse.oomph.manifests.AbstractProjectHandler;
import org.eclipse.oomph.manifests.Activator;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.resource.Resource;

public class OpenManifestHandler
extends AbstractProjectHandler {
    private static final ProjectType[] PROJECT_TYPES = new ProjectType[]{new ProjectType("org.eclipse.pde.PluginNature", "org.eclipse.pde.ui.manifestEditor", "META-INF/MANIFEST.MF"), new ProjectType("org.eclipse.pde.FeatureNature", "org.eclipse.pde.ui.featureEditor", "feature.xml"), new ProjectType("org.eclipse.pde.UpdateSiteNature", "org.eclipse.pde.ui.siteEditor", "site.xml"), new ProjectType(null, "org.eclipse.pde.ui.categoryEditor", "category.xml")};

    @Override
    protected boolean executeWithProject(IWorkbenchPage page, IProject project) {
        ProjectType[] projectTypeArray = PROJECT_TYPES;
        int n = PROJECT_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                IFile manifest;
                ProjectType projectType = projectTypeArray[n2];
                String natureID = projectType.getNatureID();
                if (natureID != null && !project.hasNature(natureID) || !(manifest = project.getFile((IPath)new Path(projectType.getManifestPath()))).exists()) break block6;
                try {
                    FileEditorInput input = new FileEditorInput(manifest);
                    page.openEditor((IEditorInput)input, projectType.getEditorID(), true);
                    return true;
                }
                catch (PartInitException ex) {
                    try {
                        OpenManifestHandler.log((CoreException)((Object)ex));
                        return false;
                    }
                    catch (CoreException ex2) {
                        OpenManifestHandler.log(ex2);
                    }
                }
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected void executeWithElement(IWorkbenchPage page, Object element) throws Exception {
        IPackageFragmentRoot root;
        IEditorInput editorInput;
        IPluginModelBase pluginModelBase;
        IEditorPart editor;
        if (element == null && (editor = page.getActiveEditor()) != null) {
            element = editor.getEditorInput();
        }
        if ((pluginModelBase = (IPluginModelBase)ObjectUtil.adapt((Object)element, IPluginModelBase.class)) != null) {
            ManifestEditor.openPluginEditor((IPluginModelBase)pluginModelBase);
            return;
        }
        BundleDescription bundleDescription = (BundleDescription)ObjectUtil.adapt((Object)element, BundleDescription.class);
        if (bundleDescription != null) {
            ManifestEditor.openPluginEditor((Resource)bundleDescription);
            return;
        }
        IJavaElement javaElement = (IJavaElement)ObjectUtil.adapt((Object)element, IJavaElement.class);
        while (javaElement != null && javaElement.getElementType() != 3) {
            javaElement = javaElement.getParent();
        }
        if (javaElement != null && (editorInput = this.getManifestEditorInputStorage(root = (IPackageFragmentRoot)javaElement)) != null) {
            page.openEditor(editorInput, "org.eclipse.pde.ui.manifestEditor");
        }
    }

    private IEditorInput getManifestEditorInputStorage(IPackageFragmentRoot root) throws JavaModelException {
        Object[] objectArray = root.getNonJavaResources();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            IContainer container;
            Object object = objectArray[n2];
            if (object instanceof IJarEntryResource) {
                IJarEntryResource jarEntryResource = (IJarEntryResource)object;
                if ("META-INF".equalsIgnoreCase(jarEntryResource.getName())) {
                    IJarEntryResource[] iJarEntryResourceArray = jarEntryResource.getChildren();
                    int n3 = iJarEntryResourceArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IJarEntryResource child = iJarEntryResourceArray[n4];
                        if ("MANIFEST.MF".equalsIgnoreCase(child.getName())) {
                            return new JarEntryEditorInput((IStorage)child);
                        }
                        ++n4;
                    }
                }
            } else if (object instanceof IContainer && "META-INF".equalsIgnoreCase((container = (IContainer)object).getName()) && (file = container.getFile((IPath)new Path("MANIFEST.MF"))).exists()) {
                return new FileEditorInput(file);
            }
            ++n2;
        }
        return null;
    }

    private static void log(CoreException ex) {
        Activator.getDefault().getLog().log(ex.getStatus());
    }

    private static final class ProjectType {
        private String natureID;
        private String editorID;
        private String manifestPath;

        public ProjectType(String natureID, String editorID, String manifestPath) {
            this.natureID = natureID;
            this.editorID = editorID;
            this.manifestPath = manifestPath;
        }

        public String getNatureID() {
            return this.natureID;
        }

        public String getEditorID() {
            return this.editorID;
        }

        public String getManifestPath() {
            return this.manifestPath;
        }
    }
}

