/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.tasks.preferences;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.ui.preferences.PropertyAndPreferencePage;
import org.eclipse.xtext.ui.tasks.preferences.PreferencesMessages;
import org.eclipse.xtext.ui.tasks.preferences.TaskTagConfigurationBlock;

public class TaskTagPreferencePage
extends PropertyAndPreferencePage {
    private TaskTagConfigurationBlock taskConfigurationBlock;
    private String languageName;
    private IPreferenceStoreAccess preferenceStoreAccess;

    public TaskTagPreferencePage() {
        this.setDescription(PreferencesMessages.TaskTagPreferencePage_description);
        this.setTitle(PreferencesMessages.TaskTagPreferencePage_title);
    }

    @Inject
    public void setLanguageName(@Named(value="languageName") String languageName) {
        this.languageName = languageName;
    }

    @Inject
    public void setPreferenceStoreAccess(IPreferenceStoreAccess preferenceStoreAccess) {
        this.preferenceStoreAccess = preferenceStoreAccess;
    }

    public void createControl(Composite parent) {
        IWorkbenchPreferenceContainer container = (IWorkbenchPreferenceContainer)this.getContainer();
        IPreferenceStore preferenceStore = this.preferenceStoreAccess.getWritablePreferenceStore(this.getProject());
        this.taskConfigurationBlock = new TaskTagConfigurationBlock(this.getProject(), preferenceStore, container, this.languageName);
        this.taskConfigurationBlock.setStatusChangeListener(this.getNewStatusChangedListener());
        super.createControl(parent);
    }

    protected Control createPreferenceContent(Composite composite, IPreferencePageContainer preferencePageContainer) {
        return this.taskConfigurationBlock.createContents(composite);
    }

    protected boolean hasProjectSpecificOptions(IProject project) {
        return this.taskConfigurationBlock.hasProjectSpecificOptions(project);
    }

    protected String getPreferencePageID() {
        return String.valueOf(this.languageName) + ".task.preferencePage";
    }

    protected String getPropertyPageID() {
        return String.valueOf(this.languageName) + ".task.propertyPage";
    }

    public void dispose() {
        if (this.taskConfigurationBlock != null) {
            this.taskConfigurationBlock.dispose();
        }
        super.dispose();
    }

    protected void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        super.enableProjectSpecificSettings(useProjectSpecificSettings);
        if (this.taskConfigurationBlock != null) {
            this.taskConfigurationBlock.useProjectSpecificSettings(useProjectSpecificSettings);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this.taskConfigurationBlock != null) {
            this.taskConfigurationBlock.performDefaults();
        }
    }

    public boolean performOk() {
        if (this.taskConfigurationBlock != null && !this.taskConfigurationBlock.performOk()) {
            return false;
        }
        return super.performOk();
    }

    public void performApply() {
        if (this.taskConfigurationBlock != null) {
            this.taskConfigurationBlock.performApply();
        }
    }

    public void setElement(IAdaptable element) {
        super.setElement(element);
        this.setDescription(null);
    }
}

