/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.resource;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtext.ui.resource.IStorage2UriMapperJdtExtensions;
import org.eclipse.xtext.ui.resource.JarEntryLocator;
import org.eclipse.xtext.ui.resource.PackageFragmentRootWalker;
import org.eclipse.xtext.ui.resource.SourceAttachmentPackageFragmentRootWalker;
import org.eclipse.xtext.ui.resource.Storage2UriMapperImpl;
import org.eclipse.xtext.ui.resource.UriValidator;
import org.eclipse.xtext.ui.util.IJdtHelper;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class Storage2UriMapperJavaImpl
extends Storage2UriMapperImpl
implements IStorage2UriMapperJdtExtensions {
    private static final Logger log = Logger.getLogger(Storage2UriMapperJavaImpl.class);
    @Inject
    private JarEntryLocator locator;
    @Inject
    private UriValidator uriValidator;
    @Inject
    private IJdtHelper jdtHelper;
    private Map<String, PackageFragmentRootData> cachedPackageFragmentRootData = Maps.newLinkedHashMap();

    @Override
    public void setUriValidator(UriValidator uriValidator) {
        super.setUriValidator(uriValidator);
        this.uriValidator = uriValidator;
    }

    public void setJdtHelper(IJdtHelper jdtHelper) {
        this.jdtHelper = jdtHelper;
    }

    public void setLocator(JarEntryLocator locator) {
        this.locator = locator;
    }

    @Override
    protected boolean isHandled(IFolder folder) {
        return super.isHandled(folder) && this.jdtHelper != null && !this.jdtHelper.isFromOutputPath((IResource)folder);
    }

    @Override
    public Pair<URI, URI> getURIMapping(IPackageFragmentRoot root) throws JavaModelException {
        PackageFragmentRootData data = this.getData(root);
        if (data.uriPrefix == null) {
            return null;
        }
        IPath path = root.isExternal() ? root.getPath() : root.getUnderlyingResource().getLocation();
        URI physical = URI.createFileURI((String)path.toFile().getPath());
        return Tuples.create((Object)data.uriPrefix, (Object)physical);
    }

    @Override
    public Map<URI, IStorage> getAllEntries(IPackageFragmentRoot root) {
        try {
            if (root.getUnderlyingResource() instanceof IFolder) {
                return this.getAllEntries((IContainer)((IFolder)root.getUnderlyingResource()));
            }
        }
        catch (JavaModelException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return Collections.emptyMap();
        }
        PackageFragmentRootData data = this.getData(root);
        return data.uri2Storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageFragmentRootData getData(IPackageFragmentRoot root) {
        boolean isCachable;
        String id = root.getHandleIdentifier();
        boolean bl = isCachable = root.isArchive() || root.isExternal();
        if (isCachable) {
            Map<String, PackageFragmentRootData> map = this.cachedPackageFragmentRootData;
            synchronized (map) {
                if (this.cachedPackageFragmentRootData.containsKey(id)) {
                    PackageFragmentRootData data = this.cachedPackageFragmentRootData.get(id);
                    if (this.isUpToDate(data, root)) {
                        return data;
                    }
                    this.cachedPackageFragmentRootData.remove(id);
                }
            }
        }
        PackageFragmentRootData data = this.initializeData(root);
        if (isCachable) {
            Map<String, PackageFragmentRootData> map = this.cachedPackageFragmentRootData;
            synchronized (map) {
                if (!this.cachedPackageFragmentRootData.containsKey(id)) {
                    this.cachedPackageFragmentRootData.put(id, data);
                }
            }
        }
        return data;
    }

    private boolean isUpToDate(PackageFragmentRootData data, IPackageFragmentRoot root) {
        return Objects.equal((Object)data.modificationStamp, (Object)this.computeModificationStamp(root));
    }

    private Object computeModificationStamp(IPackageFragmentRoot root) {
        try {
            if (root.exists()) {
                IResource resource = root.getUnderlyingResource();
                if (resource != null) {
                    return resource.getLocation().toFile().lastModified();
                }
                return root.getPath().toFile().lastModified();
            }
        }
        catch (JavaModelException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return new Object();
    }

    protected PackageFragmentRootData initializeData(final IPackageFragmentRoot root) {
        final PackageFragmentRootData data = new PackageFragmentRootData(root, this.computeModificationStamp(root));
        try {
            SourceAttachmentPackageFragmentRootWalker<Void> walker = new SourceAttachmentPackageFragmentRootWalker<Void>(){

                @Override
                protected URI getURI(IFile file, PackageFragmentRootWalker.TraversalState state) {
                    if (!Storage2UriMapperJavaImpl.this.uriValidator.isPossiblyManaged((IStorage)file)) {
                        return null;
                    }
                    return super.getURI(file, state);
                }

                @Override
                protected URI getURI(IJarEntryResource jarEntry, PackageFragmentRootWalker.TraversalState state) {
                    if (!Storage2UriMapperJavaImpl.this.uriValidator.isPossiblyManaged((IStorage)jarEntry)) {
                        return null;
                    }
                    URI uri = Storage2UriMapperJavaImpl.this.locator.getURI(root, jarEntry, state);
                    if (!Storage2UriMapperJavaImpl.this.uriValidator.isValid(uri, (IStorage)jarEntry)) {
                        return null;
                    }
                    return uri;
                }

                @Override
                protected Void handle(URI uri, IStorage storage, PackageFragmentRootWalker.TraversalState state) {
                    data.uri2Storage.put(uri, storage);
                    return null;
                }
            };
            walker.traverse(root, false);
            if (walker.getBundleSymbolicName() != null) {
                data.uriPrefix = URI.createPlatformResourceURI((String)walker.getBundleSymbolicName(), (boolean)true);
            }
        }
        catch (JavaModelException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return data;
    }

    @Override
    public Iterable<Pair<IStorage, IProject>> getStorages(URI uri) {
        Iterable<Pair<IStorage, IProject>> storages = super.getStorages(uri);
        if (!Iterables.isEmpty(storages)) {
            return storages;
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)1);
        Iterator<PackageFragmentRootData> iterator = this.cachedPackageFragmentRootData.values().iterator();
        while (iterator.hasNext()) {
            PackageFragmentRootData data = iterator.next();
            if (data.root.exists()) {
                IStorage storage;
                if (data.uriPrefix != null && !uri.toString().startsWith(data.uriPrefix.toString()) || (storage = data.uri2Storage.get(uri)) == null) continue;
                result.add(Tuples.create((Object)storage, (Object)data.root.getJavaProject().getProject()));
                continue;
            }
            iterator.remove();
        }
        if (result.isEmpty() && uri.isArchive()) {
            String authority = uri.authority();
            URI archiveURI = URI.createURI((String)(authority = authority.substring(0, authority.length() - 1)));
            if (archiveURI.isFile()) {
                Path archivePath = new Path(archiveURI.toFileString());
                for (PackageFragmentRootData data : this.cachedPackageFragmentRootData.values()) {
                    URI expectedURI;
                    IStorage storage;
                    if (data.uriPrefix == null || !archivePath.equals((Object)data.root.getPath()) || (storage = data.uri2Storage.get(expectedURI = data.uriPrefix.appendSegments(uri.segments()))) == null) continue;
                    result.add(Tuples.create((Object)storage, (Object)data.root.getJavaProject().getProject()));
                }
            }
        }
        return result;
    }

    @Override
    protected URI internalGetUri(IStorage storage) {
        if (!this.uriValidator.isPossiblyManaged(storage)) {
            return null;
        }
        URI uri = super.internalGetUri(storage);
        if (uri != null) {
            return uri;
        }
        if (storage instanceof IJarEntryResource) {
            IJarEntryResource storage2 = (IJarEntryResource)storage;
            Map<URI, IStorage> data = this.getAllEntries(storage2.getPackageFragmentRoot());
            for (Map.Entry<URI, IStorage> entry : data.entrySet()) {
                if (!entry.getValue().equals(storage2)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    @Deprecated
    public void elementChanged(ElementChangedEvent changeEvent) {
        log.warn((Object)"Storage2UriMapperJavaImpl.elementChanged(ElementChangedEvent) is deperecated and does nothing.");
    }

    static class PackageFragmentRootData {
        public URI uriPrefix;
        public final Object modificationStamp;
        public final IPackageFragmentRoot root;
        public Map<URI, IStorage> uri2Storage = Maps.newLinkedHashMap();

        public PackageFragmentRootData(IPackageFragmentRoot root, Object modificationStamp) {
            this.modificationStamp = modificationStamp;
            this.root = root;
        }

        public String toString() {
            return String.valueOf(this.root.toString()) + " / " + this.uriPrefix;
        }
    }
}

